/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.agenda.event.ChairEvent;
import com.elluminate.groupware.agenda.event.ChairListener;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.event.EventListenerList;

public class ChairEventSupport {
    private Client client;
    private EventListenerList listenerList = new EventListenerList();

    public ChairEventSupport(Client client) {
        this.client = client;
        client.getClientList().addPropertyChangeListener("chair", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ChairEventSupport.this.chairChange(e);
            }
        });
    }

    public boolean meIsChair() {
        Chair chair = ChairProtocol.getChair((ClientList)this.client.getClientList());
        return chair.isMe();
    }

    public void addChairListener(ChairListener l) {
        this.listenerList.add(ChairListener.class, l);
    }

    public void removeChairListener(ChairListener l) {
        this.listenerList.remove(ChairListener.class, l);
    }

    private void chairChange(PropertyChangeEvent e) {
        if (this.listenerList.getListenerCount(ChairListener.class) == 0) {
            return;
        }
        Chair oldChair = new Chair((Connection)this.client, e.getOldValue());
        Chair chair = new Chair((Connection)this.client, e.getNewValue());
        if (chair != null && oldChair != null) {
            for (ClientInfo ci : chair) {
                if (ci == null || oldChair.contains(ci.getAddress())) continue;
                this.fireChairEvent(1, ci);
            }
            for (ClientInfo ci : oldChair) {
                if (ci == null || chair.contains(ci.getAddress())) continue;
                this.fireChairEvent(2, ci);
            }
        }
    }

    protected void fireChairEvent(int eventID, ClientInfo clientInfo) {
        ChairEvent e = new ChairEvent(this.client, eventID, clientInfo);
        ChairListener[] ls = (ChairListener[])this.listenerList.getListeners(ChairListener.class);
        block4: for (int i = ls.length - 1; i >= 0; --i) {
            switch (eventID) {
                case 1: {
                    ls[i].chairAdded(e);
                    continue block4;
                }
                case 2: {
                    ls[i].chairRemoved(e);
                }
            }
        }
    }
}

