/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaLibrary;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaProtocol;
import com.elluminate.groupware.agenda.AgendaTopic;
import com.elluminate.groupware.agenda.QuotaExceededException;
import com.elluminate.groupware.agenda.StringsProperties;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.log.LogSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.CRC32;

public class AgendaResponder
extends DefaultProtocolResponder
implements ChannelDataListener {
    private AgendaLibrary library = new AgendaLibrary(false);
    private I18n i18n = I18n.create((Object)((Object)this));
    private AgendaTopic lastTopic = null;
    private HashMap<Object, DefinitionDownload> downloads = new HashMap();

    public AgendaResponder(AgendaProtocol protocol) {
        super((JinxProtocol)protocol);
        this.setChannelDataListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void onChannelData(ChannelDataEvent e) {
        DataInputStream in = null;
        try {
            in = e.read();
            switch (e.getCommand()) {
                case 1: {
                    this.receiveNewAgendaMessage(in);
                    return;
                }
                case 2: {
                    this.receiveChangeAgendaMessage(in);
                    return;
                }
                case 3: {
                    this.receiveDeleteAgendaMessage(in);
                    return;
                }
                case 11: {
                    this.receiveActivateAgendaMessage(in);
                    return;
                }
                case 12: {
                    this.receiveDeactivateAgendaMessage(in);
                    return;
                }
                case 20: {
                    this.receiveDownloadDefinitionMessage(in);
                    return;
                }
            }
            return;
        }
        catch (QuotaExceededException ex) {
            LogSupport.error((Object)((Object)this), (String)"onChannelData", (String)ex.toString());
            return;
        }
        catch (IOException ex) {
            LogSupport.error((Object)((Object)this), (String)"onChannelData", (String)ex.toString());
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void receiveNewAgendaMessage(DataInputStream in) throws QuotaExceededException, IOException {
        int agendaID = in.readInt();
        String agendaName = in.readUTF();
        short requester = in.readShort();
        if (agendaID != -1 && this.library.getAgendaByID(agendaID) != null) {
            return;
        }
        Agenda ag = new Agenda(agendaName);
        ag.setID(agendaID);
        this.library.addAgenda(ag, requester);
    }

    private void receiveChangeAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        String property = in.readUTF();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            LogSupport.log((Object)((Object)this), (String)"receiveChangeAgendaMessage", (String)("Unknown agenda ID: " + agendaID));
            return;
        }
        if (!this.library.isActiveAgenda(ag)) {
            return;
        }
        String[] pair = AgendaProtocol.parseProperty(property);
        if (pair == null) {
            LogSupport.log((Object)((Object)this), (String)"receiveChangeAgendaMessage", (String)("Invalid name=value pair: " + property));
            return;
        }
        String name = pair[0];
        String value = pair[1];
        if (name.equals("currentitem")) {
            AgendaNode node;
            int itemID = -1;
            try {
                itemID = Integer.parseInt(value);
                if (itemID == -1) {
                    return;
                }
            }
            catch (NumberFormatException ex) {
                LogSupport.log((Object)((Object)this), (String)"receiveChangeAgendaMessage", (String)("Invalid node ID: " + value));
                return;
            }
            AgendaItem it = ag.getItemByID(itemID);
            if (!(it instanceof AgendaNode)) {
                LogSupport.log((Object)((Object)this), (String)"receiveChangeAgendaMessage", (String)("Item not a node: " + it));
                return;
            }
            for (node = (AgendaNode)it; node != null && !(node instanceof AgendaTopic); node = node.getParent()) {
            }
            AgendaTopic topic = (AgendaTopic)node;
            if (topic != this.lastTopic) {
                this.lastTopic = topic;
                if (topic != null) {
                    VCRFile.IndexEntry entry = new VCRFile.IndexEntry(this.i18n.getMessage((PropertiesEnum)StringsProperties.AGENDARESPONDER_INDEXICON), this.i18n.getMessage((PropertiesEnum)StringsProperties.AGENDARESPONDER_INDEXTOPICCHANGED), new I18nMessage(topic.getName()));
                    this.fireNotableEventListeners("recording.index", entry);
                }
            }
        }
    }

    private void receiveDeleteAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short requester = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        this.library.removeAgenda(ag, requester);
    }

    private void receiveDownloadDefinitionMessage(DataInputStream in) throws IOException {
        long downloadID = in.readLong();
        byte messageType = in.readByte();
        Object key = AgendaResponder.makeDownloadKey(downloadID);
        switch (messageType) {
            case 1: {
                int agendaID = in.readInt();
                long size = in.readLong();
                Agenda ag = this.library.getAgendaByID(agendaID);
                if (ag == null) {
                    return;
                }
                DefinitionDownload dl = new DefinitionDownload(ag, size);
                this.downloads.put(key, dl);
                break;
            }
            case 3: {
                DefinitionDownload dl = this.downloads.get(key);
                if (dl == null) break;
                dl.receive(in);
                break;
            }
            case 5: {
                DefinitionDownload dl = this.downloads.remove(key);
                if (dl == null) break;
                long crc32 = in.readLong();
                dl.finish(crc32);
                dl.getAgenda().load(new ByteArrayInputStream(dl.getReceivedData()));
                break;
            }
            case 6: {
                DefinitionDownload dl = this.downloads.remove(key);
                if (dl == null) break;
                dl.halt();
            }
        }
    }

    private void receiveActivateAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short requester = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        if (this.library.isActiveAgenda(ag)) {
            return;
        }
        this.library.activateAgenda(ag, requester);
        this.sendDownloadDefinitionRequestMessage(AgendaResponder.newDownloadID(), ag);
    }

    private void receiveDeactivateAgendaMessage(DataInputStream in) throws IOException {
        int agendaID = in.readInt();
        short requester = in.readShort();
        Agenda ag = this.library.getAgendaByID(agendaID);
        if (ag == null) {
            return;
        }
        this.library.deactivateAgenda(ag, requester);
        ag.unload();
        this.sendReleaseDefinitionMessage(ag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendDownloadDefinitionRequestMessage(long downloadID, Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)20);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeLong(downloadID);
            out.writeByte(1);
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.sendDataOnChannel("agenda", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendReleaseDefinitionMessage(Agenda agenda) throws IOException {
        ChannelDataEvent e = ChannelDataEvent.getInstance((Object)((Object)this), (short)0, (byte)10);
        DataOutputStream out = null;
        try {
            out = e.write();
            out.writeInt(agenda.getID());
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        this.sendDataOnChannel("agenda", e);
    }

    private static long newDownloadID() {
        return System.currentTimeMillis();
    }

    private static Object makeDownloadKey(long downloadID) {
        return String.valueOf(downloadID);
    }

    private static class DefinitionDownload {
        private Agenda agenda;
        private long size;
        private ByteArrayOutputStream outputStream;
        private CRC32 crc32 = new CRC32();

        public DefinitionDownload(Agenda agenda, long size) throws IOException {
            this.agenda = agenda;
            this.size = size;
            this.outputStream = new ByteArrayOutputStream((int)size);
        }

        public Agenda getAgenda() {
            return this.agenda;
        }

        public byte[] getReceivedData() {
            if (this.outputStream != null) {
                return this.outputStream.toByteArray();
            }
            return null;
        }

        public void receive(InputStream inputStream) throws IOException {
            int bytesRead;
            byte[] buf = new byte[1024];
            while ((bytesRead = inputStream.read(buf)) != -1) {
                this.outputStream.write(buf, 0, bytesRead);
                this.crc32.update(buf, 0, bytesRead);
            }
        }

        public void finish(long crc32Value) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (crc32Value == 0L) {
                LogSupport.log((String)"No checksum to check against");
            } else if (this.crc32.getValue() != crc32Value) {
                LogSupport.log((String)("Checksums do not match for downloaded agenda definition: " + this.agenda.getName()));
                this.outputStream = null;
            }
        }

        public void halt() {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.outputStream = null;
        }
    }
}

