/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaObject;
import com.elluminate.groupware.agenda.AgendaTopic;

public abstract class AgendaNode
extends AgendaItem {
    protected boolean covered = false;
    private int duration = 0;

    public AgendaNode getParent() {
        return this.parent instanceof AgendaNode ? (AgendaNode)this.parent : null;
    }

    @Override
    public Agenda getParentAgenda() {
        AgendaObject p = this.parent;
        if (p instanceof Agenda) {
            return (Agenda)p;
        }
        if (p instanceof AgendaNode) {
            return ((AgendaNode)p).getParentAgenda();
        }
        return null;
    }

    public boolean isAncestorOf(AgendaNode node) {
        for (AgendaNode p = node.getParent(); p != null; p = p.getParent()) {
            if (p != this) continue;
            return true;
        }
        return false;
    }

    @Override
    void removeFromParent() {
        AgendaObject p = this.parent;
        if (p instanceof Agenda) {
            ((Agenda)p).removeNode(this);
        } else if (p instanceof AgendaTopic) {
            ((AgendaTopic)p).removeNode(this);
        }
    }

    public boolean isCovered() {
        return this.covered;
    }

    public void setCovered(boolean covered) {
        if (this.covered != covered) {
            this.covered = covered;
            this.changeItemNotify(this, "covered");
        }
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        if (this.duration != duration) {
            this.duration = duration;
            this.changeItemNotify(this, "duration");
        }
    }

    @Override
    public boolean canMoveUp() {
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            return ag.getNodeBefore(this, false) != null;
        }
        return false;
    }

    @Override
    public boolean canMoveDown() {
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            AgendaNode n = this;
            while ((n = ag.getNodeAfter(n, false)) != null) {
                if (this.isAncestorOf(n)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean canMoveLeft() {
        if (!(this.parent instanceof AgendaTopic)) {
            return false;
        }
        AgendaTopic top = (AgendaTopic)this.parent;
        return top.getNodeIndex(this) == top.getNodeCount() - 1;
    }

    @Override
    public boolean canMoveRight() {
        Agenda ag = this.getParentAgenda();
        if (ag != null) {
            AgendaNode prev = ag.getSiblingNodeBefore(this);
            return prev instanceof AgendaTopic;
        }
        return false;
    }

    @Override
    protected String paramString() {
        StringBuffer b = new StringBuffer();
        b.append(super.paramString());
        b.append(",covered=");
        b.append(this.covered);
        b.append(",duration=");
        b.append(this.duration);
        return b.toString();
    }
}

