/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.Agenda;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.QuotaExceededException;
import com.elluminate.groupware.agenda.event.AgendaLibraryEvent;
import com.elluminate.groupware.agenda.event.AgendaLibraryListener;
import java.io.File;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.event.EventListenerList;

public class AgendaLibrary {
    private static HashMap<Integer, Agenda> allAgendas = new HashMap();
    private static SecureRandom idGenerator = new SecureRandom();
    private HashMap<Integer, Agenda> agendas = new HashMap();
    private Agenda activeAgenda = null;
    private ArrayList<Agenda> autoloadedAgendas = new ArrayList();
    private long quota = 0L;
    private boolean indexed = true;
    private EventListenerList listenerList = new EventListenerList();

    public AgendaLibrary() {
        this(true);
    }

    AgendaLibrary(boolean indexed) {
        this.indexed = indexed;
    }

    public void setQuota(long quota) {
        this.quota = quota;
    }

    public long getQuota() {
        return this.quota;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getQuotaUsed() {
        HashMap<Integer, Agenda> hashMap = this.agendas;
        synchronized (hashMap) {
            long used = 0L;
            for (Agenda ag : this.agendas.values()) {
                File f = ag.getFile();
                if (f == null) continue;
                used += f.length();
            }
            return used;
        }
    }

    public void checkQuota(long requestedStorage) throws QuotaExceededException {
        if (this.quota > 0L && this.getQuotaUsed() + requestedStorage > this.quota) {
            throw new QuotaExceededException("The requested storage would exceed the library quota: " + requestedStorage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addAgenda(Agenda agenda, short requester) throws QuotaExceededException {
        HashMap<Integer, Agenda> hashMap = this.agendas;
        synchronized (hashMap) {
            int id;
            File f = agenda.getFile();
            if (f != null) {
                this.checkQuota(f.length());
            }
            if ((id = agenda.getID()) == -1 || this.agendas.containsKey(new Integer(id))) {
                id = AgendaLibrary.reserveID();
                agenda.setID(id);
            }
            this.confirmID(id, agenda);
            this.agendas.put(new Integer(id), agenda);
            this.fireAgendaLibraryEvent(1, agenda, requester);
            return id;
        }
    }

    public synchronized boolean removeAgenda(Agenda agenda, short requester) {
        Integer id = new Integer(agenda.getID());
        Agenda ag = this.agendas.get(id);
        if (ag != null && ag == agenda) {
            if (this.isActiveAgenda(ag)) {
                this.deactivateAgenda(ag, requester);
            }
            if (this.isAgendaAutoloaded(ag)) {
                this.autoloadedAgendas.remove(ag);
            }
            if (this.indexed) {
                AgendaLibrary.releaseID(id);
            }
            this.agendas.remove(id);
            this.fireAgendaLibraryEvent(2, agenda, requester);
            AgendaNode node = ag.getRunningNode();
            if (node != null) {
                ag.cancelTimer(node);
            }
            ag.setID(-1);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllAgendas(short requester) {
        HashMap<Integer, Agenda> hashMap = this.agendas;
        synchronized (hashMap) {
            Agenda[] ags = this.getAllAgendas();
            for (int i = 0; i < ags.length; ++i) {
                this.removeAgenda(ags[i], requester);
            }
        }
    }

    public boolean contains(Agenda agenda) {
        return this.agendas.containsValue(agenda);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Agenda getAgenda(String name) {
        HashMap<Integer, Agenda> hashMap = this.agendas;
        synchronized (hashMap) {
            for (Agenda ag : this.agendas.values()) {
                if (!ag.getName().equals(name)) continue;
                return ag;
            }
        }
        return null;
    }

    public Agenda[] getAllAgendas() {
        return this.agendas.values().toArray(new Agenda[0]);
    }

    public Agenda getAgendaByID(int id) {
        return this.agendas.get(new Integer(id));
    }

    public static Agenda getAgendaByIDFromAnySession(int id) {
        return allAgendas.get(new Integer(id));
    }

    public static int reserveID() {
        HashMap<Integer, Agenda> hashMap = allAgendas;
        synchronized (hashMap) {
            Integer uid;
            while (allAgendas.containsKey(uid = new Integer(idGenerator.nextInt()))) {
            }
            allAgendas.put(uid, null);
            return uid;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmID(int id, Agenda agenda) {
        HashMap<Integer, Agenda> hashMap = allAgendas;
        synchronized (hashMap) {
            if (this.indexed) {
                allAgendas.put(new Integer(id), agenda);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseID(int id) {
        HashMap<Integer, Agenda> hashMap = allAgendas;
        synchronized (hashMap) {
            allAgendas.remove(new Integer(id));
        }
    }

    public synchronized Agenda getActiveAgenda() {
        return this.activeAgenda;
    }

    public boolean isActiveAgenda(Agenda agenda) {
        return agenda == this.activeAgenda;
    }

    public synchronized boolean activateAgenda(Agenda agenda, short requester) {
        if (!this.contains(agenda) || this.isActiveAgenda(agenda)) {
            return false;
        }
        if (this.activeAgenda != null) {
            this.deactivateAgenda(this.activeAgenda, requester);
        }
        this.activeAgenda = agenda;
        this.fireAgendaLibraryEvent(3, agenda, requester);
        return true;
    }

    public synchronized boolean deactivateAgenda(Agenda agenda, short requester) {
        if (!this.contains(agenda) || !this.isActiveAgenda(agenda)) {
            return false;
        }
        this.activeAgenda = null;
        this.fireAgendaLibraryEvent(4, agenda, requester);
        return true;
    }

    public Agenda[] getAutoloadedAgendas() {
        return this.autoloadedAgendas.toArray(new Agenda[0]);
    }

    public boolean isAgendaAutoloaded(Agenda agenda) {
        return this.autoloadedAgendas.contains(agenda);
    }

    public boolean autoloadAgenda(Agenda agenda, short requester) {
        if (!this.contains(agenda) || this.autoloadedAgendas.contains(agenda)) {
            return false;
        }
        this.autoloadedAgendas.add(agenda);
        this.fireAgendaLibraryEvent(5, agenda, requester);
        return true;
    }

    public void addAgendaLibraryListener(AgendaLibraryListener l) {
        this.listenerList.add(AgendaLibraryListener.class, l);
    }

    public void removeAgendaLibraryListener(AgendaLibraryListener l) {
        this.listenerList.remove(AgendaLibraryListener.class, l);
    }

    protected void fireAgendaLibraryEvent(int eventID, Agenda agenda, short requester) {
        AgendaLibraryEvent e = new AgendaLibraryEvent(this, eventID, agenda, requester);
        Object[] ls = this.listenerList.getListenerList();
        block7: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != AgendaLibraryListener.class) continue;
            AgendaLibraryListener l = (AgendaLibraryListener)ls[i + 1];
            switch (eventID) {
                case 1: {
                    l.agendaAdded(e);
                    continue block7;
                }
                case 2: {
                    l.agendaRemoved(e);
                    continue block7;
                }
                case 3: {
                    l.agendaActivated(e);
                    continue block7;
                }
                case 4: {
                    l.agendaDeactivated(e);
                    continue block7;
                }
                case 5: {
                    l.agendaAutoloaded(e);
                }
            }
        }
    }
}

