/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.agenda;

import com.elluminate.groupware.agenda.AgendaAction;
import com.elluminate.groupware.agenda.AgendaFile;
import com.elluminate.groupware.agenda.AgendaItem;
import com.elluminate.groupware.agenda.AgendaNode;
import com.elluminate.groupware.agenda.AgendaObject;
import com.elluminate.groupware.agenda.AgendaText;
import com.elluminate.groupware.agenda.AgendaTopic;
import com.elluminate.groupware.agenda.AgendaUtils;
import com.elluminate.groupware.agenda.Transfer;
import com.elluminate.groupware.agenda.event.AgendaEvent;
import com.elluminate.groupware.agenda.event.AgendaListener;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.ShortList;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.swing.event.EventListenerList;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class Agenda
extends AgendaObject {
    public static final float CURRENT_VERSION = 1.0f;
    public static final String FILENAME_EXTENSION = ".elpx";
    public static final String FILENAME_EXTENSION_V1 = ".elp";
    public static final String DEFINITION_EXTENSION = ".ead";
    public static final String DEFINITION_NAME = "Agenda.ead";
    public static final String FILES_DIRECTORY_NAME = "Files";
    public static final String INFORMATION_NAME = "Info.txt";
    public static final int LABEL_NONE = 0;
    public static final int LABEL_LEADER = 1;
    public static final int LABEL_BULLET = 2;
    public static final int LABEL_NUMBER = 3;
    public static final int LABEL_LEGAL = 4;
    public static final int LABEL_LETTER_LOWERCASE = 5;
    public static final int LABEL_LETTER_UPPERCASE = 6;
    public static final String MODIFIED_PROPERTY = "modified";
    public static final String ID_ATTR = "id";
    public static final String FILE_NAME = "filename";
    public static final String DOC_TYPE_SYSTEM = "http://www.elluminate.com/plan.dtd";
    public static final String ROOT_ELEMENT = "agenda";
    public static final String ROOT_AUTO_TIME_TRACKING_ATTR = "autotimetracking";
    public static final String ROOT_LABEL_TYPE_ATTR = "labeltype";
    public static final String ROOT_SHOW_ICONS_ATTR = "showicons";
    public static final String ROOT_VERSION_ATTR = "version";
    public static final String ROOT_CURRENT_NODE_ATTR = "currentitem";
    public static final boolean ROOT_AUTO_TIME_TRACKING_DEFAULT = false;
    public static final int ROOT_LABEL_TYPE_DEFAULT = 0;
    public static final boolean ROOT_SHOW_ICONS_DEFAULT = true;
    public static final String FILE_ELEMENT = "file";
    public static final String FILE_AUTO_LOAD_ATTR = "autoload";
    public static final String FILE_COMMAND_ATTR = "command";
    public static final String FILE_NAME_ATTR = "name";
    public static final String FILE_PATH_ATTR = "path";
    public static final String FILE_SIZE_ATTR = "size";
    public static final String FILE_PARAMETER_ATTR = "parameter";
    public static final String FILE_PARAMETERS_ATTR = "parameters";
    public static final String NODE_COVERED_ATTR = "covered";
    public static final boolean NODE_COVERED_DEFAULT = false;
    public static final String NODE_DURATION_ATTR = "duration";
    public static final int NODE_DURATION_DEFAULT = 0;
    public static final boolean FILE_AUTO_LOAD_DEFAULT = true;
    public static final String FILE_COMMAND_DEFAULT = null;
    public static final String FILE_PATH_DEFAULT = null;
    public static final String FILE_PARAMETERS_DEFAULT = null;
    public static final String TOPIC_ELEMENT = "topic";
    public static final String TOPIC_NAME_ATTR = "name";
    public static final String TOPIC_NOTE_ATTR = "note";
    public static final String TOPIC_NOTE_DEFAULT = null;
    public static final String TEXT_ELEMENT = "text";
    public static final String TEXT_TEXT_ATTR = "text";
    public static final String ACTION_ELEMENT = "action";
    public static final String ACTION_COMMAND_ATTR = "command";
    public static final String ACTION_DESCRIPTION_ATTR = "description";
    public static final String ACTION_NOTE_ATTR = "note";
    public static final String ACTION_PARAMETER_ATTR = "parameter";
    public static final String ACTION_PARAMETERS_ATTR = "parameters";
    public static final String ACTION_COMMAND_DEFAULT = null;
    public static final String ACTION_NOTE_DEFAULT = null;
    public static final String ACTION_PARAMETERS_DEFAULT = null;
    private String name;
    private File file;
    private File cache;
    private float version = 1.0f;
    private boolean timeTrackingAutomatic = false;
    private int labelType = 0;
    private boolean showingIcons = true;
    private ArrayList files = new ArrayList();
    private ArrayList nodes = new ArrayList();
    private TreeMap itemMap = new TreeMap();
    private int nextItemID = 1;
    private boolean loaded = false;
    private boolean modified = false;
    private EventListenerList listenerList = new EventListenerList();
    private short editor = (short)-32767;
    private ArrayList viewers = new ArrayList();
    private AgendaNode currentNode = null;
    private Document cachedDocument;
    private NodeTimer timer;
    private ArrayList transfers = new ArrayList();
    protected PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    public Agenda(String name) {
        this(name, null);
    }

    public Agenda(String name, File file) {
        this.name = name;
        this.file = file;
    }

    public void setName(String name) {
        this.name = name;
        this.fireAgendaEvent(2, null, FILE_NAME, -1, null);
    }

    public String getName() {
        return this.name;
    }

    public void setFile(File file) {
        this.file = file;
        this.setName(AgendaUtils.parseFileName(file)[0]);
    }

    public File getFile() {
        return this.file;
    }

    public float getVersion() {
        return this.version;
    }

    public void setTimeTrackingAutomatic(boolean timeTrackingAutomatic) {
        if (this.timeTrackingAutomatic != timeTrackingAutomatic) {
            this.timeTrackingAutomatic = timeTrackingAutomatic;
            this.fireAgendaEvent(2, null, ROOT_AUTO_TIME_TRACKING_ATTR, -1, null);
            this.setModified(true);
        }
    }

    public boolean isTimeTrackingAutomatic() {
        return this.timeTrackingAutomatic;
    }

    public void setLabelType(int labelType) {
        switch (labelType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (this.labelType == labelType) break;
                this.labelType = labelType;
                this.fireAgendaEvent(2, null, ROOT_LABEL_TYPE_ATTR, -1, null);
                this.setModified(true);
            }
        }
    }

    public int getLabelType() {
        return this.labelType;
    }

    public void setShowingIcons(boolean showingIcons) {
        if (this.showingIcons != showingIcons) {
            this.showingIcons = showingIcons;
            this.fireAgendaEvent(2, null, ROOT_SHOW_ICONS_ATTR, -1, null);
            this.setModified(true);
        }
    }

    public boolean isShowingIcons() {
        return this.showingIcons;
    }

    public void setEditor(short editor) {
        if (this.editor != editor) {
            this.editor = editor;
            this.fireAgendaEvent(1, null, null, -1, null);
        }
    }

    public short getEditor() {
        return this.editor;
    }

    public void addViewer(short viewer) {
        this.viewers.add(ShortList.get((short)viewer));
    }

    public void removeViewer(short viewer) {
        this.viewers.remove(ShortList.get((short)viewer));
    }

    public int getViewerCount() {
        return this.viewers.size();
    }

    public boolean isViewer(short viewer) {
        return this.viewers.contains(ShortList.get((short)viewer));
    }

    public void setCurrentNode(AgendaNode currentNode) {
        if ((currentNode == null || this.containsItem(currentNode)) && this.currentNode != currentNode) {
            this.currentNode = currentNode;
            this.fireAgendaEvent(2, null, ROOT_CURRENT_NODE_ATTR, -1, null);
        }
    }

    public AgendaNode getCurrentNode() {
        return this.currentNode;
    }

    public boolean isCurrentNode(AgendaNode node) {
        return node != null && node == this.currentNode;
    }

    public AgendaFile getFileBefore(AgendaFile file) {
        int index = this.getFileIndex(file);
        if (index == 0) {
            return null;
        }
        return this.getFile(index - 1);
    }

    public AgendaFile getFileAfter(AgendaFile file) {
        int index = this.getFileIndex(file);
        if (index == this.getFileCount() - 1) {
            return null;
        }
        return this.getFile(index + 1);
    }

    public AgendaNode getNodeBefore(AgendaNode node, boolean withCompoundActions) {
        AgendaNode parent = node.getParent();
        if (parent == null) {
            int index = this.getNodeIndex(node);
            if (index == -1) {
                return null;
            }
            if (index == 0) {
                return null;
            }
            AgendaNode n = this.getNode(index - 1);
            while (true) {
                AgendaAction action;
                int count;
                if (n instanceof AgendaTopic) {
                    AgendaTopic topic = (AgendaTopic)n;
                    count = topic.getNodeCount();
                    if (count == 0) break;
                    n = topic.getNode(count - 1);
                    continue;
                }
                if (!withCompoundActions || !(n instanceof AgendaAction) || (count = (action = (AgendaAction)n).getActionCount()) == 0) break;
                n = action.getAction(count - 1);
            }
            return n;
        }
        if (parent instanceof AgendaTopic) {
            AgendaTopic parentTopic = (AgendaTopic)parent;
            int index = parentTopic.getNodeIndex(node);
            if (index == -1) {
                return null;
            }
            if (index == 0) {
                return parentTopic;
            }
            AgendaNode n = parentTopic.getNode(index - 1);
            while (true) {
                AgendaAction action;
                int count;
                if (n instanceof AgendaTopic) {
                    AgendaTopic topic = (AgendaTopic)n;
                    count = topic.getNodeCount();
                    if (count == 0) break;
                    n = topic.getNode(count - 1);
                    continue;
                }
                if (!withCompoundActions || !(n instanceof AgendaAction) || (count = (action = (AgendaAction)n).getActionCount()) == 0) break;
                n = action.getAction(count - 1);
            }
            return n;
        }
        if (withCompoundActions && parent instanceof AgendaAction && node instanceof AgendaAction) {
            int count;
            AgendaAction parentAction = (AgendaAction)parent;
            int index = parentAction.getActionIndex((AgendaAction)node);
            if (index == -1) {
                return null;
            }
            if (index == 0) {
                return parentAction;
            }
            AgendaAction n = parentAction.getAction(index - 1);
            while ((count = n.getActionCount()) != 0) {
                n = n.getAction(count - 1);
            }
            return n;
        }
        return null;
    }

    public AgendaNode getPreviousNode(boolean withCompoundActions) {
        AgendaNode node = this.currentNode;
        if (node != null) {
            return this.getNodeBefore(node, withCompoundActions);
        }
        return null;
    }

    public AgendaNode getNodeAfter(AgendaNode node, boolean withCompoundActions) {
        int index;
        if (node instanceof AgendaTopic && ((AgendaTopic)node).getNodeCount() != 0) {
            return ((AgendaTopic)node).getNode(0);
        }
        if (withCompoundActions && node instanceof AgendaAction && ((AgendaAction)node).getActionCount() != 0) {
            return ((AgendaAction)node).getAction(0);
        }
        AgendaNode parent = node.getParent();
        if (parent == null) {
            int index2 = this.getNodeIndex(node);
            if (index2 == -1) {
                return null;
            }
            if (index2 == this.getNodeCount() - 1) {
                return null;
            }
            return this.getNode(index2 + 1);
        }
        if (parent instanceof AgendaTopic) {
            AgendaTopic parentTopic = (AgendaTopic)parent;
            index = parentTopic.getNodeIndex(node);
            if (index == -1) {
                return null;
            }
            if (index != parentTopic.getNodeCount() - 1) {
                return parentTopic.getNode(index + 1);
            }
        } else if (withCompoundActions && parent instanceof AgendaAction && node instanceof AgendaAction) {
            AgendaAction parentAction = (AgendaAction)parent;
            index = parentAction.getActionIndex((AgendaAction)node);
            if (index == -1) {
                return null;
            }
            if (index != parentAction.getActionCount() - 1) {
                return parentAction.getAction(index + 1);
            }
        }
        AgendaNode n = parent;
        while (true) {
            int index3;
            if ((parent = n.getParent()) == null) {
                index = this.getNodeIndex(n);
                if (index == -1) {
                    return null;
                }
                if (index == this.getNodeCount() - 1) {
                    return null;
                }
                return this.getNode(index + 1);
            }
            if (parent instanceof AgendaTopic) {
                AgendaTopic parentTopic = (AgendaTopic)parent;
                index3 = parentTopic.getNodeIndex(n);
                if (index3 == -1) {
                    return null;
                }
                if (index3 != parentTopic.getNodeCount() - 1) {
                    return parentTopic.getNode(index3 + 1);
                }
            } else if (withCompoundActions && parent instanceof AgendaAction && n instanceof AgendaAction) {
                AgendaAction parentAction = (AgendaAction)parent;
                index3 = parentAction.getActionIndex((AgendaAction)n);
                if (index3 == -1) {
                    return null;
                }
                if (index3 != parentAction.getActionCount() - 1) {
                    return parentAction.getAction(index3 + 1);
                }
            }
            n = parent;
        }
    }

    public AgendaNode getNextNode(boolean withCompoundActions) {
        AgendaNode node = this.currentNode;
        if (node != null) {
            return this.getNodeAfter(node, withCompoundActions);
        }
        if (this.getNodeCount() == 0) {
            return null;
        }
        return this.getNode(0);
    }

    public AgendaNode getSiblingNodeBefore(AgendaNode node) {
        AgendaAction act;
        int index;
        AgendaNode p = node.getParent();
        if (p == null) {
            int index2 = this.getNodeIndex(node);
            if (index2 > 0) {
                return this.getNode(index2 - 1);
            }
        } else if (p instanceof AgendaTopic) {
            AgendaTopic top = (AgendaTopic)p;
            int index3 = top.getNodeIndex(node);
            if (index3 > 0) {
                return top.getNode(index3 - 1);
            }
        } else if (p instanceof AgendaAction && node instanceof AgendaAction && (index = (act = (AgendaAction)p).getActionIndex((AgendaAction)node)) > 0) {
            return act.getAction(index - 1);
        }
        return null;
    }

    public AgendaNode getSiblingNodeAfter(AgendaNode node) {
        return null;
    }

    public void startTimer(AgendaNode node) {
        this.startTimer(node, -1);
    }

    public synchronized void startTimer(AgendaNode node, int duration) {
        if (this.timer != null) {
            this.stopTimer(this.timer.getNode());
        }
        if (!this.containsItem(node)) {
            return;
        }
        int dur = duration;
        if (dur == -1) {
            dur = node.getDuration();
        }
        if (dur <= 0) {
            return;
        }
        this.timer = new NodeTimer(node);
        this.timer.scheduleIn(dur * 1000);
        this.fireAgendaEvent(6, node, null, -1, null);
    }

    public boolean stopTimer(AgendaNode node) {
        if (this.cancelTimer(node)) {
            this.fireAgendaEvent(7, node, null, -1, null);
            return true;
        }
        return false;
    }

    public synchronized boolean cancelTimer(AgendaNode node) {
        if (this.isRunningNode(node)) {
            this.timer.cancel();
            this.timer = null;
            return true;
        }
        return false;
    }

    public int getTimeLeft(AgendaNode node) {
        NodeTimer t = this.timer;
        if (t != null && t.getNode() == node) {
            return t.getTimeLeft();
        }
        return -1;
    }

    public AgendaNode getRunningNode() {
        NodeTimer t = this.timer;
        return t != null ? t.getNode() : null;
    }

    public boolean isRunningNode(AgendaNode node) {
        NodeTimer t = this.timer;
        return t != null && node == t.getNode() && t.isScheduled();
    }

    public void addFile(AgendaFile file) {
        this.addFile(file, -1);
    }

    public void addFile(AgendaFile file, int index) {
        this.addFile(file, index, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFile(AgendaFile file, int index, boolean fireEvents) {
        TreeMap treeMap = this.itemMap;
        synchronized (treeMap) {
            AgendaObject p = file.parent;
            if (p != null && p instanceof Agenda) {
                ((Agenda)p).removeFile(file);
            }
            file.parent = this;
            if (index >= 0) {
                this.files.add(index, file);
            } else {
                this.files.add(file);
            }
            this.addItemNotify(file, index, fireEvents);
        }
    }

    public void removeFile(AgendaFile file) {
        this.removeFile(file, true);
    }

    private void removeFile(AgendaFile file, boolean fireEvents) {
        if (this.files.remove(file)) {
            file.parent = null;
            this.removeItemNotify(file, fireEvents);
        }
    }

    public AgendaFile[] getFiles() {
        return this.files.toArray(new AgendaFile[0]);
    }

    public int getFileCount() {
        return this.files.size();
    }

    public AgendaFile getFile(int index) {
        return (AgendaFile)this.files.get(index);
    }

    public int getFileIndex(AgendaFile file) {
        return this.files.indexOf(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AgendaFile getFileByName(String name) {
        ArrayList arrayList = this.files;
        synchronized (arrayList) {
            for (AgendaFile file : this.files) {
                if (!file.getName().equals(name)) continue;
                return file;
            }
        }
        return null;
    }

    public void addNode(AgendaNode node) {
        this.addNode(node, -1);
    }

    public void addNode(AgendaNode node, int index) {
        this.addNode(node, index, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNode(AgendaNode node, int index, boolean fireEvents) {
        TreeMap treeMap = this.itemMap;
        synchronized (treeMap) {
            if (node.parent != null) {
                node.removeFromParent();
            }
            node.parent = this;
            if (index >= 0) {
                this.nodes.add(index, node);
            } else {
                this.nodes.add(node);
            }
            this.addItemNotify(node, index, fireEvents);
        }
    }

    public void removeNode(AgendaNode node) {
        this.removeNode(node, true);
    }

    private void removeNode(AgendaNode node, boolean fireEvents) {
        if (this.nodes.remove(node)) {
            node.parent = null;
            this.removeItemNotify(node, fireEvents);
        }
    }

    public int getNodeCount() {
        return this.nodes.size();
    }

    public AgendaNode getNode(int index) {
        return (AgendaNode)this.nodes.get(index);
    }

    public int getNodeIndex(AgendaNode node) {
        return this.nodes.indexOf(node);
    }

    public AgendaNode getFirstNode() {
        return this.nodes.size() != 0 ? (AgendaNode)this.nodes.get(0) : null;
    }

    public AgendaItem getItemByID(int id) {
        return (AgendaItem)this.itemMap.get(new Integer(id));
    }

    public boolean containsItem(AgendaItem item) {
        return this.itemMap.containsValue(item);
    }

    @Override
    void addItemNotify(AgendaItem item, int index) {
        this.addItemNotify(item, index, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addItemNotify(AgendaItem item, int index, boolean fireEvents) {
        TreeMap treeMap = this.itemMap;
        synchronized (treeMap) {
            int id = item.getID();
            if (id == -1 || this.itemMap.containsKey(new Integer(id))) {
                id = this.nextItemID++;
                item.setID(id);
            }
            this.itemMap.put(new Integer(id), item);
            if (fireEvents) {
                this.fireAgendaEvent(3, item, null, index, null);
                this.setModified(true);
            }
            if (item instanceof AgendaTopic) {
                AgendaTopic topic = (AgendaTopic)item;
                for (int i = 0; i < topic.getNodeCount(); ++i) {
                    AgendaNode node = topic.getNode(i);
                    this.addItemNotify(node, -1, fireEvents);
                }
            } else if (item instanceof AgendaAction) {
                AgendaAction action = (AgendaAction)item;
                for (int i = 0; i < action.getActionCount(); ++i) {
                    AgendaAction act = action.getAction(i);
                    this.addItemNotify(act, -1, fireEvents);
                }
            }
        }
    }

    @Override
    void changeItemNotify(AgendaItem item, String property) {
        this.changeItemNotify(item, property, true);
    }

    void changeItemNotify(AgendaItem item, String property, boolean fireEvents) {
        if (fireEvents) {
            this.fireAgendaEvent(5, item, property, -1, null);
            this.setModified(true);
        }
    }

    @Override
    void removeItemNotify(AgendaItem item) {
        this.removeItemNotify(item, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeItemNotify(AgendaItem item, boolean fireEvents) {
        TreeMap treeMap = this.itemMap;
        synchronized (treeMap) {
            if (item instanceof AgendaTopic) {
                AgendaTopic topic = (AgendaTopic)item;
                for (int i = 0; i < topic.getNodeCount(); ++i) {
                    AgendaNode node = topic.getNode(i);
                    this.removeItemNotify(node, fireEvents);
                }
            } else if (item instanceof AgendaAction) {
                AgendaAction action = (AgendaAction)item;
                for (int i = 0; i < action.getActionCount(); ++i) {
                    AgendaAction act = action.getAction(i);
                    this.removeItemNotify(act, fireEvents);
                }
            }
            this.itemMap.remove(new Integer(item.getID()));
            if (fireEvents) {
                this.fireAgendaEvent(4, item, null, -1, null);
                this.setModified(true);
            }
        }
    }

    public boolean isNew() {
        return this.file == null || !this.file.exists();
    }

    public boolean isModified() {
        return this.modified;
    }

    void setModified(boolean modified) {
        boolean oldModified = this.modified;
        this.modified = modified;
        if (modified) {
            this.cachedDocument = null;
        }
        this.changeSupport.firePropertyChange(MODIFIED_PROPERTY, oldModified, modified);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    void setCache(File cache) {
        this.cache = cache;
    }

    public void load() throws IOException {
        if (this.loaded) {
            return;
        }
        try {
            String name = AgendaUtils.filterFileName(this.name);
            this.cache = AgendaUtils.createTempDirectory("plan-" + name);
            this.cache.deleteOnExit();
            if (this.file != null) {
                this.readDefinitionFromFile();
                this.readFiles();
            }
            this.loaded = true;
            this.setModified(false);
        }
        catch (IOException ex) {
            if (this.cache != null) {
                if (this.cache.exists()) {
                    AgendaUtils.deleteRecursively(this.cache);
                }
                this.cache = null;
            }
            throw ex;
        }
    }

    public void load(InputStream in) throws IOException {
        if (this.loaded) {
            return;
        }
        this.readDefinition(in, true);
        this.loaded = true;
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void readDefinitionFromFile() throws IOException {
        ZipFile f = null;
        BufferedInputStream in = null;
        try {
            f = new ZipFile(this.file, 1);
            ZipEntry e = f.getEntry(DEFINITION_NAME);
            if (e == null) {
                throw new IOException("Agenda does not contain a definition");
            }
            in = new BufferedInputStream(f.getInputStream(e));
            this.readDefinition(in, false);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (f != null) {
                try {
                    f.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void readDefinition(InputStream in, boolean preserveFilePaths) throws IOException {
        try {
            SAXBuilder b = new SAXBuilder();
            Document doc = b.build((InputStream)new FilterInputStream(in){

                @Override
                public void close() throws IOException {
                }
            });
            Agenda.documentToDefinition(this, doc, preserveFilePaths);
        }
        catch (JDOMException ex) {
            throw new IOException("Invalid data in agenda definition");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFiles() throws IOException {
        ZipFile zf = null;
        BufferedInputStream in = null;
        try {
            zf = new ZipFile(this.file, 1);
            File filesCache = new File(this.cache, FILES_DIRECTORY_NAME);
            if (!filesCache.exists()) {
                filesCache.mkdir();
                filesCache.deleteOnExit();
            }
            Iterator itr = this.files.iterator();
            while (itr.hasNext()) {
                AgendaFile af = (AgendaFile)itr.next();
                ZipEntry e = zf.getEntry("Files/" + af.getPath());
                if (e == null) {
                    itr.remove();
                    continue;
                }
                in = new BufferedInputStream(zf.getInputStream(e));
                File f = new File(filesCache, af.getPath());
                Agenda.readFile(in, f);
                f.deleteOnExit();
                af.setPath(f.getAbsolutePath());
                af.setSize(f.length());
                in.close();
                in = null;
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readFile(InputStream inputStream, File file) throws IOException {
        FilterOutputStream out = null;
        try {
            int bytesRead;
            out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buf = new byte[1024];
            while ((bytesRead = inputStream.read(buf)) != -1) {
                ((BufferedOutputStream)out).write(buf, 0, bytesRead);
            }
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void documentToDefinition(Agenda agenda, Document document, boolean preserveFilePaths) throws IOException {
        Agenda agenda2 = agenda;
        synchronized (agenda2) {
            AgendaItem it;
            Element root = document.getRootElement();
            if (!root.getName().equals(ROOT_ELEMENT)) {
                throw new IOException("Invalid root element in agenda definition: " + root.getName());
            }
            try {
                agenda.version = Float.parseFloat(root.getAttributeValue(ROOT_VERSION_ATTR));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            String value = root.getAttributeValue(ROOT_AUTO_TIME_TRACKING_ATTR, "false");
            agenda.setTimeTrackingAutomatic(value.equals("true"));
            int type = 0;
            value = root.getAttributeValue(ROOT_LABEL_TYPE_ATTR, "none");
            if (value.equals("uppercaseletter")) {
                type = 6;
            } else if (value.equals("lowercaseletter")) {
                type = 5;
            } else if (value.equals("legal")) {
                type = 4;
            } else if (value.equals("number")) {
                type = 3;
            } else if (value.equals("bullet")) {
                type = 2;
            } else if (value.equals("leader")) {
                type = 1;
            } else if (value.equals("none")) {
                type = 0;
            }
            agenda.setLabelType(type);
            value = root.getAttributeValue(ROOT_SHOW_ICONS_ATTR, "true");
            agenda.setShowingIcons(value.equals("true"));
            int currentNodeID = -1;
            try {
                value = root.getAttributeValue(ROOT_CURRENT_NODE_ATTR, String.valueOf(-1));
                currentNodeID = Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
            for (Element e : root.getChildren()) {
                String name = e.getName();
                if (name.equals(FILE_ELEMENT)) {
                    agenda.addFile(Agenda.elementToFile(e, preserveFilePaths), -1, false);
                    continue;
                }
                if (name.equals(TOPIC_ELEMENT)) {
                    agenda.addNode(Agenda.elementToTopic(e), -1, false);
                    continue;
                }
                if (name.equals("text")) {
                    agenda.addNode(Agenda.elementToText(e), -1, false);
                    continue;
                }
                if (!name.equals(ACTION_ELEMENT)) continue;
                agenda.addNode(Agenda.elementToAction(e), -1, false);
            }
            if (currentNodeID != -1 && (it = agenda.getItemByID(currentNodeID)) instanceof AgendaNode) {
                agenda.currentNode = (AgendaNode)it;
            }
            if (agenda.itemMap.size() != 0) {
                Integer largestID = (Integer)agenda.itemMap.lastKey();
                agenda.nextItemID = largestID + 1;
            }
        }
    }

    private static AgendaFile elementToFile(Element element, boolean preservePath) throws IOException {
        String params;
        String value;
        AgendaFile file = new AgendaFile();
        try {
            value = element.getAttributeValue(ID_ATTR, String.valueOf(-1));
            if (value != null && value.length() != 0) {
                file.setID(Integer.parseInt(value));
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        value = element.getAttributeValue(FILE_AUTO_LOAD_ATTR, "true");
        file.setAutoload(value.equals("true"));
        value = element.getAttributeValue("command");
        if (value != null && value.length() != 0) {
            file.setCommandName(value);
        }
        if ((value = element.getAttributeValue(FILE_PATH_ATTR)) != null && value.length() != 0) {
            if (!preservePath) {
                value = AgendaUtils.getNameFromPath(value);
            }
            file.setPath(value);
        }
        if ((value = element.getAttributeValue("name")) != null && value.length() != 0) {
            file.setName(value);
        }
        if ((value = element.getAttributeValue(FILE_SIZE_ATTR)) != null && value.length() != 0) {
            try {
                file.setSize(Long.parseLong(value));
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        if ((params = element.getAttributeValue("parameters")) != null) {
            StringTokenizer st = new StringTokenizer(params, ";");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                int pos = param.indexOf(":");
                if (pos == -1) continue;
                String name = param.substring(0, pos);
                value = param.substring(pos + 1);
                file.setCommandParameter(name, value);
            }
        }
        return file;
    }

    private static AgendaTopic elementToTopic(Element element) throws IOException {
        String value;
        AgendaTopic topic = new AgendaTopic();
        try {
            value = element.getAttributeValue(ID_ATTR, String.valueOf(-1));
            if (value != null && value.length() != 0) {
                topic.setID(Integer.parseInt(value));
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        value = element.getAttributeValue(NODE_COVERED_ATTR, "false");
        topic.setCovered(value.equals("true"));
        value = element.getAttributeValue("name", "");
        topic.setName(value);
        value = element.getAttributeValue("note");
        if (value != null && value.length() != 0) {
            topic.setNote(value);
        }
        try {
            value = element.getAttributeValue(NODE_DURATION_ATTR, "0");
            topic.setDuration(Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        for (Element child : element.getChildren()) {
            String name = child.getName();
            if (name.equals(TOPIC_ELEMENT)) {
                topic.addNode(Agenda.elementToTopic(child));
                continue;
            }
            if (name.equals("text")) {
                topic.addNode(Agenda.elementToText(child));
                continue;
            }
            if (name.equals(ACTION_ELEMENT)) {
                topic.addNode(Agenda.elementToAction(child));
                continue;
            }
            throw new IOException("Invalid child of topic element in agenda definition: " + name);
        }
        return topic;
    }

    private static AgendaText elementToText(Element element) throws IOException {
        String value;
        AgendaText text = new AgendaText();
        try {
            value = element.getAttributeValue(ID_ATTR, String.valueOf(-1));
            if (value != null && value.length() != 0) {
                text.setID(Integer.parseInt(value));
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        value = element.getAttributeValue(NODE_COVERED_ATTR, "false");
        text.setCovered(value.equals("true"));
        try {
            value = element.getAttributeValue(NODE_DURATION_ATTR, "0");
            text.setDuration(Integer.parseInt(value));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        text.setText(element.getText());
        return text;
    }

    private static AgendaAction elementToAction(Element element) throws IOException {
        String value;
        AgendaAction action = new AgendaAction();
        try {
            value = element.getAttributeValue(ID_ATTR, String.valueOf(-1));
            if (value != null && value.length() != 0) {
                action.setID(Integer.parseInt(value));
            }
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        value = element.getAttributeValue("command");
        if (value != null && value.length() != 0) {
            action.setCommandName(value);
        }
        value = element.getAttributeValue(NODE_COVERED_ATTR, "false");
        action.setCovered(value.equals("true"));
        value = element.getAttributeValue(ACTION_DESCRIPTION_ATTR);
        action.setDescription(value);
        value = element.getAttributeValue("note", "");
        action.setNote(value);
        try {
            value = element.getAttributeValue(NODE_DURATION_ATTR, "0");
            action.setDuration(Integer.parseInt(value));
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        String params = element.getAttributeValue("parameters");
        if (params != null) {
            StringTokenizer st = new StringTokenizer(params, ";");
            while (st.hasMoreTokens()) {
                String param = st.nextToken();
                int pos = param.indexOf(":");
                if (pos == -1) continue;
                String name = param.substring(0, pos);
                value = param.substring(pos + 1);
                action.setCommandParameter(name, value);
            }
        }
        for (Element child : element.getChildren()) {
            String name = child.getName();
            if (name.equals(ACTION_ELEMENT)) {
                action.addAction(Agenda.elementToAction(child));
                continue;
            }
            throw new IOException("Invalid child of action element in agenda definition: " + name);
        }
        return action;
    }

    public synchronized void unload() {
        AgendaNode node = this.getRunningNode();
        if (node != null) {
            this.cancelTimer(node);
        }
        if (this.cache != null) {
            if (this.cache.exists()) {
                AgendaUtils.deleteRecursively(this.cache);
            }
            this.cache = null;
        }
        this.itemMap.clear();
        this.files.clear();
        this.nodes.clear();
        this.nextItemID = 1;
        this.loaded = false;
        this.setModified(false);
    }

    public boolean isFiled() {
        return this.file != null && this.file.exists();
    }

    public synchronized void save() throws IOException {
        this.writeAgendaFile(this.file);
        this.setModified(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void writeAgendaFile(File file) throws IOException {
        File f = null;
        ZipOutputStream out = null;
        try {
            f = AgendaUtils.createSaveFile(file);
            out = new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(f)));
            ZipEntry en = new ZipEntry(DEFINITION_NAME);
            out.putNextEntry(en);
            this.writeDefinition(out);
            out.closeEntry();
            for (AgendaFile af : this.files) {
                en = new ZipEntry("Files/" + new File(af.getPath()).getName());
                out.putNextEntry(en);
                Agenda.writeFile(out, af);
                out.closeEntry();
            }
            out.finish();
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ex) {}
            }
        }
        if (file.exists() && !file.delete()) {
            throw new IOException("Could not delete original file for replacement");
        }
        if (!f.renameTo(file)) {
            throw new IOException("Could not rename temporary file to original file");
        }
        f.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDefinition(OutputStream outputStream) throws IOException {
        Agenda agenda = this;
        synchronized (agenda) {
            if (this.cachedDocument == null) {
                this.cachedDocument = Agenda.definitionToDocument(this);
            }
        }
        XMLOutputter xout = new XMLOutputter();
        xout.setFormat(Format.getPrettyFormat());
        xout.output(this.cachedDocument, outputStream);
    }

    synchronized void writeDefinitionAsText(BufferedWriter writer, boolean expandCompoundActions) throws IOException {
        for (int i = 0; i < this.getNodeCount(); ++i) {
            Agenda.writeNodeAsText(writer, this.getNode(i), 0, expandCompoundActions);
        }
    }

    private static void writeNodeAsText(BufferedWriter writer, AgendaNode node, int depth, boolean expandCompoundActions) throws IOException {
        block9: {
            block8: {
                for (int i = 0; i < depth; ++i) {
                    writer.write("\t");
                }
                if (node instanceof AgendaTopic) {
                    writer.write(((AgendaTopic)node).getName());
                } else if (node instanceof AgendaAction) {
                    writer.write(((AgendaAction)node).getDescription());
                } else if (node instanceof AgendaText) {
                    writer.write(((AgendaText)node).getText());
                }
                writer.newLine();
                if (!(node instanceof AgendaTopic)) break block8;
                AgendaTopic top = (AgendaTopic)node;
                for (int i = 0; i < top.getNodeCount(); ++i) {
                    Agenda.writeNodeAsText(writer, top.getNode(i), depth + 1, expandCompoundActions);
                }
                break block9;
            }
            if (!(node instanceof AgendaAction) || !expandCompoundActions) break block9;
            AgendaAction act = (AgendaAction)node;
            for (int i = 0; i < act.getActionCount(); ++i) {
                Agenda.writeNodeAsText(writer, act.getAction(i), depth + 1, expandCompoundActions);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeFile(OutputStream outputStream, AgendaFile file) throws IOException {
        File f = new File(file.getPath());
        if (!f.exists()) {
            throw new FileNotFoundException("File not found: " + f.getPath());
        }
        BufferedInputStream in = null;
        try {
            int bytesRead;
            in = new BufferedInputStream(new FileInputStream(f));
            byte[] buf = new byte[1024];
            while ((bytesRead = in.read(buf)) != -1) {
                outputStream.write(buf, 0, bytesRead);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Document definitionToDocument(Agenda agenda) {
        Agenda agenda2 = agenda;
        synchronized (agenda2) {
            Element e;
            int i;
            AgendaNode cur;
            boolean show;
            int type;
            Element root = new Element(ROOT_ELEMENT);
            NumberFormat fmt = NumberFormat.getNumberInstance();
            fmt.setMinimumIntegerDigits(1);
            fmt.setMinimumFractionDigits(1);
            root.setAttribute(ROOT_VERSION_ATTR, fmt.format(agenda.getVersion()));
            boolean auto = agenda.isTimeTrackingAutomatic();
            if (auto) {
                root.setAttribute(ROOT_AUTO_TIME_TRACKING_ATTR, auto ? "true" : "false");
            }
            if ((type = agenda.getLabelType()) != 0) {
                switch (type) {
                    case 0: {
                        root.setAttribute(ROOT_LABEL_TYPE_ATTR, "none");
                        break;
                    }
                    case 1: {
                        root.setAttribute(ROOT_LABEL_TYPE_ATTR, "leader");
                        break;
                    }
                    case 2: {
                        root.setAttribute(ROOT_LABEL_TYPE_ATTR, "bullet");
                        break;
                    }
                    case 3: {
                        root.setAttribute(ROOT_LABEL_TYPE_ATTR, "number");
                        break;
                    }
                    case 4: {
                        root.setAttribute(ROOT_LABEL_TYPE_ATTR, "legal");
                        break;
                    }
                    case 5: {
                        root.setAttribute(ROOT_LABEL_TYPE_ATTR, "lowercaseletter");
                        break;
                    }
                    case 6: {
                        root.setAttribute(ROOT_LABEL_TYPE_ATTR, "uppercaseletter");
                    }
                }
            }
            if (!(show = agenda.isShowingIcons())) {
                root.setAttribute(ROOT_SHOW_ICONS_ATTR, show ? "true" : "false");
            }
            if ((cur = agenda.getCurrentNode()) != null) {
                root.setAttribute(ROOT_CURRENT_NODE_ATTR, String.valueOf(cur.getID()));
            }
            boolean includeID = cur != null;
            Document doc = new Document(root);
            for (i = 0; i < agenda.getFileCount(); ++i) {
                AgendaFile file = agenda.getFile(i);
                e = Agenda.fileToElement(file, includeID);
                root.addContent((Content)e);
            }
            for (i = 0; i < agenda.getNodeCount(); ++i) {
                AgendaNode node = agenda.getNode(i);
                e = null;
                if (node instanceof AgendaTopic) {
                    e = Agenda.topicToElement((AgendaTopic)node, includeID);
                } else if (node instanceof AgendaText) {
                    e = Agenda.textToElement((AgendaText)node, includeID);
                } else if (node instanceof AgendaAction) {
                    e = Agenda.actionToElement((AgendaAction)node, includeID);
                }
                if (e == null) continue;
                root.addContent((Content)e);
            }
            return doc;
        }
    }

    private static Element fileToElement(AgendaFile file, boolean includeID) {
        String path;
        String cmd;
        boolean auto;
        int id;
        Element e = new Element(FILE_ELEMENT);
        if (includeID && (id = file.getID()) != -1) {
            e.setAttribute(ID_ATTR, String.valueOf(id));
        }
        if (!(auto = file.isAutoload())) {
            e.setAttribute(FILE_AUTO_LOAD_ATTR, auto ? "true" : "false");
        }
        if ((cmd = file.getCommandName()) != null && !cmd.equals(FILE_COMMAND_DEFAULT)) {
            e.setAttribute("command", cmd);
        }
        if ((path = file.getPath()) != null) {
            path = AgendaUtils.getNameFromPath(path);
        }
        if (path != null && !path.equals(FILE_PATH_DEFAULT)) {
            e.setAttribute(FILE_PATH_ATTR, path);
        }
        e.setAttribute("name", file.getName());
        e.setAttribute(FILE_SIZE_ATTR, String.valueOf(file.getSize()));
        String params = "";
        String[] paramNames = file.getCommandParameterNames();
        for (int i = 0; i < paramNames.length; ++i) {
            if (params.length() != 0) {
                params = params + ";";
            }
            params = params + paramNames[i] + ":" + file.getCommandParameter(paramNames[i]);
        }
        if (!params.equals(FILE_PARAMETERS_DEFAULT)) {
            e.setAttribute("parameters", params);
        }
        return e;
    }

    private static Element topicToElement(AgendaTopic topic, boolean includeID) {
        int dur;
        boolean cov;
        int id;
        Element e = new Element(TOPIC_ELEMENT);
        if (includeID && (id = topic.getID()) != -1) {
            e.setAttribute(ID_ATTR, String.valueOf(id));
        }
        if (cov = topic.isCovered()) {
            e.setAttribute(NODE_COVERED_ATTR, cov ? "true" : "false");
        }
        if ((dur = topic.getDuration()) != 0) {
            e.setAttribute(NODE_DURATION_ATTR, String.valueOf(dur));
        }
        e.setAttribute("name", topic.getName());
        String note = topic.getNote();
        if (note != null && !note.equals(TOPIC_NOTE_DEFAULT)) {
            e.setAttribute("note", note);
        }
        for (int i = 0; i < topic.getNodeCount(); ++i) {
            Element child = null;
            AgendaNode node = topic.getNode(i);
            if (node instanceof AgendaTopic) {
                child = Agenda.topicToElement((AgendaTopic)node, includeID);
            } else if (node instanceof AgendaText) {
                child = Agenda.textToElement((AgendaText)node, includeID);
            } else if (node instanceof AgendaAction) {
                child = Agenda.actionToElement((AgendaAction)node, includeID);
            }
            if (child == null) continue;
            e.addContent((Content)child);
        }
        return e;
    }

    private static Element textToElement(AgendaText text, boolean includeID) {
        int dur;
        boolean cov;
        int id;
        Element e = new Element("text");
        if (includeID && (id = text.getID()) != -1) {
            e.setAttribute(ID_ATTR, String.valueOf(id));
        }
        if (cov = text.isCovered()) {
            e.setAttribute(NODE_COVERED_ATTR, cov ? "true" : "false");
        }
        if ((dur = text.getDuration()) != 0) {
            e.setAttribute(NODE_DURATION_ATTR, String.valueOf(dur));
        }
        e.addContent(text.getText());
        return e;
    }

    private static Element actionToElement(AgendaAction action, boolean includeID) {
        int i;
        String note;
        boolean cov;
        String cmd;
        int id;
        Element e = new Element(ACTION_ELEMENT);
        if (includeID && (id = action.getID()) != -1) {
            e.setAttribute(ID_ATTR, String.valueOf(id));
        }
        if ((cmd = action.getCommandName()) != null && !cmd.equals(ACTION_COMMAND_DEFAULT)) {
            e.setAttribute("command", cmd);
        }
        if (cov = action.isCovered()) {
            e.setAttribute(NODE_COVERED_ATTR, cov ? "true" : "false");
        }
        e.setAttribute(ACTION_DESCRIPTION_ATTR, action.getDescription());
        int dur = action.getDuration();
        if (dur != 0) {
            e.setAttribute(NODE_DURATION_ATTR, String.valueOf(dur));
        }
        if ((note = action.getNote()) != null && !note.equals(ACTION_NOTE_DEFAULT)) {
            e.setAttribute("note", note);
        }
        String params = "";
        String[] paramNames = action.getCommandParameterNames();
        for (i = 0; i < paramNames.length; ++i) {
            if (params.length() != 0) {
                params = params + ";";
            }
            params = params + paramNames[i] + ":" + action.getCommandParameter(paramNames[i]);
        }
        if (!params.equals(ACTION_PARAMETERS_DEFAULT)) {
            e.setAttribute("parameters", params);
        }
        for (i = 0; i < action.getActionCount(); ++i) {
            AgendaAction act = action.getAction(i);
            Element child = Agenda.actionToElement(act, includeID);
            e.addContent((Content)child);
        }
        return e;
    }

    public void addTransfer(Transfer transfer) {
        this.transfers.add(transfer);
        this.fireAgendaEvent(8, null, null, -1, transfer);
    }

    public void removeTransfer(Transfer transfer) {
        if (this.transfers.remove(transfer)) {
            this.fireAgendaEvent(9, null, null, -1, transfer);
        }
    }

    public Transfer[] getTransfers() {
        return this.transfers.toArray(new Transfer[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transfer[] getTransfers(int type) {
        ArrayList arrayList = this.transfers;
        synchronized (arrayList) {
            ArrayList<Transfer> list = new ArrayList<Transfer>();
            for (Transfer tfr : this.transfers) {
                if (tfr.getType() != type) continue;
                list.add(tfr);
            }
            return list.toArray(new Transfer[0]);
        }
    }

    public boolean isTransferring(int type) {
        Transfer[] tfrs = this.getTransfers(type);
        return tfrs != null && tfrs.length != 0;
    }

    public void addAgendaListener(AgendaListener l) {
        this.listenerList.add(AgendaListener.class, l);
    }

    public void removeAgendaListener(AgendaListener l) {
        this.listenerList.remove(AgendaListener.class, l);
    }

    protected void fireAgendaEvent(int eventID, AgendaItem item, String property, int index, Transfer transfer) {
        AgendaEvent e = new AgendaEvent(this, eventID, item, property, index, transfer);
        Object[] ls = this.listenerList.getListenerList();
        block11: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != AgendaListener.class) continue;
            AgendaListener l = (AgendaListener)ls[i + 1];
            switch (eventID) {
                case 1: {
                    l.editorChanged(e);
                    continue block11;
                }
                case 2: {
                    l.agendaPropertyChanged(e);
                    continue block11;
                }
                case 3: {
                    l.itemAdded(e);
                    continue block11;
                }
                case 4: {
                    l.itemRemoved(e);
                    continue block11;
                }
                case 5: {
                    l.itemPropertyChanged(e);
                    continue block11;
                }
                case 6: {
                    l.timerStarted(e);
                    continue block11;
                }
                case 7: {
                    l.timerStopped(e);
                    continue block11;
                }
                case 8: {
                    l.transferAdded(e);
                    continue block11;
                }
                case 9: {
                    l.transferRemoved(e);
                }
            }
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    @Override
    protected String paramString() {
        StringBuffer b = new StringBuffer();
        b.append(super.paramString());
        b.append(",name=");
        b.append(this.name);
        b.append(",editor=");
        b.append(this.editor);
        return b.toString();
    }

    private class NodeTimer
    extends LightweightTimer {
        private AgendaNode node;
        private long endTime;
        private long timeLeft;

        public NodeTimer(AgendaNode node) {
            super((Runnable)new TimerStopper(node));
            this.timeLeft = -1L;
            this.node = node;
        }

        public AgendaNode getNode() {
            return this.node;
        }

        public int getTimeLeft() {
            double t = this.timeLeft;
            if (t == -1.0) {
                t = Math.max(this.endTime - System.currentTimeMillis(), 0L);
            }
            return (int)Math.round(t / 1000.0);
        }

        public void scheduleIn(long delta) {
            this.endTime = System.currentTimeMillis() + delta;
            super.scheduleEvery(delta);
        }

        public boolean cancel() {
            this.timeLeft = Math.max(this.endTime - System.currentTimeMillis(), 0L);
            return super.cancel();
        }
    }

    private class TimerStopper
    implements Runnable {
        private AgendaNode node;

        public TimerStopper(AgendaNode node) {
            this.node = node;
        }

        @Override
        public void run() {
            Agenda.this.stopTimer(this.node);
        }
    }
}

