/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony.module;

import com.elluminate.groupware.telephony.TelephonyFlags;
import com.elluminate.groupware.telephony.module.StringsProperties;
import com.elluminate.groupware.telephony.module.TelephonyModule;
import com.elluminate.gui.component.RollOverButton;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.log.LogSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TelephonyBean
extends JPanel
implements ActionListener {
    private I18n i18n = I18n.create((Object)this);
    private volatile int state = 1;
    private volatile boolean configured = false;
    private volatile boolean moderator = false;
    private JLabel telStatus = new JLabel();
    private Icon connectingIcon = null;
    private Icon connectedIcon = null;
    private Icon disconnectedIcon = null;
    private JButton telBtn = new RollOverButton();
    private Component spacer = null;
    private Icon connectIcon = null;
    private Icon disconnectIcon = null;
    private Icon configureIcon = null;
    private Runnable updater;
    private Provider<TelephonyModule> moduleProvider;

    @Inject
    public TelephonyBean() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.telStatus, "West");
        this.connectingIcon = this.i18n.getIcon("TelephonyBean.connectingIcon");
        this.connectedIcon = this.i18n.getIcon("TelephonyBean.connectedIcon");
        this.disconnectedIcon = this.i18n.getIcon("TelephonyBean.disconnectedIcon");
        this.connectIcon = this.i18n.getIcon("TelephonyBean.connectIcon");
        this.disconnectIcon = this.i18n.getIcon("TelephonyBean.disconnectIcon");
        this.configureIcon = this.i18n.getIcon("TelephonyBean.configureIcon");
        int w = this.connectingIcon.getIconWidth();
        int h = this.connectingIcon.getIconHeight();
        if (this.connectedIcon.getIconWidth() > w) {
            w = this.connectedIcon.getIconWidth();
        }
        this.telStatus.setText(null);
        this.telStatus.setIcon(this.disconnectedIcon);
        this.telStatus.setPreferredSize(new Dimension(w, h));
        w = this.connectIcon.getIconWidth();
        h = this.connectIcon.getIconHeight();
        if (this.disconnectIcon.getIconWidth() > w) {
            w = this.disconnectIcon.getIconWidth();
        }
        if (this.configureIcon.getIconWidth() > w) {
            w = this.configureIcon.getIconWidth();
        }
        this.telBtn.setText(null);
        this.telBtn.setIcon(this.configureIcon);
        this.telBtn.setEnabled(false);
        this.telBtn.setMargin(new Insets(0, 0, 0, 0));
        this.telBtn.setPreferredSize(new Dimension(w, h));
        this.telBtn.addActionListener(this);
        this.spacer = Box.createHorizontalStrut(8);
        this.updater = new Runnable(){

            @Override
            public void run() {
                TelephonyBean.this.update();
            }
        };
    }

    @Inject
    public void initModululeProvider(Provider<TelephonyModule> module) {
        this.moduleProvider = module;
    }

    boolean isConfigured() {
        return this.configured;
    }

    void setConfigured(boolean b) {
        if (this.configured == b) {
            return;
        }
        this.configured = b;
        SwingRunnerSupport.invokeLater((Runnable)this.updater);
    }

    boolean isModerator() {
        return this.moderator;
    }

    void setModerator(boolean b) {
        if (this.moderator == b) {
            return;
        }
        this.moderator = b;
        SwingRunnerSupport.invokeLater((Runnable)this.updater);
    }

    int getState() {
        return this.state;
    }

    void setState(int s) {
        if (this.state == s) {
            return;
        }
        if (s != 1 && s != 4 && s != 2 && s != 3) {
            throw new IllegalArgumentException("Invalid state: " + s);
        }
        this.state = s;
        SwingRunnerSupport.invokeLater((Runnable)this.updater);
    }

    private void update() {
        if (TelephonyFlags.UPDATE_UI.show()) {
            LogSupport.message((Object)this, (String)"update", (String)("state=" + this.state + " configured=" + this.configured + " moderator=" + this.moderator));
        }
        String tip = null;
        String btnTip = null;
        Icon icon = null;
        Icon btnIcon = null;
        boolean btnEnable = false;
        if (this.state == 3) {
            icon = this.connectedIcon;
            tip = this.i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYBEAN_CONNECTEDSTATUSTIP);
            btnIcon = this.disconnectIcon;
            btnTip = this.i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYBEAN_DISCONNECTACTIONBTNTIP);
            btnEnable = true;
        } else if (this.state == 2) {
            icon = this.connectingIcon;
            tip = this.i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYBEAN_CONNECTINGSTATUSTIP);
            btnIcon = this.connectingIcon;
            btnTip = null;
            btnEnable = false;
        } else {
            icon = this.disconnectedIcon;
            tip = this.i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYBEAN_DISCONNECTEDSTATUSTIP);
            if (this.configured) {
                btnIcon = this.connectIcon;
                btnTip = this.i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYBEAN_CONNECTACTIONBTNTIP);
            } else {
                btnIcon = this.configureIcon;
                btnTip = this.i18n.getString((PropertiesEnum)StringsProperties.TELEPHONYBEAN_CONFIGUREACTIONBTNTIP);
            }
            btnEnable = true;
        }
        this.telStatus.setIcon(icon);
        this.telStatus.setToolTipText(tip);
        if (this.moderator) {
            if (this.telBtn.getParent() != this) {
                this.add((Component)this.telBtn, "East");
                this.add(this.spacer, "Center");
            }
            this.telBtn.setVisible(true);
            this.telBtn.setIcon(btnIcon);
            this.telBtn.setToolTipText(btnTip);
            this.telBtn.setEnabled(btnEnable);
        } else {
            this.telBtn.setEnabled(false);
            this.telBtn.setVisible(false);
            this.remove(this.telBtn);
            this.remove(this.spacer);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Object src = ev.getSource();
        if (src == this.telBtn) {
            boolean shifted;
            if (this.moduleProvider.get() == null) {
                return;
            }
            boolean bl = shifted = (ev.getModifiers() & 1) != 0;
            if (shifted) {
                ((TelephonyModule)this.moduleProvider.get()).doSetUp();
            } else if (this.state == 1) {
                if (!this.configured) {
                    ((TelephonyModule)this.moduleProvider.get()).doSetUp();
                } else {
                    ((TelephonyModule)this.moduleProvider.get()).sendConnect();
                }
            } else if (this.state == 3) {
                ((TelephonyModule)this.moduleProvider.get()).queryAndDisconnect();
            }
        }
    }
}

