/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.calculator.module;

import com.elluminate.classroom.client.messaging.ModulePublisherInfo;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.Chair;
import com.elluminate.groupware.ChairProtocol;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.calculator.module.CalculatorBean;
import com.elluminate.groupware.calculator.module.StringsProperties;
import com.elluminate.groupware.imps.PlaybackTimeAPI;
import com.elluminate.groupware.imps.PlaybackTimeListener;
import com.elluminate.groupware.module.AbstractClientModule;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.Connection;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.ComponentRegistrar;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;

public class CalculatorModule
extends AbstractClientModule
implements ModulePublisherInfo,
ItemListener,
PropertyChangeListener,
PlaybackTimeListener {
    public static final String MODULE_NAME = "calculator";
    private I18n i18n;
    private Imps imps;
    private ClientList clients = null;
    private ClientProvider clientProvider;
    private Provider<CalculatorBean> beanProvider;
    private CalculatorBean calculatorBean;
    private FeatureBroker broker;
    private ComponentFeature calculatorPanelFeature;
    private BooleanFeature lockFeature;
    private BooleanFeature showMenuFeature;
    private volatile boolean seeking;

    @Inject
    public CalculatorModule() {
    }

    @Inject
    protected void initVersionManager(ComponentRegistrar cr) {
        cr.registerComponent((Object)this);
    }

    @Inject
    public void initClientProvider(ClientProvider cp) {
        this.clientProvider = cp;
    }

    @Inject
    public void initFeatureBroker(FeatureBroker broker) {
        this.broker = broker;
    }

    @Inject
    public void initCalculatorBeanProvider(Provider<CalculatorBean> provider) {
        this.beanProvider = provider;
    }

    @Inject
    public void initI18n(I18n i18n) {
        this.i18n = i18n;
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    public String getNameOfModule() {
        return MODULE_NAME;
    }

    public String getDisplayNameOfModule() {
        return this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORMODULE_TITLE);
    }

    public Icon getModuleIcon() {
        return this.i18n.getIcon("CalculatorModule.accessIcon");
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        boolean show = e.getStateChange() == 1;
        this.changeState(show);
    }

    private void changeState(boolean show) {
        Chair chair = ChairProtocol.getChair((Connection)this.clientProvider.get());
        boolean visible = this.clients.getProperty("calculatorVisible", false);
        if (show && ((Boolean)this.showMenuFeature.getValue()).booleanValue()) {
            this.broker.addFeature((Feature)this.calculatorPanelFeature);
        } else {
            show = false;
            this.broker.removeFeature((Feature)this.calculatorPanelFeature);
        }
        if (chair.isMe() && show != visible) {
            this.clients.setProperty("calculatorVisible", show);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String nm = e.getPropertyName();
        if (this.calculatorBean != null && (nm.equals("calculatorLocked") || nm.equals("calculatorVisible") || nm.equals("chair"))) {
            boolean locked = this.clients.getProperty("calculatorLocked", false);
            boolean visible = this.clients.getProperty("calculatorVisible", false);
            boolean chair = ChairProtocol.getChair((Connection)this.clientProvider.get()).isMe();
            if (locked) {
                if ((Boolean)this.showMenuFeature.getValue() != visible && !this.seeking) {
                    this.showMenuFeature.setValue((Object)visible);
                    this.changeState(visible);
                }
                this.lockFeature.setValue((Object)true);
            } else {
                this.lockFeature.setValue((Object)false);
            }
            this.showMenuFeature.setEnabled(!locked || chair);
            if (chair) {
                this.broker.addFeature((Feature)this.lockFeature);
            } else {
                this.broker.removeFeature((Feature)this.lockFeature);
            }
        }
    }

    public boolean requestClose() {
        if (this.showMenuFeature.isEnabled()) {
            this.changeState(false);
            return true;
        }
        return false;
    }

    private void createFeatures() {
        this.showMenuFeature = this.broker.createBooleanFeature((Object)this, "/calculator/showMenu", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORMODULE_SHOWMENU), null);
        this.showMenuFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORMODULE_SHOWMENU));
        this.showMenuFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORMODULE_SHOWMENU));
        this.showMenuFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent event) {
                CalculatorModule.this.changeState(true);
            }
        });
        this.broker.addFeature((Feature)this.showMenuFeature);
        this.lockFeature = this.broker.createBooleanFeature((Object)this, "/calculator/lock", true, false, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FOLLOWMODERATOR, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator")}), null);
        this.lockFeature.setTrueText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FOLLOWMODERATOR, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator")}));
        this.lockFeature.setFalseText(this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORBEAN_FOLLOWMODERATOR, new Object[]{LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator")}));
        this.lockFeature.addValueChangeListener(new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                boolean newValue = Boolean.parseBoolean(ev.getNewValue().toString());
                CalculatorModule.this.calculatorBean.lock_itemStateChanged(newValue);
            }
        });
        this.calculatorPanelFeature = this.broker.createComponentFeature((Object)this, "/calculator/calculatorPanel", new ComponentProvider(){

            public Component get(ComponentFeature feature) {
                return CalculatorModule.this.calculatorBean;
            }
        }, this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORMODULE_TITLE), this.i18n.getString((PropertiesEnum)StringsProperties.CALCULATORMODULE_TITLE));
    }

    public void start() {
    }

    public void attach() {
        this.clients = this.clientProvider.get().getClientList();
        this.clients.addPropertyChangeListener("calculatorLocked", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("calculatorVisible", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("chair", (PropertyChangeListener)this);
        this.calculatorBean = (CalculatorBean)this.beanProvider.get();
        this.calculatorBean.setClient();
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
    }

    public void setupUI() {
        this.createFeatures();
    }

    public void cleanupUI() {
    }

    public void detach() {
        PlaybackTimeAPI playbackTimeApi = (PlaybackTimeAPI)this.imps.findBest(PlaybackTimeAPI.class);
        if (playbackTimeApi != null) {
            playbackTimeApi.addPlaybackTimeListener((PlaybackTimeListener)this);
        }
        if (this.clients != null) {
            this.clients.removePropertyChangeListener("calculatorLocked", (PropertyChangeListener)this);
            this.clients.removePropertyChangeListener("calculatorVisible", (PropertyChangeListener)this);
            this.clients.removePropertyChangeListener("chair", (PropertyChangeListener)this);
        }
    }

    public void stop() {
    }

    public void setLinearity(PlaybackTimeListener.Linearity spd) {
        boolean bl = this.seeking = spd == PlaybackTimeListener.Linearity.SEEKING;
        if (!this.seeking) {
            boolean locked = this.clients.getProperty("calculatorLocked", false);
            boolean visible = this.clients.getProperty("calculatorVisible", false);
            if (locked) {
                this.showMenuFeature.setValue((Object)visible);
            }
        }
    }

    public void resetSession() {
        this.showMenuFeature.setValue((Object)false);
    }
}

