/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.participant.ActivityDisplay;
import com.elluminate.classroom.swing.participant.ParticipantList;
import com.elluminate.classroom.swing.participant.ParticipantListModel;
import com.elluminate.classroom.swing.participant.StringsProperties;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

class RoomRenderer
extends ParticipantList.Renderer {
    private I18n i18n = I18n.create((Object)this);
    private JLabel nameLabel;
    private JLabel optionsLabel;
    private ActivityDisplay activityPanel;
    private JList list;
    private int index;
    private boolean selected;
    private boolean pressed;
    private Point hoverLocation;
    private boolean isLastOrEmpty;
    private Map<Integer, Rectangle> activityBoundsMap = new HashMap<Integer, Rectangle>();
    private Map<Integer, Collection<JLabel>> activityLabelsMap = new HashMap<Integer, Collection<JLabel>>();

    public RoomRenderer() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.anchor = 18;
        gbc.insets.left = 0;
        this.nameLabel = new JLabel();
        this.nameLabel.setBorder(BorderFactory.createEmptyBorder(2, 5, 2, 5));
        Font f = UIManager.getFont("List.font");
        this.nameLabel.setFont(f.deriveFont((float)f.getSize() * 11.0f / 12.0f));
        this.add((Component)this.nameLabel, gbc);
        gbc.weightx = 0.0;
        gbc.anchor = 12;
        gbc.insets.left = 6;
        this.optionsLabel = new JLabel();
        this.optionsLabel.setIcon(UIManager.getIcon("SideBar.optionsIcon"));
        this.add((Component)this.optionsLabel, gbc);
        gbc.weightx = 0.0;
        gbc.anchor = 12;
        gbc.insets.left = 0;
        gbc.insets.top = 2;
        gbc.insets.right = 2;
        this.activityPanel = new ActivityDisplay();
        this.activityPanel.setShowingPoll(false);
        this.add((Component)this.activityPanel, gbc);
    }

    @Override
    public void doLayout() {
        super.doLayout();
        Rectangle b = this.optionsLabel.getBounds();
        b = SwingUtilities.convertRectangle(this, b, this.getParent());
        if (this.pressed || this.hoverLocation != null && b.contains(this.hoverLocation)) {
            this.optionsLabel.setIcon(UIManager.getIcon("SideBar.optionsPressedIcon"));
        } else {
            this.optionsLabel.setIcon(UIManager.getIcon("SideBar.optionsIcon"));
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        this.activityBoundsMap.put(this.index, this.activityPanel.getBounds());
        this.activityLabelsMap.put(this.index, this.activityPanel.getActivityLabels());
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.selected) {
            Dimension s = this.getSize();
            Insets ins = this.getInsets();
            int bottomY = s.height;
            g.setColor(this.nameLabel.getBackground());
            g.drawLine(ins.left, ins.top, s.width - ins.right, ins.top);
            if (this.isLastOrEmpty) {
                bottomY = s.height - ins.bottom;
                g.drawLine(ins.left, bottomY, s.width - ins.right, bottomY);
            }
            g.drawLine(ins.left, ins.top, ins.left, bottomY);
            g.drawLine(s.width - ins.right, ins.top, s.width - ins.right, bottomY);
        }
    }

    public void setAsCollapsedOrEmpty(boolean value) {
        this.isLastOrEmpty = value;
    }

    private void updateAccessibleInfo(String room, int index) {
        this.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.ROOM_RENDERER_AX_NAME, new Object[]{"" + index, room}));
    }

    @Override
    public void prepare(JList list, Object value, int index, boolean selected, boolean focused, boolean hovered, boolean pressed, Point hoverLocation, boolean hasOptions) {
        if (index == 0) {
            this.activityBoundsMap.clear();
            this.activityLabelsMap.clear();
        }
        this.list = list;
        this.index = index;
        this.selected = selected;
        this.pressed = pressed;
        this.hoverLocation = hoverLocation;
        CRRoom room = (CRRoom)value;
        CRParticipant me = room.getSession().getMe();
        boolean myRoom = me != null && room == me.getRoom();
        ComponentOrientation or = list.getComponentOrientation();
        this.setComponentOrientation(or);
        this.nameLabel.setComponentOrientation(or);
        if (selected) {
            this.setBackground(list.getSelectionBackground());
            this.nameLabel.setForeground(list.getSelectionForeground());
            this.nameLabel.setOpaque(false);
        } else if (myRoom) {
            this.setBackground(list.getBackground());
            this.nameLabel.setForeground(UIManager.getColor("Participant.currentNameForeground"));
            this.nameLabel.setBackground(UIManager.getColor("Participant.currentRoomBackground"));
            this.nameLabel.setOpaque(true);
        } else {
            this.setBackground(list.getBackground());
            this.nameLabel.setForeground(UIManager.getColor("Participant.nameForeground"));
            this.nameLabel.setBackground(UIManager.getColor("Participant.roomBackground"));
            this.nameLabel.setOpaque(true);
        }
        ParticipantListModel m = (ParticipantListModel)list.getModel();
        boolean expanded = m.isRoomExpanded(room);
        if (myRoom) {
            this.nameLabel.setIcon(expanded ? UIManager.getIcon("Room.currentExpandedIcon") : UIManager.getIcon("Room.currentCollapsedIcon"));
        } else {
            this.nameLabel.setIcon(expanded ? UIManager.getIcon("Room.expandedIcon") : UIManager.getIcon("Room.collapsedIcon"));
        }
        this.nameLabel.setText(room.getName());
        this.optionsLabel.setVisible(hasOptions && (pressed || hovered));
        boolean en = list.isEnabled();
        this.nameLabel.setEnabled(en);
        this.optionsLabel.setEnabled(en);
        Border b = null;
        if (focused) {
            if (selected) {
                b = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (b == null) {
                b = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            b = BorderFactory.createEmptyBorder(1, 1, 1, 1);
        }
        this.setBorder(BorderFactory.createCompoundBorder(b, BorderFactory.createEmptyBorder(1, 4, 1, 4)));
        this.activityPanel.setRoom((CRRoom)(!expanded ? room : null));
        this.updateAccessibleInfo(room.getName(), index);
    }

    @Override
    public Rectangle getOptionsBounds(int row) {
        Rectangle rb = this.list.getCellBounds(row, row);
        Rectangle b = this.optionsLabel.getBounds();
        b.translate(rb.x, rb.y);
        return b;
    }

    @Override
    public Rectangle getDeviceBounds(int row) {
        return null;
    }

    @Override
    public Rectangle getExpandBounds(int row) {
        if (this.list == null) {
            return null;
        }
        Rectangle rb = this.list.getCellBounds(row, row);
        Rectangle b = this.nameLabel.getBounds();
        b.translate(rb.x, rb.y);
        b.width = this.nameLabel.getInsets().left + this.nameLabel.getIcon().getIconWidth() + this.nameLabel.getIconTextGap();
        return b;
    }

    @Override
    public String getActivityToolTipText(int row, Point point) {
        String tooltip = null;
        if (this.list == null) {
            return tooltip;
        }
        Rectangle rb = this.list.getCellBounds(row, row);
        Rectangle b = this.activityBoundsMap.get(row);
        if (b == null) {
            return tooltip;
        }
        b.translate(rb.x, rb.y);
        Collection<JLabel> labels = this.activityLabelsMap.get(row);
        if (labels != null) {
            for (JLabel label : labels) {
                Rectangle b2 = label.getBounds();
                b2.translate(b.x, b.y);
                if (!b2.contains(point)) continue;
                return label.getToolTipText();
            }
        }
        return tooltip;
    }

    @Override
    String getPermissionClicked(int row, Point location) {
        return null;
    }

    @Override
    public void clickPermission(String permission, int row) {
    }
}

