/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.participant.ParticipantList;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRAnnotationChangeListener;
import com.elluminate.framework.session.listener.event.CRAnnotationChangeEvent;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.LightweightTimerFactory;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.text.StyledEditorKit;
import sun.awt.ModalExclude;

@Singleton
public class ProfilePopupClerk
implements MouseListener,
MouseMotionListener {
    private final String DISPLAY_MODE_NONE = "none";
    private final String DISPLAY_MODE_MODERATORS = "moderators";
    private final String DISPLAY_MODE_ALL = "all";
    private LightweightTimer showTimer;
    private LightweightTimer hideTimer;
    private ParticipantList participantList;
    private String displayMode = "none";
    private ProfileWindow profileWindow;
    private Point location;
    private CRParticipant participant;

    @Inject
    public void initSession(CRSession session) {
        session.addAnnotationChangeListener("ProfileModDisplay", new CRAnnotationChangeListener(){

            public void onAnnotationValueChange(CRAnnotationChangeEvent e) {
                Object value = e.getNewAnnotation().getValue();
                if (value != null) {
                    ProfilePopupClerk.this.updateDisplayMode((String)value);
                }
            }
        });
    }

    @Inject
    public void initLightweightTimerFactory(LightweightTimerFactory timerFactory) {
        this.showTimer = timerFactory.create((byte)2, new Runnable(){

            @Override
            public void run() {
                ProfilePopupClerk.this.showProfile();
            }
        });
        this.hideTimer = timerFactory.create((byte)2, new Runnable(){

            @Override
            public void run() {
                ProfilePopupClerk.this.hideProfile();
            }
        });
    }

    void setParticipantList(ParticipantList participantList) {
        this.participantList = participantList;
        participantList.addMouseListener(this);
        participantList.addMouseMotionListener(this);
    }

    private void updateDisplayMode(String displayMode) {
        this.displayMode = displayMode;
        CRParticipant p = this.participant;
        if (p != null && !this.canDisplayProfile(p)) {
            this.prepareHideProfile();
        }
    }

    private boolean canDisplayProfile(CRParticipant participant) {
        return this.displayMode.equals("all") || this.displayMode.equals("moderators") && participant.isChair();
    }

    private void prepareShowProfile() {
        this.hideTimer.cancel();
        if (this.profileWindow != null && this.profileWindow.isVisible()) {
            this.showTimer.scheduleIn(0L);
        } else {
            this.showTimer.scheduleIn(2000L);
        }
    }

    private void prepareHideProfile() {
        this.showTimer.cancel();
        this.hideTimer.scheduleIn(1000L);
    }

    private synchronized void showProfile() {
        int row = this.participantList.locationToIndex(this.location);
        if (row == -1) {
            this.prepareHideProfile();
            return;
        }
        Object v = this.participantList.getModel().getElementAt(row);
        if (!(v instanceof CRParticipant)) {
            this.prepareHideProfile();
            return;
        }
        CRParticipant p = (CRParticipant)v;
        if (p == this.participant) {
            return;
        }
        if (!this.canDisplayProfile(p)) {
            this.prepareHideProfile();
            return;
        }
        this.participant = p;
        int minHeight = 0;
        String profileData = "";
        String contentType = "text/html";
        if (p.getAnnotation("ProfileHTMLAnnotation") != null && p.getAnnotation("ProfileMinimumHeight") != null) {
            try {
                profileData = (String)p.getAnnotation("ProfileHTMLAnnotation").getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                minHeight = (Integer)p.getAnnotation("ProfileMinimumHeight").getValue();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        if (profileData == null) {
            profileData = this.participant.getDisplayName();
            contentType = "text/plain";
        }
        if (this.profileWindow == null) {
            this.profileWindow = new ProfileWindow();
        }
        this.profileWindow.populate(contentType, profileData, minHeight);
        Rectangle b = this.participantList.getCellBounds(row, row);
        Point pt = new Point(b.x + b.width, b.y);
        SwingUtilities.convertPointToScreen(pt, this.participantList);
        this.profileWindow.setLocation(pt);
        this.profileWindow.setVisible(true);
    }

    private synchronized void hideProfile() {
        this.participant = null;
        if (this.profileWindow != null) {
            this.profileWindow.setVisible(false);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.prepareHideProfile();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.showTimer.cancel();
        this.hideTimer.cancel();
        this.hideProfile();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        this.location = e.getPoint();
        this.prepareShowProfile();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    private static class ProfileWindow
    extends JWindow
    implements ModalExclude {
        private JTextPane textPane;

        public ProfileWindow() {
            this.setFocusableWindowState(false);
            this.setAlwaysOnTop(true);
            JPanel c = (JPanel)this.getContentPane();
            if (!System.getProperty("os.name").equals("Mac OS X")) {
                c.setBorder(BorderFactory.createLineBorder(Color.GRAY));
            }
            c.setBackground(Color.WHITE);
            c.setLayout(new BorderLayout());
            this.textPane = new JTextPane();
            this.textPane.setEditable(false);
            c.add((Component)this.textPane, "Center");
        }

        public void populate(String contentType, String text, int minimumHeight) {
            this.textPane.setEditorKit(new StyledEditorKit());
            this.textPane.setContentType(contentType);
            this.textPane.setText(text);
            this.textPane.setPreferredSize(null);
            Dimension ps = this.textPane.getPreferredSize();
            if (ps.height < minimumHeight) {
                this.textPane.setPreferredSize(new Dimension(ps.width, minimumHeight));
            }
            JPanel c = (JPanel)this.getContentPane();
            c.revalidate();
            c.repaint();
            this.pack();
        }
    }
}

