/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.components.SBadge;
import com.elluminate.classroom.swing.participant.AbstractParticipantTransferHandler;
import com.elluminate.classroom.swing.participant.ParticipantList;
import com.elluminate.classroom.swing.participant.ParticipantListModel;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.UIManager;

class ParticipantListTransferHandler
extends AbstractParticipantTransferHandler {
    public ParticipantListTransferHandler(CRSession session) {
        super(session);
    }

    @Override
    public boolean importData(JComponent component, Transferable transferable) {
        if (transferable.isDataFlavorSupported(participantListFlavor)) {
            ParticipantList list = (ParticipantList)component;
            int row = list.getSelectedIndex();
            return this.importParticipants(list, row, transferable);
        }
        return false;
    }

    private boolean importParticipants(ParticipantList list, int row, Transferable transferable) {
        if (this.session != null) {
            ArrayList<CRParticipant> ps;
            Object target = null;
            if (row != -1) {
                target = list.getModel().getElementAt(row);
            }
            ArrayList<CRParticipant> droppees = new ArrayList<CRParticipant>();
            try {
                List ids = (List)transferable.getTransferData(participantListFlavor);
                Iterator i$ = ids.iterator();
                while (i$.hasNext()) {
                    short id = (Short)i$.next();
                    CRParticipant p = this.session.getParticipantById(id);
                    if (p == null) continue;
                    droppees.add(p);
                }
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
            if (this.allDroppeesAreInMainRoom(droppees) && this.targetIsMainRoom(target)) {
                boolean promote = false;
                if (target instanceof CRParticipant && ((CRParticipant)target).isChair()) {
                    promote = true;
                }
                if (promote) {
                    ps = new ArrayList();
                    for (CRParticipant p : droppees) {
                        if (p.isChair()) continue;
                        ps.add(p);
                    }
                    if (!ps.isEmpty()) {
                        return this.fireParticipantGesture(2, ps.toArray(new CRParticipant[0]), null);
                    }
                } else {
                    ps = new ArrayList();
                    for (CRParticipant p : droppees) {
                        if (!p.isChair()) continue;
                        ps.add(p);
                    }
                    if (!ps.isEmpty()) {
                        return this.fireParticipantGesture(3, ps.toArray(new CRParticipant[0]), null);
                    }
                }
            } else {
                CRRoom r = null;
                if (target instanceof CRRoom) {
                    r = target;
                } else if (target instanceof CRParticipant) {
                    r = ((CRParticipant)target).getRoom();
                }
                if (r == null) {
                    r = this.session.getMainRoom();
                }
                ps = new ArrayList<CRParticipant>();
                for (CRParticipant p : droppees) {
                    if (r.equals((Object)p.getRoom())) continue;
                    ps.add(p);
                }
                if (!ps.isEmpty()) {
                    return this.fireParticipantGesture(1, ps.toArray(new CRParticipant[0]), r);
                }
            }
        }
        return false;
    }

    @Override
    public int getSourceActions(JComponent component) {
        return 3;
    }

    @Override
    protected Transferable createTransferable(JComponent component) {
        ParticipantListTransferable t = null;
        JList list = (JList)component;
        for (Object obj : list.getSelectedValues()) {
            if (!(obj instanceof CRParticipant)) continue;
            CRParticipant p = (CRParticipant)obj;
            if (t == null) {
                t = new ParticipantListTransferable();
            }
            t.addParticipant(p.getID(), p.getDisplayName());
        }
        return t;
    }

    @Override
    public Image getVisualRepresentation(JComponent component, Transferable transferable) {
        block6: {
            if (transferable.isDataFlavorSupported(participantListFlavor)) {
                try {
                    List ids = (List)transferable.getTransferData(participantListFlavor);
                    if (ids.size() == 1) {
                        JList list;
                        int row;
                        CRParticipant p = this.session.getParticipantById(((Short)ids.get(0)).shortValue());
                        if (p != null && (row = ((ParticipantListModel)(list = (JList)component).getModel()).rowOf(p)) != -1) {
                            JComponent c = (JComponent)list.getCellRenderer().getListCellRendererComponent(list, p, row, false, false);
                            Dimension ps = c.getPreferredSize();
                            Dimension s = new Dimension(list.getWidth(), ps.height);
                            c.setSize(s);
                            BufferedImage im = new BufferedImage(s.width, s.height, 2);
                            Graphics g = im.getGraphics();
                            c.paint(g);
                            g.setColor(Color.GRAY);
                            g.drawRect(0, 0, s.width - 1, s.height - 1);
                            return im;
                        }
                        break block6;
                    }
                    Icon ic = UIManager.getIcon("Participant.defaultParticipantIcon");
                    SBadge b = new SBadge(String.valueOf(ids.size()));
                    BufferedImage im = new BufferedImage(ic.getIconWidth() + b.getIconWidth() / 2, ic.getIconHeight() + b.getIconHeight() / 2, 2);
                    Graphics g = im.getGraphics();
                    ic.paintIcon(component, g, 0, b.getIconHeight() / 2);
                    b.paintIcon(component, g, ic.getIconWidth() - b.getIconWidth() / 2, 0);
                    return im;
                }
                catch (UnsupportedFlavorException ex) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    @Override
    public Point getVisualRepresentationOffset(JComponent component, Transferable transferable, Point dragOrigin) {
        if (transferable.isDataFlavorSupported(participantListFlavor)) {
            try {
                JList list;
                int row;
                CRParticipant p;
                List ids = (List)transferable.getTransferData(participantListFlavor);
                if (ids.size() == 1 && (p = this.session.getParticipantById(((Short)ids.get(0)).shortValue())) != null && (row = ((ParticipantListModel)(list = (JList)component).getModel()).rowOf(p)) != -1) {
                    Rectangle b = list.getCellBounds(row, row);
                    return new Point(-(dragOrigin.x - b.x), -(dragOrigin.y - b.y));
                }
            }
            catch (UnsupportedFlavorException ex) {
            }
            catch (IOException ex) {
                // empty catch block
            }
        }
        return null;
    }

    private boolean targetIsMainRoom(Object target) {
        CRRoom r;
        if (target == null || target instanceof JSeparator) {
            return true;
        }
        return target instanceof CRParticipant && ((r = ((CRParticipant)target).getRoom()) == null || r.isMain());
    }

    private static class ParticipantListTransferable
    implements Transferable {
        private List<DataFlavor> flavors = new ArrayList<DataFlavor>();
        private Map<Short, String> participants = new LinkedHashMap<Short, String>();

        public ParticipantListTransferable() {
            this.flavors.add(AbstractParticipantTransferHandler.participantListFlavor);
            this.flavors.add(DataFlavor.stringFlavor);
        }

        public void addParticipant(short participantID, String participantDisplayName) {
            this.participants.put(participantID, participantDisplayName);
        }

        public boolean isEmpty() {
            return this.participants.isEmpty();
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors.toArray(new DataFlavor[0]);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return this.flavors.contains(flavor);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(AbstractParticipantTransferHandler.participantListFlavor)) {
                return new ArrayList<Short>(this.participants.keySet());
            }
            if (flavor.equals(DataFlavor.stringFlavor)) {
                StringBuilder b = new StringBuilder();
                for (String name : this.participants.values()) {
                    if (b.length() != 0) {
                        b.append(System.getProperty("line.separator"));
                    }
                    b.append(name);
                }
                return b.toString();
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }
}

