/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.participant;

import com.elluminate.classroom.swing.ParticipantGestureListener;
import com.elluminate.classroom.swing.chat.ChatServerProperties;
import com.elluminate.classroom.swing.participant.ParticipantListMenu;
import com.elluminate.classroom.swing.participant.ParticipantListModel;
import com.elluminate.classroom.swing.participant.ParticipantRenderer;
import com.elluminate.classroom.swing.participant.RoomRenderer;
import com.elluminate.classroom.swing.participant.StringsProperties;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

class ParticipantList
extends JList
implements Accessible {
    private static final int CHAT_TO_PARTICIPANTS = 1;
    private I18n i18n = I18n.create((Object)this);
    private ParticipantListMenu participantMenu;
    private ParticipantListMenu roomMenu;
    private boolean mousePressHandled;
    private boolean canSendPrivate = true;
    private ParticipantListRenderer plrenderer;

    public void setCanSendPrivate(boolean canSendPrivate) {
        this.canSendPrivate = canSendPrivate;
    }

    protected void touchUp() {
        this.plrenderer.touchUp();
    }

    public ParticipantList() {
        super(new ParticipantListModel());
        this.setBackground(Color.WHITE);
        this.plrenderer = new ParticipantListRenderer();
        this.setCellRenderer(this.plrenderer);
        final ParticipantListModel listModel = (ParticipantListModel)this.getModel();
        listModel.setParticipantList(this);
        this.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                listModel.clearSelection();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent e) {
                ParticipantListRenderer rndr = (ParticipantListRenderer)ParticipantList.this.getCellRenderer();
                int old = rndr.getHoveredRow();
                if (old != -1) {
                    rndr.setHoveredRow(-1);
                    ParticipantList.this.repaintRow(old);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                ParticipantListRenderer rndr = (ParticipantListRenderer)ParticipantList.this.getCellRenderer();
                Point pt = e.getPoint();
                int row = ParticipantList.this.locationToIndex(pt);
                int old = rndr.getHoveredRow();
                rndr.setHoveredRow(row);
                rndr.setHoverLocation(pt);
                if (old != -1 && old != row) {
                    ParticipantList.this.repaintRow(old);
                }
                if (row != -1) {
                    ParticipantList.this.repaintRow(row);
                }
            }
        });
        this.participantMenu = new ParticipantListMenu();
        this.participantMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ParticipantListRenderer rndr = (ParticipantListRenderer)ParticipantList.this.getCellRenderer();
                int row = rndr.getOptionsPressedRow();
                if (row != -1) {
                    rndr.setOptionsPressedRow(-1);
                    ParticipantList.this.repaintRow(row);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.roomMenu = new ParticipantListMenu();
        this.roomMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                ParticipantListRenderer rndr = (ParticipantListRenderer)ParticipantList.this.getCellRenderer();
                int row = rndr.getOptionsPressedRow();
                if (row != -1) {
                    rndr.setOptionsPressedRow(-1);
                    ParticipantList.this.repaintRow(row);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        String SHOW_OPTIONS_MENU = "show-options-menu";
        InputMap imap = this.getInputMap(0);
        ActionMap amap = this.getActionMap();
        imap.put(KeyStroke.getKeyStroke(32, 0), "show-options-menu");
        amap.put("show-options-menu", new AbstractAction("show-options-menu"){

            @Override
            public void actionPerformed(ActionEvent e) {
                ParticipantList.this.maybeShowMenu();
            }
        });
        this.setupSetSelectedIndexOnFocusListener();
        AccessibleContext ax = this.getAccessibleContext();
        ax.setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTLIST_NAME));
        ax.setAccessibleDescription(this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTLIST_DESC));
    }

    private void setupSetSelectedIndexOnFocusListener() {
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (ParticipantList.this.getSelectedIndex() < 0) {
                    ParticipantList.this.setSelectedIndex(0);
                }
            }
        });
    }

    public ParticipantListMenu getParticipantMenu() {
        return this.participantMenu;
    }

    public ParticipantListMenu getRoomMenu() {
        return this.roomMenu;
    }

    @Override
    public int locationToIndex(Point location) {
        Rectangle b;
        int row = super.locationToIndex(location);
        if (row != -1 && row == this.getModel().getSize() - 1 && !(b = this.getCellBounds(row, row)).contains(location)) {
            row = -1;
        }
        return row;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point pt = event.getPoint();
        int row = this.locationToIndex(pt);
        if (row != -1) {
            String tooltip;
            String typeID;
            Object v;
            ParticipantListRenderer rndr = (ParticipantListRenderer)this.getCellRenderer();
            Rectangle optionsBounds = rndr.getOptionsBounds(row);
            Rectangle deviceBounds = rndr.getDeviceBounds(row);
            if (optionsBounds != null && optionsBounds.contains(pt)) {
                v = this.getModel().getElementAt(row);
                if (v instanceof CRParticipant) {
                    return this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTLIST_PARTICIPANTOPTIONSTIP);
                }
                if (v instanceof CRRoom) {
                    return this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTLIST_ROOMOPTIONSTIP);
                }
            } else if (deviceBounds != null && deviceBounds.contains(pt) && (v = this.getModel().getElementAt(row)) instanceof CRParticipant && ((CRParticipant)v).getRoom() != null && (typeID = ((CRParticipant)v).getDeviceType()).length() > 0 && typeID.charAt(0) == 'M') {
                if (typeID != null && typeID.charAt(1) == 'i' || typeID.charAt(1) == 'a') {
                    return this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTS_DEVICE_MOBILE_PHONE);
                }
                if (typeID.charAt(1) == 'I' || typeID.charAt(1) == 'A') {
                    return this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANTS_DEVICE_MOBILE_TABLET);
                }
            }
            if ((tooltip = rndr.getActivityToolTipText(row, pt)) != null) {
                return tooltip;
            }
        }
        return null;
    }

    public void repaintRow(int row) {
        Rectangle b = this.getCellBounds(row, row);
        if (b != null) {
            this.repaint(b.x, b.y, b.width, b.height);
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        switch (e.getID()) {
            case 501: {
                Point pt = e.getPoint();
                int row = this.locationToIndex(pt);
                if (row != -1) {
                    if (e.isPopupTrigger()) {
                        this.showMenu(row, pt, true);
                        break;
                    }
                    ParticipantListRenderer rndr = (ParticipantListRenderer)this.getCellRenderer();
                    Rectangle b1 = rndr.getExpandBounds(row);
                    Rectangle b2 = rndr.getOptionsBounds(row);
                    String permission = rndr.getPermissionClicked(row, pt);
                    if (b1 != null && b1.contains(pt)) {
                        CRRoom r;
                        ParticipantListModel m = (ParticipantListModel)this.getModel();
                        Object obj = m.getElementAt(row);
                        if (!(obj instanceof CRRoom)) break;
                        m.setRoomExpanded(r, !m.isRoomExpanded(r = (CRRoom)obj));
                        this.mousePressHandled = true;
                        return;
                    }
                    if (b2 != null && b2.contains(pt)) {
                        pt = b2.getLocation();
                        pt.y += b2.height;
                        this.showMenu(row, pt, false);
                        break;
                    }
                    if (permission != null) {
                        rndr.clickPermission(permission, row);
                        break;
                    }
                    if (e.getClickCount() != 2) break;
                    ArrayList<CRParticipant> ps = new ArrayList<CRParticipant>();
                    for (Object obj : this.getSelectedValues()) {
                        if (!(obj instanceof CRParticipant) || ((CRParticipant)obj).isMe()) {
                            ps.clear();
                            break;
                        }
                        ps.add((CRParticipant)obj);
                    }
                    if (!ps.isEmpty()) {
                        this.fireParticipantGesture(1, ps.toArray(new CRParticipant[0]));
                    }
                    return;
                }
                this.clearSelection();
                return;
            }
            case 502: {
                this.mousePressHandled = false;
                if (!e.isPopupTrigger()) break;
                Point pt = e.getPoint();
                int row = this.locationToIndex(pt);
                this.showMenu(row, pt, true);
            }
        }
        super.processMouseEvent(e);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent e) {
        switch (e.getID()) {
            case 506: {
                if (!this.mousePressHandled) break;
                return;
            }
        }
        super.processMouseMotionEvent(e);
    }

    boolean hasOptions() {
        Component[] components;
        for (Component c : components = this.participantMenu.getComponents()) {
            if (!c.isVisible()) continue;
            return true;
        }
        return false;
    }

    private void showMenu(final int row, final Point location, final boolean contextual) {
        if (contextual) {
            if (!this.isSelectedIndex(row)) {
                this.setSelectedIndex(row);
            }
        } else {
            this.setSelectedIndex(row);
        }
        ArrayList<CRParticipant> ps = new ArrayList<CRParticipant>();
        ArrayList<CRRoom> rs = new ArrayList<CRRoom>();
        for (Object obj : this.getSelectedValues()) {
            if (obj instanceof CRParticipant) {
                ps.add((CRParticipant)obj);
                continue;
            }
            if (!(obj instanceof CRRoom)) continue;
            rs.add((CRRoom)obj);
        }
        if (!this.hasOptions()) {
            return;
        }
        if (!ps.isEmpty() && rs.isEmpty()) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ParticipantListRenderer rndr = (ParticipantListRenderer)ParticipantList.this.getCellRenderer();
                    if (!contextual) {
                        rndr.setOptionsPressedRow(row);
                    }
                    ParticipantList.this.participantMenu.show(ParticipantList.this, location.x, location.y);
                }
            });
        } else if (!rs.isEmpty() && ps.isEmpty()) {
            SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    ParticipantListRenderer rndr = (ParticipantListRenderer)ParticipantList.this.getCellRenderer();
                    if (!contextual) {
                        rndr.setOptionsPressedRow(row);
                    }
                    ParticipantList.this.roomMenu.show(ParticipantList.this, location.x, location.y);
                }
            });
        }
    }

    private void maybeShowMenu() {
        int row = this.getSelectedIndex();
        if (row != -1) {
            ParticipantListRenderer rndr = (ParticipantListRenderer)this.getCellRenderer();
            rndr.setHoveredRow(row);
            Rectangle b = this.getCellBounds(row, row);
            this.paintImmediately(b);
            b = rndr.getOptionsBounds(row);
            if (b != null) {
                Point pt = b.getLocation();
                pt.y += b.height;
                this.showMenu(row, pt, false);
            }
            rndr.setHoveredRow(-1);
        }
    }

    public void addParticipantGestureListener(ParticipantGestureListener l) {
        this.listenerList.add(ParticipantGestureListener.class, l);
    }

    public void removeParticipantGestureListener(ParticipantGestureListener l) {
        this.listenerList.remove(ParticipantGestureListener.class, l);
    }

    private boolean fireParticipantGesture(int id, CRParticipant[] participants) {
        boolean success = true;
        Object[] ls = this.listenerList.getListenerList();
        block3: for (int i = ls.length - 2; i >= 0; i -= 2) {
            if (ls[i] != ParticipantGestureListener.class) continue;
            ParticipantGestureListener al = (ParticipantGestureListener)ls[i + 1];
            switch (id) {
                case 1: {
                    CRParticipant[] filteredParticipants;
                    if (!this.canSendPrivate) continue block3;
                    ArrayList<CRParticipant> participantsList = new ArrayList<CRParticipant>();
                    for (CRParticipant p : participants) {
                        if (p.getName().startsWith("Teleconference") || !p.getSession().getMe().isChair() && p.getSession().getPropertyStore().getProperty(ChatServerProperties.PRIVATE_CHAT_RESTRICTED_PROPERTY, true) && !p.isChair()) continue;
                        participantsList.add(p);
                    }
                    if (participantsList.size() <= 0 || al.chatToParticipants(filteredParticipants = participantsList.toArray(new CRParticipant[0]))) continue block3;
                    success = false;
                }
            }
        }
        return success;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleParticipantList();
        }
        return this.accessibleContext;
    }

    private class AccessibleParticipantList
    extends JList.AccessibleJList {
        private int leadSelectionIndex;
        private ParticipantAccessibleAction participantAction;

        public AccessibleParticipantList() {
            super(ParticipantList.this);
            this.participantAction = new ParticipantAccessibleAction();
            this.leadSelectionIndex = ParticipantList.this.getLeadSelectionIndex();
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            if (i >= ParticipantList.this.getModel().getSize()) {
                return null;
            }
            AccessibleParticipantListChild child = new AccessibleParticipantListChild(ParticipantList.this, i);
            return child;
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            int i = ParticipantList.this.locationToIndex(p);
            if (i >= 0) {
                AccessibleParticipantListChild child = new AccessibleParticipantListChild(ParticipantList.this, i);
                return child;
            }
            return null;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            int len = this.getAccessibleSelectionCount();
            if (i < 0 || i >= len) {
                return null;
            }
            int[] indices = ParticipantList.this.getSelectedIndices();
            Accessible child = this.getAccessibleChild(indices[i]);
            return child;
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this.participantAction;
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            int oldLeadSelectionIndex = this.leadSelectionIndex;
            this.leadSelectionIndex = ParticipantList.this.getLeadSelectionIndex();
            if (oldLeadSelectionIndex != this.leadSelectionIndex) {
                Accessible oldLS = oldLeadSelectionIndex >= 0 ? this.getAccessibleChild(oldLeadSelectionIndex) : null;
                Accessible newLS = this.leadSelectionIndex >= 0 ? this.getAccessibleChild(this.leadSelectionIndex) : null;
                this.firePropertyChange("AccessibleActiveDescendant", oldLS, newLS);
            }
            this.firePropertyChange("AccessibleVisibleData", false, true);
            this.firePropertyChange("AccessibleSelection", false, true);
            AccessibleStateSet s = this.getAccessibleStateSet();
            ListSelectionModel lsm = ParticipantList.this.getSelectionModel();
            if (lsm.getSelectionMode() != 0) {
                if (!s.contains(AccessibleState.MULTISELECTABLE)) {
                    s.add(AccessibleState.MULTISELECTABLE);
                    this.firePropertyChange("AccessibleState", null, AccessibleState.MULTISELECTABLE);
                }
            } else if (s.contains(AccessibleState.MULTISELECTABLE)) {
                s.remove(AccessibleState.MULTISELECTABLE);
                this.firePropertyChange("AccessibleState", AccessibleState.MULTISELECTABLE, null);
            }
        }

        protected class AccessibleParticipantListChild
        extends AccessibleContext
        implements Accessible,
        AccessibleComponent {
            private JList parent = null;
            private int indexInParent;
            private ListModel listModel;
            private ListCellRenderer cellRenderer = null;

            public AccessibleParticipantListChild(JList parent, int indexInParent) {
                this.parent = parent;
                this.setAccessibleParent(parent);
                this.indexInParent = indexInParent;
                if (parent != null) {
                    this.listModel = parent.getModel();
                    this.cellRenderer = parent.getCellRenderer();
                }
            }

            private Component getCurrentComponent() {
                return this.getComponentAtIndex(this.indexInParent);
            }

            private AccessibleContext getCurrentAccessibleContext() {
                Component c = this.getComponentAtIndex(this.indexInParent);
                if (c instanceof Accessible) {
                    return ((Accessible)((Object)c)).getAccessibleContext();
                }
                return null;
            }

            private Component getComponentAtIndex(int index) {
                if (index < 0 || index >= this.listModel.getSize()) {
                    return null;
                }
                if (this.parent != null && this.listModel != null && this.cellRenderer != null) {
                    Object value = this.listModel.getElementAt(index);
                    boolean isSelected = this.parent.isSelectedIndex(index);
                    boolean isFocussed = this.parent.isFocusOwner() && index == this.parent.getLeadSelectionIndex();
                    return this.cellRenderer.getListCellRendererComponent(this.parent, value, index, isSelected, isFocussed);
                }
                return null;
            }

            @Override
            public AccessibleContext getAccessibleContext() {
                return this;
            }

            @Override
            public String getAccessibleName() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleName();
                }
                return null;
            }

            @Override
            public void setAccessibleName(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleName(s);
                }
            }

            @Override
            public String getAccessibleDescription() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleDescription();
                }
                return null;
            }

            @Override
            public void setAccessibleDescription(String s) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.setAccessibleDescription(s);
                }
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleRole();
                }
                return null;
            }

            @Override
            public AccessibleStateSet getAccessibleStateSet() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                AccessibleStateSet s = ac != null ? ac.getAccessibleStateSet() : new AccessibleStateSet();
                s.add(AccessibleState.SELECTABLE);
                if (this.parent.isFocusOwner() && this.indexInParent == this.parent.getLeadSelectionIndex()) {
                    s.add(AccessibleState.ACTIVE);
                }
                if (this.parent.isSelectedIndex(this.indexInParent)) {
                    s.add(AccessibleState.SELECTED);
                }
                if (this.isShowing()) {
                    s.add(AccessibleState.SHOWING);
                } else if (s.contains(AccessibleState.SHOWING)) {
                    s.remove(AccessibleState.SHOWING);
                }
                if (this.isVisible()) {
                    s.add(AccessibleState.VISIBLE);
                } else if (s.contains(AccessibleState.VISIBLE)) {
                    s.remove(AccessibleState.VISIBLE);
                }
                s.add(AccessibleState.TRANSIENT);
                return s;
            }

            @Override
            public int getAccessibleIndexInParent() {
                return this.indexInParent;
            }

            @Override
            public int getAccessibleChildrenCount() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleChildrenCount();
                }
                return 0;
            }

            @Override
            public Accessible getAccessibleChild(int i) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    Accessible accessibleChild = ac.getAccessibleChild(i);
                    ac.setAccessibleParent(this);
                    return accessibleChild;
                }
                return null;
            }

            @Override
            public Locale getLocale() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getLocale();
                }
                return null;
            }

            @Override
            public void addPropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.addPropertyChangeListener(l);
                }
            }

            @Override
            public void removePropertyChangeListener(PropertyChangeListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    ac.removePropertyChangeListener(l);
                }
            }

            @Override
            public AccessibleAction getAccessibleAction() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleAction();
            }

            @Override
            public AccessibleComponent getAccessibleComponent() {
                return this;
            }

            @Override
            public AccessibleSelection getAccessibleSelection() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleSelection();
            }

            @Override
            public AccessibleText getAccessibleText() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleText();
            }

            @Override
            public AccessibleValue getAccessibleValue() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac == null) {
                    return null;
                }
                return ac.getAccessibleValue();
            }

            @Override
            public Color getBackground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getBackground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getBackground();
                }
                return null;
            }

            @Override
            public void setBackground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBackground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setBackground(c);
                    }
                }
            }

            @Override
            public Color getForeground() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getForeground();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getForeground();
                }
                return null;
            }

            @Override
            public void setForeground(Color c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setForeground(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setForeground(c);
                    }
                }
            }

            @Override
            public Cursor getCursor() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getCursor();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getCursor();
                }
                Accessible ap = this.getAccessibleParent();
                if (ap instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ap)).getCursor();
                }
                return null;
            }

            @Override
            public void setCursor(Cursor c) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setCursor(c);
                } else {
                    Component cp = this.getCurrentComponent();
                    if (cp != null) {
                        cp.setCursor(c);
                    }
                }
            }

            @Override
            public Font getFont() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFont();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFont();
                }
                return null;
            }

            @Override
            public void setFont(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setFont(f);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setFont(f);
                    }
                }
            }

            @Override
            public FontMetrics getFontMetrics(Font f) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getFontMetrics(f);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.getFontMetrics(f);
                }
                return null;
            }

            @Override
            public boolean isEnabled() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isEnabled();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isEnabled();
                }
                return false;
            }

            @Override
            public void setEnabled(boolean b) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setEnabled(b);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setEnabled(b);
                    }
                }
            }

            @Override
            public boolean isVisible() {
                int fi = this.parent.getFirstVisibleIndex();
                int li = this.parent.getLastVisibleIndex();
                if (li == -1) {
                    li = this.parent.getModel().getSize() - 1;
                }
                return this.indexInParent >= fi && this.indexInParent <= li;
            }

            @Override
            public void setVisible(boolean b) {
            }

            @Override
            public boolean isShowing() {
                return this.parent.isShowing() && this.isVisible();
            }

            @Override
            public boolean contains(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    Rectangle r = ((AccessibleComponent)((Object)ac)).getBounds();
                    return r.contains(p);
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    Rectangle r = c.getBounds();
                    return r.contains(p);
                }
                return this.getBounds().contains(p);
            }

            @Override
            public Point getLocationOnScreen() {
                if (this.parent != null) {
                    Point listLocation = this.parent.getLocationOnScreen();
                    Point componentLocation = this.parent.indexToLocation(this.indexInParent);
                    if (componentLocation != null) {
                        componentLocation.translate(listLocation.x, listLocation.y);
                        return componentLocation;
                    }
                    return null;
                }
                return null;
            }

            @Override
            public Point getLocation() {
                if (this.parent != null) {
                    return this.parent.indexToLocation(this.indexInParent);
                }
                return null;
            }

            @Override
            public void setLocation(Point p) {
                if (this.parent != null && this.parent.contains(p)) {
                    ParticipantList.this.ensureIndexIsVisible(this.indexInParent);
                }
            }

            @Override
            public Rectangle getBounds() {
                if (this.parent != null) {
                    return this.parent.getCellBounds(this.indexInParent, this.indexInParent);
                }
                return null;
            }

            @Override
            public void setBounds(Rectangle r) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setBounds(r);
                }
            }

            @Override
            public Dimension getSize() {
                Rectangle cellBounds = this.getBounds();
                if (cellBounds != null) {
                    return cellBounds.getSize();
                }
                return null;
            }

            @Override
            public void setSize(Dimension d) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).setSize(d);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.setSize(d);
                    }
                }
            }

            @Override
            public Accessible getAccessibleAt(Point p) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).getAccessibleAt(p);
                }
                return null;
            }

            @Override
            public boolean isFocusTraversable() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    return ((AccessibleComponent)((Object)ac)).isFocusTraversable();
                }
                Component c = this.getCurrentComponent();
                if (c != null) {
                    return c.isFocusTraversable();
                }
                return false;
            }

            @Override
            public void requestFocus() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).requestFocus();
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.requestFocus();
                    }
                }
            }

            @Override
            public void addFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).addFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.addFocusListener(l);
                    }
                }
            }

            @Override
            public void removeFocusListener(FocusListener l) {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac instanceof AccessibleComponent) {
                    ((AccessibleComponent)((Object)ac)).removeFocusListener(l);
                } else {
                    Component c = this.getCurrentComponent();
                    if (c != null) {
                        c.removeFocusListener(l);
                    }
                }
            }

            @Override
            public AccessibleIcon[] getAccessibleIcon() {
                AccessibleContext ac = this.getCurrentAccessibleContext();
                if (ac != null) {
                    return ac.getAccessibleIcon();
                }
                return null;
            }
        }

        private class ParticipantAccessibleAction
        implements AccessibleAction {
            private ParticipantAccessibleAction() {
            }

            @Override
            public int getAccessibleActionCount() {
                return 1;
            }

            @Override
            public String getAccessibleActionDescription(int i) {
                return ParticipantList.this.i18n.getString((PropertiesEnum)StringsProperties.PARTICIPANT_AX_ACTION_DESC);
            }

            @Override
            public boolean doAccessibleAction(int i) {
                ParticipantList.this.maybeShowMenu();
                return true;
            }
        }
    }

    private static class ParticipantListRenderer
    implements ListCellRenderer {
        private Map<Class<?>, Renderer> renderers = new HashMap();
        private int hoveredRow = -1;
        private Point hoverLocation;
        private int optionsPressedRow = -1;
        private JList list;
        private ParticipantRenderer prenderer = null;

        public ParticipantListRenderer() {
            this.renderers.put(CRRoom.class, new RoomRenderer());
            this.prenderer = new ParticipantRenderer();
            this.renderers.put(CRParticipant.class, this.prenderer);
        }

        protected void touchUp() {
            this.prenderer.showProfile();
        }

        public int getHoveredRow() {
            return this.hoveredRow;
        }

        public void setHoveredRow(int hoveredRow) {
            this.hoveredRow = hoveredRow;
        }

        public void setHoverLocation(Point hoverLocation) {
            this.hoverLocation = hoverLocation;
        }

        public int getOptionsPressedRow() {
            return this.optionsPressedRow;
        }

        public void setOptionsPressedRow(int optionsPressedRow) {
            this.optionsPressedRow = optionsPressedRow;
        }

        Rectangle getOptionsBounds(int row) {
            Rectangle b = null;
            if (this.list != null) {
                Object value = this.list.getModel().getElementAt(row);
                Renderer r = this.renderers.get(value.getClass());
                return r.getOptionsBounds(row);
            }
            return b;
        }

        public Rectangle getDeviceBounds(int row) {
            Rectangle b = null;
            if (this.list != null) {
                Object value = this.list.getModel().getElementAt(row);
                Renderer r = this.renderers.get(value.getClass());
                return r.getDeviceBounds(row);
            }
            return b;
        }

        Rectangle getExpandBounds(int row) {
            Rectangle b = null;
            if (this.list != null) {
                Object value = this.list.getModel().getElementAt(row);
                Renderer r = this.renderers.get(value.getClass());
                return r.getExpandBounds(row);
            }
            return b;
        }

        String getActivityToolTipText(int row, Point location) {
            String tip = null;
            if (this.list != null) {
                Object value = this.list.getModel().getElementAt(row);
                Renderer r = this.renderers.get(value.getClass());
                return r.getActivityToolTipText(row, location);
            }
            return tip;
        }

        String getPermissionClicked(int row, Point location) {
            Object value = this.list.getModel().getElementAt(row);
            Renderer r = this.renderers.get(value.getClass());
            return r.getPermissionClicked(row, location);
        }

        public void clickPermission(String permission, int row) {
            Object value = this.list.getModel().getElementAt(row);
            Renderer r = this.renderers.get(value.getClass());
            r.clickPermission(permission, row);
        }

        public Component getListCellRendererComponent(JList list, Object value, int row, boolean selected, boolean focused) {
            this.list = list;
            Renderer r = this.renderers.get(value.getClass());
            if (r != null) {
                ParticipantListModel m = (ParticipantListModel)list.getModel();
                boolean isLast = m.isLastVisibleEntityInRoom(value);
                if (value instanceof CRParticipant) {
                    ParticipantRenderer renderer = (ParticipantRenderer)r;
                    renderer.setAsLastInRoom(isLast);
                    renderer.drawTopSeparator(!((CRParticipant)value).isChair() && this.isFirstParticipant(list, row));
                } else if (value instanceof CRRoom) {
                    ((RoomRenderer)r).setAsCollapsedOrEmpty(isLast);
                }
                boolean hasOptions = false;
                try {
                    ParticipantList plist = (ParticipantList)list;
                    hasOptions = plist.hasOptions();
                }
                catch (ClassCastException ccx) {
                    hasOptions = false;
                }
                r.prepare(list, value, row, selected, focused, row == this.hoveredRow, row == this.optionsPressedRow, this.hoverLocation, hasOptions);
            }
            return r;
        }

        private boolean isFirstParticipant(JList list, int row) {
            CRParticipant participant;
            Object element;
            int previous = row - 1;
            return previous >= 0 && previous < list.getModel().getSize() && (element = list.getModel().getElementAt(previous)) != null && element instanceof CRParticipant && (participant = (CRParticipant)element).isChair();
        }
    }

    static abstract class Renderer
    extends JComponent
    implements Accessible {
        Renderer() {
        }

        abstract void prepare(JList var1, Object var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, Point var8, boolean var9);

        abstract Rectangle getOptionsBounds(int var1);

        abstract Rectangle getDeviceBounds(int var1);

        abstract Rectangle getExpandBounds(int var1);

        abstract String getPermissionClicked(int var1, Point var2);

        public abstract void clickPermission(String var1, int var2);

        String getActivityToolTipText(int row, Point point) {
            return null;
        }

        @Override
        public void repaint() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void repaint(long tm, int x, int y, int width, int height) {
        }

        @Override
        public void repaint(Rectangle r) {
        }

        @Override
        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        @Override
        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleRenderer();
            }
            return this.accessibleContext;
        }

        private class AccessibleRenderer
        extends JComponent.AccessibleJComponent {
            private AccessibleRenderer() {
                super(Renderer.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }
        }
    }
}

