/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.ModeController;
import com.elluminate.classroom.swing.Stage;
import com.elluminate.classroom.swing.components.ButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.location.MenuSectionSupport;
import com.elluminate.classroom.swing.location.ModeHints;
import com.elluminate.classroom.swing.location.NotificationHints;
import com.elluminate.classroom.swing.location.NotificationSupport;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.EnumFeatureAdapter;
import com.elluminate.framework.location.EnumFeatureAdapterProvider;
import com.elluminate.framework.location.EnumStringFeatureAdapter;
import com.elluminate.framework.location.EnumStringFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.StringFeatureAdapter;
import com.elluminate.framework.location.StringFeatureAdapterProvider;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.gui.swing.CCheckBoxMenuItem;
import com.elluminate.gui.swing.CMenuItem;
import com.elluminate.gui.swing.CTextField;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.UIManager;

public class StageLocationHandler
extends AbstractSwingLocationHandler
implements NotificationHints,
ModeHints {
    private static final String LOCATION = "stage";
    private static final String AREA = "stageArea";
    private static final String ACTION_BAR_AREA = "actionBar";
    private static final String OPTIONS_MENU_AREA = "optionsMenu";
    private static final String CONTENT_AREA = "contentArea";
    private static final String SUPPORT_AREA = "supportArea";
    private static final String PALETTE_AREA = "paletteArea";
    private static final String PALETTE_ORIENTATION = "paletteOrientation";
    private static final String PALETTE_POSITION = "palettePosition";
    private static final int PALETTE_POSITION_DEFAULT = 0;
    private static final int PALETTE_POSITION_RELATIVE = 1;
    private static final String PALETTE_POSITION_RELATIVE_TO = "palettePosition.relativeTo";
    private static final String MENU_SECTION = "stageMenuSection";
    private static final String FILE_SECTION = "fileSection";
    private static final String MANAGE_SECTION = "manageSection";
    private static final String EDIT_SECTION = "editSection";
    private static final String BREAKOUT_SECTION = "breakoutSection";
    private static final String OPTION_SECTION = "optionSection";
    private static final String ORDER = "order";
    private static final String PAIR = "stage.pair";
    private I18n i18n;
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private MenuSectionSupport whiteboardMenuSupport = new MenuSectionSupport();
    private MenuSectionSupport screenSharingMenuSupport = new MenuSectionSupport();
    private MenuSectionSupport webTourMenuSupport = new MenuSectionSupport();
    private MenuSectionSupport quizMenuSupport = new MenuSectionSupport();
    private NotificationSupport notificationSupport = new NotificationSupport();
    private Map<String, ViewMode> modes = new HashMap<String, ViewMode>();
    private Stage stage;
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private StringFeatureAdapterProvider stringAdapterProvider;
    private BooleanFeatureAdapterProvider booleanAdapterProvider;
    private EnumFeatureAdapterProvider enumerationAdapterProvider;
    private EnumStringFeatureAdapterProvider enumerationStringAdapterProvider;
    private HashMap<String, Feature> pairedFeature = new HashMap();
    private Map<String, Component> paletteContent = new HashMap<String, Component>();

    public StageLocationHandler() {
        this.modes.put("whiteboard", ViewMode.WHITEBOARD);
        this.modes.put("screenSharing", ViewMode.APPSHARE);
        this.modes.put("webTour", ViewMode.WEBTOUR);
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider, StringFeatureAdapterProvider stringAdapterProvider, BooleanFeatureAdapterProvider booleanAdapterProvider, EnumFeatureAdapterProvider enumerationAdapterProvider, EnumStringFeatureAdapterProvider enumStringFeatureAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
        this.stringAdapterProvider = stringAdapterProvider;
        this.booleanAdapterProvider = booleanAdapterProvider;
        this.enumerationAdapterProvider = enumerationAdapterProvider;
        this.enumerationStringAdapterProvider = enumStringFeatureAdapterProvider;
    }

    @Inject
    public void initModeController(ModeController modeController) {
        modeController.addModeChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ViewMode old = (ViewMode)e.getOldValue();
                StageLocationHandler.this.notificationSupport.notifyInterestedFeatures("displayed", old, false);
                ViewMode mode = (ViewMode)e.getNewValue();
                StageLocationHandler.this.notificationSupport.notifyInterestedFeatures("displayed", mode, true);
            }
        });
    }

    public void setStage(Stage stage) {
        this.stage = stage;
        this.whiteboardMenuSupport.setMenu(stage.getWhiteboardOptionsMenu());
        this.whiteboardMenuSupport.addSection(FILE_SECTION);
        this.whiteboardMenuSupport.addSection(MANAGE_SECTION);
        this.whiteboardMenuSupport.addSection(EDIT_SECTION);
        this.whiteboardMenuSupport.addSection(BREAKOUT_SECTION);
        this.whiteboardMenuSupport.addSection(OPTION_SECTION);
        this.screenSharingMenuSupport.setMenu(stage.getScreenSharingOptionsMenu());
        this.screenSharingMenuSupport.addSection(FILE_SECTION);
        this.screenSharingMenuSupport.addSection(MANAGE_SECTION);
        this.screenSharingMenuSupport.addSection(EDIT_SECTION);
        this.screenSharingMenuSupport.addSection(BREAKOUT_SECTION);
        this.screenSharingMenuSupport.addSection(OPTION_SECTION);
        this.webTourMenuSupport.setMenu(stage.getWebTourOptionsMenu());
        this.webTourMenuSupport.addSection(FILE_SECTION);
        this.webTourMenuSupport.addSection(MANAGE_SECTION);
        this.webTourMenuSupport.addSection(EDIT_SECTION);
        this.webTourMenuSupport.addSection(BREAKOUT_SECTION);
        this.webTourMenuSupport.addSection(OPTION_SECTION);
        this.quizMenuSupport.setMenu(stage.getQuizOptionsMenu());
        this.quizMenuSupport.addSection(FILE_SECTION);
        this.quizMenuSupport.addSection(MANAGE_SECTION);
        this.quizMenuSupport.addSection(EDIT_SECTION);
        this.quizMenuSupport.addSection(BREAKOUT_SECTION);
        this.quizMenuSupport.addSection(OPTION_SECTION);
    }

    protected void addFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            String notif = String.valueOf(notification);
            Object mode = feature.getHintValue("mode");
            if (mode != null) {
                this.notificationSupport.addInterestedFeature(feature, notif, this.modes.get(String.valueOf(mode)));
            }
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(ACTION_BAR_AREA)) {
                this.addToActionBar(feature);
            } else if (area.equals(OPTIONS_MENU_AREA)) {
                this.addToOptionsMenu(feature);
            } else if (area.equals(CONTENT_AREA)) {
                this.addToContentArea(feature);
            } else if (area.equals(SUPPORT_AREA)) {
                this.addToSupportArea(feature);
            } else if (area.equals(PALETTE_AREA)) {
                this.addToPaletteArea(feature);
            }
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            String notif = String.valueOf(notification);
            Object mode = feature.getHintValue("mode");
            if (mode != null) {
                this.notificationSupport.removeInterestedFeature(feature, notif, this.modes.get(String.valueOf(mode)));
            }
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(ACTION_BAR_AREA)) {
                this.removeFromActionBar(feature);
            } else if (area.equals(OPTIONS_MENU_AREA)) {
                this.removeFromOptionsMenu(feature);
            } else if (area.equals(CONTENT_AREA)) {
                this.removeFromContentArea(feature);
            } else if (area.equals(SUPPORT_AREA)) {
                this.removeFromSupportArea(feature);
            } else if (area.equals(PALETTE_AREA)) {
                this.removeFromPaletteArea(feature);
            }
        }
    }

    private void addToActionBar(Feature feature) {
        Object mode = feature.getHintValue("mode");
        if (mode == null) {
            throw new IllegalStateException("Stage feature lacks mode hint: " + feature);
        }
        CTextField c = null;
        BooleanFeatureAdapter a = null;
        if (this.pairActionBarFeature(feature)) {
            return;
        }
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            SButton b = new SButton();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)b, null);
            aa.setHasIcon(true);
            aa.setHasText(!mode.equals("webTour"));
            aa.setHasToolTip(true);
            b.addFocusListener(new ButtonFocusDisplayer());
            c = b;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            JCheckBox cb = new JCheckBox();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)cb, null);
            ba.setHasText(true);
            ba.setHasToolTip(true);
            ba.setHasIcon(false);
            cb.addFocusListener(new ButtonFocusDisplayer());
            c = cb;
            a = ba;
        } else if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            final CTextField tf = new CTextField(25);
            StringFeatureAdapter sa = this.stringAdapterProvider.get(LOCATION, sf, (JTextField)tf, null);
            tf.getAccessibleContext().setAccessibleName(sf.getAccessibleName());
            tf.getAccessibleContext().setAccessibleDescription(sf.getAccessibleDescription());
            tf.setBackground(UIManager.getColor("WebTourURLAddress.background"));
            tf.setForeground(UIManager.getColor("WebTourURLAddress.foreground"));
            feature.addMetaDataListener("Feature.enabled", new MetaDataListener(){

                public void metaDataChanged(MetaDataEvent ev) {
                    final boolean enabled = (Boolean)ev.getNewValue();
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            if (enabled) {
                                tf.requestFocusInWindow();
                            }
                        }
                    };
                    SwingRunnerSupport.invokeLater((Runnable)r);
                }
            });
            sa.setHasText(true);
            sa.setHasToolTip(mode.equals("webTour"));
            if (mode.equals("webTour")) {
                tf.addMouseListener((MouseListener)new MouseAdapter(){

                    @Override
                    public void mouseEntered(MouseEvent e) {
                        if (!tf.hasFocus()) {
                            KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
                            mgr.clearGlobalFocusOwner();
                        }
                    }
                });
            }
            c = tf;
            a = sa;
        } else if (feature instanceof EnumeratedFeature) {
            EnumeratedFeature ef = (EnumeratedFeature)feature;
            CTextField cb = new JComboBox();
            cb.setToolTipText(ef.getDescription());
            EnumFeatureAdapter ea = this.enumerationAdapterProvider.get(LOCATION, ef, cb, null);
            ea.setHasText(true);
            for (Object val : ef.getEnumerationSet()) {
                ea.addItem(val);
            }
            c = cb;
            a = ea;
        } else if (feature instanceof ComponentFeature) {
            CTextField comp;
            ComponentFeature cf = (ComponentFeature)feature;
            c = comp = (CTextField)cf.getComponent();
        }
        this.completeAdapter(feature, (JComponent)c, (FeatureAdapter)a);
    }

    private void completeAdapter(Feature feature, JComponent c, FeatureAdapter a) {
        if (c != null) {
            float order;
            Object mode = feature.getHintValue("mode");
            try {
                order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            }
            catch (Exception e) {
                order = -1.0f;
            }
            if (a != null) {
                this.adapters.put(feature, a);
            }
            if (mode.equals("whiteboard")) {
                this.stage.addWhiteboardAction(c, order);
            } else if (mode.equals("screenSharing")) {
                this.stage.addScreenSharingAction(c, order);
            } else if (mode.equals("webTour")) {
                this.stage.addWebTourAction(c, order);
            } else if (mode.equals("quiz")) {
                this.stage.addQuizAction(c, order);
            }
        }
    }

    private boolean pairActionBarFeature(Feature feature) {
        boolean paired = false;
        Object pairedPath = feature.getHintValue(PAIR);
        if (pairedPath instanceof String) {
            paired = true;
            this.pairedFeature.put(feature.getPath(), feature);
            Feature pair = this.pairedFeature.get(pairedPath);
            if (pair != null) {
                StringFeature sf;
                EnumeratedFeature ef;
                if (feature instanceof EnumeratedFeature) {
                    ef = (EnumeratedFeature)feature;
                    sf = (StringFeature)pair;
                } else {
                    sf = (StringFeature)feature;
                    ef = (EnumeratedFeature)pair;
                }
                JComboBox cb = new JComboBox();
                cb.setToolTipText(ef.getDescription());
                EnumStringFeatureAdapter ea = this.enumerationStringAdapterProvider.get(LOCATION, ef, sf, cb, null);
                for (Object val : ef.getEnumerationSet()) {
                    ea.addItem(val);
                }
                this.completeAdapter((Feature)ef, cb, (FeatureAdapter)ea);
            }
        }
        return paired;
    }

    private void removeFromActionBar(Feature feature) {
        JComponent c = null;
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            c = (JComponent)cf.getComponent();
        } else if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            c = (JComponent)a.getComponent();
            a.dispose();
        }
        if (c != null) {
            Object mode = feature.getHintValue("mode");
            if (mode.equals("whiteboard")) {
                this.stage.removeWhiteboardAction(c);
            } else if (mode.equals("screenSharing")) {
                this.stage.removeScreenSharingAction(c);
            } else if (mode.equals("webTour")) {
                this.stage.removeWebTourAction(c);
            } else if (mode.equals("quiz")) {
                this.stage.removeQuizAction(c);
            }
        }
    }

    private void addToOptionsMenu(Feature feature) {
        CMenuItem mi;
        CMenuItem c = null;
        BooleanFeatureAdapter a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            mi = new CMenuItem();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)mi, null);
            aa.setInteractiveSubstitution(this.i18n.getString((PropertiesEnum)StringsProperties.MENUHANDLER_INTERACTIVEITEM));
            aa.setHasText(true);
            c = mi;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            mi = new CCheckBoxMenuItem();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)mi, null);
            ba.setHasText(true);
            c = mi;
            a = ba;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            Object section = feature.getHintValue(MENU_SECTION);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            Object mode = feature.getHintValue("mode");
            if (mode.equals("whiteboard")) {
                this.whiteboardMenuSupport.add((JComponent)c, String.valueOf(section), order);
            } else if (mode.equals("screenSharing")) {
                this.screenSharingMenuSupport.add((JComponent)c, String.valueOf(section), order);
            } else if (mode.equals("webTour")) {
                this.webTourMenuSupport.add((JComponent)c, String.valueOf(section), order);
            } else if (mode.equals("quiz")) {
                this.quizMenuSupport.add((JComponent)c, String.valueOf(section), order);
            }
        }
    }

    private void removeFromOptionsMenu(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            JComponent c = (JComponent)a.getComponent();
            Object mode = feature.getHintValue("mode");
            if (mode.equals("whiteboard")) {
                this.whiteboardMenuSupport.remove(c);
            } else if (mode.equals("screenSharing")) {
                this.screenSharingMenuSupport.remove(c);
            } else if (mode.equals("webTour")) {
                this.webTourMenuSupport.remove(c);
            } else if (mode.equals("quiz")) {
                this.quizMenuSupport.remove(c);
            }
            a.dispose();
        }
    }

    private void addToContentArea(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Component c = cf.getComponent();
            Object mode = feature.getHintValue("mode");
            if (mode.equals("whiteboard")) {
                this.stage.addWhiteboardContent(c);
            } else if (mode.equals("screenSharing")) {
                this.stage.addScreenSharingContent(c);
            } else if (mode.equals("webTour")) {
                this.stage.addWebTourContent(c);
            } else if (mode.equals("quiz")) {
                this.stage.addQuizContent(c);
            }
        }
    }

    private void removeFromContentArea(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Component c = cf.getComponent();
            Object mode = feature.getHintValue("mode");
            if (mode.equals("whiteboard")) {
                this.stage.removeWhiteboardContent(c);
            } else if (mode.equals("screenSharing")) {
                this.stage.removeScreenSharingContent(c);
            } else if (mode.equals("webTour")) {
                this.stage.removeWebTourContent(c);
            } else if (mode.equals("quiz")) {
                this.stage.removeQuizContent(c);
            }
        }
    }

    private void addToSupportArea(Feature feature) {
    }

    private void removeFromSupportArea(Feature feature) {
    }

    private void addToPaletteArea(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Component c = cf.getComponent();
            this.paletteContent.put(cf.getPath(), c);
            Object mode = feature.getHintValue("mode");
            HintEnum orientationHint = (HintEnum)feature.getHintValue(PALETTE_ORIENTATION, HintEnum.class);
            int orientation = -1;
            if (orientationHint != null) {
                orientation = orientationHint.getOrdinal();
            }
            Component relativeTo = null;
            HintEnum positionHint = (HintEnum)feature.getHintValue(PALETTE_POSITION, HintEnum.class);
            int position = 0;
            if (positionHint != null) {
                position = positionHint.getOrdinal();
            }
            if (position == 1) {
                String relativeToPath = (String)feature.getHintValue(PALETTE_POSITION_RELATIVE_TO, String.class);
                relativeTo = this.paletteContent.get(relativeToPath);
            }
            if (mode.equals("whiteboard")) {
                this.stage.addWhiteboardPalette(c, orientation, relativeTo);
            } else if (mode.equals("screenSharing")) {
                this.stage.addScreenSharingPalette(c, orientation, relativeTo);
            } else if (mode.equals("webTour")) {
                this.stage.addWebTourPalette(c, orientation, relativeTo);
            } else if (mode.equals("quiz")) {
                this.stage.addQuizPalette(c, orientation, relativeTo);
            }
        }
    }

    private void removeFromPaletteArea(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Component c = cf.getComponent();
            this.paletteContent.remove(cf.getPath());
            Object mode = feature.getHintValue("mode");
            if (mode.equals("whiteboard")) {
                this.stage.removeWhiteboardPalette(c);
            } else if (mode.equals("screenSharing")) {
                this.stage.removeScreenSharingPalette(c);
            } else if (mode.equals("webTour")) {
                this.stage.removeWebTourPalette(c);
            } else if (mode.equals("quiz")) {
                this.stage.removeQuizPalette(c);
            }
        }
    }
}

