/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.PlayerBar;
import com.elluminate.classroom.swing.location.ListFeatureAdapter;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.google.inject.Inject;
import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;

public class PlayerLocationHandler
extends AbstractSwingLocationHandler {
    private static final String LOCATION = "playerBar";
    private static final String AREA = "playerBarArea";
    private static final String PLAYER_ACTION_AREA = "playerControl";
    private static final String PLAYER_NAVIGATION_AREA = "playerNavigation";
    private static final String PLAYER_DISPLAY_AREA = "playerDisplay";
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private I18n i18n;
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private PlayerBar playerBar;
    private ListFeatureAdapter playerIndexAdapter;

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
    }

    @Inject
    public void initScreenListAdapter(ListFeatureAdapter adapter) {
        this.playerIndexAdapter = adapter;
    }

    public void setPlayerBar(PlayerBar playerBar) {
        this.playerBar = playerBar;
    }

    protected void addFeatureSwing(Feature f) {
        Object area = f.getHintValue(AREA);
        if (area.equals(PLAYER_DISPLAY_AREA)) {
            this.addDisplay(f);
        } else if (area.equals(PLAYER_ACTION_AREA)) {
            this.addAction(f);
        } else if (area.equals(PLAYER_NAVIGATION_AREA)) {
            this.addNavigation(f);
        }
    }

    private void addNavigation(Feature f) {
        if (f instanceof ListFeature) {
            ListFeature lf = (ListFeature)f;
            JComboBox cb = new JComboBox();
            this.playerIndexAdapter.init(cb, lf);
            this.adapters.put((Feature)lf, this.playerIndexAdapter);
            this.playerBar.addSelectorComponent(cb);
        } else if (f instanceof ActionFeature) {
            this.playerIndexAdapter.initGotoAction((ActionFeature)f);
            this.adapters.put(f, this.playerIndexAdapter);
        } else if (f instanceof ValueFeature) {
            ValueFeature<?> vf = this.playerIndexAdapter.getSelectedScreenFeature();
            if (vf == f) {
                return;
            }
            if (vf != null) {
                throw new IllegalStateException("Already have a value feature");
            }
            this.adapters.put(f, this.playerIndexAdapter);
            this.playerIndexAdapter.initSelectedFeature((ValueFeature)f);
        }
    }

    private void removeNavigation(Feature feature) {
        if (this.adapters.get(feature) == this.playerIndexAdapter) {
            this.adapters.remove(feature);
            if (feature instanceof ListFeature) {
                if (this.playerIndexAdapter.getListFeature() != feature) {
                    throw new IllegalArgumentException("wrong list feature");
                }
                JComboBox cb = this.playerIndexAdapter.getCombo();
                if (cb != null) {
                    this.playerBar.removeNavigation(cb);
                }
                this.playerIndexAdapter.removeListFeature();
            } else if (feature instanceof ActionFeature) {
                if (this.playerIndexAdapter.getGotoAction() != feature) {
                    throw new IllegalArgumentException("wrong action feature");
                }
                this.playerIndexAdapter.removeGotoAction();
            } else if (feature instanceof ValueFeature) {
                if (this.playerIndexAdapter.getSelectedScreenFeature() != feature) {
                    throw new IllegalArgumentException("wrong value feature");
                }
                this.playerIndexAdapter.removeSelectedScreenFeature();
            }
            if (this.playerIndexAdapter.isEmpty()) {
                this.playerIndexAdapter.dispose();
            }
        }
    }

    protected void removeFeatureSwing(Feature f) {
        Object area = f.getHintValue(AREA);
        if (area.equals(PLAYER_DISPLAY_AREA)) {
            this.removeDisplay(f);
        } else if (area.equals(PLAYER_ACTION_AREA)) {
            this.removeAction(f);
        } else if (area.equals(PLAYER_NAVIGATION_AREA)) {
            this.removeNavigation(f);
        }
    }

    private void addDisplay(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            Component c = cf.getComponent();
            this.playerBar.addDisplayComponent(c);
        }
    }

    private void removeDisplay(Feature feature) {
        if (feature instanceof ComponentFeature) {
            ComponentFeature cf = (ComponentFeature)feature;
            this.playerBar.removeDisplay(cf.getComponent());
        }
    }

    private void addAction(Feature feature) {
        JButton c = null;
        ActionFeatureAdapter a = null;
        ActionFeature af = (ActionFeature)feature;
        JButton b = new JButton();
        ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)b, null);
        aa.setHasIcon(true);
        c = b;
        a = aa;
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            this.playerBar.addAction(c);
        }
    }

    private void removeAction(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            Component c = a.getComponent();
            a.dispose();
            this.playerBar.removeAction(c);
        }
    }
}

