/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.ParticipantsPanel;
import com.elluminate.classroom.swing.location.LocationDebug;
import com.elluminate.classroom.swing.participant.ParticipantConsolePanel;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.NumericFeature;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.NumericLabelFeatureAdapter;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class ParticipantSessionLocationHandler
extends AbstractSwingLocationHandler {
    private static final String LOCATION = "participant.session";
    private static final String PATH_POLLING = "polling";
    private Logger log = null;
    private ParticipantConsolePanel consolePanel = null;
    private Provider<NumericLabelFeatureAdapter> numericLabelProvider = null;
    private ActionFeatureAdapterProvider actionFeatureAdapterProvider = null;
    private Map<Feature, FeatureAdapter> registry = new HashMap<Feature, FeatureAdapter>();

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initLogger(Logger l) {
        this.log = l;
    }

    @Inject
    public void initNumericLabelProvider(Provider<NumericLabelFeatureAdapter> p) {
        this.numericLabelProvider = p;
    }

    @Inject
    public void initActionFeatureProvider(ActionFeatureAdapterProvider p) {
        this.actionFeatureAdapterProvider = p;
    }

    protected void addFeatureSwing(Feature f) {
        ActionFeature feature;
        if (f instanceof NumericFeature) {
            NumericFeature feature2 = (NumericFeature)f;
            if (feature2.getPath().contains(PATH_POLLING)) {
                this.addPollSummary(feature2);
            }
        } else if (f instanceof ActionFeature && (feature = (ActionFeature)f).getPath().contains(PATH_POLLING)) {
            this.addPollAction(feature);
        }
    }

    private void addPollAction(ActionFeature feature) {
        if (LocationDebug.POLLING_TRACE.show()) {
            this.log.message("add poll action: " + feature.toString());
        }
        JButton btn = new JButton();
        ActionFeatureAdapter adapter = this.actionFeatureAdapterProvider.get(LOCATION, feature, (AbstractButton)btn, null);
        adapter.setHasText(true);
        this.registry.put((Feature)feature, (FeatureAdapter)adapter);
        this.consolePanel.addSessionAction(adapter.getButton(), ParticipantsPanel.SessionCard.POLL);
    }

    private void addPollSummary(NumericFeature feature) {
        char l;
        Object v = feature.getMetaDatum("responseName");
        final char letter = v instanceof String && ((String)v).length() == 1 ? (Character.isLetter(l = ((String)v).charAt(0)) ? l : (char)'\u0000') : (char)'\u0000';
        JLabel response = letter != '\u0000' ? new JLabel(){

            @Override
            public void setText(String text) {
                super.setText(letter + ": " + text);
            }
        } : new JLabel();
        NumericLabelFeatureAdapter adapter = (NumericLabelFeatureAdapter)this.numericLabelProvider.get();
        adapter.initAdapter(LOCATION, feature, response, null);
        this.registry.put((Feature)feature, (FeatureAdapter)adapter);
        this.consolePanel.addSessionDisplay((JComponent)adapter.getComponent(), ParticipantsPanel.SessionCard.POLL);
    }

    protected void removeFeatureSwing(Feature f) {
        FeatureAdapter adapter;
        if (LocationDebug.POLLING_TRACE.show()) {
            this.log.message("[ParticipantSessionLocationHandler] remove feature: " + f.getPath());
        }
        if ((adapter = this.registry.get(f)) != null) {
            if (f instanceof NumericFeature) {
                this.consolePanel.removeSessionDisplay((JComponent)adapter.getComponent(), ParticipantsPanel.SessionCard.POLL);
            } else if (f instanceof ActionFeature) {
                this.consolePanel.removeSessionAction((JButton)adapter.getComponent(), ParticipantsPanel.SessionCard.POLL);
            }
        }
        this.registry.remove(f);
    }

    public void setParticipantConsolePanel(ParticipantConsolePanel pcp) {
        this.consolePanel = pcp;
    }
}

