/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.ParticipantGestureListener;
import com.elluminate.classroom.swing.ParticipantsPanel;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.classroom.swing.components.SToggleButton;
import com.elluminate.classroom.swing.location.GlobalPermissionsSupport;
import com.elluminate.classroom.swing.location.MenuSectionSupport;
import com.elluminate.classroom.swing.location.NotificationHints;
import com.elluminate.classroom.swing.location.NotificationSupport;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.EnumeratedFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.StringFeature;
import com.elluminate.framework.location.AbstractSwingLocationHandler;
import com.elluminate.framework.location.ActionFeatureAdapter;
import com.elluminate.framework.location.ActionFeatureAdapterProvider;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.framework.location.BooleanFeatureAdapterProvider;
import com.elluminate.framework.location.EnumFeatureAdapter;
import com.elluminate.framework.location.EnumFeatureAdapterProvider;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.framework.location.MenuFactory;
import com.elluminate.framework.location.ParameterSource;
import com.elluminate.framework.location.SelectionParameterSource;
import com.elluminate.framework.location.StringFeatureAdapter;
import com.elluminate.framework.location.StringFeatureAdapterProvider;
import com.elluminate.framework.session.CRAnnotation;
import com.elluminate.framework.session.CRParticipant;
import com.elluminate.framework.session.CRRoom;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRAnnotationChangeListener;
import com.elluminate.framework.session.listener.event.CRAnnotationChangeEvent;
import com.elluminate.gui.KeyBindingAdapter;
import com.elluminate.gui.swing.CMenu;
import com.elluminate.gui.swing.CRadioButtonMenuItem;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;

public class ParticipantLocationHandler
extends AbstractSwingLocationHandler
implements NotificationHints {
    private static final String LOCATION = "participant";
    private static final String AREA = "participantArea";
    private static final String TITLE_BAR_AREA = "titleBar";
    private static final String OPTIONS_MENU_AREA = "optionsMenu";
    private static final String PARTICIPANT_ACTIONS_AREA = "participantActions";
    private static final String ROOM_NAME_AREA = "roomName";
    private static final String ROOMS_MENU_AREA = "roomsMenu";
    private static final String SESSION_ACTIONS_AREA = "sessionActions";
    private static final String PARTICIPANT_MENU_AREA = "participantMenu";
    private static final String ROOM_MENU_AREA = "roomMenu";
    private static final String GESTURE_ACTIONS_AREA = "gestureActions";
    private static final String MENU_SECTION = "participantMenuSection";
    private static final String PERMISSION_SECTION = "permissionSection";
    private static final String PARTICIPANT_SECTION = "participantSection";
    private static final String OPTION_SECTION = "optionSection";
    private static final String BREAKOUT_SECTION = "breakoutSection";
    private static final String ROOMS_SECTION = "roomsSection";
    private static final String SESSION_SECTION = "sessionSection";
    private static final String POLLING_SECTION = "pollingSection";
    private static final String PANEL_SECTION = "panelSection";
    private static final String ROLE = "participantGestureActionRole";
    private static final String MOVE_PARTICIPANTS_ROLE = "moveParticipantsRole";
    private static final String PROMOTE_PARTICIPANTS_ROLE = "promoteParticipantsRole";
    private static final String DEMOTE_PARTICIPANTS_ROLE = "demoteParticipantsRole";
    private static final String CHAT_TO_PARTICIPANTS_ROLE = "chatToParticipantsRole";
    private static final String ORDER = "order";
    private static final String BADGE = "badge";
    private static final String SESSION_CARD = "sessionCard";
    private static final String POLL_CARD = "poll";
    private Map<Feature, FeatureAdapter> adapters = new HashMap<Feature, FeatureAdapter>();
    private Map<Feature, FeatureAdapter> globalPermissionAdapters = new HashMap<Feature, FeatureAdapter>();
    private Map<String, ActionFeature> gestureActionFeatures = new HashMap<String, ActionFeature>();
    private Map<Feature, AnnotationBadger> badgers = new HashMap<Feature, AnnotationBadger>();
    private MetaDataListener roomNameListener;
    private Map<String, ParticipantsPanel.SessionCard> sessionCards = new HashMap<String, ParticipantsPanel.SessionCard>();
    private NotificationSupport notificationSupport = new NotificationSupport();
    private MenuSectionSupport optionsMenuSupport = new MenuSectionSupport();
    private MenuSectionSupport roomsMenuSupport = new MenuSectionSupport();
    private MenuSectionSupport participantMenuSupport = new MenuSectionSupport();
    private MenuSectionSupport roomMenuSupport = new MenuSectionSupport();
    private GlobalPermissionsSupport globalPermissionsSupport = new GlobalPermissionsSupport();
    private ParticipantsPanel participantsPanel;
    private ActionFeatureAdapterProvider actionAdapterProvider;
    private BooleanFeatureAdapterProvider booleanAdapterProvider;
    private StringFeatureAdapterProvider stringAdapterProvider;
    private EnumFeatureAdapterProvider enumerationAdapterProvider;
    private CRSession session;
    private MenuFactory factory;
    private List<ParameterSource<?>> sources = null;
    private I18n i18n;
    private Provider<KeyBindingAdapter> keyBindingAdapter;

    public ParticipantLocationHandler() {
        this.sessionCards.put(POLL_CARD, ParticipantsPanel.SessionCard.POLL);
        this.roomNameListener = new MetaDataListener(){

            public void metaDataChanged(final MetaDataEvent e) {
                String id = e.getID();
                if (id.equals("Feature.name")) {
                    SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            ParticipantLocationHandler.this.participantsPanel.setCurrentRoomName((String)e.getNewValue());
                        }
                    });
                }
            }
        };
    }

    @Inject
    public void initBrokerAdapter(BrokerAdapter brokerAdapter) {
        brokerAdapter.addLocationHandler(LOCATION, (LocationHandler)this);
    }

    @Inject
    public void initCRSession(CRSession session) {
        this.session = session;
    }

    @Inject
    public void initMenuItemFactory(MenuFactory factory) {
        this.factory = factory;
    }

    @Inject
    public void initSelectionParameterSource(SelectionParameterSource paramSrc) {
        if (paramSrc != null) {
            this.addParameterSource(paramSrc.getParticipantParameterSource());
            this.addParameterSource(paramSrc.getRoomParameterSource());
        }
    }

    @Inject
    public void initI18n(I18nProvider prov) {
        this.i18n = prov.get((Object)this);
    }

    @Inject
    public void initKeyBindingAdapterProvider(Provider<KeyBindingAdapter> kbaa) {
        this.keyBindingAdapter = kbaa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addParameterSource(ParameterSource<?> src) {
        ParticipantLocationHandler participantLocationHandler = this;
        synchronized (participantLocationHandler) {
            if (this.sources == null) {
                this.sources = new ArrayList();
            }
            this.sources.add(src);
        }
    }

    @Inject
    public void initAdapterProviders(ActionFeatureAdapterProvider actionAdapterProvider, BooleanFeatureAdapterProvider booleanAdapterProvider, StringFeatureAdapterProvider stringAdapterProvider, EnumFeatureAdapterProvider enumerationAdapterProvider) {
        this.actionAdapterProvider = actionAdapterProvider;
        this.booleanAdapterProvider = booleanAdapterProvider;
        this.stringAdapterProvider = stringAdapterProvider;
        this.enumerationAdapterProvider = enumerationAdapterProvider;
    }

    public void setParticipantsPanel(ParticipantsPanel participantsPanel) {
        this.participantsPanel = participantsPanel;
        this.optionsMenuSupport.setMenu(participantsPanel.getOptionsMenu());
        this.optionsMenuSupport.addSection(PERMISSION_SECTION);
        this.optionsMenuSupport.addSection(OPTION_SECTION);
        this.optionsMenuSupport.addSection(BREAKOUT_SECTION);
        this.optionsMenuSupport.addSection(SESSION_SECTION);
        this.optionsMenuSupport.addSection(POLLING_SECTION);
        this.optionsMenuSupport.addSection(PANEL_SECTION);
        this.roomsMenuSupport.setMenu(participantsPanel.getRoomsMenu());
        this.roomsMenuSupport.addSection(ROOMS_SECTION);
        this.roomsMenuSupport.addSection(SESSION_SECTION);
        this.roomsMenuSupport.addSection(BREAKOUT_SECTION);
        this.participantMenuSupport.setMenu(participantsPanel.getParticipantMenu());
        this.participantMenuSupport.addSection(PERMISSION_SECTION);
        this.participantMenuSupport.addSection(PARTICIPANT_SECTION);
        this.participantMenuSupport.addSection(BREAKOUT_SECTION);
        this.participantMenuSupport.addSection(SESSION_SECTION);
        this.roomMenuSupport.setMenu(participantsPanel.getRoomMenu());
        this.roomMenuSupport.addSection(SESSION_SECTION);
        this.roomMenuSupport.addSection(PARTICIPANT_SECTION);
        this.roomMenuSupport.addSection(BREAKOUT_SECTION);
        participantsPanel.addPropertyChangeListener("expanded", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                ParticipantLocationHandler.this.notificationSupport.notifyInterestedFeatures("displayed", e.getNewValue());
            }
        });
        participantsPanel.addParticipantGestureListener(new ParticipantGestureListener(){

            @Override
            public boolean moveParticipants(CRParticipant[] participants, CRRoom room) {
                ActionFeature f = (ActionFeature)ParticipantLocationHandler.this.gestureActionFeatures.get(ParticipantLocationHandler.MOVE_PARTICIPANTS_ROLE);
                if (f == null) {
                    return false;
                }
                HashMap<String, List<Object>> params = new HashMap<String, List<Object>>();
                params.put("participants", Arrays.asList(participants));
                params.put("room", (List<Object>)room);
                return f.fireActionFeatureListeners(params).isSuccessful();
            }

            @Override
            public boolean promoteParticipants(CRParticipant[] participants) {
                ActionFeature f = (ActionFeature)ParticipantLocationHandler.this.gestureActionFeatures.get(ParticipantLocationHandler.PROMOTE_PARTICIPANTS_ROLE);
                if (f == null) {
                    return false;
                }
                HashMap<String, List<CRParticipant>> params = new HashMap<String, List<CRParticipant>>();
                params.put("participants", Arrays.asList(participants));
                return f.fireActionFeatureListeners(params).isSuccessful();
            }

            @Override
            public boolean demoteParticipants(CRParticipant[] participants) {
                ActionFeature f = (ActionFeature)ParticipantLocationHandler.this.gestureActionFeatures.get(ParticipantLocationHandler.DEMOTE_PARTICIPANTS_ROLE);
                if (f == null) {
                    return false;
                }
                HashMap<String, List<CRParticipant>> params = new HashMap<String, List<CRParticipant>>();
                params.put("participants", Arrays.asList(participants));
                return f.fireActionFeatureListeners(params).isSuccessful();
            }

            @Override
            public boolean chatToParticipants(CRParticipant[] participants) {
                ActionFeature f = (ActionFeature)ParticipantLocationHandler.this.gestureActionFeatures.get(ParticipantLocationHandler.CHAT_TO_PARTICIPANTS_ROLE);
                if (f == null) {
                    return false;
                }
                HashMap<String, List<CRParticipant>> params = new HashMap<String, List<CRParticipant>>();
                params.put("participants", Arrays.asList(participants));
                return f.fireActionFeatureListeners(params).isSuccessful();
            }
        });
    }

    protected void addFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            this.notificationSupport.addInterestedFeature(feature, String.valueOf(notification));
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(TITLE_BAR_AREA)) {
                this.addTitleBarItem(feature);
            } else if (area.equals(OPTIONS_MENU_AREA)) {
                this.addMenuItem(feature, this.optionsMenuSupport);
            } else if (area.equals(PARTICIPANT_ACTIONS_AREA)) {
                this.addParticipantAction(feature);
            } else if (area.equals(ROOM_NAME_AREA)) {
                this.addRoomAction(feature);
            } else if (area.equals(ROOMS_MENU_AREA)) {
                this.addMenuItem(feature, this.roomsMenuSupport);
            } else if (area.equals(SESSION_ACTIONS_AREA)) {
                this.addSessionAction(feature);
            } else if (area.equals(PARTICIPANT_MENU_AREA)) {
                this.addMenuItem(feature, this.participantMenuSupport);
            } else if (area.equals(ROOM_MENU_AREA)) {
                this.addMenuItem(feature, this.roomMenuSupport);
            } else if (area.equals(GESTURE_ACTIONS_AREA)) {
                this.addGestureAction(feature);
            }
        }
    }

    protected void removeFeatureSwing(Feature feature) {
        Object area;
        Object notification = feature.getHintValue("notification");
        if (notification != null) {
            this.notificationSupport.removeInterestedFeature(feature, String.valueOf(notification));
        }
        if ((area = feature.getHintValue(AREA)) != null) {
            if (area.equals(TITLE_BAR_AREA)) {
                this.removeTitleBarItem(feature);
            } else if (area.equals(OPTIONS_MENU_AREA)) {
                this.removeMenuItem(feature, this.optionsMenuSupport);
            } else if (area.equals(PARTICIPANT_ACTIONS_AREA)) {
                this.removeParticipantAction(feature);
            } else if (area.equals(ROOM_NAME_AREA)) {
                this.removeRoomAction(feature);
            } else if (area.equals(ROOMS_MENU_AREA)) {
                this.removeMenuItem(feature, this.roomsMenuSupport);
            } else if (area.equals(SESSION_ACTIONS_AREA)) {
                this.removeSessionAction(feature);
            } else if (area.equals(PARTICIPANT_MENU_AREA)) {
                this.removeMenuItem(feature, this.participantMenuSupport);
            } else if (area.equals(ROOM_MENU_AREA)) {
                this.removeMenuItem(feature, this.roomMenuSupport);
            } else if (area.equals(GESTURE_ACTIONS_AREA)) {
                this.removeGestureAction(feature);
            }
        }
    }

    private void addTitleBarItem(Feature feature) {
        JComponent c = null;
        StringFeatureAdapter a = null;
        if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            JLabel l = new JLabel();
            StringFeatureAdapter sa = this.stringAdapterProvider.get(LOCATION, sf, l, null);
            sa.setHasText(true);
            c = l;
            a = sa;
        } else if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            SButton b = new SButton();
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, af, (AbstractButton)b, null);
            aa.setHasIcon(true);
            aa.setHasToolTip(true);
            c = b;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            SButton b = new SButton();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)b, null);
            ba.setHasIcon(true);
            ba.setHasToolTip(true);
            c = b;
            a = ba;
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            this.participantsPanel.addTitleBarItem(c);
        }
    }

    private void removeTitleBarItem(Feature feature) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.participantsPanel.removeTitleBarItem((AbstractButton)a.getComponent());
            a.dispose();
        }
    }

    private void addGlobalPermission(BooleanFeature feature) {
        if (feature != null) {
            JButton button = new JButton();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, feature, (AbstractButton)button, null);
            ba.setHasIcon(true);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            this.globalPermissionAdapters.put((Feature)feature, (FeatureAdapter)ba);
            this.globalPermissionsSupport.add(button, ba, order);
        }
    }

    private void removeGlobalPermission(BooleanFeature feature) {
        if (this.globalPermissionAdapters.containsKey(feature)) {
            FeatureAdapter a = this.globalPermissionAdapters.remove(feature);
            JButton c = (JButton)a.getComponent();
            if (c != null) {
                this.globalPermissionsSupport.remove(c);
            }
            a.dispose();
        }
    }

    private void addMenuItem(Feature feature, MenuSectionSupport menuSupport) {
        JMenuItem mi;
        JMenuItem c = null;
        Object a = null;
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            mi = this.factory.createItem(feature);
            ActionFeatureAdapter aa = this.actionAdapterProvider.get(LOCATION, this.sources, af, (AbstractButton)mi, null);
            aa.setInteractiveSubstitution(this.i18n.getString((PropertiesEnum)StringsProperties.MENUHANDLER_INTERACTIVEITEM));
            aa.setHasText(true);
            c = mi;
            a = aa;
        } else if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            mi = this.factory.createItem(feature);
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)mi, null);
            ba.setHasText(true);
            if (bf.getFalseIcon() != null || bf.getTrueIcon() != null) {
                ba.setHasIcon(true);
                if (mi instanceof JCheckBoxMenuItem && feature.getPath().endsWith("Global")) {
                    this.addGlobalPermission(bf);
                }
                if (mi instanceof JCheckBoxMenuItem && (Platform.getPlatform() != 1 || Platform.getVersion() < 6)) {
                    mi.setHorizontalTextPosition(10);
                    mi.setIconTextGap(10);
                }
            }
            c = mi;
            a = ba;
        } else if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            mi = this.factory.createItem(feature);
            StringFeatureAdapter sa = this.stringAdapterProvider.get(LOCATION, sf, mi, null);
            sa.setHasText(true);
            c = mi;
            a = sa;
        } else if (feature instanceof EnumeratedFeature) {
            EnumeratedFeature ef = (EnumeratedFeature)feature;
            if (menuSupport == this.roomsMenuSupport) {
                FlatEnumFeatureAdapter ea = new FlatEnumFeatureAdapter(LOCATION, ef, menuSupport);
                for (Object val : ef.getEnumerationSet()) {
                    ea.addItem((JRadioButtonMenuItem)new CRadioButtonMenuItem(), val);
                }
                c = null;
                a = ea;
            } else {
                CMenu m = new CMenu();
                EnumFeatureAdapter ea = this.enumerationAdapterProvider.get(LOCATION, ef, (Container)m, null);
                ea.setHasText(true);
                for (Object val : ef.getEnumerationSet()) {
                    if (val == null) continue;
                    ea.addItem((AbstractButton)new CRadioButtonMenuItem(), val);
                }
                c = m;
                a = ea;
            }
        }
        if (a != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
        }
        if (c != null) {
            Object section = feature.getHintValue(MENU_SECTION);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            menuSupport.add(c, String.valueOf(section), order);
        }
    }

    private void removeMenuItem(Feature feature, MenuSectionSupport menuSupport) {
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            JComponent c = (JComponent)a.getComponent();
            if (c != null) {
                menuSupport.remove(c);
            }
            a.dispose();
            if (feature instanceof BooleanFeature) {
                this.removeGlobalPermission((BooleanFeature)feature);
            }
        }
    }

    private void addParticipantAction(Feature feature) {
        Object b;
        Object c = null;
        BooleanFeatureAdapter a = null;
        if (feature instanceof BooleanFeature) {
            BooleanFeature bf = (BooleanFeature)feature;
            SToggleButton tb = new SToggleButton();
            BooleanFeatureAdapter ba = this.booleanAdapterProvider.get(LOCATION, bf, (AbstractButton)tb, null);
            ba.setHasIcon(true);
            ba.setHasToolTip(true);
            c = tb;
            a = ba;
        } else if (feature instanceof EnumeratedFeature) {
            EnumeratedFeature ef = (EnumeratedFeature)feature;
            b = new SMenuButton(){

                @Override
                public Component add(Component component) {
                    if (component instanceof JComponent) {
                        super.addItem((JComponent)component);
                    }
                    return component;
                }

                @Override
                public void setText(String text) {
                }
            };
            ((SMenuButton)b).setShowMenuOnHover(true);
            ((JComponent)b).setToolTipText(ef.getDescription());
            EnumFeatureAdapter ea = this.enumerationAdapterProvider.get(LOCATION, ef, (Container)b, null);
            ea.setHasIcon(true);
            ea.setHasText(true);
            for (Object val : ef.getEnumerationSet()) {
                ea.addItem((AbstractButton)new CRadioButtonMenuItem(), val);
            }
            c = b;
            a = ea;
        }
        if (c instanceof SToggleButton && feature.hasHint(BADGE)) {
            String annotation = (String)feature.getHintValue(BADGE, String.class);
            b = new AnnotationBadger((SToggleButton)c, annotation);
            this.session.addAnnotationChangeListener(annotation, (CRAnnotationChangeListener)b);
            this.badgers.put(feature, (AnnotationBadger)b);
        }
        if (c != null) {
            this.adapters.put(feature, (FeatureAdapter)a);
            float order = ((Float)feature.getHintValue(ORDER, Float.class)).floatValue();
            ParticipantsPanel.SessionCard card = null;
            if (feature.hasHint(SESSION_CARD)) {
                card = this.sessionCards.get(feature.getHintValue(SESSION_CARD).toString());
            }
            this.participantsPanel.addParticipantAction((JComponent)c, order, card);
        }
    }

    private void removeParticipantAction(Feature feature) {
        if (this.badgers.containsKey(feature)) {
            AnnotationBadger b = this.badgers.remove(feature);
            this.session.removeAnnotationChangeListener(b.getAnnotation(), (CRAnnotationChangeListener)b);
        }
        if (this.adapters.containsKey(feature)) {
            FeatureAdapter a = this.adapters.remove(feature);
            this.participantsPanel.removeParticipantAction((JComponent)a.getComponent());
            a.dispose();
        }
    }

    private void addRoomAction(Feature feature) {
        if (feature instanceof StringFeature) {
            StringFeature sf = (StringFeature)feature;
            sf.addMetaDataListener(this.roomNameListener);
            this.participantsPanel.setCurrentRoomName(sf.getName());
        }
    }

    private void removeRoomAction(Feature feature) {
        if (feature instanceof StringFeature) {
            feature.removeMetaDataListener(this.roomNameListener);
            this.participantsPanel.setCurrentRoomName(null);
        }
    }

    private void addSessionAction(Feature feature) {
    }

    private void removeSessionAction(Feature feature) {
    }

    private void addGestureAction(Feature feature) {
        if (feature instanceof ActionFeature) {
            ActionFeature af = (ActionFeature)feature;
            Object role = af.getHintValue(ROLE);
            this.gestureActionFeatures.put(String.valueOf(role), af);
        }
    }

    private void removeGestureAction(Feature feature) {
        if (feature instanceof ActionFeature) {
            Object role = feature.getHintValue(ROLE);
            this.gestureActionFeatures.remove(String.valueOf(role));
        }
    }

    private class AnnotationBadger
    implements CRAnnotationChangeListener {
        private SToggleButton toggleButton;
        private String annotation;

        public AnnotationBadger(SToggleButton toggleButton, String annotation) {
            this.toggleButton = toggleButton;
            this.annotation = annotation;
        }

        public String getAnnotation() {
            return this.annotation;
        }

        public void onAnnotationValueChange(CRAnnotationChangeEvent e) {
            final CRAnnotation a = e.getNewAnnotation();
            CRParticipant p = ParticipantLocationHandler.this.session.getParticipantById(a.getID());
            if (p.isMe()) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        Number n;
                        String text = null;
                        Object v = a.getValue();
                        if (v instanceof Number && (n = (Number)v).intValue() != 0) {
                            text = n.toString();
                        }
                        AnnotationBadger.this.toggleButton.setBadgeText(text);
                    }
                });
            }
        }
    }

    private static class FlatEnumFeatureAdapter
    extends FeatureAdapter
    implements ActionListener {
        private EnumeratedFeature feature;
        private MenuSectionSupport menuSupport;
        private Map<JRadioButtonMenuItem, Object> items = new HashMap<JRadioButtonMenuItem, Object>();

        public FlatEnumFeatureAdapter(String location, EnumeratedFeature feature, MenuSectionSupport menuSupport) {
            super.init(location, (Feature)feature, (Component)menuSupport.getMenu(), null);
            this.feature = feature;
            this.menuSupport = menuSupport;
            feature.addMetaDataListener((MetaDataListener)this);
        }

        public void addItem(JRadioButtonMenuItem item, Object value) {
            this.items.put(item, value);
            item.addActionListener(this);
            String text = this.feature.getValueText(value);
            if (text == null && value != null) {
                text = value.toString();
            }
            item.setText(text);
            item.setSelected(value.equals(this.feature.getValue()));
            Object section = this.feature.getHintValue(ParticipantLocationHandler.MENU_SECTION);
            float order = ((Float)this.feature.getHintValue(ParticipantLocationHandler.ORDER, Float.class)).floatValue();
            this.menuSupport.add(item, String.valueOf(section), order);
        }

        public void dispose() {
            this.feature.removeMetaDataListener((MetaDataListener)this);
            for (JRadioButtonMenuItem mi : this.items.keySet()) {
                mi.removeActionListener(this);
                this.menuSupport.remove(mi);
            }
            this.items.clear();
        }

        private void applySelection(Object value) {
            for (JRadioButtonMenuItem item : this.items.keySet()) {
                item.setSelected(value != null && value.equals(this.items.get(item)));
            }
        }

        public void doMetaDataChanged(MetaDataEvent e) {
            String id = e.getID();
            if (id.equals("ValueFeature.value")) {
                this.applySelection(e.getNewValue());
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButtonMenuItem mi = (JRadioButtonMenuItem)e.getSource();
            Object val = this.items.get(mi);
            if (!val.equals(this.feature.getValue())) {
                if (this.feature.isChangeRequestSupported()) {
                    this.applySelection(this.feature.getValue());
                    this.feature.requestValue(val);
                } else {
                    this.feature.setValue(val);
                }
            } else {
                mi.setSelected(true);
            }
        }

        public void setHasText(boolean hasText) {
        }

        public void setHasToolTip(boolean hasTip) {
        }
    }
}

