/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.ListElementChangeEvent;
import com.elluminate.framework.feature.ListElementChangeListener;
import com.elluminate.framework.feature.ListFeature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.ValueFeature;
import com.elluminate.framework.location.FeatureAdapter;
import com.elluminate.gui.I18nUI;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18nMessage;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;

public class ListFeatureAdapter
extends FeatureAdapter {
    private JComboBox combo;
    private ListFeature<?> listFeature;
    private ActionFeature gotoAction;
    private ValueFeature<?> selectedScreenFeature;
    private ActionListener comboActionListener;
    private ListElementChangeListener listListener;
    private MetaDataListener listEnabledListener;

    public void init(JComboBox combo, ListFeature<?> lf) {
        this.combo = combo;
        this.listFeature = lf;
        this.wireFeaturesUp();
    }

    public void initGotoAction(ActionFeature gotoAction) {
        this.gotoAction = gotoAction;
        this.wireFeaturesUp();
    }

    public void initSelectedFeature(ValueFeature<?> feature) {
        this.selectedScreenFeature = feature;
        this.wireFeaturesUp();
    }

    private void wireFeaturesUp() {
        if (this.combo == null || this.listFeature == null || this.gotoAction == null || this.selectedScreenFeature == null) {
            return;
        }
        this.updateScreenList();
        this.combo.setEnabled(this.listFeature.isEnabled());
        this.listFeature.addListElementListener(this.createListListener());
        this.listFeature.addMetaDataListener("Feature.enabled", this.createListEnabledListener());
        this.combo.addActionListener(this.createComboActionListener());
        this.selectedScreenFeature.addValueChangeListener(this.createValueChangeListener());
    }

    private MetaDataListener createListEnabledListener() {
        if (this.listEnabledListener == null) {
            this.listEnabledListener = new MetaDataListener(){

                public void metaDataChanged(MetaDataEvent ev) {
                    ListFeatureAdapter.this.combo.setEnabled((Boolean)ev.getNewValue());
                }
            };
        }
        return this.listEnabledListener;
    }

    private ActionListener createComboActionListener() {
        if (this.comboActionListener == null) {
            this.comboActionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    Object si = ListFeatureAdapter.this.combo.getSelectedItem();
                    ListFeatureAdapter.this.gotoAction.fireActionFeatureListeners(si);
                    if (ListFeatureAdapter.this.selectedScreenFeature != null) {
                        ListFeatureAdapter.this.combo.getModel().setSelectedItem(ListFeatureAdapter.this.selectedScreenFeature.getValue());
                    }
                }
            };
        }
        return this.comboActionListener;
    }

    private ListElementChangeListener createListListener() {
        if (this.listListener == null) {
            this.listListener = new ListElementChangeListener(){

                public void elementAdded(ListElementChangeEvent event) {
                    ListFeatureAdapter.this.updateScreenList();
                }

                public void elementRemoved(ListElementChangeEvent event) {
                    ListFeatureAdapter.this.updateScreenList();
                }

                public void allElementsCleared(ListElementChangeEvent event) {
                    ListFeatureAdapter.this.updateScreenList();
                }

                public void elementsBatchUpdated(ListElementChangeEvent event) {
                    ListFeatureAdapter.this.updateScreenList();
                }
            };
        }
        return this.listListener;
    }

    private void updateScreenList() {
        DefaultComboBoxModel<Object> comboModel = new DefaultComboBoxModel<Object>();
        int size = this.listFeature.size();
        for (int i = 0; i < this.listFeature.size(); ++i) {
            comboModel.addElement(this.listFeature.get(i));
        }
        this.combo.setModel(comboModel);
        this.combo.setRenderer(new IconListRenderer());
    }

    public void dispose() {
        this.removeListFeature();
        this.removeGotoAction();
        this.removeSelectedScreenFeature();
        if (this.combo != null) {
            this.combo.removeActionListener(this.comboActionListener);
        }
        this.combo = null;
    }

    public ActionFeature getGotoAction() {
        return this.gotoAction;
    }

    public ValueFeature<?> getSelectedScreenFeature() {
        return this.selectedScreenFeature;
    }

    private MetaDataListener createValueChangeListener() {
        return new MetaDataListener(){

            public void metaDataChanged(MetaDataEvent ev) {
                ListFeatureAdapter.this.combo.getModel().setSelectedItem(ev.getNewValue());
            }
        };
    }

    public ListFeature<?> getListFeature() {
        return this.listFeature;
    }

    public JComboBox getCombo() {
        return this.combo;
    }

    public void removeListFeature() {
        if (this.listFeature != null) {
            this.listFeature.removeListElementListener(this.listListener);
            this.listFeature.removeMetaDataListener("Feature.enabled", this.listEnabledListener);
            this.combo.setEnabled(false);
            this.listFeature = null;
            this.updateScreenList();
        }
    }

    public void removeGotoAction() {
        if (this.gotoAction != null) {
            this.gotoAction = null;
        }
    }

    public void removeSelectedScreenFeature() {
        if (this.selectedScreenFeature != null) {
            this.selectedScreenFeature = null;
        }
    }

    public boolean isEmpty() {
        return this.listFeature == null && this.gotoAction != null && this.selectedScreenFeature == null;
    }

    public void setHasText(boolean hasText) {
    }

    public void setHasToolTip(boolean hasTip) {
    }

    public class IconListRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (value instanceof VCRFile.IndexEntry) {
                label.setIcon(I18nUI.getIcon((I18nMessage)((VCRFile.IndexEntry)value).getModuleIntl()));
            }
            return label;
        }
    }
}

