/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.location.HotKeyAction;
import com.elluminate.classroom.swing.location.HotKeyPrefsPanel;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.MetaDataEvent;
import com.elluminate.framework.feature.MetaDataListener;
import com.elluminate.framework.feature.hints.HintEnum;
import com.elluminate.framework.location.SwingLocationHandler;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.HotKey;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.PreferencesDialog;
import com.elluminate.util.Preferences;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.KeyStroke;

@Singleton
public class HotKeyLocationHandler
extends SwingLocationHandler {
    public static final String LOCATION = "hotKey";
    private static final String MODE_HINT = "hotKey.booleanMode";
    private static final String DESC_HINT = "hotKey.desc";
    private static final String DFT_KEY_HINT = "hotKey.defaultKey";
    private static final String ACTION_SUFFIX = ".action";
    private static final String TOGGLE_SUFFIX = ".toggle";
    private static final String ENABLE_SUFFIX = ".enable";
    private static final String DISABLE_SUFFIX = ".disable";
    private static final int MODE_TOGGLE = 1;
    private static final int MODE_ON_OFF = 2;
    private PreferencesDialog dialog;
    private Provider<HotKeyPrefsPanel> panelProv;
    private Preferences prefs;
    private String platformMask;
    private List<HotKeyAction> actions = new ArrayList<HotKeyAction>();
    private Map<String, List<KeyAction>> byPath = new HashMap<String, List<KeyAction>>();
    private Map<KeyStroke, Binding> bindings = new HashMap<KeyStroke, Binding>();

    @Inject
    public HotKeyLocationHandler(Preferences prefs) {
        this.prefs = prefs;
        if (this.platformMask == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            int mask = toolkit.getMenuShortcutKeyMask();
            String mods = "";
            if ((mask & 2) != 0) {
                mods = mods + "control";
            }
            if ((mask & 1) != 0) {
                if (mods.length() > 0) {
                    mods = mods + " ";
                }
                mods = mods + "shift";
            }
            if ((mask & 4) != 0) {
                if (mods.length() > 0) {
                    mods = mods + " ";
                }
                mods = mods + "meta";
            }
            if ((mask & 8) != 0) {
                if (mods.length() > 0) {
                    mods = mods + " ";
                }
                mods = mods + "alt";
            }
            this.platformMask = mods;
        }
    }

    @Inject
    public void initPrefsDialog(PreferencesDialog prefsDlg) {
        this.dialog = prefsDlg;
    }

    @Inject
    public void initPrefsPanel(Provider<HotKeyPrefsPanel> panelProv) {
        this.panelProv = panelProv;
    }

    public List<HotKeyAction> getActions() {
        return Collections.unmodifiableList(this.actions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void bind(HotKeyAction action, KeyStroke key) {
        if (!(action instanceof KeyAction)) {
            return;
        }
        Map<KeyStroke, Binding> map = this.bindings;
        synchronized (map) {
            Binding b;
            KeyAction keyAction = (KeyAction)action;
            KeyStroke prev = keyAction.getKeyStroke();
            if (prev != null && (b = this.bindings.get(prev)).removeAction(keyAction)) {
                this.bindings.remove(prev);
            }
            if (key != null) {
                b = this.bindings.get(key);
                if (b == null) {
                    b = new Binding(key);
                    this.bindings.put(key, b);
                }
                b.addAction(keyAction);
            }
        }
    }

    public KeyStroke[] getKeyStrokesFor(String path) {
        List<KeyAction> actions = this.byPath.get(path);
        KeyStroke[] keys = new KeyStroke[actions.size()];
        int i = 0;
        for (KeyAction action : actions) {
            keys[i++] = action.getKeyStroke();
        }
        return keys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHotKeyValid(KeyStroke key) {
        boolean valid = false;
        Map<KeyStroke, Binding> map = this.bindings;
        synchronized (map) {
            int mods;
            if (this.bindings.containsKey(key)) {
                valid = true;
                return true;
            }
            if (key == null) {
                return true;
            }
            int code = key.getKeyCode();
            HotKey k = GuiUtils.createHotKey((int)code, (int)(mods = key.getModifiers()), (Runnable)new Runnable(){

                @Override
                public void run() {
                }
            });
            if (k != null) {
                valid = k.isValid();
                k.dispose();
            }
        }
        return valid;
    }

    protected void addFeatureSwing(Feature f) {
        List<KeyAction> set = this.byPath.get(f.getPath());
        if (set == null) {
            this.announceFeatureSwing(f);
            set = this.byPath.get(f.getPath());
        }
        if (set != null) {
            for (KeyAction action : set) {
                action.attach(f);
            }
        }
    }

    protected void removeFeatureSwing(Feature f) {
        List<KeyAction> set = this.byPath.get(f.getPath());
        if (f != null) {
            for (KeyAction action : set) {
                action.detach();
            }
        }
    }

    protected void announceFeatureSwing(Feature f) {
        KeyAction action = null;
        if (f instanceof ActionFeature) {
            action = new ActionKey(f);
            this.addAction(f, action);
        } else if (f instanceof BooleanFeature) {
            HintEnum mode = (HintEnum)f.getHintValue(MODE_HINT, HintEnum.class);
            if (mode == null) {
                throw new IllegalArgumentException("Missing hotKey.booleanMode hint on " + f.getPath());
            }
            switch (mode.getOrdinal()) {
                case 1: {
                    action = new KeyToggle(f);
                    this.addAction(f, action);
                    break;
                }
                case 2: {
                    action = new KeyOn(f);
                    this.addAction(f, action);
                    action = new KeyOff(f);
                    this.addAction(f, action);
                }
            }
        } else {
            this.logger.error((Object)this, "announceFeatureSwing", "Unsupported HotKey feature type for " + f.getPath() + ": " + f.getClass().getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAction(Feature f, KeyAction action) {
        boolean addPanel = false;
        Map<String, List<KeyAction>> map = this.byPath;
        synchronized (map) {
            String path = f.getPath();
            List<KeyAction> set = this.byPath.get(path);
            if (set == null) {
                set = new ArrayList<KeyAction>();
                this.byPath.put(path, set);
            }
            set.add(action);
            ArrayList<HotKeyAction> updated = new ArrayList<HotKeyAction>(this.actions);
            updated.add(action);
            addPanel = this.actions.isEmpty() && !updated.isEmpty();
            this.actions = updated;
        }
        if (addPanel) {
            this.dialog.addPanel((AbstractPreferencesPanel)this.panelProv.get());
        }
    }

    class ActionKey
    extends KeyAction {
        ActionFeature feature;

        public ActionKey(Feature f) {
            super(f, 1, 1);
            this.feature = null;
        }

        @Override
        public String initPrefName(String path) {
            return HotKeyLocationHandler.LOCATION + path.replace('/', '.') + HotKeyLocationHandler.ACTION_SUFFIX;
        }

        @Override
        public void run() {
            if (this.feature != null) {
                this.feature.fireActionFeatureListeners();
            }
        }

        @Override
        public void attach(Feature f) {
            this.feature = (ActionFeature)f;
            Binding b = this.getBinding();
            if (b != null && b.isValid()) {
                this.feature.setKeyStroke(GuiUtils.getKeystrokeText((KeyStroke)b.getKeyStroke()));
            }
        }

        @Override
        public void detach() {
            this.feature.setKeyStroke(null);
            this.feature = null;
        }

        @Override
        public void bindHook(Binding b) {
            if (this.feature != null) {
                if (b != null && b.isValid()) {
                    this.feature.setKeyStroke(GuiUtils.getKeystrokeText((KeyStroke)b.getKeyStroke()));
                } else {
                    this.feature.setKeyStroke(null);
                }
            }
        }
    }

    class Binding
    implements Runnable {
        KeyStroke keystroke;
        HotKey hotkey;
        List<KeyAction> actions = new ArrayList<KeyAction>();

        public Binding(KeyStroke key) {
            this.keystroke = key;
            this.hotkey = GuiUtils.createHotKey((int)key.getKeyCode(), (int)key.getModifiers(), (Runnable)this);
        }

        public KeyStroke getKeyStroke() {
            return this.keystroke;
        }

        public void addAction(KeyAction action) {
            this.actions.add(action);
            action.setBinding(this);
        }

        public boolean removeAction(KeyAction action) {
            this.actions.remove(action);
            if (this.actions.isEmpty()) {
                if (this.hotkey != null) {
                    this.hotkey.dispose();
                }
                return true;
            }
            return false;
        }

        public boolean isValid() {
            return this.hotkey == null ? false : this.hotkey.isValid();
        }

        @Override
        public void run() {
            ArrayList<KeyAction> execute = new ArrayList<KeyAction>();
            for (KeyAction action : this.actions) {
                if (!action.isApplicable()) continue;
                execute.add(action);
            }
            for (KeyAction action : execute) {
                action.run();
            }
        }
    }

    abstract class BooleanAction
    extends KeyAction
    implements MetaDataListener {
        protected BooleanFeature feature;

        public BooleanAction(Feature f, int idx, int limit) {
            super(f, idx, limit);
            this.feature = null;
        }

        protected void valueChanged() {
        }

        @Override
        public void attach(Feature f) {
            this.feature = (BooleanFeature)f;
            Binding b = this.getBinding();
            if (b != null && b.isValid() && this.isApplicable()) {
                this.feature.setKeyStroke(GuiUtils.getKeystrokeText((KeyStroke)b.getKeyStroke()));
            }
            this.feature.addValueChangeListener((MetaDataListener)this);
        }

        @Override
        public void detach() {
            this.feature.setKeyStroke(null);
            this.feature.removeValueChangeListener((MetaDataListener)this);
            this.feature = null;
        }

        public void metaDataChanged(MetaDataEvent e) {
        }
    }

    abstract class BooleanAssignAction
    extends BooleanAction {
        private boolean target;

        public BooleanAssignAction(Feature f, int idx, boolean value) {
            super(f, idx, 2);
            this.target = value;
        }

        @Override
        public boolean isApplicable() {
            return this.feature != null && (Boolean)this.feature.getValue() != this.target;
        }

        @Override
        public void bindHook(Binding b) {
            if (this.feature != null && this.isApplicable()) {
                if (b.isValid()) {
                    this.feature.setKeyStroke(GuiUtils.getKeystrokeText((KeyStroke)b.getKeyStroke()));
                } else {
                    this.feature.setKeyStroke(null);
                }
            }
        }

        @Override
        public void run() {
            if (this.feature != null && (Boolean)this.feature.getValue() != this.target) {
                if (this.feature.isChangeRequestSupported()) {
                    this.feature.requestValue((Object)this.target);
                } else {
                    this.feature.setValue((Object)this.target);
                }
            }
        }

        @Override
        public void metaDataChanged(MetaDataEvent e) {
            Binding b;
            if (this.feature != null && (b = this.getBinding()) != null && b.isValid() && this.isApplicable()) {
                this.feature.setKeyStroke(GuiUtils.getKeystrokeText((KeyStroke)b.getKeyStroke()));
            }
        }
    }

    abstract class KeyAction
    implements HotKeyAction,
    Runnable,
    PropertyChangeListener {
        public static final String PREFIX = "HotKey";
        public static final String PLATFORM_MODIFIER = "PLATFORM";
        private String path;
        private KeyStroke keystroke;
        private String desc;
        private String dftstroke;
        private String prefName;
        private Binding binding = null;

        public KeyAction(Feature f, int index, int limit) {
            this.path = f.getPath();
            this.desc = this.getHintValue(f, HotKeyLocationHandler.DESC_HINT, index, limit);
            this.dftstroke = this.getHintValue(f, HotKeyLocationHandler.DFT_KEY_HINT, index, limit);
            this.prefName = this.initPrefName(this.path);
            this.keystroke = this.getPreference(HotKeyLocationHandler.this.prefs);
            if (this.keystroke != null) {
                HotKeyLocationHandler.this.bind(this, this.keystroke);
            }
            HotKeyLocationHandler.this.prefs.addSettingChangeListener(this.prefName, (PropertyChangeListener)this);
        }

        private String getHintValue(Feature f, String hint, int idx, int limit) {
            List list = (List)f.getHintValue(hint, List.class);
            if (list.size() != limit) {
                throw new IllegalArgumentException(f.getPath() + " requires exactly " + limit + " values for the " + hint + " hint - " + list.size() + " provided.");
            }
            return (String)list.get(idx - 1);
        }

        public String getPath() {
            return this.path;
        }

        @Override
        public String getDescription() {
            return this.desc;
        }

        @Override
        public KeyStroke getKeyStroke() {
            if (this.binding == null) {
                return null;
            }
            return this.binding.getKeyStroke();
        }

        @Override
        public boolean isValid() {
            if (this.binding == null) {
                return false;
            }
            return this.binding.isValid();
        }

        @Override
        public void setPreference(Preferences prefs, KeyStroke stroke) {
            if (stroke == null) {
                prefs.setSetting(this.prefName, "");
            } else {
                prefs.setSetting(this.prefName, stroke.toString());
            }
        }

        @Override
        public KeyStroke getPreference(Preferences prefs) {
            KeyStroke stroke = null;
            String strokeDesc = prefs.getSetting(this.prefName, this.dftstroke);
            if (strokeDesc != null) {
                if ((strokeDesc = strokeDesc.replace(PLATFORM_MODIFIER, HotKeyLocationHandler.this.platformMask)).contains("|")) {
                    StringTokenizer parser = new StringTokenizer(strokeDesc, "|", false);
                    while (stroke == null && parser.hasMoreTokens()) {
                        stroke = KeyStroke.getKeyStroke(parser.nextToken());
                        if (stroke == null || GuiUtils.checkKeyCode((int)stroke.getKeyCode())) continue;
                        stroke = null;
                    }
                } else {
                    stroke = KeyStroke.getKeyStroke(strokeDesc);
                }
            }
            return stroke;
        }

        @Override
        public void resetPreference(Preferences prefs) {
            prefs.clearSetting(this.prefName);
        }

        public boolean isApplicable() {
            return true;
        }

        public Binding getBinding() {
            return this.binding;
        }

        public final void setBinding(Binding b) {
            this.binding = b;
            this.bindHook(b);
        }

        public void bindHook(Binding b) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            HotKeyLocationHandler.this.bind(this, this.getPreference(HotKeyLocationHandler.this.prefs));
        }

        public abstract void attach(Feature var1);

        public abstract void detach();

        protected abstract String initPrefName(String var1);
    }

    class KeyOff
    extends BooleanAssignAction {
        public KeyOff(Feature f) {
            super(f, 2, false);
        }

        @Override
        public String initPrefName(String path) {
            return HotKeyLocationHandler.LOCATION + path.replace('/', '.') + HotKeyLocationHandler.DISABLE_SUFFIX;
        }
    }

    class KeyOn
    extends BooleanAssignAction {
        public KeyOn(Feature f) {
            super(f, 1, true);
        }

        @Override
        public String initPrefName(String path) {
            return HotKeyLocationHandler.LOCATION + path.replace('/', '.') + HotKeyLocationHandler.ENABLE_SUFFIX;
        }
    }

    class KeyToggle
    extends BooleanAction {
        public KeyToggle(Feature f) {
            super(f, 1, 1);
        }

        @Override
        public String initPrefName(String path) {
            return HotKeyLocationHandler.LOCATION + path.replace('/', '.') + HotKeyLocationHandler.TOGGLE_SUFFIX;
        }

        @Override
        public void bindHook(Binding b) {
            if (this.feature != null) {
                if (b.isValid()) {
                    this.feature.setKeyStroke(GuiUtils.getKeystrokeText((KeyStroke)b.getKeyStroke()));
                } else {
                    this.feature.setKeyStroke(null);
                }
            }
        }

        @Override
        public void run() {
            if (this.feature != null) {
                if (this.feature.isChangeRequestSupported()) {
                    this.feature.requestValue((Object)((Boolean)this.feature.getValue() == false ? 1 : 0));
                } else {
                    this.feature.setValue((Object)((Boolean)this.feature.getValue() == false ? 1 : 0));
                }
            }
        }
    }
}

