/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.swing.GlobalPermissionsPanel;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.framework.feature.BooleanFeature;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.location.BooleanFeatureAdapter;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class GlobalPermissionsSupport {
    private static final String AUDIO_PERMISSION = "/audio/audioPermissionGlobal";
    private static final String VIDEO_PERMISSION = "/video/videoPermissionGlobal";
    private static final String CHAT_PERMISSION = "/chat/chatPermissionGlobal";
    private static final String WHITEBOARD_PERMISSION = "/whiteboard/whiteboardPermissionGlobal";
    private static final String APPSHARE_PERMISSION = "/appshare/appSharePermissionGlobal";
    private static final String WEBTOUR_PERMISSION = "/web/webTourPermissionGlobal";
    private static final String ORDER_PROPERTY = "__order__";
    private Dimension buttonSize = new Dimension(18, 20);
    private static GlobalPermissionsPanel panel;
    private static I18n i18n;
    private static Map<String, BooleanFeatureAdapter> featureMap;

    public GlobalPermissionsSupport() {
        panel = new GlobalPermissionsPanel(new FlowLayout(2, 0, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        panel.setOpaque(false);
    }

    @Inject
    public void initI18n(I18nProvider prov) {
        i18n = prov.get((Object)this);
    }

    public GlobalPermissionsPanel getPanel() {
        return panel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(JButton button, BooleanFeatureAdapter feature, float order) {
        Object object = panel.getTreeLock();
        synchronized (object) {
            int insertionIndex = -1;
            for (int index = 0; index < panel.getComponentCount(); ++index) {
                Component c = panel.getComponent(index);
                float o = this.getItemOrder(c);
                if (!(o > order)) continue;
                insertionIndex = index;
                break;
            }
            button.putClientProperty(ORDER_PROPERTY, Float.valueOf(order));
            button.setSize(this.buttonSize);
            button.setPreferredSize(this.buttonSize);
            button.setBorderPainted(false);
            button.setContentAreaFilled(false);
            button.setVisible(true);
            feature.getButton().setIcon(this.getIcon(feature.getBooleanFeature()));
            feature.getBooleanFeature().setRolloverTrueIcon(((ImageIcon)GlobalPermissionsSupport.getGrantedRolloverIcon(feature.getBooleanFeature())).getImage());
            feature.getBooleanFeature().setRolloverFalseIcon(((ImageIcon)GlobalPermissionsSupport.getRevokedRolloverIcon(feature.getBooleanFeature())).getImage());
            button.setToolTipText(GlobalPermissionsSupport.getToolTipText(feature.getBooleanFeature()));
            button.addActionListener(this.getActionListener(feature));
            panel.add((Component)button, insertionIndex);
            featureMap.put(feature.getBooleanFeature().getPath(), feature);
        }
    }

    private Icon getIcon(BooleanFeature feature) {
        if (((Boolean)feature.getValue()).booleanValue()) {
            return GlobalPermissionsSupport.getGrantedIcon(feature);
        }
        return GlobalPermissionsSupport.getRevokedIcon(feature);
    }

    private static Icon getGrantedRolloverIcon(BooleanFeature feature) {
        if (feature.getPath().equals(AUDIO_PERMISSION)) {
            return UIManager.getIcon("Audio.permissionGrantedRolloverIcon");
        }
        if (feature.getPath().equals(CHAT_PERMISSION)) {
            return UIManager.getIcon("Chat.permissionGrantedRolloverIcon");
        }
        if (feature.getPath().equals(VIDEO_PERMISSION)) {
            return UIManager.getIcon("Video.permissionGrantedRolloverIcon");
        }
        if (feature.getPath().equals(WHITEBOARD_PERMISSION)) {
            return UIManager.getIcon("Whiteboard.permissionGrantedRolloverIcon");
        }
        if (feature.getPath().equals(APPSHARE_PERMISSION)) {
            return UIManager.getIcon("ScreenSharing.permissionGrantedRolloverIcon");
        }
        if (feature.getPath().equals(WEBTOUR_PERMISSION)) {
            return UIManager.getIcon("WebTour.permissionGrantedRolloverIcon");
        }
        return null;
    }

    private static Icon getGrantedIcon(BooleanFeature feature) {
        if (feature.getPath().equals(AUDIO_PERMISSION)) {
            return UIManager.getIcon("Audio.permissionGrantedIcon");
        }
        if (feature.getPath().equals(CHAT_PERMISSION)) {
            return UIManager.getIcon("Chat.permissionGrantedIcon");
        }
        if (feature.getPath().equals(VIDEO_PERMISSION)) {
            return UIManager.getIcon("Video.permissionGrantedIcon");
        }
        if (feature.getPath().equals(WHITEBOARD_PERMISSION)) {
            return UIManager.getIcon("Whiteboard.permissionGrantedIcon");
        }
        if (feature.getPath().equals(APPSHARE_PERMISSION)) {
            return UIManager.getIcon("ScreenSharing.permissionGrantedIcon");
        }
        if (feature.getPath().equals(WEBTOUR_PERMISSION)) {
            return UIManager.getIcon("WebTour.permissionGrantedIcon");
        }
        return null;
    }

    private static Icon getRevokedRolloverIcon(BooleanFeature feature) {
        if (feature.getPath().equals(AUDIO_PERMISSION)) {
            return UIManager.getIcon("Audio.permissionRevokedRolloverIcon");
        }
        if (feature.getPath().equals(CHAT_PERMISSION)) {
            return UIManager.getIcon("Chat.permissionRevokedRolloverIcon");
        }
        if (feature.getPath().equals(VIDEO_PERMISSION)) {
            return UIManager.getIcon("Video.permissionRevokedRolloverIcon");
        }
        if (feature.getPath().equals(WHITEBOARD_PERMISSION)) {
            return UIManager.getIcon("Whiteboard.permissionRevokedRolloverIcon");
        }
        if (feature.getPath().equals(APPSHARE_PERMISSION)) {
            return UIManager.getIcon("ScreenSharing.permissionRevokedRolloverIcon");
        }
        if (feature.getPath().equals(WEBTOUR_PERMISSION)) {
            return UIManager.getIcon("WebTour.permissionRevokedRolloverIcon");
        }
        return null;
    }

    private static Icon getRevokedIcon(BooleanFeature feature) {
        if (feature.getPath().equals(AUDIO_PERMISSION)) {
            return UIManager.getIcon("Audio.permissionRevokedIcon");
        }
        if (feature.getPath().equals(CHAT_PERMISSION)) {
            return UIManager.getIcon("Chat.permissionRevokedIcon");
        }
        if (feature.getPath().equals(VIDEO_PERMISSION)) {
            return UIManager.getIcon("Video.permissionRevokedIcon");
        }
        if (feature.getPath().equals(WHITEBOARD_PERMISSION)) {
            return UIManager.getIcon("Whiteboard.permissionRevokedIcon");
        }
        if (feature.getPath().equals(APPSHARE_PERMISSION)) {
            return UIManager.getIcon("ScreenSharing.permissionRevokedIcon");
        }
        if (feature.getPath().equals(WEBTOUR_PERMISSION)) {
            return UIManager.getIcon("WebTour.permissionRevokedIcon");
        }
        return null;
    }

    private static String getToolTipText(BooleanFeature feature) {
        if (feature.getPath().equals(AUDIO_PERMISSION)) {
            return (Boolean)feature.getValue() != false ? i18n.getString((PropertiesEnum)StringsProperties.AUDIO_PERMISSION_GRANTED_TOOLTIP) : i18n.getString((PropertiesEnum)StringsProperties.AUDIO_PERMISSION_REVOKED_TOOLTIP);
        }
        if (feature.getPath().equals(CHAT_PERMISSION)) {
            return (Boolean)feature.getValue() != false ? i18n.getString((PropertiesEnum)StringsProperties.CHAT_PERMISSION_GRANTED_TOOLTIP) : i18n.getString((PropertiesEnum)StringsProperties.CHAT_PERMISSION_REVOKED_TOOLTIP);
        }
        if (feature.getPath().equals(VIDEO_PERMISSION)) {
            return (Boolean)feature.getValue() != false ? i18n.getString((PropertiesEnum)StringsProperties.VIDEO_PERMISSION_GRANTED_TOOLTIP) : i18n.getString((PropertiesEnum)StringsProperties.VIDEO_PERMISSION_REVOKED_TOOLTIP);
        }
        if (feature.getPath().equals(WHITEBOARD_PERMISSION)) {
            return (Boolean)feature.getValue() != false ? i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARD_PERMISSION_GRANTED_TOOLTIP) : i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARD_PERMISSION_REVOKED_TOOLTIP);
        }
        if (feature.getPath().equals(APPSHARE_PERMISSION)) {
            return (Boolean)feature.getValue() != false ? i18n.getString((PropertiesEnum)StringsProperties.SCREENSHARING_PERMISSION_GRANTED_TOOLTIP) : i18n.getString((PropertiesEnum)StringsProperties.SCREENSHARING_PERMISSION_REVOKED_TOOLTIP);
        }
        if (feature.getPath().equals(WEBTOUR_PERMISSION)) {
            return (Boolean)feature.getValue() != false ? i18n.getString((PropertiesEnum)StringsProperties.WEBTOUR_PERMISSION_GRANTED_TOOLTIP) : i18n.getString((PropertiesEnum)StringsProperties.WEBTOUR_PERMISSION_REVOKED_TOOLTIP);
        }
        return null;
    }

    private float getItemOrder(Component item) {
        Object prop;
        if (item instanceof JComponent && (prop = ((JComponent)item).getClientProperty(ORDER_PROPERTY)) instanceof Number) {
            return ((Number)prop).floatValue();
        }
        return -1.0f;
    }

    public JButton createButton(Feature feature) {
        return new JButton();
    }

    private ActionListener getActionListener(BooleanFeatureAdapter feature) {
        ActionListener al = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        return al;
    }

    public void remove(JButton c) {
        if (panel.isAncestorOf(c)) {
            panel.remove(c);
        }
    }

    public static void setIcons(String group, boolean permValue) {
        if (featureMap == null || featureMap.isEmpty()) {
            return;
        }
        if (group.equalsIgnoreCase("AudioPermission")) {
            if (permValue) {
                featureMap.get(AUDIO_PERMISSION).getButton().setIcon(UIManager.getIcon("Audio.permissionGrantedIcon"));
                featureMap.get(AUDIO_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AUDIO_PERMISSION_GRANTED_TOOLTIP));
            } else {
                featureMap.get(AUDIO_PERMISSION).getButton().setIcon(UIManager.getIcon("Audio.permissionRevokedIcon"));
                featureMap.get(AUDIO_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.AUDIO_PERMISSION_REVOKED_TOOLTIP));
            }
            featureMap.get(AUDIO_PERMISSION).getBooleanFeature().setRolloverTrueIcon(((ImageIcon)GlobalPermissionsSupport.getGrantedRolloverIcon(featureMap.get(AUDIO_PERMISSION).getBooleanFeature())).getImage());
            featureMap.get(AUDIO_PERMISSION).getBooleanFeature().setRolloverFalseIcon(((ImageIcon)GlobalPermissionsSupport.getRevokedRolloverIcon(featureMap.get(AUDIO_PERMISSION).getBooleanFeature())).getImage());
        }
        if (group.equalsIgnoreCase("VideoPermission")) {
            if (permValue) {
                featureMap.get(VIDEO_PERMISSION).getButton().setIcon(UIManager.getIcon("Video.permissionGrantedIcon"));
                featureMap.get(VIDEO_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.VIDEO_PERMISSION_GRANTED_TOOLTIP));
            } else {
                featureMap.get(VIDEO_PERMISSION).getButton().setIcon(UIManager.getIcon("Video.permissionRevokedIcon"));
                featureMap.get(VIDEO_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.VIDEO_PERMISSION_REVOKED_TOOLTIP));
            }
            featureMap.get(VIDEO_PERMISSION).getBooleanFeature().setRolloverTrueIcon(((ImageIcon)GlobalPermissionsSupport.getGrantedRolloverIcon(featureMap.get(VIDEO_PERMISSION).getBooleanFeature())).getImage());
            featureMap.get(VIDEO_PERMISSION).getBooleanFeature().setRolloverFalseIcon(((ImageIcon)GlobalPermissionsSupport.getRevokedRolloverIcon(featureMap.get(VIDEO_PERMISSION).getBooleanFeature())).getImage());
        }
        if (group.equalsIgnoreCase("ChatPermission")) {
            if (permValue) {
                featureMap.get(CHAT_PERMISSION).getButton().setIcon(UIManager.getIcon("Chat.permissionGrantedIcon"));
                featureMap.get(CHAT_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.CHAT_PERMISSION_GRANTED_TOOLTIP));
            } else {
                featureMap.get(CHAT_PERMISSION).getButton().setIcon(UIManager.getIcon("Chat.permissionRevokedIcon"));
                featureMap.get(CHAT_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.CHAT_PERMISSION_REVOKED_TOOLTIP));
            }
            featureMap.get(CHAT_PERMISSION).getBooleanFeature().setRolloverTrueIcon(((ImageIcon)GlobalPermissionsSupport.getGrantedRolloverIcon(featureMap.get(CHAT_PERMISSION).getBooleanFeature())).getImage());
            featureMap.get(CHAT_PERMISSION).getBooleanFeature().setRolloverFalseIcon(((ImageIcon)GlobalPermissionsSupport.getRevokedRolloverIcon(featureMap.get(CHAT_PERMISSION).getBooleanFeature())).getImage());
        }
        if (group.equalsIgnoreCase("WhiteBoardPermission")) {
            if (permValue) {
                featureMap.get(WHITEBOARD_PERMISSION).getButton().setIcon(UIManager.getIcon("Whiteboard.permissionGrantedIcon"));
                featureMap.get(WHITEBOARD_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARD_PERMISSION_GRANTED_TOOLTIP));
            } else {
                featureMap.get(WHITEBOARD_PERMISSION).getButton().setIcon(UIManager.getIcon("Whiteboard.permissionRevokedIcon"));
                featureMap.get(WHITEBOARD_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.WHITEBOARD_PERMISSION_REVOKED_TOOLTIP));
            }
            featureMap.get(WHITEBOARD_PERMISSION).getBooleanFeature().setRolloverTrueIcon(((ImageIcon)GlobalPermissionsSupport.getGrantedRolloverIcon(featureMap.get(WHITEBOARD_PERMISSION).getBooleanFeature())).getImage());
            featureMap.get(WHITEBOARD_PERMISSION).getBooleanFeature().setRolloverFalseIcon(((ImageIcon)GlobalPermissionsSupport.getRevokedRolloverIcon(featureMap.get(WHITEBOARD_PERMISSION).getBooleanFeature())).getImage());
        }
        if (group.equalsIgnoreCase("AppSharePermission")) {
            if (permValue) {
                featureMap.get(APPSHARE_PERMISSION).getButton().setIcon(UIManager.getIcon("ScreenSharing.permissionGrantedIcon"));
                featureMap.get(APPSHARE_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SCREENSHARING_PERMISSION_GRANTED_TOOLTIP));
            } else {
                featureMap.get(APPSHARE_PERMISSION).getButton().setIcon(UIManager.getIcon("ScreenSharing.permissionRevokedIcon"));
                featureMap.get(APPSHARE_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.SCREENSHARING_PERMISSION_REVOKED_TOOLTIP));
            }
            featureMap.get(APPSHARE_PERMISSION).getBooleanFeature().setRolloverTrueIcon(((ImageIcon)GlobalPermissionsSupport.getGrantedRolloverIcon(featureMap.get(APPSHARE_PERMISSION).getBooleanFeature())).getImage());
            featureMap.get(APPSHARE_PERMISSION).getBooleanFeature().setRolloverFalseIcon(((ImageIcon)GlobalPermissionsSupport.getRevokedRolloverIcon(featureMap.get(APPSHARE_PERMISSION).getBooleanFeature())).getImage());
        }
        if (group.equalsIgnoreCase("WebTourPermission")) {
            if (permValue) {
                featureMap.get(WEBTOUR_PERMISSION).getButton().setIcon(UIManager.getIcon("WebTour.permissionGrantedIcon"));
                featureMap.get(WEBTOUR_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.WEBTOUR_PERMISSION_GRANTED_TOOLTIP));
            } else {
                featureMap.get(WEBTOUR_PERMISSION).getButton().setIcon(UIManager.getIcon("WebTour.permissionRevokedIcon"));
                featureMap.get(WEBTOUR_PERMISSION).getButton().setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.WEBTOUR_PERMISSION_REVOKED_TOOLTIP));
            }
            featureMap.get(WEBTOUR_PERMISSION).getBooleanFeature().setRolloverTrueIcon(((ImageIcon)GlobalPermissionsSupport.getGrantedRolloverIcon(featureMap.get(WEBTOUR_PERMISSION).getBooleanFeature())).getImage());
            featureMap.get(WEBTOUR_PERMISSION).getBooleanFeature().setRolloverFalseIcon(((ImageIcon)GlobalPermissionsSupport.getRevokedRolloverIcon(featureMap.get(WEBTOUR_PERMISSION).getBooleanFeature())).getImage());
        }
    }

    static {
        featureMap = new HashMap<String, BooleanFeatureAdapter>();
    }
}

