/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.location;

import com.elluminate.classroom.client.GeneralPrefsOwner;
import com.elluminate.classroom.swing.location.AudioAlert;
import com.elluminate.classroom.swing.location.AudioAlertClerk;
import com.elluminate.classroom.swing.location.StringsProperties;
import com.elluminate.gui.GuiUtils;
import com.elluminate.gui.component.AbstractPreferencesPanel;
import com.elluminate.gui.component.MultilineLabel;
import com.elluminate.gui.component.PreferencesPanelOwner;
import com.elluminate.gui.swing.CTable;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.accessibility.AccessibleContext;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AudioAlertsPrefsPanel
extends AbstractPreferencesPanel {
    private static final int COL_NAME = 0;
    private static final int COL_ENABLED = 1;
    private static final int COL_PREVIEW = 2;
    private static I18n i18n = I18n.create((Object)new Object(){});
    private Icon playIcon = UIManager.getIcon("AudioAlerts.playSound");
    private AlertTableModel tableModel = null;
    private CTable alertTable = null;
    private JScrollPane scroller;
    private AudioAlertClerk clerk = null;

    @Inject
    public AudioAlertsPrefsPanel(GeneralPrefsOwner owner, AudioAlertClerk clerk) {
        super((PreferencesPanelOwner)owner, i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_TITLE));
        this.clerk = clerk;
    }

    protected void createContent() {
        Component c;
        this.setLayout(new BorderLayout());
        DefaultTableColumnModel colModel = new DefaultTableColumnModel();
        TableColumn col = new TableColumn(0);
        col.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_NAMECOLUMN));
        col.setCellRenderer(new NameRenderer());
        colModel.addColumn(col);
        col = new TableColumn(1);
        col.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_ENABLEDCOLUMN));
        col.setCellRenderer(new EnabledRenderer());
        col.setMaxWidth(100);
        colModel.addColumn(col);
        col = new TableColumn(2);
        col.setHeaderValue(i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_PREVIEWCOLUMN));
        col.setMaxWidth(100);
        colModel.addColumn(col);
        this.alertTable = new CTable(this.getAlertTableModel(), colModel){

            public void updateUI() {
                super.updateUI();
                GuiUtils.removeKeyBinding((KeyStroke)KeyStroke.getKeyStroke(32, 0), (JComponent)((Object)this));
            }
        };
        PreviewEditor previewEditor = new PreviewEditor(this.playIcon);
        this.alertTable.setDefaultRenderer(AudioAlert.class, (TableCellRenderer)new PreviewRenderer(this.playIcon));
        this.alertTable.setDefaultEditor(AudioAlert.class, (TableCellEditor)previewEditor);
        this.alertTable.setColumnAlignment(1, 0);
        this.alertTable.setColumnAlignment(2, 0);
        this.alertTable.setPreferredScrollableViewportSize(new Dimension(1, 270));
        int rowHeight = this.alertTable.getRowHeight();
        TableCellEditor enabledEditor = this.alertTable.getDefaultEditor(Boolean.class);
        int enabledHeight = enabledEditor == null ? new JCheckBox().getPreferredSize().height : (enabledEditor instanceof JComponent ? ((JComponent)((Object)enabledEditor)).getPreferredSize().height : (enabledEditor instanceof Component ? ((Component)((Object)enabledEditor)).getHeight() : ((c = enabledEditor.getTableCellEditorComponent((JTable)this.alertTable, Boolean.TRUE, true, 0, 1)) == null ? new JCheckBox().getPreferredSize().height : (c instanceof JComponent ? ((JComponent)c).getPreferredSize().height : c.getHeight()))));
        rowHeight = Math.max(rowHeight, enabledHeight);
        rowHeight = Math.max(rowHeight, previewEditor.getPreferredRowHeight());
        this.alertTable.setRowHeight(rowHeight);
        this.scroller = new JScrollPane((Component)this.alertTable, 22, 31);
        String expoText = i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_EXPOSITORYTEXT);
        MultilineLabel exposition = new MultilineLabel(expoText);
        JPanel bottom = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.weightx = 1.0;
        gbc.insets.left = 0;
        bottom.add(Box.createHorizontalGlue(), gbc);
        JButton b = new JButton(i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_ALLBUTTON));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertTableModel m = AudioAlertsPrefsPanel.this.getAlertTableModel();
                Iterator itr = m.getInfoIterator();
                while (itr.hasNext()) {
                    AlertInfo info = (AlertInfo)itr.next();
                    info.enabled = true;
                }
                m.fireTableDataChanged();
                AudioAlertsPrefsPanel.this.setModified(true);
            }
        });
        gbc.weightx = 0.0;
        gbc.insets.left = 0;
        bottom.add((Component)b, gbc);
        b = new JButton(i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_STANDARDBUTTON));
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AlertTableModel m = AudioAlertsPrefsPanel.this.getAlertTableModel();
                Iterator itr = m.getInfoIterator();
                while (itr.hasNext()) {
                    AlertInfo info = (AlertInfo)itr.next();
                    info.enabled = info.alert.isLegacy();
                }
                m.fireTableDataChanged();
                AudioAlertsPrefsPanel.this.setModified(true);
            }
        });
        gbc.weightx = 0.0;
        gbc.insets.left = 6;
        bottom.add((Component)b, gbc);
        JPanel p = new JPanel(new BorderLayout(0, 6));
        this.add(p, "North");
        p.add((Component)exposition, "North");
        p.add((Component)this.scroller, "Center");
        p.add((Component)bottom, "South");
    }

    protected void populate(Preferences preferences) {
        AlertTableModel m = this.getAlertTableModel();
        Iterator itr = m.getInfoIterator();
        while (itr.hasNext()) {
            boolean enabled;
            AlertInfo info = (AlertInfo)itr.next();
            info.enabled = enabled = preferences.getBooleanSetting(info.alert.getEnabledKey(), info.alert.isDefaultEnabled());
        }
        m.fireTableDataChanged();
    }

    protected void apply(Preferences preferences) {
        AlertTableModel m = this.getAlertTableModel();
        Iterator itr = m.getInfoIterator();
        while (itr.hasNext()) {
            AlertInfo info = (AlertInfo)itr.next();
            preferences.setSetting(info.alert.getEnabledKey(), info.enabled);
        }
    }

    protected void reset(Preferences preferences) {
        AlertTableModel m = this.getAlertTableModel();
        Iterator itr = m.getInfoIterator();
        while (itr.hasNext()) {
            AlertInfo info = (AlertInfo)itr.next();
            preferences.setSetting(info.alert.getEnabledKey(), info.alert.isDefaultEnabled());
        }
    }

    private synchronized AlertTableModel getAlertTableModel() {
        if (this.tableModel == null) {
            this.tableModel = new AlertTableModel(this.clerk.getAlerts());
        }
        return this.tableModel;
    }

    private static class AlertInfo {
        AudioAlert alert = null;
        boolean enabled = false;

        private AlertInfo() {
        }
    }

    private class AlertTableModel
    extends AbstractTableModel {
        private ArrayList<AlertInfo> alertData;

        private AlertTableModel(Collection<AudioAlert> alerts) {
            this.alertData = new ArrayList(alerts.size());
            for (AudioAlert alert : alerts) {
                AlertInfo info = new AlertInfo();
                info.alert = alert;
                info.enabled = alert.isEnabled();
                this.alertData.add(info);
            }
        }

        @Override
        public int getRowCount() {
            return this.alertData.size();
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Boolean.class;
                }
                case 2: {
                    return AudioAlert.class;
                }
            }
            return Object.class;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            if (row < 0 || row >= this.alertData.size()) {
                return false;
            }
            AlertInfo info = this.alertData.get(row);
            switch (col) {
                case 0: {
                    return false;
                }
                case 1: {
                    return !info.alert.isMandatory();
                }
                case 2: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.alertData.size()) {
                return null;
            }
            AlertInfo info = this.alertData.get(row);
            switch (col) {
                case 0: {
                    return info.alert.getName();
                }
                case 1: {
                    return info.enabled ? Boolean.TRUE : Boolean.FALSE;
                }
                case 2: {
                    return info.alert;
                }
            }
            return "";
        }

        @Override
        public void setValueAt(Object val, int row, int col) {
            if (row < 0 || row >= this.alertData.size()) {
                return;
            }
            if (col != 1) {
                return;
            }
            AlertInfo info = this.alertData.get(row);
            info.enabled = (Boolean)val;
            AudioAlertsPrefsPanel.this.setModified(true);
        }

        private Iterator<AlertInfo> getInfoIterator() {
            return this.alertData.iterator();
        }
    }

    private static class EnabledRenderer
    extends JCheckBox
    implements TableCellRenderer {
        public EnabledRenderer() {
            this.setHorizontalAlignment(0);
            this.setBorderPainted(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            if (value instanceof Boolean) {
                this.setSelected((Boolean)value);
            } else {
                this.setSelected(false);
            }
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            if (focused) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            return this;
        }
    }

    private static class NameRenderer
    extends DefaultTableCellRenderer {
        private NameRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int column) {
            super.getTableCellRendererComponent(table, value, selected, focused, row, column);
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
            if (focused) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            return this;
        }
    }

    private static class PreviewEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JButton editorBtn;
        private AudioAlert alert;

        PreviewEditor(Icon icon) {
            this.editorBtn = new JButton(icon);
            this.editorBtn.setOpaque(false);
            this.editorBtn.setMargin(new Insets(0, 0, 0, 0));
            this.editorBtn.setContentAreaFilled(false);
            this.editorBtn.setFocusPainted(false);
            this.editorBtn.setFocusable(false);
            this.editorBtn.putClientProperty("JButton.buttonType", "toolbar");
            this.editorBtn.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            this.editorBtn.addActionListener(this);
        }

        int getPreferredRowHeight() {
            return this.editorBtn.getIcon().getIconHeight() + 4;
        }

        @Override
        public Object getCellEditorValue() {
            return this.alert;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int col) {
            this.alert = value instanceof AudioAlert ? (AudioAlert)value : null;
            return this.editorBtn;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            if (this.alert != null) {
                this.alert.previewCustomSound();
            }
        }
    }

    private class PreviewRenderer
    extends JButton
    implements TableCellRenderer {
        PreviewRenderer(Icon icon) {
            super(icon);
            this.setOpaque(false);
            this.setMargin(new Insets(0, 0, 0, 0));
            this.setContentAreaFilled(false);
            this.setFocusPainted(false);
            this.setFocusable(false);
            this.putClientProperty("JButton.buttonType", "toolbar");
            AccessibleContext ax = this.getAccessibleContext();
            ax.setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_PLAYBTNNAME));
            ax.setAccessibleDescription(i18n.getString((PropertiesEnum)StringsProperties.AUDIOALERTSPREFS_PLAYBTNTIP));
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean focused, int row, int col) {
            if (focused) {
                this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            } else {
                this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
            }
            return this;
        }
    }
}

