/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.debug;

import com.elluminate.classroom.swing.debug.ShadeUiDebugFlags;
import com.elluminate.util.log.LogSupport;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.border.Border;

public class FocusDebugHighlight {
    private Border previousBorder = null;

    public void registerGlobalFocusListener() {
        AWTEventListener focusEventListener = new AWTEventListener(){

            @Override
            public void eventDispatched(AWTEvent event) {
                if (event instanceof FocusEvent) {
                    FocusEvent evt = (FocusEvent)event;
                    if (ShadeUiDebugFlags.FOCUS_HIGHLIGHT.show()) {
                        FocusDebugHighlight.this.handleFocusHighlighting(evt);
                    }
                    if (ShadeUiDebugFlags.FOCUS_LOGGING.show()) {
                        FocusDebugHighlight.this.handleFocusLogging(evt);
                    }
                    if (ShadeUiDebugFlags.KEYBOARD_FOCUS_LOGGING.show()) {
                        FocusDebugHighlight.this.handleKeyboardFocusLogging(evt);
                    }
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(focusEventListener, 4L);
    }

    private void handleFocusHighlighting(FocusEvent evt) {
        Component comp;
        if (evt.getID() == 1004) {
            Component comp2 = evt.getComponent();
            if (comp2 instanceof JComponent) {
                this.previousBorder = ((JComponent)comp2).getBorder();
                ((JComponent)comp2).setBorder(BorderFactory.createLineBorder(Color.RED, 2));
            }
        } else if (evt.getID() == 1005 && (comp = evt.getComponent()) instanceof JComponent) {
            ((JComponent)comp).setBorder(this.previousBorder);
        }
    }

    private void handleFocusLogging(FocusEvent evt) {
        String focusType = evt.getID() == 1004 ? "GAINED" : "LOST";
        LogSupport.message((String)("FOCUS " + focusType + " [ Event: " + evt.toString() + "]"));
    }

    private void handleKeyboardFocusLogging(FocusEvent evt) {
        KeyboardFocusManager mgr = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        Component focusOwner = mgr.getFocusOwner();
        String focusOwnerStr = "(none)";
        if (focusOwner != null) {
            focusOwnerStr = focusOwner.toString();
        }
        Window focusActiveWindow = mgr.getActiveWindow();
        String focusActiveWindowStr = "(none)";
        if (focusActiveWindow != null) {
            focusActiveWindowStr = focusActiveWindow.toString();
        }
        Window focusedWindow = mgr.getFocusedWindow();
        String focusedWindowStr = "(none)";
        if (focusedWindow != null) {
            focusedWindowStr = focusedWindow.toString();
        }
        Component permanentFocusOwner = mgr.getPermanentFocusOwner();
        String permanentFocusOwnerStr = "(none)";
        if (permanentFocusOwner != null) {
            permanentFocusOwnerStr = permanentFocusOwner.toString();
        }
        LogSupport.message((String)("KEYBOARD FOCUS:  FocusOwner[" + focusOwnerStr + "]\n" + "                 ActiveWindow[" + focusActiveWindowStr + "]\n" + "                 FocusedWindow[" + focusedWindowStr + "]\n" + "                 PermanentFocusOwner[" + permanentFocusOwnerStr + "]"));
    }
}

