/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.SBadge;
import com.elluminate.classroom.swing.components.SToggleButton;
import com.elluminate.classroom.swing.components.skin.delegate.DelegateButtonUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ShadeToggleButtonUI
extends DelegateButtonUI {
    private static final int BADGE_SIZE = 13;
    private SToggleButton tb;
    private SBadge badge;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("badgeText")) {
                if (ShadeToggleButtonUI.this.badge == null) {
                    ShadeToggleButtonUI.this.badge = new SBadge();
                }
                ShadeToggleButtonUI.this.tb.repaint();
            } else if (prop.equals("badgeFont") || prop.equals("badgeColor")) {
                if (ShadeToggleButtonUI.this.badge != null) {
                    ShadeToggleButtonUI.this.tb.repaint();
                }
            } else if (prop.equals("JButton.buttonType")) {
                ShadeToggleButtonUI.this.updateMacForeground();
            }
        }
    };
    private ItemListener itemListener;
    private Color normalMacForeground;

    public static ComponentUI createUI(JComponent c) {
        return new ShadeToggleButtonUI();
    }

    public ShadeToggleButtonUI() {
        super("ToggleButtonUI");
    }

    @Override
    public void installUI(JComponent c) {
        super.installUI(c);
        this.tb = (SToggleButton)c;
        this.tb.setBadgeFont(UIManager.getFont("Badge.font"));
        this.tb.setBadgeColor(UIManager.getColor("Badge.color"));
        this.tb.addPropertyChangeListener("badgeText", this.propertyListener);
        this.tb.addPropertyChangeListener("badgeFont", this.propertyListener);
        this.tb.addPropertyChangeListener("badgeColor", this.propertyListener);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.itemListener = new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    ShadeToggleButtonUI.this.updateMacForeground();
                }
            };
            this.tb.addItemListener(this.itemListener);
            this.tb.addPropertyChangeListener("JButton.buttonType", this.propertyListener);
        }
    }

    @Override
    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.tb.removePropertyChangeListener("badgeText", this.propertyListener);
        this.tb.removePropertyChangeListener("badgeFont", this.propertyListener);
        this.tb.removePropertyChangeListener("badgeColor", this.propertyListener);
        if (System.getProperty("os.name").equals("Mac OS X")) {
            this.tb.removeItemListener(this.itemListener);
            this.tb.removePropertyChangeListener("JButton.buttonType", this.propertyListener);
        }
    }

    @Override
    public void update(Graphics g, JComponent c) {
        super.update(g, c);
        String txt = this.tb.getBadgeText();
        if (txt != null && txt.length() != 0 && this.badge != null) {
            this.badge.setText(txt);
            this.badge.setFont(this.tb.getBadgeFont());
            this.badge.setColor(this.tb.getBadgeColor());
            Dimension s = this.tb.getSize();
            int x = s.width - this.badge.getIconWidth();
            int y = s.height - this.badge.getIconHeight();
            this.badge.paintIcon(this.tb, g, x, y);
        }
    }

    private void updateMacForeground() {
        Object buttonType = this.tb.getClientProperty("JButton.buttonType");
        if (buttonType != null && buttonType.equals("textured")) {
            if (this.tb.isSelected()) {
                if (this.normalMacForeground == null) {
                    this.normalMacForeground = this.tb.getForeground();
                }
                this.tb.setForeground(Color.WHITE);
            } else {
                this.tb.setForeground(this.normalMacForeground);
            }
        }
    }
}

