/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components.skin.shade;

import com.elluminate.classroom.swing.components.STickedPanel;
import com.elluminate.classroom.swing.components.skin.STickedPanelUI;
import com.elluminate.classroom.swing.components.skin.shade.Shade;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;

public class ShadeTickedPanelUI
extends STickedPanelUI {
    private STickedPanel p;
    private PropertyChangeListener propertyListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String prop = e.getPropertyName();
            if (prop.equals("margin")) {
                Insets m = (Insets)e.getNewValue();
                ShadeTickedPanelUI.this.p.setBorder(BorderFactory.createEmptyBorder(m.top, m.left, m.bottom, m.right));
                ShadeTickedPanelUI.this.p.revalidate();
                ShadeTickedPanelUI.this.p.repaint();
            } else if (prop.equals("related")) {
                ShadeTickedPanelUI.this.p.repaint();
            } else if (prop.equals("background") || prop.equals("backgroundFlat")) {
                ShadeTickedPanelUI.this.p.repaint();
            }
        }
    };

    public static ComponentUI createUI(JComponent c) {
        return new ShadeTickedPanelUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.p = (STickedPanel)c;
        this.p.setLayout(new BorderLayout());
        this.p.setBackground(UIManager.getColor("TickedPanel.background"));
        Insets m = this.p.getMargin();
        this.p.setBorder(BorderFactory.createEmptyBorder(m.top, m.left, m.bottom, m.right));
        this.p.addPropertyChangeListener("margin", this.propertyListener);
        this.p.addPropertyChangeListener("related", this.propertyListener);
        this.p.addPropertyChangeListener("background", this.propertyListener);
        this.p.addPropertyChangeListener("backgroundFlat", this.propertyListener);
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.p.removePropertyChangeListener("margin", this.propertyListener);
        this.p.removePropertyChangeListener("related", this.propertyListener);
        this.p.removePropertyChangeListener("background", this.propertyListener);
        this.p.removePropertyChangeListener("backgroundFlat", this.propertyListener);
    }

    @Override
    public void paint(Graphics g, JComponent component) {
        Graphics2D g2 = (Graphics2D)g;
        Object oldHint = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Dimension s = this.p.getSize();
        Insets ins = this.p.getInsets();
        g.translate(-1, -1);
        s.width += 2;
        s.height += 2;
        int[] xs = null;
        int[] ys = null;
        Component r = this.p.getRelated();
        if (r != null) {
            int tickSize;
            Rectangle rb = SwingUtilities.convertRectangle(r.getParent(), r.getBounds(), this.p);
            int cx = rb.x + (rb.width + 1) / 2;
            if (cx >= 0 && cx <= s.width - 1 && (tickSize = rb.y + rb.height <= 0 ? ins.top - 1 : ins.bottom - 1) > 0) {
                xs = new int[]{ins.left, cx - tickSize, cx, cx + tickSize, s.width - 1 - ins.right, s.width - 1 - ins.right, ins.left};
                ys = rb.y + rb.height <= 0 ? new int[]{tickSize + 1, tickSize + 1, 1, tickSize + 1, tickSize + 1, s.height - 1 - ins.bottom, s.height - 1 - ins.bottom} : new int[]{s.height - tickSize - 2, s.height - tickSize - 2, s.height - 2, s.height - tickSize - 2, s.height - tickSize - 2, ins.top, ins.top};
            }
        }
        if (xs != null && ys != null) {
            Color c = this.p.getBackground();
            if (this.p.isBackgroundFlat()) {
                g.setColor(c);
            } else {
                ((Graphics2D)g).setPaint(new GradientPaint(0.0f, 0.0f, Shade.darkenColor(c, 0.1), 0.0f, s.height, Shade.lightenColor(c, 1.0)));
            }
            g.fillPolygon(xs, ys, xs.length);
            g.setColor(new Color(0, 0, 0, 64));
            g.drawPolygon(xs, ys, xs.length);
        }
        g.translate(1, 1);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldHint);
    }
}

