/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.SSideBarTabBar;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class SSideBarTab
extends JComponent
implements Accessible {
    private static final String uiClassID = "SSideBarTabUI";
    private Object id;
    private String text;
    private Icon icon;
    private boolean closeable;
    private JLabel iconLabel;
    private JLabel textLabel;
    private boolean hovered;
    private boolean armed;

    public SSideBarTab(Object id, String text, Icon icon) {
        this.id = id;
        this.text = text;
        this.icon = icon;
        this.setLayout(new BorderLayout(4, 0));
        this.iconLabel = new JLabel(icon);
        this.add((Component)this.iconLabel, "West");
        this.textLabel = new JLabel(text);
        this.add((Component)this.textLabel, "Center");
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!SSideBarTab.this.hovered) {
                    if (SSideBarTab.this.closeable && SSideBarTab.this.isHoveringIcon(e.getPoint())) {
                        SSideBarTab.this.hovered = true;
                        SSideBarTab.this.iconLabel.setIcon(UIManager.getIcon("SideBar.tabCloseIcon"));
                    }
                } else if (!SSideBarTab.this.isHoveringIcon(e.getPoint())) {
                    SSideBarTab.this.hovered = false;
                    SSideBarTab.this.iconLabel.setIcon(SSideBarTab.this.icon);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (SSideBarTab.this.closeable && SSideBarTab.this.isHoveringIcon(e.getPoint())) {
                    SSideBarTab.this.armed = true;
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                Container p;
                if (SSideBarTab.this.armed && (p = SSideBarTab.this.getParent()) instanceof SSideBarTabBar) {
                    SSideBarTabBar tb = (SSideBarTabBar)p;
                    tb.removeTab(SSideBarTab.this.getID());
                }
                SSideBarTab.this.armed = false;
            }
        });
        this.updateUI();
    }

    private boolean isHoveringIcon(Point location) {
        return this.iconLabel.getBounds().contains(location);
    }

    public Object getID() {
        return this.id;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
        this.textLabel.setText(text);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        if (!this.hovered) {
            this.iconLabel.setIcon(icon);
        }
    }

    public boolean isCloseable() {
        return this.closeable;
    }

    public void setCloseable(boolean closeable) {
        this.closeable = closeable;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSSideBarTab();
        }
        return this.accessibleContext;
    }

    private class AccessibleSSideBarTab
    extends JComponent.AccessibleJComponent {
        private AccessibleSSideBarTab() {
            super(SSideBarTab.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }
    }
}

