/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.DockingAdapter;
import com.elluminate.classroom.swing.components.SSideBarTabBar;
import com.elluminate.classroom.swing.components.SSideBarTitleBar;
import com.elluminate.classroom.swing.components.SizingAdapter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JWindow;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class SSideBarPanel
extends JComponent
implements Accessible {
    private static final String uiClassID = "SSideBarPanelUI";
    protected SSideBarTitleBar titleBar;
    private JPanel contentPane;
    private SSideBarTabBar tabBar;
    private DockingAdapter docker;
    private boolean expanded = true;

    public SSideBarPanel() {
        this(null);
    }

    public SSideBarPanel(String title) {
        this.setLayout(new BorderLayout());
        this.titleBar = new SSideBarTitleBar(this, title);
        this.setupOptionsMenuKeyBinding();
        this.add((Component)this.titleBar, "North");
        this.contentPane = new JPanel(new BorderLayout());
        this.contentPane.setBorder(BorderFactory.createEmptyBorder(0, 5, 9, 5));
        this.contentPane.setOpaque(false);
        this.add((Component)this.contentPane, "Center");
        this.docker = new DockingAdapter(this, UndockedWindow.class);
        this.docker.addPropertyChangeListener("docked", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                boolean old = (Boolean)e.getOldValue();
                boolean docked = (Boolean)e.getNewValue();
                SSideBarPanel.this.firePropertyChange("docked", old, docked);
            }
        });
        this.addMouseListener(this.docker);
        this.addMouseMotionListener(this.docker);
        SizingAdapter resizer = new SizingAdapter();
        this.addMouseListener(resizer);
        this.addMouseMotionListener(resizer);
        this.updateUI();
    }

    private void setupOptionsMenuKeyBinding() {
        KeyStroke optionsKeystroke = this.getOptionsKeystroke();
        String actionName = "open.options.menu." + this.hashCode();
        this.getInputMap(1).put(optionsKeystroke, actionName);
        this.getActionMap().put(actionName, new AbstractAction(actionName){

            @Override
            public void actionPerformed(ActionEvent e) {
                SSideBarPanel.this.titleBar.getOptionsButton().doClick();
            }
        });
    }

    private KeyStroke getOptionsKeystroke() {
        int mask = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        return KeyStroke.getKeyStroke(79, mask | 0x40);
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public String getTitle() {
        return this.titleBar.getTitle();
    }

    public void setTitle(String title) {
        this.titleBar.setTitle(title);
    }

    public void addTitleBarItem(JComponent item) {
        if (item instanceof JLabel) {
            this.titleBar.addLabel((JLabel)item);
        } else if (item instanceof AbstractButton) {
            this.titleBar.addButton((AbstractButton)item);
        }
    }

    public void removeTitleBarItem(JComponent item) {
        if (item instanceof JLabel) {
            this.titleBar.removeLabel((JLabel)item);
        } else if (item instanceof AbstractButton) {
            this.titleBar.removeButton((AbstractButton)item);
        }
    }

    protected void removeExpandButton() {
        this.titleBar.removeExpandButton();
    }

    protected void addExpandButton() {
        this.titleBar.addExpandButton();
    }

    public boolean isExpanded() {
        return this.expanded;
    }

    public void setExpanded(boolean expanded) {
        Window w;
        boolean old = this.expanded;
        this.expanded = expanded;
        this.firePropertyChange("expanded", old, expanded);
        this.setContentVisible(expanded);
        this.revalidate();
        if (!this.docker.isDocked() && (w = SwingUtilities.getWindowAncestor(this)) != null) {
            int h = -1;
            if (expanded) {
                Object v = this.getClientProperty("weightedHeight");
                if (v instanceof Integer) {
                    h = (Integer)v;
                } else {
                    h = this.getMinimumSize().height;
                    if (h + 100 <= this.getMaximumSize().height) {
                        h += 100;
                    }
                }
            } else {
                this.putClientProperty("weightedHeight", this.getHeight());
                h = this.getPreferredSize().height;
            }
            if (h != -1) {
                Insets ins = w.getInsets();
                Dimension s = w.getSize();
                w.setSize(s.width, h + ins.top + ins.bottom);
            }
        }
    }

    @Override
    public Dimension getMaximumSize() {
        if (this.expanded) {
            return super.getMaximumSize();
        }
        return this.getPreferredSize();
    }

    public Container getContentPane() {
        return this.contentPane;
    }

    protected void setContentVisible(boolean contentVisible) {
        this.contentPane.setVisible(contentVisible);
    }

    public void setTabBar(SSideBarTabBar tabBar) {
        this.tabBar = tabBar;
        this.add((Component)tabBar, "South");
    }

    public SSideBarTabBar getTabBar() {
        return this.tabBar;
    }

    public JPopupMenu getOptionsMenu() {
        return this.titleBar.getOptionsButton().getMenu();
    }

    public boolean isDocked() {
        return this.docker.isDocked();
    }

    public void setDocked(boolean docked) {
        this.docker.setDocked(docked);
    }

    public void setUndockedBounds(Rectangle undockedBounds) {
        if (undockedBounds != null) {
            this.docker.setUndockedLocation(undockedBounds.getLocation());
            this.docker.setUndockedSize(undockedBounds.getSize());
        } else {
            this.docker.setUndockedLocation(null);
            this.docker.setUndockedSize(null);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSSideBarPanel();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSSideBarPanel
    extends JComponent.AccessibleJComponent {
        protected AccessibleSSideBarPanel() {
            super(SSideBarPanel.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }

    private static class UndockedWindow
    extends JWindow {
        public UndockedWindow(Frame owner) {
            super(owner);
        }

        @Override
        public boolean getFocusableWindowState() {
            Object bypass = this.getRootPane().getClientProperty("DockingAdapter.bypassFocusableWindowState");
            if (bypass instanceof Boolean) {
                return (Boolean)bypass;
            }
            return super.getFocusableWindowState();
        }
    }
}

