/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.classroom.swing.components.SSideBarPanel;
import com.elluminate.classroom.swing.components.WeightLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class SSideBar
extends JComponent
implements Accessible {
    public static final int MIN_WIDTH = 250;
    private static final String uiClassID = "SSideBarUI";

    public SSideBar() {
        this.setLayout(new WeightLayout());
        this.setMinimumSize(new Dimension(250, 0));
        this.updateUI();
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public SSideBarPanel[] getPanels() {
        return (SSideBarPanel[])this.getComponents();
    }

    SSideBarPanel[] getResizablePanels(SSideBarPanel basePanel) {
        SSideBarPanel[] panels = new SSideBarPanel[2];
        boolean foundBase = false;
        for (Component c : this.getComponents()) {
            if (!(c instanceof SSideBarPanel) || !c.isVisible()) continue;
            SSideBarPanel p = (SSideBarPanel)c;
            int h = p.getHeight();
            int minh = p.getMinimumSize().height;
            int maxh = p.getMaximumSize().height;
            if (!foundBase) {
                if (p == basePanel) {
                    if (minh < h || h < maxh) {
                        panels[1] = p;
                        break;
                    }
                    foundBase = true;
                    continue;
                }
                if (minh >= h && h >= maxh) continue;
                panels[0] = p;
                continue;
            }
            if (minh >= h && h >= maxh) continue;
            panels[1] = p;
            break;
        }
        if (panels[0] != null && panels[1] != null) {
            return panels;
        }
        return null;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleSSideBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleSSideBar
    extends JComponent.AccessibleJComponent {
        protected AccessibleSSideBar() {
            super(SSideBar.this);
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PANEL;
        }
    }
}

