/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import com.elluminate.gui.TargetLayoutSize;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JComponent;
import javax.swing.SwingConstants;
import javax.swing.UIManager;

public class SPalette
extends JComponent
implements SwingConstants {
    public static final int AUTOMATIC = -1;
    private static final String uiClassID = "SPaletteUI";
    private Component content;
    private int orientation;
    private int paletteWidth = -1;
    private Point handle;

    public SPalette(Component component) {
        this(component, -1);
    }

    public SPalette(Component component, int orientation) {
        if (orientation == -1) {
            orientation = SPalette.guessOrientation(component);
        }
        this.checkOrientation(orientation);
        this.orientation = orientation;
        this.setLayout(new BorderLayout());
        this.add(component, "Center");
        this.content = component;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                SPalette.this.handle = e.getPoint();
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                Point pt = e.getPoint();
                int x = SPalette.this.getX() + pt.x - ((SPalette)SPalette.this).handle.x;
                int y = SPalette.this.getY() + pt.y - ((SPalette)SPalette.this).handle.y;
                Dimension s = SPalette.this.getSize();
                Container p = SPalette.this.getParent();
                Dimension ps = p.getSize();
                Insets pins = p.getInsets();
                if (x + s.width > ps.width - pins.right) {
                    x = ps.width - pins.right - s.width;
                }
                if (x < pins.left) {
                    x = pins.left;
                }
                if (y + s.height > ps.height - pins.bottom) {
                    y = ps.height - pins.bottom - s.height;
                }
                if (y < pins.top) {
                    y = pins.top;
                }
                SPalette.this.setLocation(x, y);
            }
        });
        this.updateUI();
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        this.checkOrientation(orientation);
        int old = this.orientation;
        this.orientation = orientation;
        this.firePropertyChange("orientation", old, orientation);
    }

    private void checkOrientation(int orientation) {
        switch (orientation) {
            case 0: 
            case 1: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Orientation must be one of: VERTICAL, HORIZONTAL");
            }
        }
    }

    private static int guessOrientation(Component component) {
        Dimension ps = component.getPreferredSize();
        return ps.height > ps.width ? 1 : 0;
    }

    public void setPaletteWidth(int paletteWidth) {
        this.paletteWidth = paletteWidth;
    }

    public Dimension getTargetLayoutSize() {
        Insets ins = this.getInsets();
        Dimension dim = null;
        if (this.content != null) {
            if (this.content instanceof TargetLayoutSize) {
                dim = ((TargetLayoutSize)this.content).getTargetLayoutSize();
            }
            if (dim == null) {
                dim = this.content.getPreferredSize();
            }
        }
        dim = dim == null ? new Dimension(0, 0) : new Dimension(dim);
        dim.width += ins.left + ins.right;
        dim.height += ins.top + ins.bottom;
        return dim;
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension ps = super.getPreferredSize();
        if (this.paletteWidth != -1) {
            ps = new Dimension(ps);
            switch (this.orientation) {
                case 1: {
                    ps.width = this.paletteWidth;
                    break;
                }
                case 0: {
                    ps.height = this.paletteWidth;
                }
            }
        }
        return ps;
    }

    @Override
    public void updateUI() {
        this.setUI(UIManager.getUI(this));
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    @Override
    protected void addImpl(Component component, Object constraints, int index) {
        super.addImpl(component, "Center", index);
    }
}

