/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonModel;
import javax.swing.JCheckBox;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class SCheckBox
extends JCheckBox {
    private static final String uiClassID = "SCheckBoxUI";
    private String badgeText;
    private Font badgeFont;
    private Color badgeColor;
    private boolean workedAroundNullIcon;
    private ItemListener selectedListener;

    public SCheckBox() {
        this((String)null, true);
    }

    public SCheckBox(String text) {
        this(text, true);
    }

    public SCheckBox(String text, boolean checked) {
        super(text, checked);
    }

    @Override
    public void setModel(ButtonModel model) {
        if (this.model != null && this.selectedListener != null) {
            this.model.removeItemListener(this.selectedListener);
        }
        super.setModel(model);
        if (model != null) {
            if (this.selectedListener == null) {
                this.selectedListener = this.createSelectedListener();
            }
            model.addItemListener(this.selectedListener);
        }
    }

    private ItemListener createSelectedListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SCheckBox.this.updateNullIconWorkaround();
            }
        };
    }

    private void updateNullIconWorkaround() {
        if (this.isSelected()) {
            if (this.getIcon() == null && this.getSelectedIcon() != null) {
                this.workedAroundNullIcon = true;
                this.setIcon(this.getSelectedIcon());
            }
        } else if (this.workedAroundNullIcon) {
            this.workedAroundNullIcon = false;
            this.setIcon(null);
        }
    }

    @Override
    public void setBorder(Border border) {
        Border b = this.getBorder();
        if (b == null || !(border instanceof UIResource) || b instanceof UIResource) {
            super.setBorder(border);
        }
    }

    public String getBadgeText() {
        return this.badgeText;
    }

    public void setBadgeText(String badgeText) {
        String old = this.badgeText;
        this.badgeText = badgeText;
        this.firePropertyChange("badgeText", old, badgeText);
    }

    public Font getBadgeFont() {
        return this.badgeFont;
    }

    public void setBadgeFont(Font badgeFont) {
        Font old = this.badgeFont;
        this.badgeFont = badgeFont;
        this.firePropertyChange("badgeFont", old, badgeFont);
    }

    public Color getBadgeColor() {
        return this.badgeColor;
    }

    public void setBadgeColor(Color badgeColor) {
        Color old = this.badgeColor;
        this.badgeColor = badgeColor;
        this.firePropertyChange("badgeColor", old, badgeColor);
    }
}

