/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import java.awt.Color;
import java.awt.Font;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class SButton
extends JButton {
    private static final String uiClassID = "SButtonUI";
    private String badgeText;
    private Font badgeFont;
    private Color badgeColor;
    private Icon[] resources;
    private Icon[] selectedResources;
    private Icon[] rolloverResources;
    private boolean workedAroundNullIcon;
    private ItemListener selectedListener;

    public SButton() {
        this(null, null);
    }

    public SButton(Icon icon) {
        this(null, icon);
    }

    public SButton(String text) {
        this(text, null);
    }

    public SButton(String text, Icon icon) {
        super(text, icon);
    }

    @Override
    public void setModel(ButtonModel model) {
        if (this.model != null && this.selectedListener != null) {
            this.model.removeItemListener(this.selectedListener);
        }
        super.setModel(model);
        if (model != null) {
            if (this.selectedListener == null) {
                this.selectedListener = this.createSelectedListener();
            }
            model.addItemListener(this.selectedListener);
        }
    }

    private ItemListener createSelectedListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                SButton.this.updateNullIconWorkaround();
            }
        };
    }

    @Override
    public void setSelectedIcon(Icon selectedIcon) {
        super.setSelectedIcon(selectedIcon);
        if (this.isSelected()) {
            this.updateNullIconWorkaround();
        }
    }

    private void updateNullIconWorkaround() {
        if (this.isSelected()) {
            if (this.getIcon() == null && this.getSelectedIcon() != null) {
                this.workedAroundNullIcon = true;
                this.setIcon(this.getSelectedIcon());
            }
        } else if (this.workedAroundNullIcon) {
            this.workedAroundNullIcon = false;
            this.setIcon(null);
        }
    }

    @Override
    public void setBorder(Border border) {
        Border b = this.getBorder();
        if (b == null || !(border instanceof UIResource) || b instanceof UIResource) {
            super.setBorder(border);
        }
    }

    public String getBadgeText() {
        return this.badgeText;
    }

    public void setBadgeText(String badgeText) {
        String old = this.badgeText;
        this.badgeText = badgeText;
        this.firePropertyChange("badgeText", old, badgeText);
    }

    public Font getBadgeFont() {
        return this.badgeFont;
    }

    public void setBadgeFont(Font badgeFont) {
        Font old = this.badgeFont;
        this.badgeFont = badgeFont;
        this.firePropertyChange("badgeFont", old, badgeFont);
    }

    public Color getBadgeColor() {
        return this.badgeColor;
    }

    public void setBadgeColor(Color badgeColor) {
        Color old = this.badgeColor;
        this.badgeColor = badgeColor;
        this.firePropertyChange("badgeColor", old, badgeColor);
    }

    public Icon[] getResources() {
        return this.resources;
    }

    public void setResources(Icon[] resources) {
        if (resources != null && resources.length != 3) {
            throw new IllegalArgumentException("resources must be an array of 3 or null");
        }
        Icon[] old = this.resources;
        this.resources = null;
        if (resources != null) {
            this.resources = new Icon[3];
            System.arraycopy(resources, 0, this.resources, 0, 3);
        }
        this.firePropertyChange("resources", old, this.resources);
    }

    public Icon[] getSelectedResources() {
        return this.selectedResources;
    }

    public void setSelectedResources(Icon[] selectedResources) {
        if (selectedResources != null && selectedResources.length != 3) {
            throw new IllegalArgumentException("resources must be an array of 3 or null");
        }
        Icon[] old = this.selectedResources;
        this.selectedResources = null;
        if (selectedResources != null) {
            this.selectedResources = new Icon[3];
            System.arraycopy(selectedResources, 0, this.selectedResources, 0, 3);
        }
        this.firePropertyChange("selectedResources", old, this.selectedResources);
    }

    public Icon[] getRolloverResources() {
        return this.rolloverResources;
    }

    public void setRolloverResources(Icon[] rolloverResources) {
        if (rolloverResources != null && rolloverResources.length != 3) {
            throw new IllegalArgumentException("resources must be an array of 3 or null");
        }
        Icon[] old = this.rolloverResources;
        this.rolloverResources = null;
        if (rolloverResources != null) {
            this.rolloverResources = new Icon[3];
            System.arraycopy(rolloverResources, 0, this.rolloverResources, 0, 3);
        }
        this.firePropertyChange("rolloverResources", old, this.rolloverResources);
        this.setRolloverEnabled(rolloverResources != null);
        this.repaint();
    }

    @Override
    public String getUIClassID() {
        if (this.getClientProperty("Delegate.bypassGetUIClassID") != null) {
            return super.getUIClassID();
        }
        return uiClassID;
    }
}

