/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.components;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.HashMap;
import javax.swing.SwingConstants;

public class OverflowLayout
implements LayoutManager,
SwingConstants {
    private Component overflowComponent;
    private int overflowVerticalAlignment = 0;
    private boolean proportionalLayout = true;
    private int overflowPadding;

    public OverflowLayout(Component overflowComponent) {
        this.overflowComponent = overflowComponent;
    }

    public boolean isProportionalLayout() {
        return this.proportionalLayout;
    }

    public void setProportionalLayout(boolean proportionalLayout) {
        this.proportionalLayout = proportionalLayout;
    }

    public int getOverflowVerticalAlignment() {
        return this.overflowVerticalAlignment;
    }

    public void setOverflowVerticalAlignment(int overflowVerticalAlignment) {
        this.overflowVerticalAlignment = overflowVerticalAlignment;
    }

    public int getOverflowPadding() {
        return this.overflowPadding;
    }

    public void setOverflowPadding(int overflowPadding) {
        this.overflowPadding = overflowPadding;
    }

    @Override
    public void addLayoutComponent(String name, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Dimension ps = new Dimension();
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component c = container.getComponent(i);
            if (c == this.overflowComponent || !c.isVisible()) continue;
            Dimension s = c.getPreferredSize();
            ps.width += s.width;
            ps.height = Math.max(s.height, ps.height);
        }
        Insets ins = container.getInsets();
        ps.width += ins.left + ins.right;
        ps.height += ins.top + ins.bottom;
        return ps;
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    @Override
    public void layoutContainer(Container container) {
        Component[] cs;
        Dimension s = container.getSize();
        Insets ins = container.getInsets();
        int availableWidth = s.width - ins.left - ins.right - this.overflowPadding;
        int w = 0;
        HashMap<Component, Integer> widths = new HashMap<Component, Integer>();
        for (Component c : cs = container.getComponents()) {
            if (c == this.overflowComponent) continue;
            int maxw = c.getMaximumSize().width;
            w += maxw;
            widths.put(c, maxw);
        }
        boolean overflowing = false;
        if (w > availableWidth && this.proportionalLayout) {
            int overflowWidth = w - availableWidth;
            int flexibleWidth = 0;
            for (Component c : cs) {
                if (c == this.overflowComponent) continue;
                flexibleWidth += (Integer)widths.get(c) - c.getMinimumSize().width;
            }
            if (flexibleWidth >= overflowWidth) {
                double proportion = (double)overflowWidth / (double)flexibleWidth;
                for (Component c : cs) {
                    if (c == this.overflowComponent) continue;
                    int minw = c.getMinimumSize().width;
                    int maxw = (Integer)widths.get(c);
                    widths.put(c, maxw - (int)((double)(maxw - minw) * proportion));
                }
            } else {
                overflowing = true;
                availableWidth -= this.overflowComponent.getPreferredSize().width;
                boolean overflowReached = false;
                w = 0;
                Component[] arr$ = cs;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Component c = arr$[i$];
                    if (c == this.overflowComponent) continue;
                    int minw = c.getMinimumSize().width;
                    if (!overflowReached && w + minw > availableWidth) {
                        overflowReached = true;
                    }
                    if (overflowReached) {
                        minw = 0;
                    } else {
                        w += minw;
                    }
                    widths.put(c, minw);
                }
            }
        }
        int x = ins.left;
        int y = ins.top;
        int h = s.height - ins.top - ins.bottom;
        for (Component c : cs) {
            if (c == this.overflowComponent) continue;
            int pw = (Integer)widths.get(c);
            if (pw > 0) {
                c.setBounds(x, y, pw, h);
                x += pw;
                continue;
            }
            c.setBounds(0, s.height + 100, 0, 0);
        }
        Dimension ps = this.overflowComponent.getPreferredSize();
        h = Math.min(ps.height, s.height - ins.top - ins.bottom);
        x = s.width - ins.right - ps.width;
        switch (this.overflowVerticalAlignment) {
            case 1: {
                y = ins.top;
                break;
            }
            case 3: {
                y = s.height - ins.bottom - h;
                break;
            }
            default: {
                y = ins.top + (s.height - ins.top - ins.bottom - h) / 2;
            }
        }
        this.overflowComponent.setBounds(x, y, ps.width, h);
        this.overflowComponent.setVisible(overflowing);
    }
}

