/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.chat;

import com.elluminate.classroom.swing.chat.StringsProperties;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.FileSaveDialog;
import com.elluminate.gui.component.FileSaveDialogFactory;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.io.IOUtilities;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Component;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

@Singleton
public class SaveChatSupport {
    private static final String[] extensions = new String[]{"txt"};
    private Provider<Frame> frameProvider;
    private I18n i18n;
    private FileSaveDialogFactory fileSaveDialogFactory;
    private DialogParentProvider parentProvider;

    @Inject
    public void initFrameProvider(Provider<Frame> frameProvider) {
        this.frameProvider = frameProvider;
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
    }

    @Inject
    public void initFileSaveDialogFactory(FileSaveDialogFactory fileSaveDialogFactory) {
        this.fileSaveDialogFactory = fileSaveDialogFactory;
    }

    @Inject
    public void initParentProvider(DialogParentProvider parentProvider) {
        this.parentProvider = parentProvider;
    }

    public void save(HTMLDocument document) {
        File fileToSave = null;
        boolean saved = false;
        ChatFileFilter chatFilter = new ChatFileFilter();
        FileSaveDialog chooser = this.fileSaveDialogFactory.makeFileSaveDialog(fileToSave);
        int which = chooser.showSaveDialog((Component)this.parentProvider.getDialogParent());
        if (which != 0) {
            return;
        }
        chooser.removeChoosableFileFilter(chooser.getAcceptAllFileFilter());
        chooser.setFileFilter((FileFilter)chatFilter);
        chooser.setRequiredSuffix((FileFilter)chatFilter, "txt");
        while (!saved) {
            if (fileToSave != null) {
                chooser.setCurrentDirectory(fileToSave);
                if (fileToSave.isFile()) {
                    chooser.setSelectedFile(fileToSave);
                    chooser.ensureFileIsVisible(fileToSave);
                }
            } else {
                chooser.setCurrentDirectory(Platform.getDefaultDir());
            }
            chooser.setDialogTitle(this.i18n.getString((PropertiesEnum)StringsProperties.SAVE_CHAT));
            if (chooser.showSaveDialog((Component)this.frameProvider.get()) == 0) {
                fileToSave = chooser.getSelectedFile();
                if (fileToSave == null) {
                    return;
                }
                if (fileToSave.isDirectory()) {
                    this.showSaveToDirError(fileToSave);
                    continue;
                }
                try {
                    saved = SaveChatSupport.saveToStream(IOUtilities.generateUTF8WriterFromFile((File)fileToSave), document);
                    continue;
                }
                catch (Exception e) {
                    if (this.showSaveErrorRetry(fileToSave, e)) continue;
                    return;
                }
            }
            return;
        }
    }

    public boolean showSaveErrorRetry(File dir, Exception e) {
        return ModalDialog.showConfirmDialog((Component)((Component)this.frameProvider.get()), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_SAVEERROR, new Object[]{dir.getName(), e.toString()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_SAVEERROR_TITLE), (int)0, (int)0) == 0;
    }

    public void showSaveToDirError(File dir) {
        ModalDialog.showMessageDialog((Component)((Component)this.frameProvider.get()), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_SAVETODIRERROR, new Object[]{dir.getName()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CHAT_SAVEERROR_TITLE), (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveToStream(OutputStreamWriter writer, HTMLDocument doc) {
        PrintWriter out = new PrintWriter(new BufferedWriter(writer));
        try {
            String[] lines;
            for (String line : lines = SaveChatSupport.extractText(doc).split("\n")) {
                out.println(line);
            }
            out.flush();
        }
        catch (Exception ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (out != null) {
                out.close();
                out = null;
            }
        }
        return true;
    }

    private static String extractText(HTMLDocument doc) throws BadLocationException {
        Element e;
        ElementIterator it = new ElementIterator(doc);
        StringBuilder s = new StringBuilder();
        while ((e = it.next()) != null) {
            AttributeSet attrs = e.getAttributes();
            Object name = attrs.getAttribute(StyleConstants.NameAttribute);
            if (name == HTML.Tag.IMG) {
                s.append(attrs.getAttribute(HTML.Attribute.ALT));
                continue;
            }
            if (name != HTML.Tag.CONTENT) continue;
            int startOffset = e.getStartOffset();
            int endOffset = e.getEndOffset();
            int length = endOffset - startOffset;
            String content = doc.getText(startOffset, length);
            s.append(content);
        }
        return s.toString();
    }

    private class ChatFileFilter
    extends FileFilter {
        private ChatFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (FileSysUtils.isTraversableDirectory((File)f)) {
                return true;
            }
            String extension = FileSysUtils.getExtension((File)f);
            if (extension == null) {
                return false;
            }
            for (int i = 0; i < extensions.length; ++i) {
                if (!extension.equalsIgnoreCase(extensions[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getDescription() {
            return SaveChatSupport.this.i18n.getString((PropertiesEnum)StringsProperties.CHATFILEFILTER_DESCRIPTION);
        }
    }
}

