/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.chat;

import com.elluminate.classroom.swing.chat.FontSizable;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JPanel;

public class FontSizableStack
extends JPanel {
    private int sizeDelta = 0;
    private static final int MAX_POSITIVE_DELTA = 48;
    private static final int MAX_NEGATIVE_DELTA = -3;

    public FontSizableStack(LayoutManager layout) {
        super(layout);
    }

    public boolean canIncreaseFontSize() {
        return this.sizeDelta + 1 <= 48;
    }

    public boolean canDecreaseFontSize() {
        return this.sizeDelta - 1 >= -3;
    }

    public void add(Component c, String id) {
        if (c instanceof FontSizable) {
            FontSizable fs = (FontSizable)((Object)c);
            fs.resetFontSize();
            if (this.sizeDelta > 0) {
                for (int i = 0; i < this.sizeDelta; ++i) {
                    fs.increaseFontSize();
                }
            } else if (this.sizeDelta < 0) {
                for (int i = 0; i > this.sizeDelta; --i) {
                    fs.decreaseFontSize();
                }
            }
        }
        super.add(c, id);
    }

    public void increaseFontSize() {
        if (this.sizeDelta + 1 > 48) {
            return;
        }
        ++this.sizeDelta;
        for (Component c : this.getComponents()) {
            FontSizable fs = (FontSizable)((Object)c);
            fs.increaseFontSize();
        }
    }

    public void decreaseFontSize() {
        if (this.sizeDelta - 1 < -3) {
            return;
        }
        --this.sizeDelta;
        for (Component c : this.getComponents()) {
            FontSizable fs = (FontSizable)((Object)c);
            fs.decreaseFontSize();
        }
    }
}

