/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.chat;

import com.elluminate.classroom.swing.chat.AxJEditorPane;
import com.elluminate.classroom.swing.chat.EmoticonSupport;
import com.elluminate.classroom.swing.chat.FontSizable;
import com.elluminate.classroom.swing.chat.SaveChatSupport;
import com.elluminate.classroom.swing.chat.StringsProperties;
import com.elluminate.framework.session.CRSession;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.browser.BrowserUtil;
import com.google.inject.Provider;
import java.awt.Adjustable;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JEditorPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class ChatMessagePanel
extends JScrollPane
implements FontSizable {
    private JEditorPane chatHistory;
    private String lastSender;
    private Provider<EmoticonSupport> emoticonSupportProvider;
    private Provider<SaveChatSupport> saveChatSupportProvider;
    private HyperlinkExceptionHandler hyperlinkExceptionHandler;
    private int fontSizeDelta = 0;
    private int ptStep = 2;
    private static final I18n i18n = I18n.create(ChatMessagePanel.class);
    private int lastCaretPosition = 0;
    private boolean autoScrollEnabled = true;
    private boolean currentlyAtBottom = false;
    private boolean showEmoticons;
    private DefaultCaret caret;
    private CRSession session;
    private String initialMessageHtmlTemplate;
    private String consecutiveMessageHtmlTemplate;
    private String initialSupervisedHtmlTemplate;
    private String consecutiveSupervisedHtmlTemplate;
    private String initialRoomPrivateHtmlTemplate;
    private String consecutiveRoomPrivateHtmlTemplate;
    private String eventMessageHtmlTemplate;
    private static final String SENDER_CLASS_PLACEHOLDER = "%sender-class%";
    private static final String SENDER_NAME_PLACEHOLDER = "%sender-display-name%";
    private static final String MESSAGE_BODY_PLACEHOLDER = "%message-body%";
    private static final String TIMESTAMP_PLACEHOLDER = "%short-timestamp%";
    private static final String SENDER_AND_RECIPIENT_NAMES_PLACEHOLDER = "%sender-and-recipient-names%";
    private static final String PRIVATE_MESSAGE_ICON = "%private-message-icon%";
    private String clickToOpenTooltipText = "<span class='tooltip' alt='" + i18n.getString((PropertiesEnum)StringsProperties.CHATMESSAGEPANEL_PRIVATEMESSAGETOOOLTIP) + "' value='%sender-display-name%'>%sender-and-recipient-names%</span>";
    private static final Pattern WEB_URL_PATTERN = Pattern.compile("(?i)\\b((?:https?://|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))");
    private static final Pattern WEB_AND_EMAIL_URL_PATTERN = Pattern.compile("(?i)\\b((?:https?://|www\\d{0,3}[.]|[a-z0-9.\\-]+[.][a-z]{2,4}/|mailto:)(?:[^\\s()<>]+|\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\))+(?:\\(([^\\s()<>]+|(\\([^\\s()<>]+\\)))*\\)|[^\\s`!()\\[\\]{};:'\".,<>?\u00ab\u00bb\u201c\u201d\u2018\u2019]))");
    private static final Pattern BETWEEN_ANCHORS_PATTERN = Pattern.compile("<a\\b[^>]*>(.*?)</a>");
    private static final String IMG_TAG_FORMAT = "<img src=\"%1$s\" alt=\"%2$s\"></img>";
    private static final String ANCHOR_TAG_FORMAT = "<a href=\"%1$s\">%2$s</a>";
    private String embeddedPrivateMessageIcon;
    private String embeddedPrivateMessageIconCSSRule = "background: url(%private-message-icon%) left bottom no-repeat;";

    public ChatMessagePanel(Provider<EmoticonSupport> emoticonSupportProvider, Provider<SaveChatSupport> saveChatSupportProvider, String id, CRSession session) {
        this.session = session;
        this.emoticonSupportProvider = emoticonSupportProvider;
        this.saveChatSupportProvider = saveChatSupportProvider;
        this.setBorder(BorderFactory.createEmptyBorder());
        this.setViewportBorder(BorderFactory.createEmptyBorder());
        this.setHorizontalScrollBarPolicy(30);
        this.chatHistory = new AxJEditorPane();
        InputMap im = this.chatHistory.getInputMap(0);
        im.put(KeyStroke.getKeyStroke("control shift O"), "none");
        this.chatHistory.setToolTipText(i18n.getString((PropertiesEnum)StringsProperties.CHATMESSAGEPANEL_TOOLTIPTEXT));
        this.chatHistory.setContentType("text/html");
        this.chatHistory.setMargin(new Insets(2, 4, 2, 4));
        this.chatHistory.setEditable(false);
        this.chatHistory.setBackground(UIManager.getColor("SideBar.contentBackground"));
        this.chatHistory.getAccessibleContext().setAccessibleName(i18n.getString((PropertiesEnum)StringsProperties.CHATMESSAGEPANEL_AX_NAME, new Object[]{id}));
        HTMLDocument doc = (HTMLDocument)this.chatHistory.getDocument();
        StyleSheet ss = ((HTMLDocument)this.chatHistory.getDocument()).getStyleSheet();
        Font f = UIManager.getFont("EditorPane.font");
        ss.addRule("body { font-family: " + f.getFamily() + "; }");
        this.applyFontSizeDelta();
        try {
            this.initialMessageHtmlTemplate = this.loadResourceAsString("html/initial_message.html");
            this.consecutiveMessageHtmlTemplate = this.loadResourceAsString("html/consecutive_message.html");
            this.initialSupervisedHtmlTemplate = this.loadResourceAsString("html/initial_supervised_message.html");
            this.consecutiveSupervisedHtmlTemplate = this.loadResourceAsString("html/consecutive_supervised_message.html");
            this.initialRoomPrivateHtmlTemplate = this.loadResourceAsString("html/initial_room_private_message.html");
            this.consecutiveRoomPrivateHtmlTemplate = this.loadResourceAsString("html/consecutive_room_private_message.html");
            this.eventMessageHtmlTemplate = this.loadResourceAsString("html/event_message.html");
            this.embeddedPrivateMessageIcon = this.getClass().getResource(i18n.getString((PropertiesEnum)StringsProperties.CHATMESSAGEPANEL_PRIVATEMESSAGEICONPATH)).toString();
            this.embeddedPrivateMessageIconCSSRule = this.embeddedPrivateMessageIconCSSRule.replace(PRIVATE_MESSAGE_ICON, this.embeddedPrivateMessageIcon);
            String cssString = this.loadResourceAsString("html/chat.css");
            StringReader r = new StringReader(cssString);
            doc.getStyleSheet().loadRules(r, null);
            ((Reader)r).close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setViewportView(this.chatHistory);
        this.chatHistory.addHyperlinkListener(new ChatHyperlinkListener());
        this.caret = (DefaultCaret)this.chatHistory.getCaret();
        this.applyPlatformStyling();
        this.chatHistory.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent ke) {
                ChatMessagePanel.this.handleChatHistoryKeyUpDownPressed(ke);
            }
        });
        this.getVerticalScrollBar().addAdjustmentListener(new AdjustmentListener(){

            @Override
            public void adjustmentValueChanged(final AdjustmentEvent evt) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChatMessagePanel.this.handleAdjustmentsToVerticalScrollbar(evt);
                    }
                });
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ChatMessagePanel.this.getVerticalScrollBar().setValue(ChatMessagePanel.this.getVerticalScrollBar().getMaximum());
                    }
                });
            }
        });
    }

    private void handleChatHistoryKeyUpDownPressed(KeyEvent ke) {
        int keyCode = ke.getKeyCode();
        switch (keyCode) {
            case 38: 
            case 40: {
                int dot = this.caret.getDot();
                if (dot < this.getLastCaretPosition()) {
                    this.setAutoScrollEnabled(false);
                    break;
                }
                if (dot < this.getLastCaretPosition()) break;
                this.setAutoScrollEnabled(true);
            }
        }
    }

    private void handleAdjustmentsToVerticalScrollbar(AdjustmentEvent evt) {
        Adjustable source = evt.getAdjustable();
        if (evt.getValueIsAdjusting()) {
            return;
        }
        int orient = source.getOrientation();
        int type = evt.getAdjustmentType();
        switch (type) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                if (orient != 1) break;
                boolean isCurrentlyAutoScrollEnabled = this.isAutoScrollEnabled();
                if (this.isAtBottom()) {
                    this.setAutoScrollEnabled(true);
                    this.currentlyAtBottom = true;
                    break;
                }
                if (this.currentlyAtBottom) {
                    this.setAutoScrollEnabled(false);
                    this.currentlyAtBottom = false;
                    break;
                }
                this.setAutoScrollEnabled(isCurrentlyAutoScrollEnabled);
            }
        }
    }

    public boolean isAtBottom() {
        int maxPosition;
        JScrollBar vsb = this.getVerticalScrollBar();
        int currentPosition = vsb.getValue();
        boolean atBottom = currentPosition == (maxPosition = vsb.getMaximum() - vsb.getVisibleAmount());
        return atBottom;
    }

    private void applyPlatformStyling() {
        if (Platform.getOS() == 202) {
            StyleSheet ss = ((HTMLDocument)this.chatHistory.getDocument()).getStyleSheet();
            ss.addRule("body { color: #363636; }");
        }
    }

    private String loadResourceAsString(String resourcePath) throws IOException {
        StringBuilder b = new StringBuilder();
        InputStreamReader r = new InputStreamReader(this.getClass().getResourceAsStream(resourcePath));
        char[] buf = new char[1024];
        int charsRead = -1;
        while ((charsRead = r.read(buf)) != -1) {
            b.append(buf, 0, charsRead);
        }
        ((Reader)r).close();
        return b.toString();
    }

    private String linkify(String text) {
        Matcher m = WEB_AND_EMAIL_URL_PATTERN.matcher(text);
        StringBuffer strb = new StringBuffer();
        while (m.find()) {
            String origText = m.group();
            String urlStr = m.group();
            if (!(urlStr.startsWith("http://") || urlStr.startsWith("https://") || urlStr.startsWith("mailto:"))) {
                urlStr = new String("http://" + urlStr);
            }
            String str = String.format(Locale.ENGLISH, ANCHOR_TAG_FORMAT, urlStr, origText);
            str = Matcher.quoteReplacement(str);
            m.appendReplacement(strb, str);
        }
        m.appendTail(strb);
        return strb.toString();
    }

    private static boolean rangesIntersect(int start1, int end1, int start2, int end2) {
        if (start1 <= end2 && start1 >= start2) {
            return true;
        }
        return start2 <= end1 && start2 >= start1;
    }

    private String emoticonify(String text) {
        EmoticonSupport es = (EmoticonSupport)this.emoticonSupportProvider.get();
        Pattern ep = es.getShortcutCapturePattern(EmoticonSupport.ShortcutType.HTML_ESCAPED_TEXT);
        Matcher em = ep.matcher(text);
        Matcher am = BETWEEN_ANCHORS_PATTERN.matcher(text);
        StringBuffer strb = new StringBuffer();
        while (em.find()) {
            boolean matchIsInAnchor = false;
            while (am.find() && !matchIsInAnchor) {
                if (!ChatMessagePanel.rangesIntersect(em.start(), em.end(), am.start(), am.end())) continue;
                matchIsInAnchor = true;
            }
            if (!matchIsInAnchor) {
                String str = String.format(Locale.ENGLISH, IMG_TAG_FORMAT, es.imagePathForShortcut(em.group(), EmoticonSupport.ShortcutType.HTML_ESCAPED_TEXT), em.group());
                str = Matcher.quoteReplacement(str);
                em.appendReplacement(strb, str);
            }
            am.reset();
        }
        em.appendTail(strb);
        return strb.toString();
    }

    public void appendMessage(String sender, Date timestamp, String message, MessageType type) {
        this.appendMessage(sender, "", timestamp, message, type);
    }

    public void appendMessage(String sender, String senderAndRecipients, Date timestamp, String message, MessageType type) {
        HTMLDocument doc = (HTMLDocument)this.chatHistory.getDocument();
        int pos = doc.getLength();
        Element e = doc.getParagraphElement(pos);
        message = StringUtils.htmlEscape((String)message);
        if (type != MessageType.EVENT) {
            message = this.linkify(message);
            if (this.showEmoticons) {
                message = this.emoticonify(message);
            }
        }
        message = Matcher.quoteReplacement(message);
        String htmlTemplate = null;
        String html = null;
        boolean consecutive = this.lastSender != null && this.lastSender.equals(sender);
        switch (type) {
            case SUPERVISED: {
                htmlTemplate = consecutive ? this.consecutiveSupervisedHtmlTemplate : this.initialSupervisedHtmlTemplate;
                html = htmlTemplate.replace(SENDER_AND_RECIPIENT_NAMES_PLACEHOLDER, senderAndRecipients);
                break;
            }
            case ROOM_PRIVATE: {
                htmlTemplate = consecutive ? this.consecutiveRoomPrivateHtmlTemplate : this.initialRoomPrivateHtmlTemplate;
                String senderAndRecipientString = "";
                senderAndRecipientString = this.clickToOpenTooltipText.replace(SENDER_NAME_PLACEHOLDER, sender).replace(SENDER_AND_RECIPIENT_NAMES_PLACEHOLDER, senderAndRecipients);
                ((HTMLDocument)this.chatHistory.getDocument()).getStyleSheet().addRule(this.embeddedPrivateMessageIconCSSRule);
                html = htmlTemplate.replace(SENDER_AND_RECIPIENT_NAMES_PLACEHOLDER, senderAndRecipientString);
                break;
            }
            case EVENT: {
                html = htmlTemplate = this.eventMessageHtmlTemplate;
                break;
            }
            case NORMAL_FROM_ME: 
            case NORMAL_NOT_FROM_ME: {
                String senderClassName = type == MessageType.NORMAL_FROM_ME ? "sender-me" : "sender-not-me";
                htmlTemplate = consecutive ? this.consecutiveMessageHtmlTemplate : this.initialMessageHtmlTemplate;
                html = htmlTemplate.replace(SENDER_CLASS_PLACEHOLDER, senderClassName).replace(SENDER_NAME_PLACEHOLDER, sender);
            }
        }
        String shortTimeStr = DateFormat.getTimeInstance(3).format(timestamp);
        html = html.replace(TIMESTAMP_PLACEHOLDER, shortTimeStr).replaceAll(MESSAGE_BODY_PLACEHOLDER, message);
        try {
            boolean shouldScrollToBottom = this.isAutoScrollEnabled() || type == MessageType.NORMAL_FROM_ME;
            this.setLastCaretPosition(doc.getLength());
            if (shouldScrollToBottom) {
                this.caret.setUpdatePolicy(2);
                this.chatHistory.setCaretPosition(this.getLastCaretPosition());
            } else {
                this.caret.setUpdatePolicy(1);
            }
            doc.insertAfterEnd(e, html);
            this.lastSender = sender;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (BadLocationException ble) {
            ble.printStackTrace();
        }
    }

    private void applyFontSizeDelta() {
        int baseSize = UIManager.getFont("EditorPane.font").getSize();
        StyleSheet ss = ((HTMLDocument)this.chatHistory.getDocument()).getStyleSheet();
        ss.addRule("body { font-size: " + (baseSize + this.fontSizeDelta) + "pt; }");
    }

    @Override
    public void increaseFontSize() {
        this.fontSizeDelta += this.ptStep;
        this.applyFontSizeDelta();
    }

    @Override
    public void decreaseFontSize() {
        this.fontSizeDelta -= this.ptStep;
        this.applyFontSizeDelta();
    }

    @Override
    public void resetFontSize() {
        this.fontSizeDelta = 0;
        this.applyFontSizeDelta();
    }

    @Override
    public void setFontSizeStep(int pts) {
        this.ptStep = pts;
    }

    public void setShowEmoticons(boolean enabled) {
        this.showEmoticons = enabled;
    }

    public void setShowingSupervisedMessages(boolean showing) {
        StyleSheet ss = ((HTMLDocument)this.chatHistory.getDocument()).getStyleSheet();
        if (showing) {
            ss.addRule("table.supervised-message td.message-body { font-size: 0.9em; }");
            ss.addRule("table.supervised-message td.timestamp { font-size: 0.9em; }");
            ss.addRule("table.supervised-message td.sender-and-recipients { font-size: 0.9em; }");
            ss.addRule("table.supervised-message tr.initial-row td { padding-top: 4px; }");
        } else {
            ss.addRule("table.supervised-message td.message-body { font-size: 0em; }");
            ss.addRule("table.supervised-message td.timestamp { font-size: 0em; }");
            ss.addRule("table.supervised-message td.sender-and-recipients { font-size: 0em; }");
            ss.addRule("table.supervised-message tr.initial-row td { padding-top: 0; }");
        }
    }

    public void setShowingRoomPrivateMessages(boolean showing) {
        StyleSheet ss = ((HTMLDocument)this.chatHistory.getDocument()).getStyleSheet();
        if (showing) {
            ss.addRule("table.room-private-message td.message-body { font-size: 0.9em; }");
            ss.addRule("table.room-private-message td.timestamp { font-size: 0.9em; }");
            ss.addRule("table.room-private-message td.sender-and-recipients { font-size: 0.9em;" + this.embeddedPrivateMessageIconCSSRule + "}");
            ss.addRule("table.room-private-message tr.initial-row td { padding-top: 4px; }");
        } else {
            ss.addRule("table.room-private-message td.message-body { font-size: 0em; }");
            ss.addRule("table.room-private-message td.timestamp { font-size: 0em; }");
            ss.addRule("table.room-private-message td.sender-and-recipients { font-size: 0em;background: none;");
            ss.addRule("table.room-private-message tr.initial-row td { padding-top: 0; }");
        }
    }

    public void setShowingEventMessages(boolean showing) {
        StyleSheet ss = ((HTMLDocument)this.chatHistory.getDocument()).getStyleSheet();
        if (showing) {
            ss.addRule("div.event-message  { font-size: 0.9em; }");
        } else {
            ss.addRule("div.event-message  { font-size: 0em; }");
        }
    }

    public void saveToDisk() {
        HTMLDocument htmlDoc = (HTMLDocument)this.chatHistory.getDocument();
        ((SaveChatSupport)this.saveChatSupportProvider.get()).save(htmlDoc);
    }

    public void clear() {
        HTMLDocument olddoc = (HTMLDocument)this.chatHistory.getDocument();
        HTMLDocument newdoc = new HTMLDocument(olddoc.getStyleSheet());
        newdoc.setParser(olddoc.getParser());
        this.chatHistory.setDocument(newdoc);
    }

    private int getLastCaretPosition() {
        return this.lastCaretPosition;
    }

    private void setLastCaretPosition(int lastCaretPosition) {
        this.lastCaretPosition = lastCaretPosition;
    }

    private boolean isAutoScrollEnabled() {
        return this.autoScrollEnabled;
    }

    private void setAutoScrollEnabled(boolean autoScrollEnabled) {
        this.autoScrollEnabled = autoScrollEnabled;
    }

    public JEditorPane getChatHistory() {
        return this.chatHistory;
    }

    private class ChatHyperlinkListener
    implements HyperlinkListener {
        private ChatHyperlinkListener() {
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            if (e.getURL() == null || e.getEventType() != HyperlinkEvent.EventType.ACTIVATED) {
                return;
            }
            URL url = e.getURL();
            try {
                BrowserUtil.gotoURL((String)url.toString());
            }
            catch (Exception ex) {
                if (ChatMessagePanel.this.hyperlinkExceptionHandler != null) {
                    ChatMessagePanel.this.hyperlinkExceptionHandler.problemLaunchingBrowser(url, ex);
                }
                ex.printStackTrace();
            }
        }
    }

    public static interface HyperlinkExceptionHandler {
        public void problemLaunchingBrowser(URL var1, Exception var2);
    }

    public static enum MessageType {
        NORMAL_FROM_ME,
        NORMAL_NOT_FROM_ME,
        SUPERVISED,
        ROOM_PRIVATE,
        EVENT;

    }
}

