/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.caption;

import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

@Singleton
public class CaptionWindowModel {
    public static final String BGCOLOR = "Caption.bgcolor";
    public static final String FGCOLOR = "Caption.fgcolor";
    public static final String FONTFAMILY = "Caption.fontfamily";
    public static final String FONTSIZE = "Caption.fontsize";
    private static final Object lock = new Object();
    private int fontSize = -1;
    private String fontFamily = null;
    private Color bgColor = null;
    private Color fgColor = null;
    private Provider<ListenerRegistry<PropertyChangeListener>> registryProvider;
    private Map<String, ListenerRegistry<PropertyChangeListener>> propertyListenerMap = new HashMap<String, ListenerRegistry<PropertyChangeListener>>();

    @Inject
    public void initListenerRegistryProvider(Provider<ListenerRegistry<PropertyChangeListener>> lrp) {
        this.registryProvider = lrp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        if (listener == null || property == null) {
            return;
        }
        Object object = lock;
        synchronized (object) {
            if (this.propertyListenerMap.containsKey(property)) {
                this.propertyListenerMap.get(property).add((Object)listener);
            } else {
                ListenerRegistry reg = (ListenerRegistry)this.registryProvider.get();
                reg.add((Object)listener);
                this.propertyListenerMap.put(property, (ListenerRegistry<PropertyChangeListener>)reg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        Object object = lock;
        synchronized (object) {
            for (String prop : this.propertyListenerMap.keySet()) {
                this.removePropertyChangeListener(prop, listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        Object object = lock;
        synchronized (object) {
            if (this.propertyListenerMap.containsKey(property)) {
                this.propertyListenerMap.get(property).remove((Object)listener);
            }
        }
    }

    public int getFontSize() {
        return this.fontSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontSize(int sz) {
        if (sz == this.fontSize) {
            return;
        }
        int oldSize = -1;
        Object object = lock;
        synchronized (object) {
            oldSize = this.fontSize;
            this.fontSize = sz;
        }
        this.firePropertyChange(FONTSIZE, oldSize, sz);
    }

    public String getFontName() {
        return this.fontFamily;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFontFamily(String name) {
        if (name == this.fontFamily) {
            return;
        }
        String oldName = null;
        Object object = lock;
        synchronized (object) {
            oldName = this.fontFamily;
            this.fontFamily = name;
        }
        this.firePropertyChange(FONTFAMILY, oldName, name);
    }

    public Color getBgColor() {
        return this.bgColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBgColor(Color color) {
        if (color == this.bgColor) {
            return;
        }
        Color oldColor = null;
        Object object = lock;
        synchronized (object) {
            oldColor = this.bgColor;
            this.bgColor = color;
        }
        this.firePropertyChange(BGCOLOR, oldColor, color);
    }

    public Color getFgColor() {
        return this.fgColor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFgColor(Color color) {
        if (color == this.fgColor) {
            return;
        }
        Color oldColor = null;
        Object object = lock;
        synchronized (object) {
            oldColor = this.fgColor;
            this.fgColor = color;
        }
        this.firePropertyChange(FGCOLOR, oldColor, color);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void firePropertyChange(final String prop, final Object oldVal, final Object newVal) {
        ListenerRegistry<PropertyChangeListener> sendTo = null;
        Object object = lock;
        synchronized (object) {
            if (this.propertyListenerMap.containsKey(prop)) {
                sendTo = this.propertyListenerMap.get(prop);
            }
        }
        sendTo.fire((FiringFunctor)new FiringFunctor<PropertyChangeListener>(){

            public void fire(PropertyChangeListener listener) {
                listener.propertyChange(new PropertyChangeEvent(this, prop, oldVal, newVal));
            }
        });
    }
}

