/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.caption;

import com.elluminate.platform.Platform;
import com.google.inject.Inject;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CaptionSourcePanel
extends JPanel {
    private JComboBox source;
    private GridBagConstraints constraints;

    @Inject
    public CaptionSourcePanel() {
        this.setupUI();
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        if (Platform.getLAF() == 502) {
            this.constraints.insets.top = -1;
            this.constraints.insets.bottom = -2;
        } else {
            this.constraints.insets.top = 2;
            this.constraints.insets.bottom = 2;
        }
        this.constraints.insets.left = 2;
        this.constraints.insets.right = 2;
        this.setOpaque(false);
        this.source = new JComboBox();
        this.source.setPrototypeDisplayValue("XXXXXXXXXXXXXXXXXXXX");
        this.add((Component)this.source, this.constraints);
        this.source.setVisible(false);
    }

    public void setSourceComponent(JComboBox comp) {
        if (comp != null) {
            this.source = comp;
        }
        this.removeAll();
        this.add((Component)this.source, this.constraints);
        this.revalidate();
        this.repaint();
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JComponent) {
            this.fontAdjustment((JComponent)comp);
        }
        return super.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof JComponent) {
            this.fontAdjustment((JComponent)comp);
        }
        super.add(comp, constraints);
    }

    private void fontAdjustment(JComponent comp) {
        Font btnFont = UIManager.getFont("Button.font");
        Font font = btnFont.deriveFont((float)btnFont.getSize() * 11.0f / 12.0f);
        comp.setFont(font);
        if (Platform.getLAF() == 502) {
            comp.putClientProperty("JComponent.sizeVariant", "small");
        }
    }

    public void removeSourceComponent() {
        this.removeAll();
    }
}

