/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.caption;

import com.elluminate.classroom.swing.caption.CaptionWindowModel;
import com.elluminate.classroom.swing.caption.StringsProperties;
import com.elluminate.gui.FontUtils;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.FileSaveDialog;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.LightweightTimerFactory;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.event.FiringFunctor;
import com.elluminate.util.event.ListenerRegistry;
import com.elluminate.util.io.FileSysUtils;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultCaret;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public class CaptionPanel
extends JPanel {
    private static final long SEND_INTERVAL = 500L;
    private I18n i18n = I18n.create(CaptionPanel.class);
    private String wdir = System.getProperty("user.home");
    private Logger log;
    private MutableAttributeSet dftAttrs = new SimpleAttributeSet();
    private JTextPane captions = new JTextPane();
    private JScrollPane captionScroller = new JScrollPane();
    private CaptionWindowModel windowModel;
    private SwingRunner swinger;
    private ListenerRegistry<OutboundCaptionMessageListener> listeners;
    private DocumentListener docListener;
    private KeyListener keyListener;
    private LightweightTimer timer;
    private ByteBuffer buffer = ByteBuffer.allocate(50);
    private String documentBkup = "";
    private int lastCaretPosition = 0;
    private boolean autoScrollEnabled = true;

    @Inject
    public CaptionPanel(Logger l) {
        this.log = l;
        this.setupPanel();
    }

    @Inject
    public void initLightweightTimerFactory(LightweightTimerFactory tf) {
        this.timer = tf.create((byte)1, new Runnable(){

            @Override
            public void run() {
                CaptionPanel.this.sendBufferContentsToListener();
            }
        });
    }

    @Inject
    public void initSwingRunner(SwingRunner sr) {
        this.swinger = sr;
    }

    @Inject
    public void initCaptionWindowModel(CaptionWindowModel cwm) {
        this.windowModel = cwm;
        this.setupListeners();
    }

    @Inject
    public void initListenerRegistry(ListenerRegistry<OutboundCaptionMessageListener> lr) {
        this.listeners = lr;
    }

    private void setupListeners() {
        this.windowModel.addPropertyChangeListener("Caption.bgcolor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Color) {
                    CaptionPanel.this.handleBGColorChange((Color)evt.getNewValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fgcolor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Color) {
                    CaptionPanel.this.handleFGColorChange((Color)evt.getNewValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fontsize", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Integer) {
                    CaptionPanel.this.handleFontSizeChange((Integer)evt.getNewValue());
                }
            }
        });
        this.windowModel.addPropertyChangeListener("Caption.fontfamily", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof String) {
                    CaptionPanel.this.handleFontFamilyChange((String)evt.getNewValue());
                }
            }
        });
    }

    protected void handleFontFamilyChange(String fontFamily) {
        final MutableAttributeSet attrs = this.captions.getInputAttributes();
        StyleConstants.setFontFamily(attrs, fontFamily);
        final StyledDocument doc = this.captions.getStyledDocument();
        this.swinger.invokeLater(new Runnable(){

            @Override
            public void run() {
                doc.setCharacterAttributes(0, doc.getLength() + 1, attrs, false);
            }
        });
    }

    protected void handleFontSizeChange(Integer sz) {
        Font oldFont = this.captions.getFont();
        final Font newFont = FontUtils.setFontSize((Font)oldFont, (int)sz);
        this.swinger.invokeLater(new Runnable(){

            @Override
            public void run() {
                CaptionPanel.this.captions.setFont(newFont);
            }
        });
    }

    protected void handleFGColorChange(final Color color) {
        this.swinger.invokeLater(new Runnable(){

            @Override
            public void run() {
                CaptionPanel.this.captions.setForeground(color);
                CaptionPanel.this.captions.setCaretColor(color);
            }
        });
    }

    protected void handleBGColorChange(final Color color) {
        this.swinger.invokeLater(new Runnable(){

            @Override
            public void run() {
                CaptionPanel.this.captions.setBackground(color);
            }
        });
    }

    private void setupPanel() {
        this.setLayout(new BorderLayout());
        this.captions.setFont(FontUtils.setFontStyleAndSize((Font)this.getFont(), (int)1, (int)24));
        this.captions.setEditable(true);
        this.captions.setMargin(new Insets(1, 4, 1, 4));
        this.docListener = this.createDocumentListener();
        this.captionScroller.setViewportView(this.captions);
        this.captionScroller.setHorizontalScrollBarPolicy(31);
        this.captionScroller.setVerticalScrollBarPolicy(20);
        this.captionScroller.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.add((Component)this.captionScroller, "Center");
        this.setupAutoscrolling();
    }

    private DocumentListener createDocumentListener() {
        DocumentListener listener = new DocumentListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void removeUpdate(DocumentEvent e) {
                JTextPane jTextPane = CaptionPanel.this.captions;
                synchronized (jTextPane) {
                    if (CaptionPanel.this.captions.isEditable()) {
                        int length = e.getLength();
                        for (int i = 0; i < length; ++i) {
                            CaptionPanel.this.addKeyToBuffer((byte)8);
                        }
                    }
                }
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                if (CaptionPanel.this.captions.isEditable()) {
                    try {
                        Document doc = e.getDocument();
                        int length = e.getLength();
                        int offset = e.getOffset();
                        String inserted = doc.getText(offset, length);
                        for (byte b : inserted.getBytes("UTF8")) {
                            CaptionPanel.this.addKeyToBuffer(b);
                        }
                    }
                    catch (Exception e1) {
                        CaptionPanel.this.log.message("Problem sending caption input text to the recipients");
                    }
                }
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
        return listener;
    }

    public void setEditable(boolean editable) {
        this.captions.setEditable(editable);
        this.handleCaptionEditableChange(editable);
        this.enableMessageTimer(editable);
    }

    private void enableMessageTimer(boolean enable) {
        if (enable) {
            this.timer.scheduleEvery(500L);
        } else {
            this.timer.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeyToBuffer(byte key) {
        try {
            ByteBuffer byteBuffer = this.buffer;
            synchronized (byteBuffer) {
                this.buffer.put(key);
            }
        }
        catch (BufferOverflowException bofe) {
            this.sendBufferContentsToListener();
            this.addKeyToBuffer(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBufferContentsToListener() {
        byte[] contents = new byte[]{};
        ByteBuffer byteBuffer = this.buffer;
        synchronized (byteBuffer) {
            this.buffer.flip();
            while (this.buffer.hasRemaining()) {
                byte b = this.buffer.get();
                byte[] temp = new byte[contents.length + 1];
                System.arraycopy(contents, 0, temp, 0, contents.length);
                contents = temp;
                contents[contents.length - 1] = b;
            }
            this.buffer.clear();
        }
        final byte[] toSend = contents;
        this.listeners.fire((FiringFunctor)new FiringFunctor<OutboundCaptionMessageListener>(){

            public void fire(OutboundCaptionMessageListener listener) {
                if (toSend != null && toSend.length > 0) {
                    listener.sendMessage(toSend);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveBtn_actionPerformed(ActionEvent e) {
        FileSaveDialog dlg = new FileSaveDialog(this.wdir);
        dlg.addChoosableFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return CaptionPanel.this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_TXTFILTERDESC);
            }

            @Override
            public boolean accept(File f) {
                if (FileSysUtils.isTraversableDirectory((File)f)) {
                    return true;
                }
                if (f.isFile()) {
                    String nm = f.getName();
                    int ln = nm.length();
                    if (ln < 5) {
                        return false;
                    }
                    if (nm.substring(ln - 4).equalsIgnoreCase(".txt")) {
                        return true;
                    }
                }
                return false;
            }
        });
        if (dlg.showSaveDialog((Component)this) == 0) {
            String nm;
            int ln;
            File f = dlg.getSelectedFile();
            this.wdir = dlg.getCurrentDirectory().getAbsolutePath();
            if (!(dlg.getFileFilter() == dlg.getAcceptAllFileFilter() || (ln = (nm = f.getName()).length()) >= 5 && nm.substring(ln - 4).equalsIgnoreCase(".txt"))) {
                f = new File(f.getAbsolutePath() + ".txt");
            }
            FileWriter fw = null;
            PrintWriter print = null;
            try {
                fw = new FileWriter(f);
                print = new PrintWriter(fw);
                print.print(this.captions.getText());
            }
            catch (IOException iox) {
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this, (Object)this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_WRITEERRORMSG, new Object[]{f.toString(), iox.getMessage()}), (String)this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_WRITEERRORTITLE), (int)0);
            }
            finally {
                if (print != null) {
                    try {
                        print.close();
                    }
                    catch (Throwable ignored) {}
                }
                if (fw != null) {
                    try {
                        fw.close();
                    }
                    catch (Throwable ignored) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerOutboundCaptionMessageListener(OutboundCaptionMessageListener listener) {
        ListenerRegistry<OutboundCaptionMessageListener> listenerRegistry = this.listeners;
        synchronized (listenerRegistry) {
            this.listeners.add((Object)listener);
        }
    }

    public void deregisterOutboundCaptionMessageListener(OutboundCaptionMessageListener listener) {
        this.listeners.remove((Object)listener);
    }

    private void handleCaptionEditableChange(boolean editable) {
        if (editable) {
            this.docListener = this.docListener != null ? this.docListener : this.createDocumentListener();
            this.captions.getDocument().addDocumentListener(this.docListener);
        } else if (this.docListener != null) {
            this.captions.getDocument().removeDocumentListener(this.docListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void backupDocument() {
        JTextPane jTextPane = this.captions;
        synchronized (jTextPane) {
            if (!this.captions.isEditable()) {
                try {
                    Document doc = this.captions.getDocument();
                    String text = doc.getText(0, doc.getLength());
                    if (text != null && text.length() > 0) {
                        this.documentBkup = text;
                    }
                }
                catch (BadLocationException e) {
                    this.log.message("unable to backup captions");
                }
            }
        }
    }

    public void restoreDocument() {
        if (this.documentBkup != null && this.documentBkup.length() > 0 && !this.captions.isEditable()) {
            this.insertText(this.documentBkup);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDocument() {
        JTextPane jTextPane = this.captions;
        synchronized (jTextPane) {
            this.captions.setText("");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertText(String text) {
        JTextPane jTextPane = this.captions;
        synchronized (jTextPane) {
            try {
                Document doc = this.captions.getDocument();
                if (text == null || text.equals("")) {
                    return;
                }
                try {
                    boolean shouldScrollToBottom = this.isAutoScrollEnabled();
                    DefaultCaret caret = (DefaultCaret)this.captions.getCaret();
                    this.setLastCaretPosition(doc.getLength());
                    if (shouldScrollToBottom) {
                        caret.setUpdatePolicy(2);
                        this.captions.setCaretPosition(this.getLastCaretPosition());
                    } else {
                        caret.setUpdatePolicy(1);
                    }
                    StringReader r = new StringReader(text);
                    EditorKit kit = this.captions.getEditorKit();
                    kit.read(r, doc, doc.getLength());
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (BadLocationException ble) {
                    ble.printStackTrace();
                }
            }
            catch (Exception e) {
                this.log.message("Unable to insert text: " + text);
            }
        }
    }

    private void setupAutoscrolling() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                CaptionPanel.this.captionScroller.getVerticalScrollBar().setValue(CaptionPanel.this.captionScroller.getVerticalScrollBar().getMaximum());
            }
        });
    }

    private int getLastCaretPosition() {
        return this.lastCaretPosition;
    }

    private void setLastCaretPosition(int lastCaretPosition) {
        this.lastCaretPosition = lastCaretPosition;
    }

    private boolean isAutoScrollEnabled() {
        return this.autoScrollEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteCharacter() {
        JTextPane jTextPane = this.captions;
        synchronized (jTextPane) {
            try {
                Document doc = this.captions.getDocument();
                if (doc.getText(doc.getLength() - 1, 1).equals("\n")) {
                    return;
                }
                doc.remove(doc.getLength() - 1, 1);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void requestFocus() {
        this.captions.requestFocus();
    }

    public static interface OutboundCaptionMessageListener {
        public void sendMessage(byte[] var1);
    }
}

