/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing.caption;

import com.elluminate.classroom.swing.caption.CaptionWindowModel;
import com.elluminate.classroom.swing.caption.StringsProperties;
import com.elluminate.gui.component.PopupColorPicker;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class CaptionBGToolPanel
extends JPanel {
    private static final Dimension BUTTON_SIZE = new Dimension(20, 20);
    private static final Color NO_COLOR = null;
    private I18n i18n = I18n.create(CaptionBGToolPanel.class);
    private JLabel bgColorLabel;
    private PopupColorPicker colorPicker;
    private CaptionWindowModel windowModel;

    @Inject
    public CaptionBGToolPanel() {
        this.setupUI();
    }

    @Inject
    public void initCaptionWindowModel(CaptionWindowModel cwm) {
        this.windowModel = cwm;
        this.setupListeners();
    }

    private void setupListeners() {
        this.windowModel.addPropertyChangeListener("Caption.bgcolor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getNewValue() != null && evt.getNewValue() instanceof Color) {
                    CaptionBGToolPanel.this.changeBGColor((Color)evt.getNewValue());
                }
            }
        });
    }

    private void setupUI() {
        this.setLayout(new GridBagLayout());
        this.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        if (Platform.getLAF() == 502) {
            constraints.insets.top = -1;
            constraints.insets.bottom = -2;
        } else {
            constraints.insets.top = 2;
            constraints.insets.bottom = 2;
        }
        constraints.insets.left = 2;
        constraints.insets.right = 2;
        this.bgColorLabel = new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_BACKGROUND_TEXT));
        this.bgColorLabel.setForeground(UIManager.getColor("ShadeWindow.textColor"));
        this.add((Component)this.bgColorLabel, constraints);
        this.colorPicker = new PopupColorPicker(BUTTON_SIZE, NO_COLOR);
        this.colorPicker.setFocusable(true);
        this.colorPicker.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.CAPTION_BACKGROUND_AXTEXT));
        this.colorPicker.addPropertyChangeListener("QuickColorPicker.chosenColor", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                if (ev.getNewValue() != null && ev.getNewValue() instanceof Color) {
                    CaptionBGToolPanel.this.changeBGColor((Color)ev.getNewValue());
                }
            }
        });
        this.add((Component)this.colorPicker, constraints);
    }

    @Override
    public Component add(Component comp) {
        if (comp instanceof JComponent) {
            this.fontAdjustment((JComponent)comp);
        }
        return super.add(comp);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof JComponent) {
            this.fontAdjustment((JComponent)comp);
        }
        super.add(comp, constraints);
    }

    private void fontAdjustment(JComponent comp) {
        Font btnFont = UIManager.getFont("Button.font");
        Font font = btnFont.deriveFont((float)btnFont.getSize() * 11.0f / 12.0f);
        comp.setFont(font);
        if (Platform.getLAF() == 502) {
            comp.putClientProperty("JComponent.sizeVariant", "small");
        }
    }

    protected void changeBGColor(Color color) {
        Color bgColor = this.colorPicker.getColor();
        if (bgColor == null || !this.colorPicker.getColor().equals(color)) {
            this.colorPicker.setColor(color);
        }
        this.windowModel.setBgColor(color);
    }
}

