/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.swing.ArrowNavigation;
import com.elluminate.classroom.swing.ContentLoader;
import com.elluminate.classroom.swing.ModeController;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.TopFocusReceiver;
import com.elluminate.classroom.swing.components.ButtonFocusDisplayer;
import com.elluminate.classroom.swing.components.SButton;
import com.elluminate.classroom.swing.components.SMenuButton;
import com.elluminate.classroom.swing.components.SToggleButton;
import com.elluminate.classroom.swing.components.STopBar;
import com.elluminate.classroom.swing.location.ContentLoaderLocationHandler;
import com.elluminate.classroom.swing.location.TopBarLocationHandler;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAvailableListener;
import com.elluminate.groupware.imps.view.ViewAPI;
import com.elluminate.groupware.imps.view.ViewMode;
import com.elluminate.gui.swing.DialogParentProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.UIManager;

public class TopBar
extends STopBar
implements ContentLoader,
TopFocusReceiver {
    private JPanel modePanel;
    private ModeButton whiteboardButton;
    private ModeButton screenSharingButton;
    private ModeButton webTourButton;
    private JPanel displayPanel;
    private SMenuButton optionsButton;
    private Font optionsFont;
    private JPanel sessionActionPanel;
    private SButton addContentButton;
    private ContentLoaderLocationHandler contentHandler;
    private ModeController modeController;
    private DialogParentProvider parentProvider;
    private Preferences preferences;
    private I18n i18n;
    private File lastAddContentFolder;
    private JPanel brandingPanel;
    private JLabel brandingLogo = new JLabel();
    private BrandingI18nProvider branding;
    private ButtonGroup grp;

    public TopBar() {
        this.setLayout(new BorderLayout());
        ArrowNavigation.install(this);
        this.modePanel = new JPanel(new GridLayout(1, 0, 1, 0));
        this.modePanel.setOpaque(false);
        this.modePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 0, 1, UIManager.getColor("TopBar.separatorColor")), BorderFactory.createEmptyBorder(0, 2, 0, 2)));
        this.add((Component)this.modePanel, "West");
        this.grp = new ButtonGroup();
        this.whiteboardButton = new ModeButton();
        this.whiteboardButton.setIcon(UIManager.getIcon("TopBar.whiteboardModeIcon"));
        this.whiteboardButton.setRolloverIcon(UIManager.getIcon("TopBar.whiteboardModeRolloverIcon"));
        this.whiteboardButton.setPressedIcon(UIManager.getIcon("TopBar.whiteboardModeRolloverIcon"));
        this.whiteboardButton.setSelectedIcon(UIManager.getIcon("TopBar.whiteboardModeSelectedIcon"));
        this.whiteboardButton.setRolloverSelectedIcon(UIManager.getIcon("TopBar.whiteboardModeSelectedIcon"));
        this.whiteboardButton.setDisabledIcon(UIManager.getIcon("TopBar.whiteboardModeDisabledIcon"));
        this.whiteboardButton.setDisabledSelectedIcon(UIManager.getIcon("TopBar.whiteboardModeDisabledSelectedIcon"));
        this.whiteboardButton.setSelected(true);
        this.whiteboardButton.addFocusListener(new ButtonFocusDisplayer());
        this.whiteboardButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopBar.this.modeController.setMode(ViewMode.WHITEBOARD);
            }
        });
        this.grp.add(this.whiteboardButton);
        this.screenSharingButton = new ModeButton();
        this.screenSharingButton.setIcon(UIManager.getIcon("TopBar.screenSharingModeIcon"));
        this.screenSharingButton.setRolloverIcon(UIManager.getIcon("TopBar.screenSharingModeRolloverIcon"));
        this.screenSharingButton.setPressedIcon(UIManager.getIcon("TopBar.screenSharingModeRolloverIcon"));
        this.screenSharingButton.setSelectedIcon(UIManager.getIcon("TopBar.screenSharingModeSelectedIcon"));
        this.screenSharingButton.setRolloverSelectedIcon(UIManager.getIcon("TopBar.screenSharingModeSelectedIcon"));
        this.screenSharingButton.setDisabledIcon(UIManager.getIcon("TopBar.screenSharingModeDisabledIcon"));
        this.screenSharingButton.setDisabledSelectedIcon(UIManager.getIcon("TopBar.screenSharingModeDisabledSelectedIcon"));
        this.screenSharingButton.addFocusListener(new ButtonFocusDisplayer());
        this.screenSharingButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopBar.this.modeController.setMode(ViewMode.APPSHARE);
            }
        });
        this.grp.add(this.screenSharingButton);
        this.webTourButton = new ModeButton();
        this.webTourButton.setIcon(UIManager.getIcon("TopBar.webTourModeIcon"));
        this.webTourButton.setRolloverIcon(UIManager.getIcon("TopBar.webTourModeRolloverIcon"));
        this.webTourButton.setPressedIcon(UIManager.getIcon("TopBar.webTourModeRolloverIcon"));
        this.webTourButton.setSelectedIcon(UIManager.getIcon("TopBar.webTourModeSelectedIcon"));
        this.webTourButton.setRolloverSelectedIcon(UIManager.getIcon("TopBar.webTourModeSelectedIcon"));
        this.webTourButton.setDisabledIcon(UIManager.getIcon("TopBar.webTourModeDisabledIcon"));
        this.webTourButton.setDisabledSelectedIcon(UIManager.getIcon("TopBar.webTourModeDisabledSelectedIcon"));
        this.webTourButton.addFocusListener(new ButtonFocusDisplayer());
        this.webTourButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TopBar.this.modeController.setMode(ViewMode.WEBTOUR);
            }
        });
        this.grp.add(this.webTourButton);
        this.whiteboardButton.setEnabled(false);
        this.screenSharingButton.setEnabled(false);
        this.webTourButton.setEnabled(false);
        this.displayPanel = new JPanel(new GridBagLayout());
        this.displayPanel.setOpaque(false);
        this.add((Component)this.displayPanel, "Center");
        this.sessionActionPanel = new JPanel(new GridBagLayout());
        this.sessionActionPanel.setOpaque(false);
        this.sessionActionPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, UIManager.getColor("TopBar.separatorColor")), BorderFactory.createEmptyBorder(0, 12, 0, 12)));
        JPanel eastPanel = new JPanel(new BorderLayout());
        eastPanel.setOpaque(false);
        eastPanel.add((Component)this.sessionActionPanel, "West");
        this.brandingPanel = new JPanel(new GridBagLayout());
        this.brandingPanel.setOpaque(false);
        this.brandingPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, UIManager.getColor("TopBar.separatorColor")), BorderFactory.createEmptyBorder(0, 12, 0, 12)));
        eastPanel.add((Component)this.brandingPanel, "East");
        this.add((Component)eastPanel, "East");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.left = 0;
        this.optionsButton = new SMenuButton(UIManager.getIcon("TopBar.infoIcon"));
        this.optionsButton.putClientProperty("JButton.buttonType", "textured");
        this.optionsButton.setVisible(false);
        this.optionsButton.getMenu().addContainerListener(new ContainerListener(){

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (!(c instanceof JSeparator)) {
                    c.setFont(TopBar.this.optionsFont);
                    TopBar.this.optionsButton.setVisible(true);
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                if (!(e.getChild() instanceof JSeparator)) {
                    boolean vis = false;
                    for (Component c : TopBar.this.optionsButton.getMenu().getComponents()) {
                        if (c instanceof JSeparator || !c.isVisible()) continue;
                        vis = true;
                        break;
                    }
                    if (!vis) {
                        TopBar.this.optionsButton.setVisible(false);
                    }
                }
            }
        });
        this.sessionActionPanel.add((Component)this.optionsButton, gbc);
        Dimension ps = this.optionsButton.getPreferredSize();
        Icon ic = this.optionsButton.getIcon();
        int ins = ps.height - ic.getIconHeight();
        this.optionsButton.setPreferredSize(new Dimension(ic.getIconWidth() + ins, ps.height));
        Font f = UIManager.getFont("PopupMenu.font");
        this.optionsFont = f.deriveFont((float)(f.getSize() * 11 / 12));
        gbc.insets.left = 8;
        this.addContentButton = new SButton();
        this.addContentButton.setVisible(false);
        this.addContentButton.putClientProperty("JButton.buttonType", "textured");
        this.addContentButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                File[] fs = null;
                if (TopBar.this.preferences.getBooleanSetting("Gemini.useNativeFileDialog", false)) {
                    FileDialog d = new FileDialog(TopBar.this.parentProvider.getDialogParent(), TopBar.this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_ADD_CONTENT_TEXT), 0);
                    if (TopBar.this.lastAddContentFolder != null) {
                        d.setDirectory(TopBar.this.lastAddContentFolder.getAbsolutePath());
                    }
                    d.setVisible(true);
                    if (d.getFile() != null) {
                        File fo = new File(d.getDirectory());
                        TopBar.this.lastAddContentFolder = fo;
                        fs = new File[]{new File(fo, d.getFile())};
                    }
                } else {
                    JFileChooser ch = new JFileChooser(TopBar.this.lastAddContentFolder);
                    ch.setDialogTitle(TopBar.this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_ADD_CONTENT_TEXT));
                    ch.setMultiSelectionEnabled(true);
                    int result = ch.showOpenDialog(TopBar.this.parentProvider.getDialogParent());
                    if (result == 0 && (fs = ch.getSelectedFiles()).length != 0) {
                        TopBar.this.lastAddContentFolder = fs[0].getParentFile();
                    }
                }
                if (fs != null && fs.length != 0) {
                    TopBar.this.contentHandler.loadContent(fs);
                }
            }
        });
        this.sessionActionPanel.add((Component)this.addContentButton, gbc);
    }

    @Inject
    public void initLocationHandler(TopBarLocationHandler locationHandler) {
        locationHandler.setTopBar(this);
    }

    @Inject
    public void initContentHandler(ContentLoaderLocationHandler contentHandler) {
        this.contentHandler = contentHandler;
        contentHandler.addContentLoader(this);
    }

    @Inject
    public void initModeController(ModeController modeController) {
        modeController.addModeChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent e) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ViewMode mode = (ViewMode)e.getNewValue();
                        switch (mode) {
                            case WHITEBOARD: {
                                TopBar.this.whiteboardButton.setSelected(true);
                                break;
                            }
                            case APPSHARE: {
                                TopBar.this.screenSharingButton.setSelected(true);
                                break;
                            }
                            case WEBTOUR: {
                                TopBar.this.webTourButton.setSelected(true);
                            }
                        }
                    }
                });
            }
        });
        modeController.addModeEnabledListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(final PropertyChangeEvent e) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        ViewMode mode = (ViewMode)e.getSource();
                        boolean enabled = (Boolean)e.getNewValue();
                        switch (mode) {
                            case WHITEBOARD: {
                                TopBar.this.whiteboardButton.setEnabled(enabled);
                                break;
                            }
                            case APPSHARE: {
                                TopBar.this.screenSharingButton.setEnabled(enabled);
                                break;
                            }
                            case WEBTOUR: {
                                TopBar.this.webTourButton.setEnabled(enabled);
                            }
                        }
                    }
                });
            }
        });
        this.modeController = modeController;
    }

    @Inject
    public void initParentProvider(DialogParentProvider parentProvider) {
        this.parentProvider = parentProvider;
    }

    @Inject
    public void initPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Inject
    public void initI18n(I18nProvider provider) {
        this.i18n = provider.get((Object)this);
        this.whiteboardButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_WHITEBOARD_MODE_TIP));
        this.screenSharingButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_SCREEN_SHARING_MODE_TIP));
        this.webTourButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_WEB_TOUR_MODE_TIP));
        this.optionsButton.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_ADD_OPTIONS_TEXT));
        this.optionsButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_ADD_OPTIONS_TIP));
        this.addContentButton.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_ADD_CONTENT_TEXT));
        this.addContentButton.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TOPBAR_ADD_CONTENT_TIP));
    }

    @Inject
    public void initBranding(BrandingI18nProvider prov) {
        this.branding = prov;
        this.brandingLogo = new JLabel(this.branding.get().getIcon((PropertiesEnum)BrandingI18nProvider.Values.BRANDING_LOGO));
        this.brandingPanel.add(this.brandingLogo);
    }

    @Inject
    public void initImps(Imps imps) {
        ImpsAvailableListener<ViewAPI> listener = new ImpsAvailableListener<ViewAPI>(){

            public void available(ViewAPI api) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TopBar.this.modePanel.add(TopBar.this.whiteboardButton);
                        TopBar.this.modePanel.add(TopBar.this.screenSharingButton);
                        TopBar.this.modePanel.add(TopBar.this.webTourButton);
                    }
                });
            }

            public void removed(ViewAPI api) {
                SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TopBar.this.modePanel.remove(TopBar.this.whiteboardButton);
                        TopBar.this.modePanel.remove(TopBar.this.screenSharingButton);
                        TopBar.this.modePanel.remove(TopBar.this.webTourButton);
                    }
                });
            }
        };
        imps.addImpsAvailableListener((ImpsAvailableListener)listener, ViewAPI.class);
    }

    @Override
    public void setContentLoadable(boolean contentLoadable) {
        this.addContentButton.setVisible(contentLoadable);
        this.sessionActionPanel.revalidate();
    }

    @Override
    public boolean requestTopFocus() {
        Enumeration<AbstractButton> modeButtons = this.grp.getElements();
        while (modeButtons.hasMoreElements()) {
            AbstractButton btn = modeButtons.nextElement();
            if (!this.tryRequestFocus(btn)) continue;
            return true;
        }
        return false;
    }

    public boolean tryRequestFocus(AbstractButton btn) {
        if (btn != null && btn.isVisible() && btn.isFocusable() && btn.isEnabled()) {
            btn.requestFocus();
            return true;
        }
        return false;
    }

    public void addDisplayComponent(Component component) {
        GridBagConstraints gbc = new GridBagConstraints();
        this.displayPanel.add(component, gbc);
        this.displayPanel.revalidate();
        this.displayPanel.repaint();
    }

    public void removeDisplayComponent(Component component) {
        this.displayPanel.remove(component);
        this.displayPanel.revalidate();
        this.displayPanel.repaint();
    }

    public JPopupMenu getOptionsMenu() {
        return this.optionsButton.getMenu();
    }

    public void addSessionAction(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)component;
            b.putClientProperty("JButton.buttonType", "textured");
            b.setHorizontalTextPosition(10);
        }
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets.left = 8;
        this.sessionActionPanel.add(component, gbc);
        this.sessionActionPanel.revalidate();
    }

    public void removeSessionAction(Component component) {
        this.sessionActionPanel.remove(component);
        this.sessionActionPanel.revalidate();
    }

    private static class ModeButton
    extends SToggleButton {
        public ModeButton() {
            this.setContentAreaFilled(false);
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }
}

