/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.client.ApplicationUIProxy;
import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.moduleloading.LoadingStatus;
import com.elluminate.classroom.swing.AboutUIClerk;
import com.elluminate.classroom.swing.LoadingSplashContentPane;
import com.elluminate.classroom.swing.LoginContentPane;
import com.elluminate.classroom.swing.MainFrame;
import com.elluminate.classroom.swing.MainMenuBar;
import com.elluminate.classroom.swing.PreferencesUIClerk;
import com.elluminate.classroom.swing.SessionContentPane;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.SwingDebug;
import com.elluminate.classroom.swing.components.skin.shade.ShadeLookAndFeel;
import com.elluminate.classroom.swing.location.AudioNotificationLocationHandler;
import com.elluminate.classroom.swing.location.CaptionWindowLocationHandler;
import com.elluminate.classroom.swing.location.ContextualMenuLocation;
import com.elluminate.classroom.swing.location.HotKeyLocationHandler;
import com.elluminate.classroom.swing.location.VisualNotificationLocationHandler;
import com.elluminate.classroom.swing.location.WindowLocationHandler;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.extra.ExTRA;
import com.elluminate.framework.feature.ActionFeature;
import com.elluminate.framework.feature.BrokerAdapter;
import com.elluminate.framework.feature.ComponentFeature;
import com.elluminate.framework.feature.ComponentProvider;
import com.elluminate.framework.feature.Feature;
import com.elluminate.framework.feature.FeatureBroker;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.framework.feature.hints.HintingEngine;
import com.elluminate.framework.imps.Imps;
import com.elluminate.framework.imps.ImpsAPI;
import com.elluminate.groupware.imps.HideContentAPI;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.swing.DialogParentProviderImpl;
import com.elluminate.platform.Platform;
import com.elluminate.platform.PlatformIssues;
import com.elluminate.platform.macos.MacAppUtils;
import com.elluminate.util.ApplicationProperties;
import com.elluminate.util.I18n;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SerializerThread;
import com.elluminate.util.SwingRunner;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.VersionManager;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.LogSupport;
import com.elluminate.util.log.Logger;
import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.xml.sax.SAXException;

@Singleton
public class SwingApplicationUI
implements ApplicationUIProxy {
    private static final String LAST_VERSION_PROP = "collaborate.lastVersion";
    private static final String MAX_VERSION_PROP = "collaborate.maxVersion";
    private static boolean initalized = false;
    private volatile boolean running = false;
    private I18n i18n = I18n.create((Object)this);
    private MainFrame mainFrame;
    private FeatureBroker featureBroker;
    private Preferences preferences;
    private PreferencesUIClerk preferencesClerk;
    private AboutUIClerk aboutClerk;
    private Provider<MainMenuBar> menuProvider;
    @Inject
    private LoadingSplashContentPane splashContentPane;
    @Inject
    private LoginContentPane loginContentPane;
    @Inject
    private SessionContentPane sessionContentPane;
    private ContentCapture contentCapture;
    private ComponentFeature licenseFeature;
    private Logger logger;
    private SwingRunner swingRunner;
    private VersionManager versionMgr;
    private BrandingI18nProvider brandingProvider;
    private Imps imps;
    private HideContentImpl hideContentImps;
    private LoadingStatus loadingStatus;
    private ApplicationProperties appProps;
    private boolean showLicenseDialog = true;

    public static void preInitialize() {
        if (!SwingRunnerSupport.getInstance().isEventDispatchThread()) {
            throw new RuntimeException("not event thread");
        }
        if (!initalized) {
            initalized = true;
            if (Platform.getPlatform() == 2) {
                System.setProperty("apple.laf.useScreenMenuBar", PlatformIssues.MAC_SCREEN_MENU_ITEMS_DO_NOT_FIRE ? "false" : "true");
            }
            try {
                UIManager.setLookAndFeel(new ShadeLookAndFeel());
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            JPopupMenu.setDefaultLightWeightPopupEnabled(false);
        }
    }

    @Inject
    public SwingApplicationUI(MainFrame mainFrame, DialogParentProviderImpl parentProvider) {
        if (Platform.getOS() == 202) {
            MacAppUtils mac = new MacAppUtils();
            try {
                Class<?> clss = this.getClass();
                mac.setAboutHandler((Object)this, clss.getMethod("showAbout", new Class[0]));
                mac.setPreferencesHandler((Object)this, clss.getMethod("showPreferences", new Class[0]));
                mac.setQuitHandler((Object)this, clss.getMethod("requestQuit", new Class[0]));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.mainFrame = mainFrame;
        parentProvider.setDialogParent((Frame)mainFrame);
    }

    @Inject
    public void initLogger(Logger logger) {
        this.logger = logger;
        if (this.swingRunner != null && !this.swingRunner.isEventDispatchThread()) {
            logger.message((Object)this, "initLogger", "WARNING: Guice initialization not on Swing thread");
        }
    }

    @Inject
    public void initSwingRunner(SwingRunner swingRunner) {
        this.swingRunner = swingRunner;
        if (this.logger != null && !swingRunner.isEventDispatchThread()) {
            this.logger.message((Object)this, "initSwingRunner", "WARNING: Guice initialization not on Swing thread");
        }
    }

    @Inject
    public void initVersionManager(VersionManager versionMgr) {
        this.versionMgr = versionMgr;
    }

    @Inject
    public void initBranding(BrandingI18nProvider brandingProvider) {
        this.brandingProvider = brandingProvider;
    }

    @Inject
    public void initLoadingStatus(LoadingStatus loadingStatus) {
        this.loadingStatus = loadingStatus;
        loadingStatus.increment();
    }

    @Inject
    public void initFeatureBroker(FeatureBroker featureBroker) {
        this.featureBroker = featureBroker;
    }

    @Inject
    public void initPreferences(Preferences preferences) {
        this.preferences = preferences;
    }

    @Inject
    public void initPreferencesClerk(PreferencesUIClerk preferencesClerk) {
        this.preferencesClerk = preferencesClerk;
    }

    @Inject
    public void initAboutClerk(AboutUIClerk aboutClerk) {
        this.aboutClerk = aboutClerk;
    }

    @Inject
    public void initMenuBar(Provider<MainMenuBar> menuProvider) {
        this.menuProvider = menuProvider;
    }

    @Inject
    public void initContentCapture(ContentCaptureProvider contentCaptureProvider) {
        this.contentCapture = contentCaptureProvider.get();
    }

    @Inject
    public void initHandlers(BrokerAdapter adapter, WindowLocationHandler windowHandler, CaptionWindowLocationHandler captionWindowHandler, VisualNotificationLocationHandler visualNotification, AudioNotificationLocationHandler audioNotification, ContextualMenuLocation contextMenuHandler, HotKeyLocationHandler hotKeys) {
        adapter.addLocationHandler("window", (LocationHandler)windowHandler);
        captionWindowHandler.initializeLocationHandler();
        adapter.addLocationHandler("window.caption", (LocationHandler)captionWindowHandler);
        adapter.addLocationHandler("notify.visual", visualNotification.getLocationHandler());
        adapter.addLocationHandler("notify.audio", (LocationHandler)audioNotification);
        adapter.addLocationHandler("menus.context", (LocationHandler)contextMenuHandler);
        adapter.addLocationHandler("hotKey", (LocationHandler)hotKeys);
    }

    @Inject
    public void initImps(Imps imps) {
        this.imps = imps;
    }

    @Inject
    public void initHintEngine(HintingEngine engine) {
        try {
            engine.configure(this.getClass().getResource("GeminiHintConfig.xml"), this.i18n);
            if (SwingDebug.HINTING.show()) {
                LogSupport.message((Object)this, (String)"initHintEngine", (String)"Loaded hint configuration.");
            }
        }
        catch (SAXException sx) {
            LogSupport.exception((Object)this, (String)"initHintEngine", (Throwable)sx, (boolean)true, (String)"Unable to parse hint configuration");
        }
        catch (IOException e) {
            LogSupport.exception((Object)this, (String)"initHintEngine", (Throwable)e, (boolean)true, (String)"while loading hint configuration");
        }
    }

    @Inject
    public void initAppArguments(ApplicationProperties args) throws IOException {
        this.appProps = args;
    }

    public void showAbout() {
        this.aboutClerk.setAboutBoxVisible(true);
    }

    public void showPreferences() {
        this.preferencesClerk.setPreferencesDialogVisible(true);
    }

    public void requestQuit() {
        final ActionFeature f = (ActionFeature)this.featureBroker.getFeatureAs(ActionFeature.class, "/classroom/exit");
        if (f != null) {
            if (PlatformIssues.JWS_HAS_MULTIPLE_CONTEXTS) {
                SerializerThread.threadInvokeLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        f.fireActionFeatureListeners();
                    }
                });
            } else {
                f.fireActionFeatureListeners();
            }
        }
    }

    public void applicationStarting() {
        this.swingRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                I18n branding = SwingApplicationUI.this.brandingProvider.get();
                if (SwingApplicationUI.this.appProps != null && SwingApplicationUI.this.appProps.containsKey("noLicenseDialog")) {
                    SwingApplicationUI.this.showLicenseDialog = false;
                } else {
                    String shouldSuppress = branding.getString((PropertiesEnum)BrandingI18nProvider.Values.SUPPRESS_LICENSE_DIALOG);
                    SwingApplicationUI.this.showLicenseDialog = !Boolean.parseBoolean(shouldSuppress);
                }
                JFrame f = new JFrame();
                f.setUndecorated(true);
                if (Platform.getPlatform() != 2) {
                    f.setIconImage(branding.getImage((PropertiesEnum)BrandingI18nProvider.Values.COLLABORATE_SYS_ICON));
                }
                if (Platform.getPlatform() != 2) {
                    f.setTitle(branding.getString((PropertiesEnum)BrandingI18nProvider.Values.APP_NAME));
                }
                SwingApplicationUI.this.splashContentPane.setInitialFocus();
                SwingApplicationUI.this.splashContentPane.setFrame(f);
                SwingApplicationUI.this.splashContentPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
                f.setContentPane(SwingApplicationUI.this.splashContentPane);
                f.pack();
                f.setLocationRelativeTo(null);
                f.setVisible(true);
                SwingApplicationUI.this.contentCapture.addAlwaysEcho((JComponent)SwingApplicationUI.this.splashContentPane);
                SwingApplicationUI.this.contentCapture.iconifyIfNotEchoing((Frame)f);
                SwingApplicationUI.this.mainFrame.setJMenuBar((JMenuBar)SwingApplicationUI.this.menuProvider.get());
                SwingApplicationUI.this.mainFrame.setDefaultCloseOperation(0);
                SwingApplicationUI.this.mainFrame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        SwingApplicationUI.this.requestQuit();
                    }
                });
                if (SwingApplicationUI.this.contentCapture.isEchoingData()) {
                    SwingApplicationUI.this.checkLicenseAgreement();
                }
            }
        });
    }

    public void applicationLoading(int stepIndex, int stepCount, String description) {
        this.splashContentPane.setProgress(stepIndex, stepCount, description);
    }

    public void start() {
        this.hideContentImps = new HideContentImpl();
        this.imps.provideAPI(HideContentAPI.class, (ImpsAPI)this.hideContentImps);
    }

    public void attach() {
    }

    public void detach() {
    }

    public void stop() {
        if (this.hideContentImps != null) {
            this.imps.revokeAPI(HideContentAPI.class, (ImpsAPI)this.hideContentImps);
            if (this.hideContentImps.isContentAreaHidden()) {
                this.hideContentImps.restoreContentArea();
            }
            this.hideContentImps = null;
        }
    }

    public void applicationRunning() {
        this.running = true;
        Runnable r = new Runnable(){
            private Runnable doShowMainFrame = new Runnable(){

                @Override
                public void run() {
                    SwingApplicationUI.this.showMainFrame();
                }
            };

            @Override
            public void run() {
                if (SwingApplicationUI.this.splashContentPane.close()) {
                    SwingApplicationUI.this.swingRunner.invokeLater(this.doShowMainFrame);
                    return;
                }
                JFrame f = SwingApplicationUI.this.splashContentPane.getFrame();
                f.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosed(WindowEvent e) {
                        SwingApplicationUI.this.swingRunner.invokeLater(doShowMainFrame);
                    }
                });
            }
        };
        this.swingRunner.invokeLater(r);
    }

    public void requestOpenURI(URI uri) {
        System.out.println("****requestOpenURI: " + uri.toString());
        ActionFeature joinURIFeature = (ActionFeature)this.featureBroker.getFeatureAs(ActionFeature.class, "/online/joinWithURI");
        joinURIFeature.fireActionFeatureListeners((Object)uri);
    }

    public boolean quitApplicationRequested() {
        return true;
    }

    public void applicationQuitting() {
        if (!this.running) {
            return;
        }
        this.running = false;
        this.swingRunner.invokeLater(new Runnable(){

            @Override
            public void run() {
                SwingApplicationUI.this.mainFrame.setVisible(false);
                SwingApplicationUI.this.loadingStatus.increment();
                if (SwingApplicationUI.this.hideContentImps != null) {
                    SwingApplicationUI.this.hideContentImps.restoreContentArea();
                }
                SwingApplicationUI.this.mainFrame.dispose();
                SwingApplicationUI.this.loadingStatus.decrement();
            }
        });
    }

    private void checkLicenseAgreement() {
        block14: {
            try {
                String maxVers = this.preferences.getSetting(MAX_VERSION_PROP, "0.0");
                int majorVers = 0;
                try {
                    majorVers = VersionManager.parse((String)maxVers)[0];
                }
                catch (Throwable t) {
                    majorVers = 0;
                    this.logger.exception((Object)this, "checkLicenseAgreement", t, true, "Parsing collaborate.maxVersion '" + maxVers + "'");
                }
                if (this.versionMgr.getProductMajorVersion() <= majorVers || !this.showLicenseDialog) break block14;
                I18n branding = this.brandingProvider.get();
                String licenseTextUrl = null;
                String text = null;
                String licenseTextUrlResourceName = "License.licenseTextURL";
                try {
                    licenseTextUrl = branding.getStringLegacy(licenseTextUrlResourceName);
                    if (licenseTextUrl == null) {
                        return;
                    }
                    if ("".equals(licenseTextUrl)) {
                        return;
                    }
                    URL u2 = new URL(licenseTextUrl);
                }
                catch (MissingResourceException mre) {
                    return;
                }
                catch (MalformedURLException mux) {
                    this.logger.exception((Object)this, "checkLicenseAgreement", (Throwable)mux, true, "Parsing '" + licenseTextUrl + "'");
                    return;
                }
                String privacyCenterUrlResourceName = "License.privacyTextURL";
                String privacyTextUrl = null;
                try {
                    privacyTextUrl = branding.getStringLegacy(privacyCenterUrlResourceName);
                    if (privacyTextUrl == null) {
                        return;
                    }
                    if ("".equals(privacyTextUrl)) {
                        return;
                    }
                    URL u2 = new URL(privacyTextUrl);
                }
                catch (MissingResourceException mre) {
                    return;
                }
                catch (MalformedURLException mux) {
                    this.logger.exception((Object)this, "checkLicenseAgreement", (Throwable)mux, true, "Parsing '" + privacyTextUrl + "'");
                    return;
                }
                byte[] htmlBytes = branding.getResource("License.licensePanelText").load();
                text = MessageFormat.format(new String(htmlBytes), licenseTextUrl, privacyTextUrl);
                this.showLicenseAgreement(text);
            }
            catch (Throwable t) {
                this.logger.exception((Object)this, "checkPrivacyAgreement", t, true);
            }
        }
    }

    private void showLicenseAgreement(final String text) {
        String path = "/classroomSwing/licenseFeature";
        String name = this.i18n.getString((PropertiesEnum)StringsProperties.SWINGAPPLICATIONUI_LICENSEFEATURENAME);
        ComponentProvider provider = new ComponentProvider(){
            private LicensePanel panel = null;

            public Component get(ComponentFeature feature) {
                if (this.panel == null) {
                    this.panel = new LicensePanel(text);
                }
                return this.panel;
            }
        };
        this.licenseFeature = this.featureBroker.createComponentFeature((Object)this, path, provider, name, null);
        this.featureBroker.setFeaturePublished((Feature)this.licenseFeature, true);
    }

    private void acceptLicense() {
        String prevVers;
        String maxVers;
        if (this.licenseFeature != null) {
            this.featureBroker.setFeaturePublished((Feature)this.licenseFeature, false);
        }
        if (this.versionMgr.isNewerThan(maxVers = this.preferences.getSetting(MAX_VERSION_PROP, prevVers = this.preferences.getSetting(LAST_VERSION_PROP, "0.0")))) {
            maxVers = this.versionMgr.getVersionString(null);
        }
        this.preferences.setSetting(MAX_VERSION_PROP, maxVers);
    }

    private void showMainFrame() {
        if (this.running) {
            this.mainFrame.setContentPane(this.sessionContentPane);
            this.mainFrame.setVisible(true);
            this.contentCapture.iconifyIfNotEchoing((Frame)this.mainFrame);
            this.sessionContentPane.setupShortcuts();
            this.sessionContentPane.setInitialFocus();
        }
        this.preferences.setSetting(LAST_VERSION_PROP, this.versionMgr.getVersionString(null));
        this.loadingStatus.decrement();
    }

    private class HideContentImpl
    implements HideContentAPI {
        private final Object locker = new Object();
        private RestoreContentInfo restoreState = null;

        private HideContentImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean isContentAreaHidden() {
            Object object = this.locker;
            synchronized (object) {
                return this.restoreState != null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void hideContentArea() {
            RestoreContentInfo info;
            RestoreContentInfo neoInfo = new RestoreContentInfo();
            Object object = this.locker;
            synchronized (object) {
                if (this.restoreState != null) {
                    return;
                }
                info = neoInfo;
                this.restoreState = neoInfo;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    info.hide();
                }
            };
            SwingApplicationUI.this.swingRunner.invokeOnEventThread(r);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void restoreContentArea() {
            RestoreContentInfo info;
            Object object = this.locker;
            synchronized (object) {
                if (this.restoreState == null) {
                    return;
                }
                info = this.restoreState;
                this.restoreState = null;
            }
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    info.restore();
                }
            };
            SwingApplicationUI.this.swingRunner.invokeOnEventThread(r);
        }

        public String getProvider() {
            return "Gemini UI";
        }

        public byte getTier() {
            return 32;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.locker;
            synchronized (object) {
                return "HideContentImpl: hidden=" + this.isContentAreaHidden() + " state=" + this.restoreState;
            }
        }
    }

    private class LicensePanel
    extends JPanel {
        private JTextPane textPane;
        private JButton acceptBtn;
        private JButton cancelBtn;
        private Border border;

        LicensePanel(String licenseText) {
            super(new BorderLayout(0, 6));
            this.textPane = new JTextPane();
            this.acceptBtn = new JButton();
            this.cancelBtn = new JButton();
            this.border = null;
            if (licenseText == null) {
                throw new IllegalArgumentException("null license text");
            }
            this.textPane.setEditable(false);
            this.textPane.setContentType("text/html");
            this.textPane.setText(licenseText);
            this.textPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            I18n branding = SwingApplicationUI.this.brandingProvider.get();
            this.acceptBtn.setText(branding.getStringLegacy("License.licenseAcceptBtn"));
            this.cancelBtn.setText(branding.getStringLegacy("License.licenseCancelBtn"));
            this.textPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent ev) {
                    if (ev.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        LicensePanel.this.showInBrowser(ev.getURL());
                    }
                }
            });
            this.acceptBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    SwingApplicationUI.this.acceptLicense();
                    ExTRA.flushExTRAProperties();
                }
            });
            this.cancelBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    SwingApplicationUI.this.logger.message((Object)this, "actionPerformed", "License rejected, exiting application.");
                    System.exit(0);
                }
            });
            final JScrollPane textScroller = new JScrollPane();
            textScroller.setVerticalScrollBarPolicy(21);
            textScroller.setHorizontalScrollBarPolicy(31);
            textScroller.getViewport().setPreferredSize(new Dimension(4096, 95));
            this.border = textScroller.getBorder();
            ComponentAdapter sbl = new ComponentAdapter(){

                @Override
                public void componentShown(ComponentEvent ev) {
                    textScroller.setBorder(LicensePanel.this.border);
                }

                @Override
                public void componentHidden(ComponentEvent ev) {
                    textScroller.setBorder(null);
                }
            };
            textScroller.getVerticalScrollBar().addComponentListener(sbl);
            textScroller.setBorder(null);
            textScroller.setViewportView(this.textPane);
            textScroller.setVerticalScrollBarPolicy(20);
            JPanel buttonPane = new JPanel(new FlowLayout(1));
            buttonPane.setOpaque(false);
            buttonPane.add(this.cancelBtn);
            buttonPane.add(this.acceptBtn);
            this.add((Component)textScroller, "Center");
            this.add((Component)buttonPane, "South");
            this.setOpaque(false);
            this.setBorder(BorderFactory.createEmptyBorder(6, 12, 6, 12));
            this.addAncestorListener(new AncestorListener(){

                @Override
                public void ancestorAdded(AncestorEvent ev) {
                    Runnable r = new Runnable(){

                        @Override
                        public void run() {
                            LicensePanel.this.textPane.scrollRectToVisible(new Rectangle(0, 0, 8, 8));
                        }
                    };
                    SwingApplicationUI.this.swingRunner.invokeLater(r);
                }

                @Override
                public void ancestorRemoved(AncestorEvent ev) {
                }

                @Override
                public void ancestorMoved(AncestorEvent ev) {
                }
            });
        }

        private void showInBrowser(URL url) {
            try {
                BrowserUtil.gotoURL((URL)url);
            }
            catch (IOException iox) {
                String title = SwingApplicationUI.this.i18n.getString((PropertiesEnum)StringsProperties.SWINGAPPLICATIONUI_BROWSERFAILEDTITLE);
                String msg = SwingApplicationUI.this.i18n.getString((PropertiesEnum)StringsProperties.SWINGAPPLICATIONUI_BROWSERFAILEDMSG, new Object[]{url.toString(), iox.toString()});
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.textPane, (Object)msg, (String)title, (int)0);
            }
        }

        private void showInDialog(URL url) {
            try {
                JTextPane text = new JTextPane();
                text.setPage(url);
                text.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
                JScrollPane scroller = new JScrollPane(text);
                scroller.setPreferredSize(new Dimension(800, 600));
                scroller.setBorder(BorderFactory.createEmptyBorder(24, 24, 24, 24));
                JPanel content = new JPanel(new BorderLayout());
                content.add((Component)scroller, "Center");
                JFrame parent = SwingApplicationUI.this.splashContentPane.getFrame();
                JDialog dlog = new JDialog((Frame)parent, true);
                dlog.setContentPane(content);
                dlog.setModal(true);
                dlog.pack();
                dlog.setLocationRelativeTo(parent);
                dlog.show();
            }
            catch (IOException iox) {
                String title = SwingApplicationUI.this.i18n.getString((PropertiesEnum)StringsProperties.SWINGAPPLICATIONUI_BROWSERFAILEDTITLE);
                String msg = SwingApplicationUI.this.i18n.getString((PropertiesEnum)StringsProperties.SWINGAPPLICATIONUI_BROWSERFAILEDMSG, new Object[]{url.toString(), iox.toString()});
                ModalDialog.showMessageDialogAsync((int)-1, (Component)this.textPane, (Object)msg, (String)title, (int)0);
            }
        }
    }

    private class RestoreContentInfo {
        private JFrame frame;
        private int frameState;
        private Rectangle frameBounds;
        private SessionContentPane content;
        private int sideBarDividerPos;

        private RestoreContentInfo() {
            this.frame = SwingApplicationUI.this.mainFrame;
            this.frameState = SwingApplicationUI.this.mainFrame.getExtendedState();
            this.frameBounds = SwingApplicationUI.this.mainFrame.getBounds();
            this.content = SwingApplicationUI.this.sessionContentPane;
            this.sideBarDividerPos = SwingApplicationUI.this.sessionContentPane.getSideBarDividerPosition();
        }

        void hide() {
            JMenuBar menuBar;
            Dimension min;
            if ((this.frameState & 1) != 0) {
                return;
            }
            if ((this.frameState & 6) != 0) {
                this.frame.setExtendedState(0);
                this.frameBounds = this.frame.getBounds();
            }
            Rectangle b = new Rectangle(this.frameBounds);
            Insets frameInsets = this.frame.getInsets();
            int w = SwingApplicationUI.this.sessionContentPane.getSideBarDividerPosition();
            if (Platform.getPlatform() != 2 && (min = (menuBar = this.frame.getJMenuBar()).getPreferredSize()) != null) {
                w = Math.max(w, min.width);
            }
            SwingApplicationUI.this.sessionContentPane.hideContentArea();
            if ((w += frameInsets.left + frameInsets.right) < b.width) {
                b.width = w;
                SwingApplicationUI.this.mainFrame.setBounds(b);
                Runnable r = new Runnable(){
                    private Rectangle bounds;
                    {
                        this.bounds = new Rectangle(RestoreContentInfo.this.frameBounds);
                    }

                    @Override
                    public void run() {
                        SwingApplicationUI.this.mainFrame.updateBoundsPreference(this.bounds);
                    }
                };
                SwingApplicationUI.this.swingRunner.invokeLater(r);
            }
        }

        void restore() {
            this.frame.setBounds(this.frameBounds);
            final Runnable r2 = new Runnable(){

                @Override
                public void run() {
                    RestoreContentInfo.this.content.setSideBarDividerPosition(RestoreContentInfo.this.sideBarDividerPos);
                }
            };
            Runnable r1 = new Runnable(){

                @Override
                public void run() {
                    RestoreContentInfo.this.frame.setExtendedState(RestoreContentInfo.this.frameState);
                    SwingApplicationUI.this.swingRunner.invokeLater(r2);
                }
            };
            int curState = this.frame.getExtendedState();
            SwingApplicationUI.this.swingRunner.invokeLater(curState != this.frameState ? r1 : r2);
        }

        public String toString() {
            return this.getClass().getSimpleName() + ": frame='" + this.frame.getTitle() + "',bounds=" + this.frameBounds + ",content=" + this.content.hashCode() + ",divider=" + this.sideBarDividerPos;
        }
    }
}

