/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.swing.RectDistance;
import com.elluminate.classroom.swing.debug.FocusDebugHighlight;
import com.elluminate.classroom.swing.debug.ShadeUiDebugFlags;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.session.CRSession;
import com.elluminate.framework.session.listener.CRParticipantAdapter;
import com.elluminate.framework.session.listener.CRParticipantListener;
import com.elluminate.framework.session.listener.event.CRParticipantEvent;
import com.elluminate.platform.Platform;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.Preferences;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;

public class MainFrame
extends JFrame {
    private static final String BOUNDS_PREF = "Gemini.mainFrame.bounds";
    private I18n branding;
    private I18n i18n;
    private CRSession session;
    private Preferences preferences;
    private ContentCapture contentCapture;

    @Inject
    public void initContentCaptureProvider(ContentCaptureProvider contentCaptureProvider) {
        this.contentCapture = contentCaptureProvider.get();
    }

    @Inject
    public MainFrame(BrandingI18nProvider brandingProvider, I18nProvider i18nProvider, CRSession session, Preferences preferences) {
        Rectangle b;
        this.branding = brandingProvider.get();
        this.i18n = i18nProvider.get((Object)this);
        this.session = session;
        this.preferences = preferences;
        if (Platform.getPlatform() != 2) {
            this.setIconImage(this.branding.getImage((PropertiesEnum)BrandingI18nProvider.Values.COLLABORATE_SYS_ICON));
        }
        if (Platform.getPlatform() != 2) {
            this.setTitle(this.branding.getString((PropertiesEnum)BrandingI18nProvider.Values.APP_NAME));
        }
        if ((b = preferences.getRectangleSetting(BOUNDS_PREF, null)) == null) {
            Dimension BASE_SCREEN_SIZE = new Dimension(1024, 768);
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            GraphicsConfiguration gc = gd.getDefaultConfiguration();
            Insets ins = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            b = new Rectangle(ins.left, ins.top, BASE_SCREEN_SIZE.width - ins.left - ins.right, BASE_SCREEN_SIZE.height - ins.top - ins.bottom);
        }
        this.ensureOnScreen(b);
        this.setBounds(b);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                MainFrame.this.updateBoundsPreference();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                MainFrame.this.updateBoundsPreference();
            }
        });
        session.addParticipantListener((CRParticipantListener)new CRParticipantAdapter(){

            public void onMeAdded(CRParticipantEvent e) {
                MainFrame.this.updateTitle();
            }

            public void onMeRemoved(CRParticipantEvent e) {
                MainFrame.this.updateTitle();
            }
        });
        if (ShadeUiDebugFlags.SHADE_DEBUG.show()) {
            new FocusDebugHighlight().registerGlobalFocusListener();
        }
    }

    private void updateBoundsPreference() {
        this.preferences.setSetting(BOUNDS_PREF, this.getBounds());
    }

    void updateBoundsPreference(Rectangle bounds) {
        this.preferences.setSetting(BOUNDS_PREF, bounds);
    }

    private void updateTitle() {
        String sessionName;
        StringBuilder b = new StringBuilder();
        if (Platform.getPlatform() != 2) {
            b.append(this.branding.getString((PropertiesEnum)BrandingI18nProvider.Values.APP_NAME));
        }
        if ((sessionName = this.session.getSessionName()) != null && sessionName.length() != 0 && b.length() != 0) {
            b.append(" \u2013 ");
        }
        b.append(sessionName);
        this.setTitle(b.toString());
        this.contentCapture.setSessionName(sessionName);
    }

    private void ensureOnScreen(Rectangle rect) {
        GraphicsDevice[] gds;
        ArrayList<Rectangle> screens = new ArrayList<Rectangle>();
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        for (GraphicsDevice gd : gds = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()) {
            GraphicsConfiguration config = gd.getDefaultConfiguration();
            Rectangle screenRect = config.getBounds();
            Insets insets = toolkit.getScreenInsets(config);
            screenRect.x += insets.left;
            screenRect.y += insets.top;
            screenRect.width -= insets.left + insets.right;
            screenRect.height -= insets.top + insets.bottom;
            screens.add(screenRect);
        }
        if (this.isOnScreen(rect, screens)) {
            return;
        }
        RectDistance best = null;
        for (Rectangle screen : screens) {
            if (screen.width < rect.width || screen.height < rect.height) continue;
            RectDistance d = new RectDistance(rect, screen);
            best = d.nearer(best);
        }
        if (best != null) {
            best.apply(rect);
            return;
        }
        Rectangle main = null;
        Point origin = new Point(0, 0);
        for (Rectangle screen : screens) {
            if (main == null) {
                main = screen;
                continue;
            }
            if (!(screen.getLocation().distance(origin) < main.getLocation().distance(origin))) continue;
            main = screen;
        }
        rect.x = main.x + 20;
        rect.y = main.y + 20;
        rect.width = main.width - 40;
        rect.height = main.height - 40;
    }

    private boolean isOnScreen(Rectangle r, List<Rectangle> screens) {
        for (Rectangle screen : screens) {
            if (!screen.contains(r)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setContentPane(Container contentPane) {
        super.setContentPane(contentPane);
    }
}

