/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.classroom.swing;

import com.elluminate.classroom.client.BrandingI18nProvider;
import com.elluminate.classroom.swing.SplashContentPane;
import com.elluminate.classroom.swing.StringsProperties;
import com.elluminate.classroom.swing.location.SplashLocationHandler;
import com.elluminate.contentcapture.ContentCapture;
import com.elluminate.contentcapture.ContentCaptureProvider;
import com.elluminate.framework.feature.LocationHandler;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nProvider;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.SwingRunnerSupport;
import com.elluminate.util.VersionManager;
import com.google.inject.Inject;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class LoadingSplashContentPane
extends SplashContentPane {
    private JLabel progressBar;
    private JFrame splashFrame;
    private JPanel loadingPanel;
    private int lastLevel;
    private Component currentlyDisplayed;
    private boolean readyToClose = true;
    private boolean closeWhenReady = false;
    private SplashLocationHandler locationHandler;
    private ContentCapture contentCapture;
    private I18n i18n;

    @Inject
    public LoadingSplashContentPane(VersionManager versionManager, BrandingI18nProvider brandingProvider, ContentCaptureProvider contentCaptureProvider, I18nProvider provider) {
        super(versionManager, brandingProvider);
        this.contentCapture = contentCaptureProvider.get();
        this.i18n = provider.get((Object)this);
        this.loadingPanel = new JPanel(new BorderLayout());
        this.loadingPanel.setPreferredSize(new Dimension(100, 80));
        this.loadingPanel.setOpaque(false);
        this.progressBar = new JLabel(this.branding.getIcon((PropertiesEnum)BrandingI18nProvider.Values.SPLASH_PROGRESS_00));
        String progressBarText = this.i18n.getString((PropertiesEnum)StringsProperties.LOADINGSPLASHSCREEN_PROGRESSTEXT);
        this.progressLabel = new JLabel(progressBarText);
        this.progressLabel.getAccessibleContext().setAccessibleName(progressBarText);
        this.progressLabel.setBorder(BorderFactory.createEmptyBorder(0, 55, 35, 0));
        this.progressLabel.setFont(new Font("Arial", 0, 11));
        this.progressLabel.setForeground(FONT_LABEL_COLOR);
        this.loadingPanel.add((Component)this.progressBar, "North");
        this.loadingPanel.add((Component)this.progressLabel, "South");
        this.left.add((Component)this.loadingPanel, "South");
        this.currentlyDisplayed = this.loadingPanel;
        this.left.requestFocusInWindow();
        this.progressLabel.requestFocusInWindow();
    }

    @Inject
    public void initLocationHandler(SplashLocationHandler locationHandler) {
        this.locationHandler = locationHandler;
        locationHandler.setSplashContentPane(this);
    }

    public LocationHandler getLocationHandler() {
        return this.locationHandler;
    }

    public boolean isReadyToClose() {
        return this.readyToClose;
    }

    public void setReadyToClose(boolean b) {
        this.readyToClose = b;
        if (this.readyToClose && this.closeWhenReady) {
            this.close();
        }
    }

    public boolean isDisplayedComponent(Component c) {
        return c == this.currentlyDisplayed;
    }

    public void addDisplayComponent(Component c) {
        if (c == this.currentlyDisplayed) {
            return;
        }
        if (this.currentlyDisplayed != null) {
            this.left.remove(this.currentlyDisplayed);
        }
        this.left.add(c, "South");
        this.currentlyDisplayed = c;
        this.left.revalidate();
        this.left.repaint();
    }

    public void setFrame(JFrame splashFrame) {
        this.splashFrame = splashFrame;
    }

    public JFrame getFrame() {
        return this.splashFrame;
    }

    public boolean close() {
        if (!this.readyToClose) {
            this.closeWhenReady = true;
            return false;
        }
        this.contentCapture.removeAlwaysEcho((JComponent)this);
        this.splashFrame.dispose();
        return true;
    }

    public void removeDisplayComponent(Component c) {
        if (c != this.currentlyDisplayed) {
            throw new IllegalStateException("Component to be removed is not currently displayed.");
        }
        if (this.currentlyDisplayed != null) {
            this.left.remove(this.currentlyDisplayed);
        }
        this.currentlyDisplayed = null;
        this.left.revalidate();
        this.left.repaint();
    }

    public void restoreOriginalDisplayComponent() {
        this.addDisplayComponent(this.loadingPanel);
    }

    public void setProgress(final int value, final int max, String description) {
        SwingRunnerSupport.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                int level = value / (max / 5);
                double loadPercent = Math.round(100 * value / max);
                String loadPercentText = loadPercent + "%";
                if (LoadingSplashContentPane.this.lastLevel != level && level <= 5) {
                    LoadingSplashContentPane.this.loadingPanel.remove(LoadingSplashContentPane.this.progressBar);
                    String s = "Splash.progress" + level;
                    LoadingSplashContentPane.this.progressBar = new JLabel(LoadingSplashContentPane.this.branding.getIcon(s));
                    String updatedProgressText = loadPercentText;
                    LoadingSplashContentPane.this.progressBar.getAccessibleContext().firePropertyChange("AccessibleDescription", "", updatedProgressText);
                    LoadingSplashContentPane.this.loadingPanel.add((Component)LoadingSplashContentPane.this.progressBar, "North");
                    LoadingSplashContentPane.this.loadingPanel.revalidate();
                    LoadingSplashContentPane.this.loadingPanel.repaint();
                }
                LoadingSplashContentPane.this.lastLevel = level;
            }
        });
    }
}

