/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony.bridge;

import com.elluminate.groupware.telephony.TelephonyMessage;
import com.elluminate.groupware.telephony.TelephonyProtocol;
import com.elluminate.jinx.AttachableClient;
import com.elluminate.jinx.Channel;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.ChannelEvent;
import com.elluminate.jinx.ChannelListener;
import com.elluminate.jinx.ClientEvent;
import com.elluminate.jinx.ClientInfo;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.ClientListener;
import com.elluminate.jinx.JinxChannelException;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.log.LogSupport;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class BridgeController
implements ChannelListener,
ChannelDataListener,
ClientListener,
PropertyChangeListener {
    private static final int AWAITING_PLACE_CALL = 0;
    private static final int CALL_IN_PROGRESS = 1;
    private static final int DISCONNECT_RECEIVED = 2;
    private static final int CLI_HANGUP_RECEIVED = 3;
    private static final int DISCONNECT_ACK_EXPECTED = 4;
    private static final int TERMINATED = 5;
    private static final int TWO_MINUTES = 120000;
    private static final int THIRTY_SECONDS = 30000;
    private AttachableClient client = null;
    private ClientList clientList = null;
    private Channel telephonyChannel = null;
    private TelephonyProtocol protocol = new TelephonyProtocol();
    private long startTime = 0L;
    private long stopTime = 0L;
    private volatile int connectionStatus = 1;
    private I18nMessage connectionStatusMsg = null;
    private volatile String failureMsg = null;
    private Object stateLock = new Object();
    private volatile int callState = 0;
    private Integer callID;
    private boolean isHangupOnRemoveClient = false;
    private LightweightTimer terminateCallTimer = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            BridgeController.this.terminateTheCall(true);
        }
    });
    private LightweightTimer terminateTimer = new LightweightTimer(new Runnable(){

        @Override
        public void run() {
            BridgeController.this.terminate();
        }
    });
    private I18n i18n = I18n.create(TelephonyMessage.class);
    private static final CallQueue activeCallQueue = new CallQueue();

    private void configure() {
        this.clientList = this.client.getClientList();
        this.clientList.addClientListener((ClientListener)this);
        this.clientList.addClientPropertyChangeListener("Telephony.audioMode", (PropertyChangeListener)this);
        this.terminateTimer.scheduleIn(120000L);
    }

    private void unconfigure() {
        this.clientList.removeClientListener((ClientListener)this);
        this.clientList.removeClientPropertyChangeListener("Telephony.audioMode", (PropertyChangeListener)this);
    }

    public void channelStateChanged(ChannelEvent event) {
        if (event.getChannel().equalsIgnoreCase("telephony") && event.getState() == 1) {
            this.terminateTimer.scheduleIn(120000L);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        short who = this.clientList.getPropertyOwner(e.getSource());
        if (who != this.client.getAddress()) {
            return;
        }
        if ("Telephony.audioMode".equals(e.getPropertyName())) {
            Integer mode = (Integer)e.getNewValue();
            if (mode == null || mode != 3) {
                return;
            }
            try {
                this.telephonyChannel = this.client.acquireChannel("telephony", (byte)2, (ChannelListener)this, (ChannelDataListener)this);
                this.telephonyChannel.setProtocol((JinxProtocol)this.protocol);
            }
            catch (JinxChannelException cx) {
                LogSupport.exception((Object)this, (String)"configure", (Throwable)cx, (boolean)true);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onChannelData(ChannelDataEvent event) {
        try {
            TelephonyMessage msg = new TelephonyMessage(event);
            switch (msg.getCommand()) {
                case 4: {
                    if (this.callState == 4) {
                        this.terminateTheCall(false);
                        break;
                    }
                    LogSupport.error((Object)this, (String)"onChannelData", (String)"the DISCONNECT_ACK_CMD was not expected, ignoring.");
                    break;
                }
                case 33: {
                    if (this.callState != 0) {
                        this.sendConnectAckCmd(2, this.i18n.getMessageLegacy("TelephonyMessage.CallAlreadyInProgress"));
                        return;
                    }
                    if (!this.placeCall(msg)) {
                        this.terminate();
                    }
                    break;
                }
                case 35: {
                    Object object = this.stateLock;
                    synchronized (object) {
                        if (this.callState != 5) {
                            this.callState = 2;
                        }
                    }
                    this.hangup();
                    break;
                }
                case 14: {
                    break;
                }
                case 36: {
                    break;
                }
                case 37: {
                    break;
                }
                default: {
                    LogSupport.error((Object)this, (String)"", (String)("Invalid command: " + msg));
                    return;
                }
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"onChannelData", (Throwable)t, (boolean)true, (String)("Error processing event: " + event));
        }
    }

    public void onAddClient(ClientEvent e) {
        ClientInfo ci = this.clientList.get(e.getAddress());
        if (ci != null && ci.isMe()) {
            ci.setProperty("Telephony.audioMode", 3);
        }
    }

    public void onRemoveClient(ClientEvent e) {
        ClientInfo ci = this.clientList.get(e.getAddress());
        if (ci != null && ci.isMe()) {
            this.isHangupOnRemoveClient = true;
            this.hangup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hangUpCall() {
        boolean doHangup = false;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.callState == 0) {
                this.callState = 3;
                doHangup = true;
            }
        }
        if (doHangup) {
            this.terminate();
            this.logCallFailure(this.i18n.getStringLegacy("TelephonyMessage.CLIHangupBeforePlaceCall"));
            return true;
        }
        if (this.callState == 1) {
            this.sendRemoteDisconnectCmd(this.i18n.getMessageLegacy("TelephonyMessage.RemoteDisconnect"));
            this.hangup();
            return true;
        }
        return false;
    }

    private void hangup() {
        this.terminateCallTimer.scheduleIn(30000L);
    }

    private void terminateTheCall(boolean forceDisconnect) {
    }

    private boolean placeCall(TelephonyMessage msg) {
        return false;
    }

    private void logCallFailure(String failureMsg) {
        this.failureMsg = this.failureMsg == null ? failureMsg : this.failureMsg + "\n" + failureMsg;
    }

    private void sendConnectAckCmd(int status, I18nMessage i18nMsg) {
        TelephonyMessage msg = TelephonyMessage.createCallAckMsg(status, i18nMsg);
        this.sendCmdOnTelephonyChannel(msg);
    }

    private void sendConnectionStatusCmd(int status, I18nMessage i18nMsg) {
        TelephonyMessage msg = TelephonyMessage.createConnectionStatusMsg(status, i18nMsg);
        this.sendCmdOnTelephonyChannel(msg);
        this.connectionStatus = status;
        this.connectionStatusMsg = i18nMsg;
    }

    private void sendDisconnectAckCmd(I18nMessage i18nMsg) {
        TelephonyMessage msg = TelephonyMessage.createDisconnectAckMsg(true, i18nMsg);
        this.sendCmdOnTelephonyChannel(msg);
        TelephonyMessage.createDisconnectAckMsg(true, i18nMsg);
        ChannelDataEvent event = null;
        try {
            event = msg.createEventRec(this, (short)0);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendDisconnectAckCmd", (Throwable)ex, (boolean)true);
        }
        if (event != null) {
            this.telephonyChannel.onChannelData(event);
        }
    }

    private void sendRemoteDisconnectCmd(I18nMessage i18nMsg) {
        this.terminateCallTimer.scheduleIn(30000L);
        this.callState = 4;
        TelephonyMessage msg = TelephonyMessage.createRemoteDisconnectMsg(i18nMsg);
        this.sendCmdOnTelephonyChannel(msg);
    }

    private void sendCmdOnTelephonyChannel(TelephonyMessage msg) {
        ChannelDataEvent event = null;
        try {
            event = msg.createEventRec(this, (short)0);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"sendDisconnectAckCmd", (Throwable)ex, (boolean)true);
        }
        if (event != null) {
            try {
                this.telephonyChannel.onChannelData(event);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void statusChanged(int status, String sipMsg, I18nMessage statusMsg) {
    }

    private String getSessionName() {
        return this.client.getConferenceName().getCanonicalName();
    }

    private String getLogString(boolean startOnly, boolean includeDuration) {
        String sessionName = this.getSessionName();
        Object sipURI = null;
        boolean failed = this.failureMsg != null;
        StringBuilder sb = new StringBuilder();
        sb.append(sessionName);
        if (this.startTime > 0L) {
            String startTimeStr = this.getDateString(this.startTime);
            sb.append(" Start time: ");
            sb.append(startTimeStr);
            if (includeDuration) {
                long duration = System.currentTimeMillis() - this.startTime;
                if (this.stopTime > this.startTime) {
                    duration = this.stopTime - this.startTime;
                }
                sb.append(" Duration: ");
                sb.append(duration / 1000L);
                sb.append(" seconds ");
            }
        }
        if (startOnly) {
            return sb.toString();
        }
        if (this.stopTime > 0L) {
            String stopTimeStr = this.getDateString(this.stopTime);
            sb.append(" stop time: ");
            sb.append(stopTimeStr);
        }
        if (failed) {
            sb.append(" FAILED with reason: ");
            sb.append(this.failureMsg);
        }
        return sb.toString();
    }

    public String toString() {
        return "BridgeController for " + this.getSessionName();
    }

    private String getDateString(long dateTime) {
        Date date = new Date(dateTime);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy.MM.dd HH:mm:ss");
        return fmt.format(date);
    }

    private void terminate() {
        this.terminateCallTimer.cancel();
        this.terminateTimer.cancel();
        if (this.callState == 5) {
            return;
        }
        if (this.callState == 1) {
            this.hangup();
            this.callState = 3;
            LogSupport.error((Object)this, (String)"terminate", (String)"In terminate with callstate as call in progress. Hanging up");
            return;
        }
        this.callState = 5;
        LogSupport.message((String)("CALL_COMPLETE: " + this.getLogString(false, true)));
        try {
            if (this.startTime != 0L) {
                long callDurationInSeconds = System.currentTimeMillis() - this.startTime;
                callDurationInSeconds /= 1000L;
            }
        }
        catch (Throwable t) {
            LogSupport.exception((Object)this, (String)"terminate", (Throwable)t, (boolean)true);
        }
        BridgeController.activeCallQueue.removeBridgeController(this);
        if (!this.isHangupOnRemoveClient) {
            try {
                Thread.sleep(10L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.client.hangup();
        }
        this.unconfigure();
    }

    public static String getCallListString() {
        Object[] list = BridgeController.activeCallQueue.getActiveControllerList();
        StringBuffer sb = new StringBuffer();
        sb.append(list.length);
        sb.append(" active calls");
        for (int i = 0; i < list.length; ++i) {
            sb.append("\n");
            sb.append(((BridgeController)list[i]).getLogString(true, true));
        }
        return sb.toString();
    }

    public static boolean hangupCallByName(String sessionName) {
        BridgeController controller = BridgeController.activeCallQueue.getControllerByName(sessionName);
        if (controller == null) {
            return false;
        }
        controller.hangUpCall();
        return true;
    }

    public static boolean getStatusByName(String sessionName, StringBuffer sb) {
        BridgeController controller = BridgeController.activeCallQueue.getControllerByName(sessionName);
        if (controller == null) {
            return false;
        }
        sb.append("Status: ");
        sb.append(TelephonyProtocol.getConnectionStatusName(controller.connectionStatus));
        if (controller.connectionStatusMsg != null) {
            sb.append(" with message ");
            sb.append(controller.connectionStatusMsg.toString());
        }
        return true;
    }

    public static void hangupAllCalls(boolean waitForCallComplete) {
        Object[] controllers = BridgeController.activeCallQueue.getActiveControllerList();
        if (controllers != null) {
            for (int i = 0; i < controllers.length; ++i) {
                ((BridgeController)controllers[i]).hangUpCall();
            }
        }
        if (waitForCallComplete) {
            int shutdownCount = 0;
            while (controllers.length > 0 && shutdownCount < 20) {
                ++shutdownCount;
                try {
                    Thread.sleep(400L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                controllers = BridgeController.activeCallQueue.getActiveControllerList();
            }
        }
    }

    public static int getMaxConcurrentCalls() {
        return BridgeController.activeCallQueue.getMaxConcurrentCalls();
    }

    public static int getCurrentCallCount() {
        return BridgeController.activeCallQueue.getCurrentCallCount();
    }

    private static class CallQueue {
        private Map byNameMap = new HashMap();
        private Map byIDMap = new HashMap();
        private int lastUsedID = 0;
        private Object mapLockObject = new Object();
        private int maxConcurrentCalls = 0;

        CallQueue() {
        }

        private int getMaxConcurrentCalls() {
            return this.maxConcurrentCalls;
        }

        private int getCurrentCallCount() {
            return this.byIDMap.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Integer addBridgeController(BridgeController controller) {
            Object object = this.mapLockObject;
            synchronized (object) {
                Integer callID = new Integer(this.lastUsedID++);
                if (this.lastUsedID >= Integer.MAX_VALUE) {
                    this.lastUsedID = 1;
                }
                this.byIDMap.put(callID, controller);
                int totalCalls = this.byIDMap.size();
                if (totalCalls > this.maxConcurrentCalls) {
                    this.maxConcurrentCalls = totalCalls;
                }
                String sessionName = controller.getSessionName();
                try {
                    this.byNameMap.put(sessionName, controller);
                }
                catch (Throwable ignorable) {
                    // empty catch block
                }
                return callID;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeBridgeController(BridgeController controller) {
            Object object = this.mapLockObject;
            synchronized (object) {
                try {
                    if (this.byIDMap.containsKey(controller.callID)) {
                        this.byIDMap.remove(controller.callID);
                    }
                }
                catch (Throwable ignorable) {
                    // empty catch block
                }
                try {
                    if (this.byNameMap.containsKey(controller.getSessionName())) {
                        this.byNameMap.remove(controller.getSessionName());
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BridgeController getControllerByName(String sessionName) {
            Object object = this.mapLockObject;
            synchronized (object) {
                return (BridgeController)this.byNameMap.get(sessionName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BridgeController getControllerById(int id) {
            Object object = this.mapLockObject;
            synchronized (object) {
                Integer callID = new Integer(id);
                return (BridgeController)this.byIDMap.get(callID);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object[] getActiveControllerList() {
            Object object = this.mapLockObject;
            synchronized (object) {
                Collection collection = this.byNameMap.values();
                Object[] objects = collection.toArray();
                return objects;
            }
        }
    }
}

