/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web;

import com.elluminate.groupware.web.StringsProperties;
import com.elluminate.groupware.web.WebProtocol;
import com.elluminate.jinx.ChannelDataEvent;
import com.elluminate.jinx.ChannelDataListener;
import com.elluminate.jinx.DefaultProtocolResponder;
import com.elluminate.jinx.JinxProtocol;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.I18n;
import com.elluminate.util.I18nMessage;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.StringUtils;
import com.elluminate.util.log.LogSupport;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;

public final class WebResponder
extends DefaultProtocolResponder
implements ChannelDataListener {
    private I18n i18n = I18n.create((Object)((Object)this));
    private I18nMessage mod = this.i18n.getMessage((PropertiesEnum)StringsProperties.WEBRESPONDER_INDEXICON);
    private boolean touring = false;

    public WebResponder(WebProtocol protocol) {
        super((JinxProtocol)protocol);
        this.setChannelDataListener(this);
    }

    public void onChannelData(ChannelDataEvent e) {
        byte cmd = e.getCommand();
        if (cmd == 2) {
            if (!this.touring) {
                this.touring = true;
                String info = "";
                String urlText = null;
                try {
                    DataInputStream istr = e.read();
                    urlText = istr.readUTF();
                    istr.close();
                }
                catch (IOException ex) {
                    LogSupport.exception((Object)((Object)this), (String)"onChannelData", (Throwable)ex, (boolean)true);
                    urlText = null;
                }
                if (urlText != null) {
                    try {
                        URL url = new URL(URLDecoder.decode(urlText, "UTF-8"));
                        info = url.getHost();
                    }
                    catch (Throwable t) {
                        int pos = StringUtils.search((String)urlText, (String)":/\\?#!;+");
                        info = pos > 0 ? urlText.substring(0, pos) : urlText;
                    }
                }
                I18nMessage type = this.i18n.getMessage((PropertiesEnum)StringsProperties.WEBRESPONDER_INDEXSTARTTYPE);
                VCRFile.IndexEntry indexEntry = new VCRFile.IndexEntry(this.mod, type, new I18nMessage(info));
                this.fireNotableEventListeners("recording.index", indexEntry);
            }
        } else if (cmd == 3) {
            this.touring = false;
        }
    }
}

