/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.web;

import com.elluminate.groupware.web.BrowserStateListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;

public class BrowserState {
    private String main = null;
    private LinkedList oFrames = new LinkedList();
    private HashMap iFrames = new HashMap();
    private Object lock = new Object();
    private static BrowserState EMPTY = new BrowserState();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(String url) {
        Object object = this.lock;
        synchronized (object) {
            this.main = url;
            this.oFrames.clear();
            this.iFrames.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navigate(String frame, String url) {
        if (frame == null || frame.equals("")) {
            this.navigate(url);
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean found = false;
            if (!this.iFrames.containsKey(frame)) {
                this.oFrames.addLast(new Pair(frame, url));
            } else {
                Iterator i = this.oFrames.iterator();
                while (i.hasNext()) {
                    Pair p = (Pair)i.next();
                    if (!p.frm.equals(frame)) continue;
                    p.url = url;
                    i.remove();
                    this.oFrames.addLast(p);
                    break;
                }
            }
            this.iFrames.put(frame, url);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.main = null;
            this.iFrames.clear();
            this.oFrames.clear();
        }
    }

    public boolean isStopped() {
        return this.main == null;
    }

    public String get() {
        return this.main;
    }

    public String get(String frm) {
        if (frm == null) {
            return this.get();
        }
        return (String)this.iFrames.get(frm);
    }

    public void update(BrowserState from, BrowserStateListener lst) {
        if (from == null) {
            from = EMPTY;
        }
        if (this.main == null) {
            if (from.main != null) {
                lst.onStop();
            }
            return;
        }
        if (this.main.equals(from.main)) {
            for (Pair p : this.oFrames) {
                String prev = (String)from.iFrames.get(p.frm);
                if (p.url.equals(prev)) continue;
                lst.onFrameNavigate(p.frm, p.url);
            }
        } else {
            lst.onNavigate(this.main);
            for (Pair p : this.oFrames) {
                lst.onFrameNavigate(p.frm, p.url);
            }
        }
    }

    static class Pair {
        public String frm;
        public String url;

        public Pair(String f, String u) {
            this.frm = f;
            this.url = u;
        }
    }
}

