/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.breakout.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.CloseRoomCommand;
import com.elluminate.groupware.breakout.module.BreakoutBean;
import com.elluminate.groupware.breakout.module.StringsProperties;
import com.elluminate.jinx.ClientGroup;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.google.inject.Inject;
import com.google.inject.Provider;

public class CloseRoomCmd
extends AbstractCommand
implements CloseRoomCommand {
    private static final long serialVersionUID = 1L;
    private String roomName = null;
    private Provider<BreakoutBean> beanProvider;
    private I18n i18n = I18n.create((Object)((Object)this));

    @Inject
    public void initBreakoutBeanProvider(Provider<BreakoutBean> bp) {
        this.beanProvider = bp;
    }

    public void setRoomName(String roomName) {
        this.roomName = roomName;
    }

    public void doexecute() throws CommandExecutionException {
        this.validateIsOnlineAndIsChair();
        if (this.roomName == null || this.roomName.length() == 0) {
            throw new CommandParameterException("Room name must be set", this.i18n.getString((PropertiesEnum)StringsProperties.CLOSEROOMCMD_BADPARAMROOMNAMENOTSET));
        }
        BreakoutBean bean = (BreakoutBean)this.beanProvider.get();
        if (!bean.isRoomNameExist(this.roomName)) {
            throw new CommandContextException("Room does not exist", this.i18n.getString((PropertiesEnum)StringsProperties.CLOSEROOMCMD_BADPARAMROOMNOTFOUND, new Object[]{this.roomName}));
        }
        bean.delete(new ClientGroup[]{bean.getRoom(this.roomName)});
    }
}

