/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony.module;

import com.elluminate.framework.imps.Imps;
import com.elluminate.groupware.LabelProps;
import com.elluminate.groupware.imps.TelephonyAPI;
import com.elluminate.groupware.imps.module.BrandingAPI;
import com.elluminate.groupware.telephony.module.ConnectionDialogs;
import com.elluminate.groupware.telephony.module.StringsProperties;
import com.elluminate.groupware.telephony.module.TelephonyConnectionController;
import com.elluminate.groupware.telephony.module.TelephonyModule;
import com.elluminate.gui.ModalDialog;
import com.elluminate.gui.component.EasyDialog;
import com.elluminate.gui.component.LabeledBorder;
import com.elluminate.jinx.Client;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.JinxServerProps;
import com.elluminate.jinx.PropertyAccessAPI;
import com.elluminate.util.I18n;
import com.elluminate.util.LightweightTimer;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.TelephonyUtils;
import com.elluminate.util.browser.BrowserUtil;
import com.elluminate.util.log.LogSupport;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ContainerOrderFocusTraversalPolicy;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import javax.swing.text.JTextComponent;

public class TeleconferenceSetupDialog
extends EasyDialog
implements ActionListener,
PropertyChangeListener {
    private static final String ADVANCED_VIEW = "advanced";
    private static final int CONFIRM_CHANGE_CLOSE = 1;
    private static final int CONFIRM_CHANGE_REJECT = 2;
    private static final int CONFIRM_CHANGE_ACCEPT = 3;
    private static final int CONFIRM_CHANGE_PENDING = 999;
    private I18n i18n = I18n.create((Object)this);
    private TelephonyAPI telephonyAPI = null;
    private String helpURL = null;
    private Client theClient;
    private ClientList clients;
    private TelephonyConnectionController controller;
    private TelephonyModule module;
    private LightweightTimer configChangeTimer;
    private PropertyChangeListener configChangeListener;
    private int validateScheme = 1;
    private String origPartPhone;
    private String origPartPin;
    private String origModPhone;
    private String origModPin;
    private String origSessionPhone;
    private String origSessionPin;
    private String origSessionSip;
    private JButton btnCancel;
    private JButton btnSave;
    private JButton btnConnect;
    private JButton btnHelp;
    private JPanel advancedPanel = new JPanel(new GridBagLayout());
    private JTextField txtPartPhoneAdv = new JTextField(20);
    private JTextField txtPartPinAdv = new JTextField(12);
    private JTextField txtModPhoneAdv = new JTextField(20);
    private JTextField txtModPinAdv = new JTextField(12);
    private JRadioButton rdoSessionPhoneAdv = new JRadioButton();
    private JRadioButton rdoSessionSipAdv = new JRadioButton();
    private JTextField txtSessionPhoneAdv = new JTextField(20);
    private JTextField txtSessionSipAdv = new JTextField(20);
    private JTextField txtSessionPinAdv = new JTextField(12);
    private JLabel lblPartPhoneAdv = new JLabel();
    private JLabel lblModPhoneAdv = new JLabel();
    private JLabel lblPartPinAdv = new JLabel();
    private JLabel lblModPinAdv = new JLabel();
    private JLabel lblSessionPinAdv = new JLabel();
    private HashSet highlights = new HashSet();
    private JLabel lblAccumulatedTime = new JLabel();
    private JLabel lblInputErrors = new JLabel();
    private JPanel configPanel;
    private JPanel msgPanel;
    private JPanel finalPanel;
    private CardLayout view;
    private DocumentListener docListener;
    private ItemListener itemListener;
    private SettingsChanged changeDlog = null;
    private Imps imps;

    public TeleconferenceSetupDialog(Component owner, String title, Client theClient, TelephonyConnectionController controller, TelephonyModule module, Imps imps) {
        super(owner, title, true);
        this.imps = imps;
        this.telephonyAPI = (TelephonyAPI)this.imps.findBest(TelephonyAPI.class);
        this.theClient = theClient;
        this.controller = controller;
        this.module = module;
        this.clients = theClient.getClientList();
        this.validateScheme = this.clients.getProperty("Telephony.numberValidation", 1);
        this.jbInit();
        Runnable configTimerAction = new Runnable(){

            @Override
            public void run() {
                if (TeleconferenceSetupDialog.this.isVisible()) {
                    TeleconferenceSetupDialog.this.asyncUpdate();
                }
            }
        };
        this.configChangeTimer = new LightweightTimer(2, configTimerAction);
        this.configChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                TeleconferenceSetupDialog.this.configChangeTimer.scheduleIn(50L);
            }
        };
        this.addConfigurationChangeListener(this.configChangeListener);
        this.setFocusTraversalPolicy(new LocalFocusTraversalPolicy());
        this.setTeleconferenceData();
        this.update();
    }

    private void jbInit() {
        BrandingAPI BrandingAPI2 = (BrandingAPI)this.imps.findBest(BrandingAPI.class);
        if (BrandingAPI2 != null) {
            this.helpURL = BrandingAPI2.getBrandingString("telephony.telephonyConfigURL");
        }
        this.btnCancel = this.makeButton(0);
        this.btnCancel.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CANCELBUTTON));
        this.btnCancel.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CANCELTIP));
        this.btnSave = this.makeButton(1);
        this.btnSave.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SAVEBUTTON));
        this.btnSave.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SAVETIP));
        this.btnConnect = new JButton();
        if (this.telephonyAPI != null) {
            if (this.telephonyAPI.isConnected()) {
                this.btnConnect.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_DISCONNECTBUTTON));
                this.btnConnect.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_DISCONNECTTIP));
            } else {
                this.btnConnect.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONNECTBUTTON));
                this.btnConnect.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONNECTTIP));
            }
        }
        this.btnHelp = new JButton();
        this.btnHelp.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_HELPBUTTON));
        this.btnHelp.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_HELPTIP));
        this.addCancelButton(this.btnCancel);
        this.addActionButton(this.btnSave, true);
        if (this.telephonyAPI != null) {
            this.addPassiveComponent(this.btnConnect);
        }
        if (this.helpURL != null) {
            this.addPassiveComponent(this.btnHelp);
        }
        this.btnConnect.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnHelp.addActionListener(this);
        this.docListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TeleconferenceSetupDialog.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                TeleconferenceSetupDialog.this.update();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TeleconferenceSetupDialog.this.update();
            }
        };
        String partLabel = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.participants");
        String part1Label = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.participant");
        String partTitleLabel = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant");
        String chairLabel = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.moderators");
        String chairTitleLabel = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator");
        String sessionLabel = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.session");
        String sessionTitleLabel = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Session");
        this.lblPartPhoneAdv.setLabelFor(this.txtPartPhoneAdv);
        this.lblPartPinAdv.setLabelFor(this.txtPartPinAdv);
        this.lblModPhoneAdv.setLabelFor(this.txtModPhoneAdv);
        this.lblModPinAdv.setLabelFor(this.txtModPinAdv);
        this.txtPartPhoneAdv.getDocument().addDocumentListener(this.docListener);
        this.txtPartPinAdv.getDocument().addDocumentListener(this.docListener);
        this.txtModPhoneAdv.getDocument().addDocumentListener(this.docListener);
        this.txtModPinAdv.getDocument().addDocumentListener(this.docListener);
        this.txtSessionPhoneAdv.getDocument().addDocumentListener(this.docListener);
        this.txtSessionPinAdv.getDocument().addDocumentListener(this.docListener);
        this.txtSessionSipAdv.getDocument().addDocumentListener(this.docListener);
        GridBagConstraints constraints = null;
        this.txtPartPhoneAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_PARTTELEPHONETOOLTIP, new Object[]{partLabel}));
        this.txtPartPhoneAdv.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_PARTICIPANTTELEPHONE, new Object[]{partLabel}));
        this.txtModPhoneAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_MODTELEPHONETOOLTIP, new Object[]{chairLabel, part1Label}));
        this.txtModPhoneAdv.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_MODERATORTELEPHONE, new Object[]{chairLabel}));
        this.txtPartPinAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_PARTPINTOOLTIP, new Object[]{partLabel}));
        this.txtPartPinAdv.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_PARTICIPANTPIN, new Object[]{partLabel}));
        this.txtModPinAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_MODPINTOOLTIP, new Object[]{chairLabel}));
        this.txtModPinAdv.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_MODERATORPIN, new Object[]{chairLabel}));
        this.rdoSessionPhoneAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESTELERDOBTNTOOLTIP, new Object[]{sessionLabel}));
        this.rdoSessionSipAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESSIPRDOBTNTOOLTIP, new Object[]{sessionLabel}));
        this.txtSessionPhoneAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESTELETXTFIELDTOOLTIP, new Object[]{sessionLabel}));
        this.txtSessionPhoneAdv.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESSIONTELACCESSIBLENAME, new Object[]{sessionLabel}));
        this.txtSessionSipAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESSIPTXTFIELDTOOLTIP, new Object[]{sessionLabel}));
        this.txtSessionSipAdv.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESSIONSIPACCESSIBLENAME, new Object[]{sessionLabel}));
        this.txtSessionPinAdv.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESPINTXTFIELDTOOLTIP, new Object[]{sessionLabel}));
        this.txtSessionPinAdv.getAccessibleContext().setAccessibleName(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESSIONPINACCESSIBLENAME, new Object[]{sessionLabel}));
        constraints = new GridBagConstraints(0, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(20, 10, 0, 10), 0, 0);
        this.advancedPanel.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_PARTICIPANTADVANCEDLABEL, new Object[]{partTitleLabel})), constraints);
        constraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 5), 0, 0);
        this.lblPartPhoneAdv.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_ADVANCEDTELEPHONELABEL));
        this.advancedPanel.add((Component)this.lblPartPhoneAdv, constraints);
        constraints = new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 5), 0, 0);
        this.advancedPanel.add((Component)this.txtPartPhoneAdv, constraints);
        constraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 5), 0, 0);
        this.lblPartPinAdv.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_ADVANCEDPINLABEL));
        this.advancedPanel.add((Component)this.lblPartPinAdv, constraints);
        constraints = new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 15), 0, 0);
        this.advancedPanel.add((Component)this.txtPartPinAdv, constraints);
        constraints = new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0);
        this.advancedPanel.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_MODERATORADVANCEDLABEL, new Object[]{chairTitleLabel})), constraints);
        constraints = new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 5), 0, 0);
        this.lblModPhoneAdv.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_ADVANCEDTELEPHONELABEL));
        this.advancedPanel.add((Component)this.lblModPhoneAdv, constraints);
        constraints = new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 5), 0, 0);
        this.advancedPanel.add((Component)this.txtModPhoneAdv, constraints);
        constraints = new GridBagConstraints(3, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 10, 5), 0, 0);
        this.lblModPinAdv.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_ADVANCEDPINLABEL));
        this.advancedPanel.add((Component)this.lblModPinAdv, constraints);
        constraints = new GridBagConstraints(4, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 15), 0, 0);
        this.advancedPanel.add((Component)this.txtModPinAdv, constraints);
        constraints = new GridBagConstraints(0, 6, 4, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0);
        this.advancedPanel.add((Component)new JLabel(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESSIONADVANCEDLABEL, new Object[]{sessionTitleLabel})), constraints);
        constraints = new GridBagConstraints(0, 7, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0);
        this.rdoSessionPhoneAdv.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_ADVANCEDTELEPHONELABEL));
        this.advancedPanel.add((Component)this.rdoSessionPhoneAdv, constraints);
        constraints = new GridBagConstraints(0, 8, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0);
        this.rdoSessionSipAdv.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SESSIONADVANCEDSIPLABEL));
        this.advancedPanel.add((Component)this.rdoSessionSipAdv, constraints);
        constraints = new GridBagConstraints(2, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 0, 0), 0, 0);
        this.advancedPanel.add((Component)this.txtSessionPhoneAdv, constraints);
        constraints = new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 10, 10, 0), 0, 0);
        this.advancedPanel.add((Component)this.txtSessionSipAdv, constraints);
        constraints = new GridBagConstraints(3, 7, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0);
        this.lblSessionPinAdv.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_ADVANCEDPINLABEL));
        this.advancedPanel.add((Component)this.lblSessionPinAdv, constraints);
        constraints = new GridBagConstraints(4, 7, 1, 2, 0.0, 0.0, 17, 0, new Insets(10, 10, 10, 0), 0, 0);
        this.advancedPanel.add((Component)this.txtSessionPinAdv, constraints);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.rdoSessionPhoneAdv);
        bg.add(this.rdoSessionSipAdv);
        this.rdoSessionPhoneAdv.addActionListener(this);
        this.rdoSessionSipAdv.addActionListener(this);
        this.itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                boolean useSip = TeleconferenceSetupDialog.this.rdoSessionSipAdv.isSelected();
                TeleconferenceSetupDialog.this.txtSessionPhoneAdv.setEnabled(!useSip);
                TeleconferenceSetupDialog.this.txtSessionSipAdv.setEnabled(useSip);
                if (useSip) {
                    TeleconferenceSetupDialog.this.txtSessionSipAdv.requestFocusInWindow();
                } else {
                    TeleconferenceSetupDialog.this.txtSessionPhoneAdv.requestFocusInWindow();
                }
                TeleconferenceSetupDialog.this.update();
            }
        };
        this.rdoSessionPhoneAdv.addItemListener(this.itemListener);
        this.rdoSessionSipAdv.addItemListener(this.itemListener);
        this.msgPanel = new JPanel(new GridLayout(2, 1, 10, 10));
        this.msgPanel.setBorder((Border)new LabeledBorder(null, this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_STATUSLABEL)));
        this.msgPanel.add(this.lblAccumulatedTime);
        this.msgPanel.add(this.lblInputErrors);
        this.lblInputErrors.setForeground(Color.RED);
        this.lblInputErrors.setVisible(true);
        this.view = new CardLayout();
        this.configPanel = new JPanel(this.view);
        this.configPanel.setBorder((Border)new LabeledBorder(null, this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIGLABEL)));
        this.configPanel.add((Component)this.advancedPanel, ADVANCED_VIEW);
        this.finalPanel = new JPanel(new BorderLayout());
        this.finalPanel.add((Component)this.configPanel, "Center");
        this.finalPanel.add((Component)this.msgPanel, "South");
        this.setContent(this.finalPanel);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                TeleconferenceSetupDialog.this.doCancel();
            }
        });
        this.clients.addPropertyChangeListener("Telephony.accruedTime", (PropertyChangeListener)this);
        this.clients.addPropertyChangeListener("Telephony.connectionState", (PropertyChangeListener)this);
    }

    private void setTeleconferenceData() {
        if (this.clients != null) {
            this.origModPhone = this.clients.getProperty("Telephony.moderatorTelephone", "");
            this.origModPin = this.clients.getProperty("Telephony.moderatorPIN", "");
            this.origPartPhone = this.clients.getProperty("Telephony.participantTelephone", "");
            this.origPartPin = this.clients.getProperty("Telephony.participantPIN", "");
            this.origSessionPhone = this.clients.getProperty("Telephony.sessionTelephone", "");
            this.origSessionPin = this.clients.getProperty("Telephony.sessionPIN", "");
            this.origSessionSip = this.clients.getProperty("Telephony.sessionSIP", "");
            this.txtPartPhoneAdv.setText(this.origPartPhone);
            this.txtPartPinAdv.setText(this.origPartPin);
            this.txtModPhoneAdv.setText(this.origModPhone);
            this.txtModPinAdv.setText(this.origModPin);
            if (this.origSessionSip.length() > 0) {
                this.txtSessionSipAdv.setText(this.origSessionSip);
                this.rdoSessionSipAdv.setSelected(true);
                this.txtSessionPinAdv.setText(this.origSessionPin);
            } else {
                this.txtSessionPhoneAdv.setText(this.origSessionPhone);
                this.txtSessionPinAdv.setText(this.origSessionPin);
                this.rdoSessionPhoneAdv.setSelected(true);
            }
        }
        this.setAccumulatedTime();
        this.lblInputErrors.setVisible(false);
    }

    private void setAccumulatedTime() {
        ClientList clients = this.theClient.getClientList();
        if (clients != null) {
            Integer timeLimit = (Integer)clients.getProperty("Telephony.timeLimit");
            Integer accruedTime = (Integer)clients.getProperty("Telephony.accruedTime");
            String timeMsg = timeLimit != null && timeLimit != -1 ? this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_TELECONFERENCEACCRUEDTIMELIMIT, new Object[]{accruedTime, timeLimit}) : this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_TELECONFERENCEACCRUEDTIME, new Object[]{accruedTime});
            this.lblAccumulatedTime.setText(timeMsg);
            this.lblAccumulatedTime.setVisible(true);
        } else {
            this.lblAccumulatedTime.setVisible(false);
        }
    }

    private String getPartPhone() {
        return TeleconferenceSetupDialog.trim(this.txtPartPhoneAdv.getText());
    }

    private String getPartPin() {
        return TeleconferenceSetupDialog.trim(this.txtPartPinAdv.getText());
    }

    private String getModPhone() {
        return TeleconferenceSetupDialog.trim(this.txtModPhoneAdv.getText());
    }

    private String getModPin() {
        return TeleconferenceSetupDialog.trim(this.txtModPinAdv.getText());
    }

    private String getSessionPhone() {
        if (this.rdoSessionPhoneAdv.isSelected()) {
            return TeleconferenceSetupDialog.trim(this.txtSessionPhoneAdv.getText());
        }
        return "";
    }

    private String getSessionPin() {
        return TeleconferenceSetupDialog.trim(this.txtSessionPinAdv.getText());
    }

    private String getSessionSip() {
        if (this.rdoSessionSipAdv.isSelected()) {
            return TeleconferenceSetupDialog.trim(this.txtSessionSipAdv.getText());
        }
        return "";
    }

    private boolean useSessionSip() {
        return this.rdoSessionSipAdv.isSelected();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.btnCancel) {
            this.doCancel();
        } else if (e.getSource() == this.btnSave) {
            if (!this.isBlankConfig() && !this.isValidConfig()) {
                return;
            }
            this.saveAction();
            this.dispose();
        } else if (src == this.btnConnect) {
            if (this.telephonyAPI.isConnected()) {
                ConnectionDialogs dialog = new ConnectionDialogs();
                if (dialog.showConfirmDisconnectDialog(this.getOwner(), this.clients)) {
                    this.controller.disconnect();
                }
            } else {
                if (!this.isValidConfig()) {
                    return;
                }
                this.saveAction();
                this.controller.connect();
                this.dispose();
            }
        } else if (src == this.btnHelp) {
            try {
                BrowserUtil.gotoURL((String)this.helpURL);
            }
            catch (IOException ex) {
                LogSupport.exception((Object)this, (String)"helpSupport_actionPerformed", (Throwable)ex, (boolean)true);
            }
        }
    }

    private void doCancel() {
        int answer;
        if (this.isModified() && (answer = ModalDialog.showConfirmDialog((Component)((Object)this), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CANCELMODIFIEDMSG), (String)this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CANCELMODIFIEDTITLE), (int)2)) == 2) {
            return;
        }
        this.dispose();
    }

    public void dispose() {
        this.removeConfigurationChangeListener(this.configChangeListener);
        this.configChangeTimer.cancel();
        this.clients.removePropertyChangeListener("Telephony.connectionState", (PropertyChangeListener)this);
        this.clients.removePropertyChangeListener("Telephony.accruedTime", (PropertyChangeListener)this);
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void hide() {
        try {
            if (this.changeDlog != null) {
                this.changeDlog.dispose();
            }
        }
        finally {
            this.changeDlog = null;
            super.hide();
        }
    }

    private void asyncUpdate() {
        if (this.clients == null) {
            return;
        }
        String asyncPartPhone = this.clients.getProperty("Telephony.participantTelephone", "");
        String asyncPartPin = this.clients.getProperty("Telephony.participantPIN", "");
        String asyncModPhone = this.clients.getProperty("Telephony.moderatorTelephone", "");
        String asyncModPin = this.clients.getProperty("Telephony.moderatorPIN", "");
        String asyncSessionPhone = this.clients.getProperty("Telephony.sessionTelephone", "");
        String asyncSessionPin = this.clients.getProperty("Telephony.sessionPIN", "");
        String asyncSessionSip = this.clients.getProperty("Telephony.sessionSIP", "");
        String curPartPhone = this.getPartPhone();
        String curPartPin = this.getPartPin();
        String curModPhone = this.getModPhone();
        String curModPin = this.getModPin();
        String curSessionPhone = this.getSessionPhone();
        String curSessionPin = this.getSessionPin();
        String curSessionSip = this.getSessionSip();
        boolean changed = false;
        if (!this.origPartPhone.equals(asyncPartPhone)) {
            changed = true;
        } else if (!this.origPartPin.equals(asyncPartPin)) {
            changed = true;
        } else if (!this.origModPhone.equals(asyncModPhone)) {
            changed = true;
        } else if (!this.origModPin.equals(asyncModPin)) {
            changed = true;
        } else if (!this.origSessionPhone.equals(asyncSessionPhone)) {
            changed = true;
        } else if (!this.origSessionPin.equals(asyncSessionPin)) {
            changed = true;
        } else if (!this.origSessionSip.equals(asyncSessionSip)) {
            changed = true;
        }
        if (!changed) {
            return;
        }
        String[] properties = new String[]{"Telephony.participantTelephone", "Telephony.participantPIN", "Telephony.moderatorTelephone", "Telephony.moderatorPIN", "Telephony.sessionTelephone", "Telephony.sessionPIN", "Telephony.sessionSIP"};
        String[] originalValues = new String[]{this.origPartPhone, this.origPartPin, this.origModPhone, this.origModPin, this.origSessionPhone, this.origSessionPin, this.origSessionSip};
        String[] currentValues = new String[]{curPartPhone, curPartPin, curModPhone, curModPin, curSessionPhone, curSessionPin, curSessionSip};
        String[] asyncValues = new String[]{asyncPartPhone, asyncPartPin, asyncModPhone, asyncModPin, asyncSessionPhone, asyncSessionPin, asyncSessionSip};
        this.origPartPhone = asyncPartPhone;
        this.origPartPin = asyncPartPin;
        this.origModPhone = asyncModPhone;
        this.origModPin = asyncModPin;
        this.origSessionPhone = asyncSessionPhone;
        this.origSessionSip = asyncSessionSip;
        this.origSessionPin = asyncSessionPin;
        int which = this.asyncConfirmation(originalValues, currentValues, asyncValues, properties);
        if (which == 999) {
            return;
        }
        if (which == 1) {
            this.setVisible(false);
            this.dispose();
            return;
        }
        if (which == 3) {
            if (!curPartPhone.equals(asyncPartPhone)) {
                this.txtPartPhoneAdv.setText(asyncPartPhone);
            }
            if (!curPartPin.equals(asyncPartPin)) {
                this.txtPartPinAdv.setText(asyncPartPin);
            }
            if (!curModPhone.equals(asyncModPhone)) {
                this.txtModPhoneAdv.setText(asyncModPhone);
            }
            if (!curModPin.equals(asyncModPin)) {
                this.txtModPinAdv.setText(asyncModPin);
            }
            boolean updatedRadioBtn = false;
            boolean radioBtnNeedsUpdate = false;
            if (!curSessionPhone.equals(asyncSessionPhone)) {
                this.txtSessionPhoneAdv.setText(asyncSessionPhone);
                if (asyncSessionPhone.length() > 0) {
                    this.rdoSessionPhoneAdv.setSelected(true);
                    updatedRadioBtn = true;
                }
                radioBtnNeedsUpdate = true;
            }
            if (!curSessionSip.equals(asyncSessionSip)) {
                this.txtSessionSipAdv.setText(asyncSessionSip);
                if (asyncSessionSip.length() > 0) {
                    this.rdoSessionSipAdv.setSelected(true);
                    updatedRadioBtn = true;
                }
                radioBtnNeedsUpdate = true;
            }
            if (!curSessionPin.equals(asyncSessionPin)) {
                this.txtSessionPinAdv.setText(asyncSessionPin);
            }
            if (radioBtnNeedsUpdate && !updatedRadioBtn) {
                if (TeleconferenceSetupDialog.trim(this.txtSessionSipAdv.getText()).length() > 0) {
                    this.rdoSessionSipAdv.setSelected(true);
                } else {
                    this.rdoSessionPhoneAdv.setSelected(true);
                }
            }
        }
        this.update();
    }

    private int asyncConfirmation(String[] originalValues, String[] currentValues, String[] asyncValues, String[] properties) {
        if (this.changeDlog != null) {
            this.changeDlog.updateTable(asyncValues);
            return 999;
        }
        this.changeDlog = new SettingsChanged(originalValues, currentValues, asyncValues, properties);
        this.changeDlog.show();
        if (this.changeDlog == null) {
            return 999;
        }
        int result = this.changeDlog.getDisposition();
        this.changeDlog = null;
        return result;
    }

    private void update() {
        this.resetErrors();
        boolean isBlank = this.isBlankConfig();
        boolean isValid = true;
        boolean isSessionValid = true;
        if (!isBlank) {
            isValid = this.isValidConfig();
            isSessionValid = this.isValidSessionConfig();
        }
        boolean modified = !this.origPartPhone.equals(this.getPartPhone()) || !this.origPartPin.equals(this.getPartPin()) || !this.origModPhone.equals(this.getModPhone()) || !this.origModPin.equals(this.getModPin()) || !this.origSessionPhone.equals(this.getSessionPhone()) || !this.origSessionPin.equals(this.getSessionPin()) || !this.origSessionSip.equals(this.getSessionSip());
        this.setModified(modified);
        this.btnSave.setEnabled(modified && (isSessionValid || isBlank));
        if (this.clients != null) {
            int state = this.clients.getProperty("Telephony.connectionState", -1);
            switch (state) {
                case 3: 
                case 4: {
                    this.btnConnect.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_DISCONNECTBUTTON));
                    this.btnConnect.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_DISCONNECTTIP));
                    this.btnConnect.setEnabled(state == 3);
                    break;
                }
                case 1: 
                case 2: {
                    if (modified) {
                        this.btnConnect.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SAVEANDCONNECTBUTTON));
                        this.btnConnect.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SAVEANDCONNECTTIP));
                    } else {
                        this.btnConnect.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONNECTBUTTON));
                        this.btnConnect.setToolTipText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONNECTTIP));
                    }
                    this.btnConnect.setEnabled(isSessionValid && !isBlank && state == 1);
                    break;
                }
                default: {
                    this.btnConnect.setVisible(false);
                }
            }
        }
    }

    private void saveAction() {
        int state = this.clients.getProperty("Telephony.connectionState", -1);
        if (state == 3 || state == 2) {
            ModalDialog.showMessageDialog((Component)((Object)this), (Object)this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SAVECONNECTEDWARNING), (String)this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SAVECONNECTEDWARNINGTITLE), (int)2);
        }
        this.module.setUpSessionTeleconference(this.getPartPhone(), this.getPartPin(), this.getModPhone(), this.getModPin(), this.getSessionPhone(), this.getSessionSip(), this.getSessionPin());
    }

    private void resetErrors() {
        for (JComponent c : this.highlights) {
            c.setForeground(Color.BLACK);
        }
        this.lblInputErrors.setVisible(false);
    }

    private boolean isBlankConfig() {
        return this.getPartPhone().length() == 0 && this.getPartPin().length() == 0 && this.getModPhone().length() == 0 && this.getModPin().length() == 0 && this.getSessionPhone().length() == 0 && this.getSessionPin().length() == 0 && this.getSessionSip().length() == 0;
    }

    private boolean isValidConfig() {
        String partPhone = this.getPartPhone();
        String partPin = this.getPartPin();
        String modPhone = this.getModPhone();
        String modPin = this.getModPin();
        String sessionPhone = this.getSessionPhone();
        String sessionPin = this.getSessionPin();
        String sessionSip = this.getSessionSip();
        boolean isValidated = true;
        isValidated &= this.isValidPhone(partPhone, true, this.lblPartPhoneAdv, isValidated, false);
        isValidated &= this.isValidPin(partPin, this.lblPartPinAdv, isValidated);
        isValidated &= this.isValidPhone(modPhone, true, this.lblModPhoneAdv, isValidated, false);
        isValidated &= this.isValidPin(modPin, this.lblModPinAdv, isValidated);
        if (this.useSessionSip()) {
            isValidated &= this.isValidSipUri(sessionSip, this.rdoSessionSipAdv, isValidated);
            isValidated &= this.isValidPin(sessionPin, this.lblSessionPinAdv, isValidated);
            this.rdoSessionPhoneAdv.setForeground(Color.BLACK);
        } else {
            isValidated &= this.isValidPhone(sessionPhone, false, this.rdoSessionPhoneAdv, isValidated, this.validateScheme == 1);
            isValidated &= this.isValidPin(sessionPin, this.lblSessionPinAdv, isValidated);
            this.rdoSessionSipAdv.setForeground(Color.BLACK);
        }
        this.lblInputErrors.setVisible(!isValidated);
        return isValidated;
    }

    private boolean isValidSessionConfig() {
        String sessionPhone = this.getSessionPhone();
        String sessionPin = this.getSessionPin();
        String sessionSip = this.getSessionSip();
        boolean isValidated = true;
        if (this.useSessionSip()) {
            isValidated &= this.isValidSipUri(sessionSip, this.rdoSessionSipAdv, false);
            isValidated &= this.isValidPin(sessionPin, this.lblSessionPinAdv, false);
            this.rdoSessionPhoneAdv.setForeground(Color.BLACK);
        } else {
            isValidated &= this.isValidPhone(sessionPhone, false, this.rdoSessionPhoneAdv, false, this.validateScheme == 1);
            isValidated &= this.isValidPin(sessionPin, this.lblSessionPinAdv, false);
            this.rdoSessionSipAdv.setForeground(Color.BLACK);
        }
        return isValidated;
    }

    private boolean isValidPhone(String value, boolean blankOK, JComponent highlight, boolean isValidated, boolean isFormatted) {
        if (!this.highlights.contains(highlight)) {
            this.highlights.add(highlight);
        }
        String errString = null;
        if (isFormatted) {
            if (TelephonyUtils.isStringATelephoneNumber((String)value, (!blankOK ? 1 : 0) != 0)) {
                return true;
            }
            errString = this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_TELEPHONEFORMATERROR);
        } else {
            if ((blankOK || value != null && !value.equals("")) && TelephonyUtils.checkTelephonyNumberIsATelephoneNumber((String)value)) {
                return true;
            }
            errString = this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_TELEPHONECHARACTERERROR);
        }
        highlight.setForeground(Color.RED);
        if (isValidated) {
            this.lblInputErrors.setText(errString);
        }
        return false;
    }

    private boolean isValidPin(String value, JComponent highlight, boolean isValidated) {
        if (!this.highlights.contains(highlight)) {
            this.highlights.add(highlight);
        }
        if (TelephonyUtils.isStringAPin((String)value)) {
            return true;
        }
        highlight.setForeground(Color.RED);
        if (isValidated) {
            this.lblInputErrors.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_PINFORMATERROR));
        }
        return false;
    }

    private boolean isValidSipUri(String value, JComponent highlight, boolean isValidated) {
        if (!this.highlights.contains(highlight)) {
            this.highlights.add(highlight);
        }
        if (TelephonyUtils.isStringAValidSipURI((String)value)) {
            return true;
        }
        highlight.setForeground(Color.RED);
        if (isValidated) {
            this.lblInputErrors.setText(this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_SIPURIFORMATERROR));
        }
        return false;
    }

    private void addConfigurationChangeListener(PropertyChangeListener l) {
        if (this.clients == null) {
            return;
        }
        if (l == null) {
            return;
        }
        this.clients.addPropertyChangeListener("Telephony.participantTelephone", l);
        this.clients.addPropertyChangeListener("Telephony.participantPIN", l);
        this.clients.addPropertyChangeListener("Telephony.moderatorTelephone", l);
        this.clients.addPropertyChangeListener("Telephony.moderatorPIN", l);
        this.clients.addPropertyChangeListener("Telephony.sessionTelephone", l);
        this.clients.addPropertyChangeListener("Telephony.sessionSIP", l);
        this.clients.addPropertyChangeListener("Telephony.sessionPIN", l);
    }

    private void removeConfigurationChangeListener(PropertyChangeListener l) {
        if (this.clients == null) {
            return;
        }
        if (l == null) {
            return;
        }
        this.clients.removePropertyChangeListener("Telephony.participantTelephone", l);
        this.clients.removePropertyChangeListener("Telephony.participantPIN", l);
        this.clients.removePropertyChangeListener("Telephony.moderatorTelephone", l);
        this.clients.removePropertyChangeListener("Telephony.moderatorPIN", l);
        this.clients.removePropertyChangeListener("Telephony.sessionTelephone", l);
        this.clients.removePropertyChangeListener("Telephony.sessionSIP", l);
        this.clients.removePropertyChangeListener("Telephony.sessionPIN", l);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == null) {
            return;
        }
        if (propName.equals("Telephony.accruedTime")) {
            this.setAccumulatedTime();
        } else if (propName.equals("Telephony.connectionState")) {
            this.update();
        }
    }

    private static String trim(String str) {
        if (str == null) {
            return "";
        }
        return str.trim();
    }

    private String lookupTableLable(String propName) {
        if ("Telephony.participantTelephone".equals(propName)) {
            String label = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant");
            return this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMLABELPHONE, new Object[]{label});
        }
        if ("Telephony.participantPIN".equals(propName)) {
            String label = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Participant");
            return this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMLABELPIN, new Object[]{label});
        }
        if ("Telephony.moderatorTelephone".equals(propName)) {
            String label = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator");
            return this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMLABELPHONE, new Object[]{label});
        }
        if ("Telephony.moderatorPIN".equals(propName)) {
            String label = LabelProps.get((PropertyAccessAPI)this.clients, (String)"Label.Moderator");
            return this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMLABELPIN, new Object[]{label});
        }
        if ("Telephony.sessionTelephone".equals(propName)) {
            String label = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Session");
            return this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMLABELPHONE, new Object[]{label});
        }
        if ("Telephony.sessionPIN".equals(propName)) {
            String label = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Session");
            return this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMLABELPIN, new Object[]{label});
        }
        if ("Telephony.sessionSIP".equals(propName)) {
            String label = JinxServerProps.get((PropertyAccessAPI)this.clients, (String)"Label.Session");
            return this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMLABELSIP, new Object[]{label});
        }
        return "";
    }

    private class LocalFocusTraversalPolicy
    extends ContainerOrderFocusTraversalPolicy {
        private LocalFocusTraversalPolicy() {
        }

        @Override
        protected boolean accept(Component cmp) {
            if (!super.accept(cmp)) {
                return false;
            }
            return this.isControl(cmp);
        }

        private boolean isControl(Component cmp) {
            if (cmp instanceof AbstractButton) {
                return true;
            }
            if (cmp instanceof JSlider) {
                return true;
            }
            if (cmp instanceof JSpinner) {
                return true;
            }
            return cmp instanceof JTextComponent;
        }
    }

    private class SettingsChanged
    extends EasyDialog
    implements ActionListener {
        private int disposition;
        private int numRows;
        private JTable table;
        private DefaultTableModel model;
        private JScrollPane scroller;
        private JButton closeBtn;
        private JButton acceptBtn;
        private JButton rejectBtn;
        private boolean[] unchanged;
        private boolean[] conflicted;
        private final String[] colNames;
        private final String unchangedText;

        public SettingsChanged(String[] originalValues, String[] currentValues, String[] asyncValues, String[] properties) {
            super((Component)((Object)TeleconferenceSetupDialog.this), TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMCHANGESETTINGSTITLE));
            this.disposition = -1;
            this.numRows = 0;
            this.table = null;
            this.model = null;
            this.scroller = null;
            this.closeBtn = null;
            this.acceptBtn = null;
            this.rejectBtn = null;
            this.unchanged = null;
            this.conflicted = null;
            this.colNames = new String[]{TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMNAMECOLUMNTITLE), TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMORIGCOLUMNTITLE), TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMNEWCOLUMNTITLE), TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMCURCOLUMNTITLE)};
            this.unchangedText = TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMCELLUNCHANGED);
            this.setResizable(true);
            this.setDefaultCloseOperation(0);
            this.numRows = originalValues.length;
            String chairLabel = LabelProps.get((PropertyAccessAPI)TeleconferenceSetupDialog.this.clients, (String)"Label.moderator");
            String sessionLabel = JinxServerProps.get((PropertyAccessAPI)TeleconferenceSetupDialog.this.clients, (String)"Label.session");
            String msgString = TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMCHANGESETTINGSMSG, new Object[]{chairLabel, sessionLabel});
            JEditorPane message = new JEditorPane("text/html", msgString);
            message.setEditable(false);
            message.setFocusable(false);
            message.setOpaque(false);
            message.setBackground(UIManager.getColor("Label.background"));
            ImageIcon icon = TeleconferenceSetupDialog.this.i18n.getIcon("TeleconferenceSetupDialog.confirmChangeSettingsIcon");
            JLabel iconLabel = new JLabel(icon);
            JPanel msgPane = new JPanel(new BorderLayout());
            msgPane.add((Component)message, "Center");
            msgPane.add((Component)iconLabel, "West");
            this.initTable(originalValues, currentValues, asyncValues, properties);
            JPanel tablePane = new JPanel(new BorderLayout());
            this.scroller = new JScrollPane(this.table);
            tablePane.add((Component)this.scroller, "Center");
            tablePane.setBorder(BorderFactory.createEmptyBorder(16, 0, 16, 12));
            int h = (this.table.getRowHeight() + 1) * (this.table.getRowCount() + 3);
            tablePane.setPreferredSize(new Dimension(600, h));
            JPanel contentPane = new JPanel(new BorderLayout());
            contentPane.add((Component)tablePane, "South");
            contentPane.add((Component)msgPane, "Center");
            super.setContent((Component)contentPane);
            String closeBtnName = TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMCHANGESETTINGSCLOSEBTN);
            String acceptBtnName = TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMCHANGESETTINGSACCEPTBTN);
            String rejectBtnName = TeleconferenceSetupDialog.this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCESETUPDIALOG_CONFIRMCHANGESETTINGSREJECTBTN);
            this.closeBtn = this.makeButton(closeBtnName);
            this.acceptBtn = this.makeButton(acceptBtnName);
            this.rejectBtn = this.makeButton(rejectBtnName);
            this.closeBtn.addActionListener(this);
            this.acceptBtn.addActionListener(this);
            this.rejectBtn.addActionListener(this);
            this.addActionButton(this.closeBtn, true);
            this.addCancelButton(this.rejectBtn);
            this.addAlternateActionButton(this.acceptBtn);
        }

        public int getDisposition() {
            return this.disposition;
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            Object src = ev.getSource();
            if (src == this.closeBtn) {
                this.disposition = 1;
                super.dispose();
            } else if (src == this.acceptBtn) {
                this.disposition = 3;
                super.dispose();
            } else if (src == this.rejectBtn) {
                this.disposition = 2;
                super.dispose();
            }
        }

        public void updateTable(String[] values) {
            if (values.length != this.numRows) {
                throw new IllegalArgumentException("Update value list length does not match original");
            }
            for (int r = 0; r < this.numRows; ++r) {
                String val = values[r];
                Object old = this.model.getValueAt(r, 2);
                if (old == val || old != null && old.equals(val)) continue;
                this.unchanged[r] = this.model.getValueAt(r, 3).equals(this.model.getValueAt(r, 1)) && val.equals(this.model.getValueAt(r, 1));
                this.conflicted[r] = !this.model.getValueAt(r, 3).equals(this.model.getValueAt(r, 1)) && !val.equals(this.model.getValueAt(r, 1)) && !val.equals(this.model.getValueAt(r, 3));
                this.model.setValueAt(val, r, 2);
            }
        }

        private void initTable(String[] originalValues, String[] currentValues, String[] asyncValues, String[] properties) {
            this.model = new DefaultTableModel(this.colNames, this.numRows){

                @Override
                public boolean isCellEditable(int r, int c) {
                    return false;
                }
            };
            this.unchanged = new boolean[this.numRows];
            this.conflicted = new boolean[this.numRows];
            for (int r = 0; r < this.numRows; ++r) {
                this.model.setValueAt(TeleconferenceSetupDialog.this.lookupTableLable(properties[r]), r, 0);
                this.model.setValueAt(originalValues[r], r, 1);
                this.model.setValueAt(asyncValues[r], r, 2);
                this.model.setValueAt(currentValues[r], r, 3);
                this.unchanged[r] = currentValues[r].equals(originalValues[r]) && asyncValues[r].equals(originalValues[r]);
                this.conflicted[r] = !currentValues[r].equals(originalValues[r]) && !asyncValues[r].equals(originalValues[r]) && !asyncValues[r].equals(currentValues[r]);
            }
            this.table = new JTable(this.model);
            this.table.setCellSelectionEnabled(false);
            this.table.getTableHeader().setReorderingAllowed(false);
            DefaultTableCellRenderer renderer = new DefaultTableCellRenderer(){

                @Override
                public Component getTableCellRendererComponent(JTable tbl, Object val, boolean s, boolean f, int r, int c) {
                    Component cmp = super.getTableCellRendererComponent(tbl, SettingsChanged.this.filterValue(r, c, val), false, false, r, c);
                    SettingsChanged.this.prepareComponent(cmp, r, c);
                    return cmp;
                }
            };
            Enumeration<TableColumn> e = this.table.getColumnModel().getColumns();
            while (e.hasMoreElements()) {
                TableColumn col = e.nextElement();
                col.setCellRenderer(renderer);
            }
        }

        private Object filterValue(int r, int c, Object val) {
            if (c > 1 && this.unchanged[r]) {
                return this.unchangedText;
            }
            return val;
        }

        private void prepareComponent(Component cmp, int r, int c) {
            cmp.setBackground(Color.WHITE);
            cmp.setForeground(Color.BLACK);
            if (r >= 0 && r < this.numRows) {
                if (this.conflicted[r]) {
                    if (c > 1) {
                        cmp.setBackground(Color.YELLOW.brighter());
                        cmp.setForeground(Color.RED);
                    }
                    cmp.setFont(cmp.getFont().deriveFont(1));
                } else if (c > 1 && this.unchanged[r]) {
                    cmp.setForeground(Color.GRAY);
                    cmp.setFont(cmp.getFont().deriveFont(2));
                } else {
                    cmp.setFont(cmp.getFont().deriveFont(0));
                }
            }
        }
    }
}

