/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.groupware.telephony.module;

import com.elluminate.engine.CommandContextException;
import com.elluminate.engine.CommandExecutionException;
import com.elluminate.engine.CommandParameterException;
import com.elluminate.engine.command.AbstractCommand;
import com.elluminate.engine.command.ConfigureTeleconferenceCommand;
import com.elluminate.groupware.telephony.module.StringsProperties;
import com.elluminate.groupware.telephony.module.TelephonyModule;
import com.elluminate.jinx.ClientList;
import com.elluminate.jinx.provider.ClientProvider;
import com.elluminate.util.I18n;
import com.elluminate.util.PropertiesEnum;
import com.elluminate.util.TelephonyUtils;
import com.google.inject.Inject;

public class ConfigureTeleconferenceCmd
extends AbstractCommand
implements ConfigureTeleconferenceCommand {
    private String participantNumber = null;
    private String participantPIN = null;
    private String moderatorNumber = null;
    private String moderatorPIN = null;
    private String sessionNumberOrSIP = null;
    private String sessionPIN = null;
    private I18n i18n = I18n.create((Object)((Object)this));
    private TelephonyModule module;
    private ClientProvider clientProvider;

    @Inject
    public void initTelephonyModule(TelephonyModule module) {
        this.module = module;
    }

    @Inject
    public void initClientProvider(ClientProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public void setParticipantNumber(String participantNumber) {
        this.participantNumber = participantNumber;
    }

    public void setParticipantPIN(String participantPIN) {
        this.participantPIN = participantPIN;
    }

    public void setModeratorNumber(String moderatorNumber) {
        this.moderatorNumber = moderatorNumber;
    }

    public void setModeratorPIN(String moderatorPIN) {
        this.moderatorPIN = moderatorPIN;
    }

    public void setSessionNumberOrSIP(String sessionNumberOrSIP) {
        this.sessionNumberOrSIP = sessionNumberOrSIP;
    }

    public void setSessionPIN(String sessionPIN) {
        this.sessionPIN = sessionPIN;
    }

    public void doexecute() throws CommandExecutionException {
        String sessPIN;
        String modPIN;
        String partPIN;
        this.validateIsOnlineAndIsChair();
        if (!this.module.isSessionTeleconferencingAvailable()) {
            throw new CommandContextException("Telephony is not available", this.i18n.getString((PropertiesEnum)StringsProperties.TELECONFERENCECMD_BADCONTEXTTELEPHONYNOTAVAILABLE));
        }
        ClientList clients = this.clientProvider.get().getClientList();
        boolean formatted = clients.getProperty("Telephony.numberValidation", 1) == 1;
        String partNum = this.participantNumber != null ? this.participantNumber : "";
        boolean valid = formatted ? TelephonyUtils.isStringATelephoneNumber((String)partNum, (boolean)false) : TelephonyUtils.checkTelephonyNumberIsATelephoneNumber((String)partNum);
        if (!valid) {
            throw new CommandParameterException("Invalid participant telephone number", this.i18n.getString((PropertiesEnum)StringsProperties.CONFIGURETELECONFERENCECMD_BADPARAMETERPARTICIPANTNUMBERINVALID, new Object[]{partNum}));
        }
        String string = partPIN = this.participantPIN != null ? this.participantPIN : "";
        if (!TelephonyUtils.isStringAPin((String)partPIN)) {
            throw new CommandParameterException("Invalid participant PIN", this.i18n.getString((PropertiesEnum)StringsProperties.CONFIGURETELECONFERENCECMD_BADPARAMETERPARTICIPANTPININVALID, new Object[]{partPIN}));
        }
        String modNum = this.moderatorNumber != null ? this.moderatorNumber : "";
        valid = formatted ? TelephonyUtils.isStringATelephoneNumber((String)modNum, (boolean)false) : TelephonyUtils.checkTelephonyNumberIsATelephoneNumber((String)modNum);
        if (!valid) {
            throw new CommandParameterException("Invalid moderator telephone number", this.i18n.getString((PropertiesEnum)StringsProperties.CONFIGURETELECONFERENCECMD_BADPARAMETERMODERATORNUMBERINVALID, new Object[]{modNum}));
        }
        String string2 = modPIN = this.moderatorPIN != null ? this.moderatorPIN : "";
        if (!TelephonyUtils.isStringAPin((String)modPIN)) {
            throw new CommandParameterException("Invalid moderator PIN", this.i18n.getString((PropertiesEnum)StringsProperties.CONFIGURETELECONFERENCECMD_BADPARAMETERMODERATORPININVALID, new Object[]{modPIN}));
        }
        String sessNum = "";
        String sessSIP = "";
        String sessNumOrSIP = this.sessionNumberOrSIP != null ? this.sessionNumberOrSIP : "";
        valid = formatted ? TelephonyUtils.isStringATelephoneNumber((String)sessNumOrSIP, (boolean)false) : TelephonyUtils.checkTelephonyNumberIsATelephoneNumber((String)sessNumOrSIP);
        if (valid) {
            sessNum = sessNumOrSIP;
        } else if (TelephonyUtils.isStringAValidSipURI((String)sessNumOrSIP)) {
            sessSIP = sessNumOrSIP;
        } else {
            throw new CommandParameterException("Invalid session telephone number or SIP URI", this.i18n.getString((PropertiesEnum)StringsProperties.CONFIGURETELECONFERENCECMD_BADPARAMETERSESSIONNUMBERORSIPINVALID, new Object[]{sessNumOrSIP}));
        }
        String string3 = sessPIN = this.sessionPIN != null ? this.sessionPIN : "";
        if (!TelephonyUtils.isStringAPin((String)sessPIN)) {
            throw new CommandParameterException("Invalid session PIN", this.i18n.getString((PropertiesEnum)StringsProperties.CONFIGURETELECONFERENCECMD_BADPARAMETERSESSIONPININVALID, new Object[]{sessPIN}));
        }
        this.module.setUpSessionTeleconference(partNum, partPIN, modNum, modPIN, sessNum, sessSIP, sessPIN);
    }
}

