/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.LocalXmitClock;
import com.elluminate.jinx.XmitClock32;
import com.elluminate.jinx.XmitClock64;

public abstract class XmitClock {
    protected long speed;

    protected XmitClock(long bps) {
        this.speed = bps / 8L;
    }

    public void setLimit(long bps) {
        this.speed = bps / 8L;
    }

    public long getLimit() {
        return this.speed * 8L;
    }

    public abstract long getAvailability();

    public long schedule(int nBytes) {
        return this.schedule(System.currentTimeMillis(), nBytes);
    }

    public abstract long schedule(long var1, int var3);

    public static XmitClock getInstance(long bps, boolean local) {
        if (local) {
            return new LocalXmitClock(bps);
        }
        if (DebugFlags.NO_ATOMIC_LONG.isEnabled()) {
            return new XmitClock32(bps);
        }
        return new XmitClock64(bps);
    }
}

