/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.MessageEvent;
import com.elluminate.jinx.VCRFile;
import com.elluminate.util.StringUtils;

public class VCREntry {
    public static final byte VCR_START_MARK = -1;
    public static final byte VCR_MESSAGE = 0;
    public static final byte VCR_DISCONNECT = 1;
    public static final byte VCR_INDEX_MARK = 3;
    public static final byte VCR_ANNOTATION = 4;
    private long time;
    private long index;
    private long offset;
    private int length;
    private byte mark;
    private MessageEvent msg;
    private VCRFile.IndexEntry indexEntry;

    public VCREntry(long tm, long idx, long off, int len, MessageEvent message) {
        this.time = tm;
        this.index = idx;
        this.offset = off;
        this.length = len;
        this.mark = 0;
        this.msg = message;
        this.indexEntry = null;
    }

    public VCREntry(long tm, long idx, long off, int len, byte marker) {
        this.time = tm;
        this.index = idx;
        this.offset = off;
        this.length = len;
        this.mark = marker;
        this.msg = null;
        this.indexEntry = null;
    }

    public VCREntry(long tm, long idx, long off, int len, VCRFile.IndexEntry entry) {
        this.time = tm;
        this.index = idx;
        this.offset = off;
        this.length = len;
        this.mark = (byte)3;
        this.msg = null;
        this.indexEntry = entry;
    }

    public VCREntry(long off, int len) {
        this.time = -1L;
        this.index = -1L;
        this.offset = off;
        this.length = len;
        this.mark = (byte)4;
        this.msg = null;
        this.indexEntry = null;
    }

    public String toString() {
        String info;
        switch (this.mark) {
            case 0: {
                info = "Message: " + this.msg;
                break;
            }
            case 3: {
                info = "Index: " + this.indexEntry;
                break;
            }
            case 1: {
                info = "Disconnect marker";
                break;
            }
            case 4: {
                info = "Annotation: offset=" + this.offset + "=0x" + Long.toHexString(this.offset) + " len=" + this.length;
                break;
            }
            default: {
                info = "Marker: " + Integer.toHexString(this.mark & 0xFF);
            }
        }
        return Long.toHexString(this.offset) + "\t" + StringUtils.formatTimeStamp((long)this.time) + "\t" + info;
    }

    public long getTime() {
        return this.time;
    }

    public long getIndex() {
        return this.index;
    }

    public long getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public MessageEvent getMessage() {
        return this.msg;
    }

    public byte getMarker() {
        return this.mark;
    }

    public VCRFile.IndexEntry getIndexEntry() {
        return this.indexEntry;
    }
}

