/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.ByteList;
import com.elluminate.jinx.ByteListCloseListener;
import com.elluminate.jinx.ByteListOutputStream;
import com.elluminate.jinx.BytePool;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.PooledDataInputStream;
import com.elluminate.jinx.PooledDataOutputStream;
import com.elluminate.jinx.ProtocolIOListener;
import com.elluminate.net.AsyncEndpoint;
import com.elluminate.util.ObjectPool;
import com.elluminate.util.PooledObject;
import com.elluminate.util.log.LogSupport;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;

public class ProtocolBuffer
extends PooledObject
implements Cloneable,
ProtocolIOListener,
ByteListCloseListener {
    private static BytePool hdrPool = new BytePool(0);
    private static BytePool bodyPool = new BytePool(1);
    private static Object bufferPoolLock = new Object();
    private static ObjectPool bufferPool = null;
    private static boolean unpooled = false;
    private ByteList content = null;
    private volatile boolean writingHeader = false;
    private volatile boolean writingPayload = false;
    private long signature;
    private boolean doValidate = false;
    private AsyncEndpoint ioEndpoint = null;
    private ProtocolIOListener ioListener = null;
    private int payloadLen = 0;
    private ByteList hdr = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ProtocolBuffer alloc() {
        if (unpooled) {
            return new ProtocolBuffer();
        }
        if (bufferPool == null) {
            Object object = bufferPoolLock;
            synchronized (object) {
                if (!ObjectPool.isEnabled()) {
                    unpooled = true;
                    return new ProtocolBuffer();
                }
                if (bufferPool == null) {
                    ObjectPool newPool;
                    bufferPool = newPool = ObjectPool.getInstance(ProtocolBuffer.class);
                }
            }
        }
        return (ProtocolBuffer)bufferPool.alloc();
    }

    public static ProtocolBuffer getInstance() {
        ProtocolBuffer buf = ProtocolBuffer.alloc();
        buf.setContent(bodyPool.getList());
        return buf;
    }

    public static ProtocolBuffer getInstance(byte[] payload) {
        ProtocolBuffer buf = ProtocolBuffer.alloc();
        ByteList list = bodyPool.getList();
        try {
            list.write(payload, 0, payload.length);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)buf, (String)"<init>", (Throwable)ex, (boolean)true);
        }
        buf.setContent(list);
        return buf;
    }

    public static ProtocolBuffer getInstance(byte[] payload, int off, int len) {
        ProtocolBuffer buf = ProtocolBuffer.alloc();
        ByteList list = bodyPool.getList();
        try {
            list.write(payload, off, len);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)buf, (String)"<init>", (Throwable)ex, (boolean)true);
        }
        buf.setContent(list);
        return buf;
    }

    private static ProtocolBuffer getInstance(ByteList lst) {
        ProtocolBuffer buf = ProtocolBuffer.alloc();
        buf.setContent(lst);
        return buf;
    }

    private void setContent(ByteList list) {
        this.content = list;
        this.signature = this.content.poGetGeneration();
    }

    public void poInit() {
        super.poInit();
        this.doValidate = DebugFlags.BYTELIST_CHECK.show();
        this.writingHeader = false;
        this.writingPayload = false;
    }

    public void poCleanup() {
        this.content = null;
        this.ioListener = null;
        this.hdr = null;
    }

    public int getSize() {
        if (this.doValidate) {
            this.validate();
        }
        return this.content.getLength();
    }

    public int getCRC() {
        return this.getCRC(new CRC32());
    }

    public int getCRC(Checksum crc) {
        return this.content.getCRC(crc);
    }

    public DataOutputStream addHeader() {
        if (this.writingHeader) {
            LogSupport.error((Object)this, (String)"addHeader", (String)"An attempt was made to start a second header while one was still being written");
            return null;
        }
        if (this.doValidate) {
            this.validate();
        }
        this.writingHeader = true;
        ByteList hdr = hdrPool.getList();
        ByteListOutputStream str = hdr.getOutputStream();
        str.setCloseListener(this);
        return PooledDataOutputStream.getInstance(str);
    }

    public void addHeader(byte[] data) {
        if (this.writingHeader) {
            LogSupport.error((Object)this, (String)"addHeader", (String)"An attempt was made to start a second header while one was still being written");
            return;
        }
        if (this.doValidate) {
            this.validate();
        }
        this.writingHeader = true;
        ByteList hdr = hdrPool.getList();
        try {
            hdr.write(data, 0, data.length);
            this.content.prepend(hdr);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"addHeader", (Throwable)ex, (boolean)true);
        }
        this.writingHeader = false;
    }

    public DataOutputStream addPayload() {
        if (this.writingPayload) {
            LogSupport.error((Object)this, (String)"addPayload", (String)"An attempt was made to start a second block of payload while one was still being written");
            return null;
        }
        if (this.doValidate) {
            this.validate();
        }
        this.writingPayload = true;
        ByteListOutputStream str = this.content.getOutputStream();
        str.setCloseListener(this);
        return PooledDataOutputStream.getInstance(str);
    }

    public void addPayload(byte[] payload) {
        if (this.writingPayload) {
            LogSupport.error((Object)this, (String)"addPayload", (String)"An attempt was made to start a second block of payload while one was still being written");
            return;
        }
        if (this.doValidate) {
            this.validate();
        }
        this.writingPayload = true;
        try {
            this.content.write(payload, 0, payload.length);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"addPayload", (Throwable)ex, (boolean)true);
        }
        this.writingPayload = false;
    }

    public void addPayload(ProtocolBuffer buf) {
        if (this.writingPayload) {
            LogSupport.error((Object)this, (String)"addPayload", (String)"An attempt was made to start a second block of payload while one was still being written");
            return;
        }
        if (this.doValidate) {
            this.validate();
        }
        this.writingPayload = true;
        this.content.append(buf.content);
        this.writingPayload = false;
        buf.content = null;
    }

    public DataInputStream readHeader(int nBytes) {
        if (this.doValidate) {
            this.validate();
        }
        return PooledDataInputStream.getInstance(this.content.getInputStream(nBytes));
    }

    public DataInputStream readPayload() {
        if (this.doValidate) {
            this.validate();
        }
        return PooledDataInputStream.getInstance(this.content.getInputStream());
    }

    public byte[] getPayload() {
        if (this.doValidate) {
            this.validate();
        }
        byte[] payload = new byte[this.content.getLength()];
        try {
            this.content.read(0, payload, 0, this.content.getLength());
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"getPayload", (Throwable)ex, (boolean)true);
        }
        return payload;
    }

    public int getSegmentCount() {
        if (this.doValidate) {
            this.validate();
        }
        return this.content.getBlockCount(500);
    }

    public ProtocolBuffer getNextSegment() {
        if (this.doValidate) {
            this.validate();
        }
        ByteList list = this.content.extractBlock(500);
        if (!this.content.isValid()) {
            this.content.dispose();
            this.content = null;
        }
        return ProtocolBuffer.getInstance(list);
    }

    public Object clone() {
        if (this.doValidate) {
            this.validate();
        }
        if (this.writingHeader) {
            throw new IllegalStateException("Cannot clone a ProtocolBuffer while writing header.");
        }
        if (this.writingPayload) {
            throw new IllegalStateException("Cannot clone a ProtocolBuffer while writing payload.");
        }
        try {
            ProtocolBuffer copy = ProtocolBuffer.alloc();
            copy.setContent((ByteList)this.content.clone());
            return copy;
        }
        catch (Exception ex) {
            LogSupport.exception((Object)this, (String)"clone", (Throwable)ex, (boolean)true);
            return null;
        }
    }

    public void dispose() {
        if (unpooled) {
            return;
        }
        if (this.content != null) {
            if (this.doValidate) {
                this.validate();
            }
            this.content.dispose();
            this.content = null;
        }
        super.dispose();
    }

    @Override
    public void streamClosed(ByteListOutputStream str) {
        ByteList list = str.getByteList();
        if (this.doValidate) {
            this.validate();
        }
        if (list != this.content) {
            this.content.prepend(list);
            this.writingHeader = false;
        } else {
            this.writingPayload = false;
        }
    }

    public void writeTo(DataOutput str) throws IOException {
        if (this.doValidate) {
            this.validate();
        }
        this.content.writeTo(str);
    }

    public void writeTo(byte[] buf, int off, int len) {
        if (this.doValidate) {
            this.validate();
        }
        try {
            this.content.read(0, buf, off, len);
        }
        catch (IOException ex) {
            LogSupport.exception((Object)this, (String)"writeTo", (Throwable)ex, (boolean)true);
        }
        catch (ArrayIndexOutOfBoundsException aioobx) {
            if (off + len > buf.length) {
                LogSupport.exception((Object)this, (String)"writeTo", (Throwable)aioobx, (boolean)true, (String)("Target buffer too small (byte[" + buf.length + "], " + off + ", " + len + ")"));
            }
            LogSupport.exception((Object)this, (String)"writeTo", (Throwable)aioobx, (boolean)true, (String)"Internal error writing ProtocolBuffer");
        }
    }

    public void readFrom(DataInput str, int hdrLen, int payloadLen) throws IOException {
        if (this.doValidate) {
            this.validate();
        }
        if (this.writingHeader || this.writingPayload) {
            LogSupport.error((Object)this, (String)"readFrom", (String)"An attempt was made to start a second header or payload block while one was still being written");
            return;
        }
        if (hdrLen > 0) {
            this.writingHeader = true;
            ByteList hdr = hdrPool.getList();
            hdr.readFrom(str, hdrLen);
            this.content.prepend(hdr);
            this.writingHeader = false;
        }
        if (payloadLen > 0) {
            this.writingPayload = true;
            this.content.readFrom(str, payloadLen);
            this.writingPayload = false;
        }
    }

    public boolean writeTo(AsyncEndpoint ep, ProtocolIOListener lst) throws IOException {
        return this.content.writeTo(ep, lst);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean readFrom(AsyncEndpoint ep, int hdrLen, int payloadLen, ProtocolIOListener lst) throws IOException {
        boolean done = false;
        if (this.doValidate) {
            this.validate();
        }
        if (this.writingHeader || this.writingPayload) {
            LogSupport.error((Object)this, (String)"readFrom", (String)"An attempt was made to start a second header or payload block while one was still being written");
            return true;
        }
        ProtocolBuffer protocolBuffer = this;
        synchronized (protocolBuffer) {
            this.ioListener = lst;
            this.ioEndpoint = ep;
            if (hdrLen > 0) {
                this.writingHeader = true;
                this.payloadLen = payloadLen;
                this.hdr = hdrPool.getList();
                if (this.hdr.readFrom(ep, hdrLen, this)) {
                    this.content.prepend(this.hdr);
                    this.hdr = null;
                    this.writingHeader = false;
                }
            }
            if (!this.writingHeader && payloadLen > 0) {
                this.writingPayload = true;
                if (this.content.readFrom(ep, payloadLen, this)) {
                    this.writingPayload = false;
                    done = true;
                }
            } else {
                boolean bl = done = !this.writingHeader;
            }
            if (done) {
                this.ioListener = null;
                this.ioEndpoint = null;
            }
        }
        return done;
    }

    private void validate() {
        this.content.validate(this.signature);
    }

    public String toString() {
        return "ProtocolBuffer[" + this.content.toString() + "]";
    }

    @Override
    public void protocolWriteComplete(IOException iox) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void protocolReadComplete(IOException iox) {
        ProtocolIOListener l = null;
        boolean notify = false;
        ProtocolBuffer protocolBuffer = this;
        synchronized (protocolBuffer) {
            if (iox == null) {
                if (this.writingHeader) {
                    this.content.prepend(this.hdr);
                    this.writingHeader = false;
                    this.writingPayload = true;
                    if (this.payloadLen > 0) {
                        try {
                            if (this.content.readFrom(this.ioEndpoint, this.payloadLen, this)) {
                                this.writingPayload = false;
                                notify = true;
                            }
                        }
                        catch (IOException x) {
                            iox = x;
                            notify = true;
                        }
                    } else {
                        notify = true;
                    }
                } else if (this.writingPayload) {
                    this.writingPayload = false;
                    notify = true;
                }
            } else {
                notify = true;
                if (this.hdr != null) {
                    this.hdr.dispose();
                }
            }
            this.hdr = null;
            if (notify) {
                l = this.ioListener;
                this.ioListener = null;
                this.ioEndpoint = null;
            }
        }
        if (l != null) {
            l.protocolReadComplete(iox);
        }
    }
}

