/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.jinx;

import com.elluminate.jinx.BandwidthLimit;
import com.elluminate.jinx.ControlPacket;
import com.elluminate.jinx.DebugFlags;
import com.elluminate.jinx.JinxTuning;
import com.elluminate.jinx.LimitSet;
import com.elluminate.jinx.PacketEvent;
import com.elluminate.jinx.TransmitStatusEvent;
import com.elluminate.util.PriorityScheduler;
import com.elluminate.util.TimerResolution;
import com.elluminate.util.log.LogSupport;

public class PacketScheduler
implements PriorityScheduler {
    private static final int TCPIP_OVERHEAD = 40;
    private long resolution = TimerResolution.get();
    private long nextPacketTime = 0L;
    private int bufferSize;
    private int bufferLeft = this.bufferSize = 1024;
    private int bufferUsed = 0;
    private boolean bufferEmpty = true;
    private LimitSet limits = null;
    private BandwidthLimit limit = new BandwidthLimit(1000000L, true);

    public PacketScheduler(BandwidthLimit[] limits) {
        BandwidthLimit[] lim;
        if (limits == null) {
            lim = new BandwidthLimit[]{this.limit};
        } else {
            lim = new BandwidthLimit[limits.length + 1];
            lim[0] = this.limit;
            System.arraycopy(limits, 0, lim, 1, limits.length);
        }
        this.limits = new LimitSet(lim);
    }

    public int getBandwidth() {
        return (int)this.limit.getLimit();
    }

    public void setBandwidth(int bps) {
        this.limit.setLimit(bps);
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int size) {
        this.bufferSize = size;
    }

    private int getTransmitSize(Object o) {
        if (o instanceof PacketEvent) {
            PacketEvent p = (PacketEvent)o;
            try {
                return p.getContent().getSize() + 10;
            }
            catch (Exception e) {
                return 0;
            }
        }
        if (o instanceof ControlPacket) {
            ControlPacket c = (ControlPacket)o;
            return c.size();
        }
        if (o instanceof TransmitStatusEvent) {
            return 0;
        }
        LogSupport.error((Object)this, (String)"processingNotify", (String)("Unknown object type in priority queue: " + o.getClass().getName()));
        return 0;
    }

    public void flush() {
        if (!DebugFlags.BANDWIDTH_OFF.isEnabled() && this.bufferUsed > 0) {
            this.limits.actual(this.bufferUsed + 40);
        }
        this.nextPacketTime = 0L;
        this.bufferLeft = this.bufferSize;
        this.bufferEmpty = true;
        this.bufferUsed = 0;
    }

    public long getProcessDelay(int priority, Object obj, long now) {
        if (DebugFlags.BANDWIDTH_OFF.isEnabled()) {
            return 0L;
        }
        int size = this.getTransmitSize(obj);
        if (priority == 0) {
            this.nextPacketTime = 0L;
        } else {
            if (!this.bufferEmpty && this.bufferLeft >= size && this.limits.getHorizon() - now < (long)JinxTuning.BundlingTimeLimit.getIntValue()) {
                return 0L;
            }
            if (this.nextPacketTime > 0L) {
                if (this.nextPacketTime <= now) {
                    this.nextPacketTime = 0L;
                }
            } else {
                this.nextPacketTime = this.limits.schedule(size);
            }
        }
        long delay = this.nextPacketTime - now;
        if (delay < this.resolution * 2L) {
            this.nextPacketTime = 0L;
            delay = 0L;
        }
        if (DebugFlags.BANDWIDTH.show() && delay > 0L) {
            LogSupport.message((Object)this, (String)"getProcessDelay", (String)("Delay " + delay + "ms"));
        }
        return delay;
    }

    public void processingNotify(Object o) {
        long nBytes = this.getTransmitSize(o);
        this.bufferUsed = (int)((long)this.bufferUsed + nBytes);
        this.bufferLeft = (int)((long)this.bufferLeft - nBytes);
        this.bufferEmpty = false;
    }
}

